/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was.restresource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.bamboo.plugin.was.qualysclient.QualysAuth;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASClient;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASResponse;
import com.qualys.bamboo.plugin.was.util.Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.map.HashedMap;
import org.codehaus.plexus.util.StringUtils;

@Path(value="/")
public class QualysRestResource {
    private static final Logger logger = Logger.getLogger(QualysRestResource.class.getName());
    private static final String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
    private Map<String, String> platformObj;

    @POST
    @Path(value="test/was_connection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testConnection(Map<Object, Object> credentials) {
        HashedMap resp = new HashedMap();
        try {
            QualysAuth auth = this.getAuth(credentials);
            QualysWASClient qcs = new QualysWASClient(auth);
            qcs.testConnection();
            resp.put("response", "Test Connection Successful!");
            return Response.status((int)200).entity((Object)resp).build();
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            resp.put("response", "Error testing connection to Qualys server. " + e.getMessage());
            return Response.status((int)500).entity((Object)resp).build();
        }
    }

    public QualysWASResponse callAPIs(String api, QualysWASClient client, String id) {
        String xmlReqData;
        QualysWASResponse resp = null;
        String string = xmlReqData = id == null ? null : "<ServiceRequest> <filters> <Criteria field=\"id\" operator=\"GREATER\">" + id + "</Criteria> </filters> </ServiceRequest>";
        if (client != null) {
            switch (api) {
                case "webAppList": {
                    resp = client.listWebApps(xmlReqData);
                    break;
                }
                case "authRecordList": {
                    resp = client.listAuthRecords(xmlReqData);
                    break;
                }
                case "profileList": {
                    resp = client.listOptionProfiles(xmlReqData);
                }
            }
        }
        return resp;
    }

    public String escapeHtml(String unsafe) {
        return unsafe.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#039;").trim();
    }

    public JsonArray getDataList(String api, QualysWASClient client) {
        boolean hasMoreRecords = true;
        int page = 0;
        String lastId = null;
        JsonArray dataList = new JsonArray();
        try {
            while (hasMoreRecords) {
                for (int retry = 0; retry < 3; ++retry) {
                    JsonObject response;
                    JsonObject serviceResp;
                    String responseCode;
                    if (retry > 0) {
                        logger.info("Retrying " + api + " call: " + retry);
                    }
                    QualysWASResponse resp = this.callAPIs(api, client, lastId);
                    logger.info("Response code received for API " + api + " call [page=" + page + "]: " + resp.responseCode);
                    hasMoreRecords = false;
                    if (resp == null || resp.responseCode != 200 || !(responseCode = (serviceResp = (response = resp.response).getAsJsonObject("ServiceResponse")).get("responseCode").getAsString()).equalsIgnoreCase("success")) continue;
                    int count = serviceResp.get("count").getAsInt();
                    if (count <= 0) break;
                    hasMoreRecords = serviceResp.get("hasMoreRecords").getAsBoolean();
                    lastId = hasMoreRecords ? serviceResp.get("lastId").getAsString() : null;
                    JsonArray arr = serviceResp.get("data").getAsJsonArray();
                    dataList.addAll(arr);
                    break;
                }
                ++page;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public QualysAuth getAuth(Map<Object, Object> credentials) {
        this.platformObj = Helper.platformsList.get(credentials.get("url"));
        String apiServer = StringUtils.defaultString((Object)this.platformObj.get("url"));
        if (apiServer == "") {
            apiServer = (String)credentials.get("apiServerURL");
        }
        String username = StringUtils.defaultString((Object)credentials.get("username"));
        String password = StringUtils.defaultString((Object)credentials.get("pas"));
        if (apiServer != null) {
            apiServer = apiServer.trim();
        }
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(apiServer, username, password);
        boolean useProxy = (Boolean)credentials.get("useProxy");
        if (useProxy) {
            String proxyServer = StringUtils.defaultString((Object)credentials.get("proxyServer"));
            String proxyUser = StringUtils.defaultString((Object)credentials.get("proxyUser"));
            String proxyPass = StringUtils.defaultString((Object)credentials.get("proxyPass"));
            String port = StringUtils.defaultString((Object)credentials.get("proxyPort"));
            int proxyPort = 0;
            if (port != null && !port.isEmpty()) {
                proxyPort = Integer.parseInt(port);
            }
            if (proxyServer != null) {
                proxyServer = proxyServer.trim();
            }
            auth.setProxyCredentials(proxyServer, proxyPort, proxyUser, proxyPass);
        }
        return auth;
    }

    @POST
    @Path(value="webapplist")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getWebAppList(Map<Object, Object> credentials) {
        HashedMap resp = new HashedMap();
        try {
            QualysAuth auth = this.getAuth(credentials);
            QualysWASClient qualyswasclient = new QualysWASClient(auth);
            JsonArray dataList = this.getDataList("webAppList", qualyswasclient);
            HashMap<String, String> webapplist = new HashMap<String, String>();
            for (JsonElement webapp : dataList) {
                JsonObject obj = webapp.getAsJsonObject();
                JsonObject webAppObj = obj.getAsJsonObject("WebApp");
                String id = webAppObj.get("id").getAsString();
                String name = webAppObj.get("name").getAsString();
                name.replaceAll(xml10pattern, "*");
                webapplist.put(this.escapeHtml(name), id);
            }
            resp.put("response", webapplist);
            return Response.status((int)200).entity((Object)resp).build();
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            resp.put("response", "Error testing connection to Qualys server. " + e.getMessage());
            return Response.status((int)500).entity((Object)resp).build();
        }
    }

    @POST
    @Path(value="authRecordIdItems")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authRecordIdItems(Map<Object, Object> credentials) {
        HashedMap resp = new HashedMap();
        try {
            QualysAuth auth = this.getAuth(credentials);
            QualysWASClient qualyswasclient = new QualysWASClient(auth);
            JsonArray dataList = this.getDataList("authRecordList", qualyswasclient);
            HashMap<String, String> authRecordList = new HashMap<String, String>();
            for (JsonElement webapp : dataList) {
                JsonObject obj = webapp.getAsJsonObject();
                JsonObject webAppObj = obj.getAsJsonObject("WebAppAuthRecord");
                String id = webAppObj.get("id").getAsString();
                String name = webAppObj.get("name").getAsString();
                name.replaceAll(xml10pattern, "*");
                authRecordList.put(this.escapeHtml(name), id);
            }
            resp.put("response", authRecordList);
            return Response.status((int)200).entity((Object)resp).build();
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            resp.put("response", "Error testing connection to Qualys server. " + e.getMessage());
            return Response.status((int)500).entity((Object)resp).build();
        }
    }

    @POST
    @Path(value="optionProfile")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response optionProfile(Map<Object, Object> credentials) {
        HashedMap resp = new HashedMap();
        try {
            QualysAuth auth = this.getAuth(credentials);
            QualysWASClient qualyswasclient = new QualysWASClient(auth);
            JsonArray dataList = this.getDataList("profileList", qualyswasclient);
            HashMap<String, String> authRecordList = new HashMap<String, String>();
            for (JsonElement webapp : dataList) {
                JsonObject obj = webapp.getAsJsonObject();
                JsonObject webAppObj = obj.getAsJsonObject("OptionProfile");
                String id = webAppObj.get("id").getAsString();
                String name = webAppObj.get("name").getAsString();
                name.replaceAll(xml10pattern, "*");
                authRecordList.put(this.escapeHtml(name), id);
            }
            resp.put("response", authRecordList);
            return Response.status((int)200).entity((Object)resp).build();
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            resp.put("response", "Error testing connection to Qualys server. " + e.getMessage());
            return Response.status((int)500).entity((Object)resp).build();
        }
    }
}

