<html>
<head>
	<meta name="tab" content="chainBuildTimes"/>
</head>

<body>
	<style>
		
		td.details-control {
		    background: url("${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/details_open.png") no-repeat center center;
		    cursor: pointer;
		}
		tr.shown td.details-control {
		    background: url("${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/details_close.png") no-repeat center center;
		}
		.status-image.failed{
			background: url('${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/failed-status.png') no-repeat center center;
			height: 50px;
		   	width: 50px;
		   	background-size: contain;
		   	margin: 10px;
		}
		
		.status-icon.ok{
		background: url('${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/ok.png') no-repeat center center;
    	background-size: contain;
    	height:20px;
	}
	.status-icon.fail{
		background: url('${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/fail.png') no-repeat center center;
		background-size: contain;
	}
	.status-icon.not-configured{
	     background: url('${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/dash.png') no-repeat center center;
		 background-size: contain;
		 text-align: -webkit-center;
		 text-align: center;
	}
	
		.status-image.success{
			background: url('${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/success-status.png') no-repeat center center;
			height: 50px;
		   	width: 50px;
		   	background-size: contain;
		   	margin: 10px;
		}
		#layersTable_filter.dataTables_filter {
			width: 75%;
	    	height: 35px;
	    	float:right;
	    	text-align: left;
		}
		
		#layersTable_filter.dataTables_filter input{
			width: 70%;
			height:35px;
			font-size: 15px;
	        font-weight:bold;
		}	
		.ui-tabs-tab {
		    padding: 5px !important;
		    margin-right: 7px !important;
		}
		#truncate_tab {
		    width: 100px;
		    overflow: hidden;
		    white-space: nowrap;
		    text-overflow: ellipsis;
		}
		.label-value_for_url{
		font-weight:200;
		color:red;
		}
		
		.canvasClass {
			margin-top: -50px;
    		width: 290px;
		}
	</style>
	[#if !reportResult.message?has_content]
		<div id="tabs">
			  
			  <ul id="imagesUL">
			  	<li class="qualys_logo">
			  	   <img src="${baseUrl}/download/resources/com.qualys.bamboo.plugin.QualysContainerSecurityBambooPlugin:qualysCSresources/pluginImages/logo.png"/>
			    </li>
			    [#if !images.isEmpty()]
					[#list images as image]
						<li class="ui-tabs-tab" imageId="${image}"><div class="tooltip"><a href="#tabs-1" id="truncate_tab">${image}</a><div class="wrapper">${image}</div></div></li>
					[/#list]
				[/#if]
	
			  </ul>
			  
			  <div id="tabs-1">
			    	
			    		<div class="left-panel">
			    			<div class="left-panel-container summary">
								<div class="left-pill-item summary selected" tab="summary">
									<span>Build Summary</span>
								</div>
								<div class="left-pill-item vulns" tab="vulns">
									<span>Vulnerabilities</span>
								</div>
								<div class="left-pill-item softwares" tab="softwares">
									<span>Installed Software</span>
								</div>
								<div class="left-pill-item layers" tab="layers">
									<span>Layers</span>
								</div>
							</div>
			    		</div>
			    		<div class="right-panel">
			    					<div id="build-summary" class="reports-main-content">
										<div class="summary-title"><span id="summary-title-span"> </span> </div>
										<div id="summary-content">
											<div id="summary-left-panel">
												<div class="status-image"></div>
											</div>
											<div id="summary-right-panel">
												<div class="summary-text-content">
													<table style="width:100%;">
														<tr>
															<td><div class="report-title">Image Scan Status: <span id="build-status"></span> </div></td>
															<td><div class="report-title">Image ID: <span id="imageId" class="label-value"> </span> </div> </td>
														</tr>
														<tr>
															<td><div class="report-title">Tags: <span id="image-tags" class="label-value"></span> </div></td>
															<td><div class="report-title">Size: <span id="image-size" class="label-value"></span> </div> </td>
														</tr>
														<tr>
															<td><div class="report-title">Scan Report: <a target="_blank" href="" id="image_summary_url" class="label-value_for_url"><u style="color:blue;">Click here to view Image Summary on Qualys Portal</u></a> 
																<br /><span class="report_link_note">Note: Valid credentials for the Qualys UI are required to view the report</span>
															</div></td>
														</tr>
													</table> 
												</div>
											
												<div class="seperator-line"></div>
												<div class="build-summary-reason">
													
													
													
												<div class="vulnschart" id="summary-chart"> 
													<div class="vulnschart-content">
														<div class="report-title center vulnschart-content-tiitle"> Image Scan Summary </div>
														<div class="report-chart-div">
															<div id="build-reason-table">
																<table id="build-summary-table">
																	<!-- <tr><td colspan="9" id="summaryTableImageId"> <div class="image-status-flag"></div><span id="summary-image-id"></span> </td></tr> -->
																	<tr class="column-header">
																		<td></td>
																		<td>QIDs</td>
																		<td>CVEs</td>
																		<td>CVSS</td>
																		<td>Software</td>
																		<td>Severity 5</td>
																		<td>Severity 4</td>
																		<td>Severity 3</td>
																		<td>Severity 2</td>
																		<td>Severity 1</td>
																	</tr>
																	<tr>
																		<td>Criteria Evaluation</td>
																		<td id="qid-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div> </div> </td>
																		<td id="cve-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div> </div> </td>
																		<td id="cvss-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div> </div> </td>
																		<td id="software-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div> </div> </td>
																		<td id="sev5-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div></div> </td>
																		<td id="sev4-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div></div> </td>
																		<td id="sev3-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div></div> </td>
																		<td id="sev2-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div></div> </td>
																		<td id="sev1-found"><div class="tooltip tooltip-scroll status-icon image-scan-status not-configured"> <div class="wrapper">  <span class="tooltip-text">Not Configured</span> </div></div> </td>
																	</tr>
																</table>
															</div>
															<div id="summary-legend-div">
																<div style="float:right; margin-left:10px;"> <div class="status-icon legend not-configured"> </div><span> Not Configured</span> </div>
																<div style="float:right; margin-left:10px;"> <div class="status-icon legend ok"> </div> <span>Satisfies criteria</span> </div>
															    <div style="float:right; margin-left:10px;"> <div class="status-icon legend fail"></div> <span>Violates criteria</span> </div>
															</div>
															<div id="excluded-items">
															  <div class="tooltip tooltip-scroll">
															    <span id="excluded-items-list"></span>
															    <div class="wrapper">
															      <span class="tooltip-text"></span>
															    </div>
															  </div>
															</div>
															<div id="potential-checked"></div>
														</div>
													</div>
												</div>
													
												</div>	
													
													
												<div class="summary-chart-content" style="display:table;width: 100%;">
													<div class="vulnschart" id="trending"> 
														<div class="vulnschart-content">
															<div class="report-title center vulnschart-content-tiitle"> Vulnerabilities Trend</div>
															<div id="canvasDiv" class="report-chart-div" style="margin-top:10px;">
																<canvas id="trendVulns" width="278" height="162" ></canvas>
																<div class="trending-chart-legend legends">
																	<ul class="trending-legend">
																		<li><span style="background-color:rgba(126, 183, 255, 1)"></span>Confirmed vulnerabilities in current build </li>
																		<li id="trending-prev-job" class="trending-legend-li"><span style="background-color:rgba(192,192,192,1)"></span><div id="trend-compare" style="display: inline;"></div></li>
																	</ul>
																</div>
															</div>
														</div>
													</div>
													<div class="vulnschart" id="sev-don-chart"> 
														<div class="vulnschart-content">
															<div class="report-title center vulnschart-content-tiitle"> Confirmed Vulnerabilities (<span id="confTotCount"></span>) </div>
															<div class="canvasClass" id="sevVulns-chart-parent">
																<canvas id="sevVulns"></canvas>
															</div>
														</div>
													</div>
													<div class="vulnschart" id="det-bar-chart">
														<div class="vulnschart-content">
															<div class="report-title center vulnschart-content-tiitle">Potential Vulnerabilities (<span id="potTotCount"></span>)</div>
															<div class="canvasClass" id="typeVulns-chart-parent">
																<canvas id="typeVulns"></canvas>
															</div>
														</div>
													</div>
													<div class="vulnschart" id="pat-don-chart"> 
														<div class="vulnschart-content">
															<div class="report-title center vulnschart-content-tiitle">Patchability </div>
															<div class="canvasClass" id="patchVulns-chart-parent">
																<canvas id="patchVulns"></canvas>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div id="clearingdiv"></div>
										</div>
									</div>
									
									<div id="vulnerabilities" class="reports-main-content" style="display: none;">
										<div class="summary-title"> QUALYS VULNERABILITIES RESULTS </div>
										<div id="vulnsTable-content">
									  		<div id="vulnsTable" class="display" width="100%"></div>
									  	</div>	
									</div>
									
									
									<div id="installed-softwares" class="reports-main-content" style="display: none;">
										<div class="summary-title"> INSTALLED SOFTWARE </div>
										<div id="softwareTable-content">
									  		<div id="softwareTable" class="display" width="100%"></div>
									  	</div>	
									</div>
									
									<div id="layers" class="reports-main-content" style="display: none;">
										<div class="summary-title"> LAYERS LIST</div>
										<div id="layersTable-content">
									  		<div id="layersTable" class="display" width="100%"></table>
									  	</div>	
									</div>
			    		</div>
			    	</div>
			  </div>
		
		
		<script type="text/javascript">
			
			var patchableChart;
			var confirmChart;
			var potentialChart;
			
			
			function format ( d ) {
			    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
				    '<tr>'+
				    	'<td>CVSS Base Score: ' + d.cvssInfo.baseScore + '</td>'+
				    	'<td>CVSS Temporal Score: '+ d.cvssInfo.temporalScore +'</td>'+
				    '</tr>'+
				    '<tr>'+
				    	'<td>CVSS3 Base Score: ' + d.cvss3Info.baseScore + '</td>'+
				    	'<td>CVSS3 Temporal Score: '+ d.cvss3Info.temporalScore +'</td>'+
				    '</tr>'+
				    '<tr>'+
				        '<td>CVSS Access Vector: </td>'+
				        '<td>'+d.cvssInfo.accessVector+'</td>'+
				    '</tr>'+
				    '<tr>'+
			            '<td>CVE Ids</td>'+
			            '<td>'+d.cveids+'</td>'+
			        '</tr>'+
			        '<tr>'+
			            '<td>Result</td>'+
			            '<td>'+d.result+'</td>'+
			        '</tr>'+
			    '</table>';
			}
			
			function bytesToSize(bytes) {
			   var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
			   if (bytes == 0) return '0 Byte';
			   var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
			   return Math.round(bytes / Math.pow(1024, i), 2) + ' ' + sizes[i];
			};
			
			jQuery( "#tabs" ).tabs();
			jQuery("div.left-panel").css("height",jQuery("div.right-panel").height());
			
			//call for render data
			var imageId = jQuery("li.ui-state-active").attr("imageId");
			var tab = jQuery(".left-pill-item.selected").attr("tab");
			renderContents(imageId, tab);
			
			//left panel items click
			jQuery(".left-pill-item").on("click", function(e){
				var selected = jQuery(this).hasClass("selected");
				if(!selected) {
					jQuery(".left-pill-item").removeClass("selected");
					window.scrollTo(0, 0);
					jQuery(".reports-main-content").hide();
					jQuery(this).addClass("selected");
					if(jQuery(this).hasClass("vulns")){
						jQuery("#vulnerabilities").show();
					}
					if(jQuery(this).hasClass("summary")){
						jQuery("#build-summary").show();
					}
					if(jQuery(this).hasClass("softwares")){
						jQuery("#installed-softwares").show();
					}
					if(jQuery(this).hasClass("layers")){
		                jQuery("#layers").show();
					}
					jQuery("div.left-panel").css("height",jQuery("div.right-panel").height());
					var imageId = jQuery("li.ui-state-active").attr("imageId");
					var tab = jQuery(".left-pill-item.selected").attr("tab");
					renderContents(imageId, tab);
				}
			});
			
			jQuery("li.ui-tabs-tab").on("click", function(){
				jQuery(".left-pill-item.summary").click();
				var imageId = jQuery("li.ui-state-active").attr("imageId");
				var tab = jQuery(".left-pill-item.selected").attr("tab");
				renderContents(imageId, tab);
			});
			function showTab(qid) {
		        jQuery("#vulnerabilities").hide();
		        jQuery(".left-pill-item.vulns").removeClass("selected");
		        jQuery(".left-pill-item.softwares").addClass("selected");
		        jQuery("#installed-softwares").show();
		        
		        var imageId = jQuery("li.ui-state-active").attr("imageId");
				var tab = jQuery(".left-pill-item.selected").attr("tab");
				renderContents(imageId, tab);
				
		        jQuery("#softwareTablecontent_filter input").val("QID="+qid);
		        jQuery("#softwareTablecontent_filter input").focus();
		        jQuery("#softwareTablecontent_filter input").keydown();
    			jQuery("#softwareTablecontent_filter input").keyup();
		        
		      /* var qidSearch = "QID=";
		        var softwareTable = jQuery('#softwareTablecontent').DataTable();
	             var searchInput = jQuery("#softwareTablecontent_filter input").val();
	             if(searchInput.indexOf(qidSearch) != -1){               
	                softwareTable.columns(4).search(searchInput).draw();                
	             }            
		      */  
		    };
		    
		  
			function updateSummary(imageId){
				[#if totalVulnsTrend?has_content]
					var totalVulnsTrendData = ${totalVulnsTrend};
					var totalVulnsTrend = totalVulnsTrendData[imageId];
					
					jQuery("#trend-compare").html("Comparing to build #" +  totalVulnsTrend.prevBuildNumber);
					if(totalVulnsTrend.prev == null  || totalVulnsTrend.prev == "null"){
						jQuery("#trending-prev-job").hide();
					}else {
						jQuery("#trending-prev-job").show();
					}
					
					var currentVulns = totalVulnsTrend.current ;
					var prevVulns = totalVulnsTrend.prev;
					
					jQuery("canvas#trendVulns").remove();
					jQuery("div#canvasDiv").append('<canvas id="trendVulns" width="278" height="162" ></canvas>');
					
					var c = jQuery("#trendVulns").get(0);
					var ctx = c.getContext("2d");
					
					var data1 = {
				        labels: ["Sev 5", "Sev 4", "Sev 3", "Sev 2", "Sev 1"],
				        datasets: [
				          {
				            label: "Current Build",
				            backgroundColor: "rgba(126, 183, 255, 0.7)",
				            data: currentVulns ? currentVulns.reverse() : []
				          },
				          {
				            label: "Previous Build",
				            backgroundColor: "rgba(192,192,192, 0.7)",
				            data: (prevVulns && prevVulns != "null") ? prevVulns.reverse() : []
				          }
				        ]
				      };
												
					var options = {
				        plugins: {
				          legend: {
				            display: false
				          }
				        },
				        scales: {
				          x: {
				            grid: {
				              display: false
				            }
				          },
				          y: {
				            grid: {
				              display: false
				            }
				          }
				        }
				      }
				    if(currentVulns){
						var barChart = new Chart(ctx, { "type": "bar", "data": data1, "options": options });
					}else{
						jQuery(".trending-chart-legend li").hide();
						jQuery("div#trending div.report-chart-div").text("Unable to show Trending chart!");
						jQuery("div#trending div.report-chart-div").css({"margin-top":"95px", "margin-left":"50px"});
					}
				[/#if]
				jQuery("#summary-title-span").html("BUILD REPORT - " + imageId);
				
				//summary values - upper part
				var summaryData = ${imageSummary};
				var summary = summaryData[imageId];
				
				var imageDetailsURL = summary.imageSummary.serverURL;
				if (imageDetailsURL.substr(-1) != '/') { 
					imageDetailsURL = imageDetailsURL + "/";
				}
				imageDetailsURL = imageDetailsURL + "cs/#/assets/images/" + summary.imageSummary.sha;
				jQuery(".summary-text-content a").attr('href', imageDetailsURL);
				
				if(summary.imageSummary.pass === false){
					jQuery('#build-status').css('color', 'red');
					jQuery('.status-image').addClass('failed');
					jQuery('.status-image').removeClass('success');
					jQuery('#build-status').text("Failed");
				}else{
					jQuery('#build-status').css('color', 'green');
					jQuery('.status-image').removeClass('failed');
					jQuery('.status-image').addClass('success');
					jQuery("#build-reason-title").hide();
					jQuery('#build-status').text("Success");
				}
				
				
				
				jQuery("#image-tags").text(" - ");
				if (summary.imageSummary.hasOwnProperty("Tags") && summary.imageSummary.Tags)   {
					var tags = summary.imageSummary.Tags; 
					var tagsStr = tags.join(', ');
					jQuery("#image-tags").text(tagsStr);
				}
				var size = summary.imageSummary.size;
				var sizeStr = bytesToSize(parseInt(size));
				jQuery("#image-size").text(sizeStr);
				jQuery("span#imageId").html(summary.imageId);
				
				// Populate summary table cells
				drawSummaryTable(summaryData[imageId]);
				
				//first reset charts and then render
				resetCanvas("sevVulns", "sevVulns-chart-parent");
				resetCanvas("typeVulns", "typeVulns-chart-parent");
				resetCanvas("patchVulns", "patchVulns-chart-parent");
				
				renderConfirmedVulnsChart(summaryData[imageId]);
				renderPotentialVulnsChart(summaryData[imageId]);
				renderPatchableVulnsChart(summaryData[imageId]);
			}
			
			
			function drawSummaryTable(reportObject)
			{
				if(reportObject.potentialVulnsChecked) {
					jQuery("#potential-checked").html("*Criteria applied to potential vulnerabilities as well.");
				}
				
				if(reportObject.qids){
					if(reportObject.qids.configured){
						jQuery("#qid-found .image-scan-status").removeClass("not-configured").removeClass("fail").removeClass("ok").addClass(reportObject.qids.result ? "ok" : "fail");
						jQuery("#qid-found .image-scan-status .tooltip-text").html("<b>Configured:</b> "+reportObject.qids.configured + "<br><b>Found: </b>"+ (reportObject.qids.found ? reportObject.qids.found : "None"));
					}
					if(reportObject.qids.excluded){
						jQuery("#excluded-items .tooltip-text").html(reportObject.qids.excluded);
						jQuery("#excluded-items-list").html("<b>*Excluded QIDs: </b>" + reportObject.qids.excluded);
					}
				}
				if(reportObject.cveIds){
					if(reportObject.cveIds.configured){
						jQuery("#cve-found .image-scan-status").removeClass("not-configured").removeClass("fail").removeClass("ok").addClass(reportObject.cveIds.result ? "ok" : "fail");
						jQuery("#cve-found .image-scan-status .tooltip-text").html("<b>Configured:</b> "+reportObject.cveIds.configured + "<br><b>Found: </b>"+ (reportObject.cveIds.found ? reportObject.cveIds.found : "None"));
					}
					if(reportObject.cveIds.excluded){
						jQuery("#excluded-items .tooltip-text").html(reportObject.cveIds.excluded);
						jQuery("#excluded-items-list").html("<b>*Excluded CVEs: </b>" + reportObject.cveIds.excluded);
					}
				}
				
				if(reportObject.cvss){
					if(reportObject.cvss.configured != null && reportObject.cvss.configured >= 0){
						var version = "";
						if (reportObject.cvss.version == "3"){
							version = "3";
						} else{
							version = "2";
						}
						jQuery("#cvss-found .image-scan-status").removeClass("not-configured").removeClass("fail").removeClass("ok").addClass(reportObject.cvss.result ? "ok" : "fail");
						jQuery("#cvss-found .image-scan-status .tooltip-text").html("<b>Configured:</b> CVSSv"+ version +" more than or equal to "+reportObject.cvss.configured + "<br><b>Found: </b>"+ (reportObject.cvss.found ? reportObject.cvss.found : "None"));
					}
				}
				if(reportObject.software){
					if(reportObject.software.configured ){
						jQuery("#software-found .image-scan-status").removeClass("not-configured").removeClass("fail").removeClass("ok").addClass(reportObject.software.result ? "ok" : "fail");
						jQuery("#software-found .image-scan-status .tooltip-text").html("<b>Configured:</b> "+reportObject.software.configured + "<br><b>Found: </b>"+ (reportObject.software.found ? reportObject.software.found : "None"));
					}
				}
				var severities = reportObject.severities;
				for(var i=1; i<=5; i++){
					if(severities[i]){
						if(severities[i].configured !== null ){
							jQuery("#sev" + i + "-found .image-scan-status").removeClass("not-configured").removeClass("fail").removeClass("ok").addClass(severities[i].result ? "ok" : "fail");
							jQuery("#sev" + i + "-found .image-scan-status .tooltip-text").html("<b>Configured:</b> more than "+ severities[i].configured + "<br><b>Found: </b>"+ (severities[i].found !== null ? severities[i].found : "0"));
						}
					}
				}
				//Code to hide exclusion when add exclusion is unchecked
				if($('#excluded-items-list').text()=='')
				{
    					$('#excluded-items').hide();
  				}
  				else
  				{
  						$('#excluded-items').show();
  				}

			}
			
			function resetCanvas(id, parent){
				if(jQuery("#" + id)){
					jQuery("#" + id).remove(); // this is my <canvas> element
					jQuery("#" + parent).prepend('<canvas id="'+ id +'" width="180" height="180"> </canvas>');
					if(patchableChart != null){
						patchableChart.destroy();
				    }
					if(confirmChart != null){
						confirmChart.destroy();
				    }
					if(potentialChart != null){
						potentialChart.destroy();
				    }
				}
			}
			
			
			function renderPatchableVulnsChart(summaryData) {
			    var patchableData = summaryData.patchability;
				console.log("PatchableVulnsChart");
				console.log(patchableData);
			    c = jQuery("#patchVulns").get(0);
			    ctx = c.getContext("2d");
			
			    colors = ["#5D9933", "#D61E1C"];
			    //chart for patchability
			    if (!(patchableData['yes'] == '0' && patchableData['no'] == '0')) {
			        count = [patchableData['yes'], patchableData['no']];
			        labels = count;
			    } else {
			        count = ["1", "1"];
			        labels = ["0", "0"];
			        colors = ["#B0BFC6", "#B0BFC6"];
			    }

				console.log("PatchableVulnsChart count");
				console.log(count);

			    var patchVulnsdata = {
			        datasets: [{
			            data: count,
			            backgroundColor: colors
			        }],
			
			        // These labels appear in the legend and in the tooltips when hovering different arcs
			        labels: [
			            "Yes " + "(" + labels[0] + ")",
			            "No " + "(" + labels[1] + ")"
			        ]
			    };

				console.log("PatchableVulnsChart PatchVulnsData");
				console.log(patchVulnsdata);
			
			    var options = {
			        responsive: true,
			        plugins: {
			            legend: {
			                display: true,
			                position: 'right'
			            },
			            tooltip: {
			                enabled: true,
			                callbacks: {
			                    label: function(context) {
			                        var label = context.label;
			                        return label;
			                    }
			                }
			            }
			        }
			    }
			    patchableChart = new Chart(ctx, {
			        "type": 'doughnut',
			        "data": patchVulnsdata,
			        "options": options
			    });
			}
			
			function renderPotentialVulnsChart(summaryData) {
			    var severity = Array();
			    var potentialVulnsObj = summaryData.potentialVulnsBySev;

				console.log("PotentialVulnsChart");
				console.log(potentialVulnsObj);
			
			    count = Array();
			    severity = Array();
			    var i = 0;
			    total = 0;
			    for (var key in potentialVulnsObj) {
			        count[i] = potentialVulnsObj[key];
			        severity[i] = key;
			        total += count[i];
			        i++;
			    }

				console.log("PotentialVulnsChart count");
				console.log(count);
				console.log("PotentialVulnsChart severity");
				console.log(severity);
			
			    labels = count;
			    colors = ["#E8E4AE", "#F4BB48", "#FAA23B", "#DE672A", "#D61E1C"];
			    jQuery("#potTotCount").text(total);
			    if (!(count.some(el => el !== 0))) {
			        count = ["1", "1", "1", "1", "1"];
			        severity = ["1", "2", "3", "4", "5"];
			        labels = ["0", "0", "0", "0", "0"];
			        colors = ["#B0BFc6", "#B0BFc6", "#B0BFc6", "#B0BFc6", "#B0BFc6"];
			    }
			    var c = jQuery("#typeVulns").get(0);
			    var ctx = c.getContext("2d");
			    var pieData = {
			        datasets: [{
			            data: [count[4].toString(), count[3].toString(), count[2].toString(), count[1].toString(), count[0].toString()],
			            backgroundColor: [colors[4], colors[3], colors[2], colors[1], colors[0]],
			            borderWidth: 1
			        }],
			
			        // These labels appear in the legend and in the tooltips when hovering different arcs
			        labels: [
			            "Sev " + severity[4].toString() + " (" + labels[4] + ")",
			            "Sev " + severity[3].toString() + " (" + labels[3] + ")",
			            "Sev " + severity[2].toString() + " (" + labels[2] + ")",
			            "Sev " + severity[1].toString() + " (" + labels[1] + ")",
			            "Sev " + severity[0].toString() + " (" + labels[0] + ")"
			        ]
			    };

				console.log("PotentialVulnsChart PieData");
				console.log(pieData);

			    var options = {
			        responsive: true,
			        plugins: {
			            legend: {
			                display: true,
			                position: 'right'
			            },
			            tooltip: {
			                enabled: true,
			                callbacks: {
			                    label: function(context) {
			                        var label = context.label;
			                        return label;
			                    }
			                }
			            }
			        }
			    }
			
			    potentialChart = new Chart(ctx, {
			        "type": 'doughnut',
			        "data": pieData,
			        "options": options
			    });
		}
		
			function renderConfirmedVulnsChart(summaryData) {
			    var d = summaryData.confirmedVulnsBySev;
				console.log("ConfirmedVulnsChart confirmedVulnsBySev");
				console.log(d);
			    var count = Array();
			    var severity = Array();
			
			    var totalCount = [0, 0];
			    var totalTypes = ["Confirmed", "Potential"];
			    var c = jQuery("#sevVulns").get(0);
			    var ctx = c.getContext("2d");
			
			    var i = 0;
			    var total = 0;
			    for (var key in d) {
			        count[i] = d[key];
			        severity[i] = key;
			        total += count[i];
			        i++;
			    }
				console.log("ConfirmedVulnsChart count");
				console.log(count);
				console.log("ConfirmedVulnsChart severity");
				console.log(severity);
			    var colors = ["#E8E4AE", "#F4BB48", "#FAA23B", "#DE672A", "#D61E1C"];
			    var labels = count;
			    jQuery("#confTotCount").text(total);
			    if (!count.some(el => el !== 0)) {
			        count = ["1", "1", "1", "1", "1"];
			        severity = ["1", "2", "3", "4", "5"];
			        labels = ["0", "0", "0", "0", "0"];
			        colors = ["#B0BFc6", "#B0BFc6", "#B0BFc6", "#B0BFc6", "#B0BFc6"];
			    }
			
			    var options = {
			        responsive: true,
			        plugins: {
			            legend: {
			                display: true,
			                position: 'right'
			            },
			            tooltip: {
			                enabled: true,
			                callbacks: {
			                    label: function(context) {
			                        var label = context.label;
			                        return label;
			                    }
			                }
			            }
			        }
			    }
			
			    pieData = {
			        datasets: [{
			            data: [count[4].toString(), count[3].toString(), count[2].toString(), count[1].toString(), count[0].toString()],
			            backgroundColor: [colors[4], colors[3], colors[2], colors[1], colors[0]],
			        }],
			
			        // These labels appear in the legend and in the tooltips when hovering different arcs
			        labels: [
			            "Sev " + severity[4].toString() + " (" + labels[4] + ")",
			            "Sev " + severity[3].toString() + " (" + labels[3] + ")",
			            "Sev " + severity[2].toString() + " (" + labels[2] + ")",
			            "Sev " + severity[1].toString() + " (" + labels[1] + ")",
			            "Sev " + severity[0].toString() + " (" + labels[0] + ")"
			        ]
			    };
				console.log("ConfirmedVulnsChart PieData");
				console.log(pieData);
			    confirmChart = new Chart(ctx, {
			        "type": 'doughnut',
			        "data": pieData,
			        "options": options
			    });
			}
			
			function updateVulns(imageId){
				var summaryData = ${imageSummary};
				var summary = summaryData[imageId];
				var vulns = summary.vulnsTable;
				
				jQuery('#vulnsTable').html('<table id="vulnstablecontent" class="display" width="100%"></table>');
				
				var table = jQuery('#vulnstablecontent').DataTable({             
					 "language": {
		        		"emptyTable": "No vulnerabilities found"
		   			 },
		   			"dom": '<"vulns-table-top"l<"custom-filters">>rt<"vulns-table-bottom"ip><"clear">',
		            "aaData": vulns,
		            "aoColumns":[
			            {
				            "className": 'details-control',
				            "orderable": false,
				            "data":      null,
				            "defaultContent": '',
				            "width":"10px"
				        },
		                { "mData": "qid" },
		                { "mData": "title" },
		                { "mData": "severity" },
		                { "mData": "cveids" },
		                { "mData": "category" },
		                { "mData": "firstFound" },
		                { "mData": "software"},
		                { "mData": "patchAvailable"},
		                { "mData": "threatIntel"},
		                { "mData": "threatIntel"},
		                { "mData": "typeDetected"}
		                
		            ],
		            'aoColumnDefs': [
		            	{ "sTitle": "", "aTargets": [0], "width":"10px" },
		            	{ "sTitle": "QID", "aTargets": [1] },
		                { "sTitle": "Title", "aTargets": [2] },    
		                { "sTitle": "Severity", "aTargets": [3] },
		                { "sTitle": "CVEs", "aTargets": [4] ,
		                	"render":  function ( data, type, row ) {
		                				if(data.length > 1){
		                					return data[0] +' + <a href="#" class="more-cve-records">' + (data.length - 1) +' more</a>';
		                				}else{
		                					return data;
		                				}
		                			}
		                },
		                { "sTitle": "Category", "aTargets": [5] },
		                { "sTitle": "Age", "aTargets": [6] ,
		                	"render":  function ( data, type, row ) {
		                    				var today= new Date();
		                    				var pubDate = new Date(Number(data));
		                    				var diff = Math.abs(today - pubDate)/1000;
		                    				var days = Math.floor(diff / 86400);
		                    				return days + ' Day' + ((days > 1) ? 's' : '');
		                			}
		                },
		                { "sTitle": "Installed Software", "aTargets": [7],
		                	"render":  function ( data, type, row ) { 
		                                var numInstalledSoftwares = row["software"];
		                                var qid = row["qid"];
		                                var count = 0;
		                                for(var key in numInstalledSoftwares) {
		                                   if (numInstalledSoftwares.hasOwnProperty(key)) {
				                                   	count++;
		                                   }
		                                }
		                                if (count == 0) {
		                                    return '<div style="text-align:center;">-</div>';
		                                }
		                                else {
		                                    return '<div style="text-align:center;"><a href="#" onClick="showTab('+qid+')">'+count+'</a></div>';
		                                }                    			
		                			} },
		                
		                { "sTitle": "Patchable", "aTargets": [8], visible:false},
		                { "sTitle": "Exploitable", "aTargets": [9], visible:false, 
		                	"render":  function ( data, type, row ) {
		                    				return (data.easyExploit && data.easyExploit != null) ? 'true' : 'false';
		                			}
		                },
		                { "sTitle": "Associated Malware", "aTargets": [10], visible:false,
		                	"render":  function ( data, type, row ) {
		                    				return (data.malware && data.malware != null) ? 'true' : 'false';
		                			}
		                },
		                { "sTitle": "Confirmed", "aTargets": [11], visible:false}
		            ],
		            "order": [[ 3, "desc" ]]
		        });
		        
		        jQuery('#vulnsTable tbody').on('click', 'td.details-control', function () {
			        var tr = jQuery(this).closest('tr');
			        var row = table.row( tr );
			 
			        if ( row.child.isShown() ) {
			            // This row is already open - close it
			            row.child.hide();
			            tr.removeClass('shown');
			        }
			        else {
			            // Open this row
			            row.child( format(row.data()) ).show();
			            tr.addClass('shown');
			        }
			    });
			    
			    jQuery("#vulnsTable tbody").on("click", ".more-cve-records", function(e){
			    	var tr = jQuery(this).closest('tr');
			    	var row = table.row( tr );
			    	row.child( format(row.data()) ).show();
			        tr.addClass('shown');
			        return false;
			    });
			    
			    jQuery(".custom-filters").html(
			    	'<div class="sev-filter-div">' + 
			    	'<span class="filters-label">Show Only: </span>' + 
			    	'<span class="sev-filter-label" >Severity </span>' + 
			    	'<select class="severity-dropdown">' + 
			    	'<option value="">All</option>' +
			    	'<option value="5"> 5 </option>' +
			    	'<option value="4"> 4 </option>' +
			    	'<option value="3"> 3 </option>' +
			    	'<option value="2"> 2 </option>' +
			    	'<option value="1"> 1 </option>' +
			    	'</select>' +
			    	'</div>'+
			    	'<ul class="filters-list">' +
			    	'<li><input class="custom-filter-checkbox" type="checkbox" id="confirmed" value="confirmed">  <label for="confirmed" class="checkbox-title"> Confirmed  </li>' +
			    	'<li><input class="custom-filter-checkbox" type="checkbox" id="patchable" value="patchable">  <label for="patchable" class="checkbox-title"> Patchable  </li>' +
			    	'<li><input class="custom-filter-checkbox" type="checkbox" id="exploitable" value="exploitable"><label for="exploitable" class="checkbox-title" > Exploitable </li>' +
			    	'<li><input class="custom-filter-checkbox" type="checkbox" id="malware" value="malware"> <label for="malware" class="checkbox-title" > Associated Malware </li>' +
			    	'</ul>' 
			    );
			    
			    jQuery(".custom-filters-left").html(
			    	
			    );
			    
			    jQuery('.severity-dropdown').on('change', function(e){
			    	 var optionSelected = jQuery("option:selected", this);
		    		 var valueSelected = this.value;
		    		 table.columns(3).search( valueSelected ).draw();
			    });
			    
			    jQuery(".custom-filter-checkbox").on("change", function(e){
					switch(this.value){
						case 'confirmed':
									var value = (this.checked)? 'confirmed' : '';
									table.columns(11).search( value ).draw();
									break;
						case 'patchable':
									var value = (this.checked)? 'true' : '';
									table.columns(8).search( value ).draw();
									break;
									
						case 'exploitable': 
									var value = (this.checked)? 'true' : '';
									table.columns(9).search( value ).draw();
									break;
						case 'malware': 
									var value = (this.checked)? 'true' : '';
									table.columns(10).search( value ).draw();
									break;
					}
				});
			}
			
			function updateLayers(imageId){
				var summaryData = ${imageSummary};
				var summary = summaryData[imageId];
				var layers = summary.layersTable;
				jQuery('#layersTable').html('<table id="layersTablecontent" class="display" width="100%"></table>');
				
				var layersTable = jQuery('#layersTablecontent').DataTable({            
					 "language": {
		        		"emptyTable": "No layers found"
		   			 },   			 
					"dom": '<"layers-table-top"l<"#search" "search-box">>frt<"layers-table-bottom"ip><"clear">',
		            "aaData": layers,
		            "aoColumns":[
		            	{ "mData": "",
		                  "mData": "createdBy"
		                }                
		            ],
		            'aoColumnDefs': [
		            	{ "sTitle": "#", "aTargets": [0], visible: true,
		                    render : function ( data, type, row, meta ) {
		                        return meta.row + meta.settings._iDisplayStart + 1;      
		                    }
		                },
		                { "sTitle": "Command", "aTargets": [1],
		                    render : function ( data, type, row ) { 
		                         return row["createdBy"];                                               
		                    }
		                }
		            ]
		        });
			}
			
	        jQuery('#softwareTablecontent_filter input').keyup(function(){
	            var searchInput = jQuery("#softwareTablecontent_filter input").val(); 
	            softwareTable.columns().search('').draw(); 
	        });
			
			function updateSoftwares(imageId){
				var summaryData = ${imageSummary};
				var summary = summaryData[imageId];
				var installedSoftwares = summary.softwaresTable;
				
				jQuery('#softwareTable').html('<table id="softwareTablecontent" class="display" width="100%"></table>');
				
				var softwareTable = jQuery('#softwareTablecontent').DataTable({
					 "language": {
		        		"emptyTable": "No Softwares installed"
		   			 },
		   			"dom": '<"soft-table-top"l<"#search" "search-box">>frt<"vulns-table-bottom"ip><"clear">',
		            "aaData": installedSoftwares,
		            "aoColumns":[
		            	{ "mData": "name" },
		                { "mData": "version" },
		                { "mData": "fixVersion", sDefaultContent :  '' },
		                { "mData": "vulnerabilities", sDefaultContent :  ''  }
		                
		            ],
		            'aoColumnDefs': [
		            	{ "sTitle": "Name", "aTargets": [0] },
		                { "sTitle": "Installed Version", "aTargets": [1],
		                "render":  function ( data, type, row ) {
		                                var fixedVersion = row["fixVersion"];
		                                if (fixedVersion!= null && fixedVersion!= '') {
		                                    return '<div class="status-image vuln"></div>'+data;
		                                }
		                                else {
		                                    return data;
		                                }
		                           }
		                },
		                { "sTitle": "Fixed In Version", "aTargets": [2]},
		                { "sTitle": "Total QID", "aTargets": [3] , visible:false,
		                "render":  function ( data, type, row ) {
		                                var vulnerabilities = row["vulnerabilities"];       
		                                return JSON.stringify(vulnerabilities);       
		                           }
		                },
		                { "sTitle": "QID", "aTargets": [4] , visible:false,
		                "render":  function ( data, type, row ) {
		                                    var QIDString = "";
		                                    var vulnerabilities = row["vulnerabilities"]; 
		                                    if (vulnerabilities!= null && vulnerabilities.length > 0) {        
		                                        vulnerabilities.forEach(function(key) {
		                                            QIDString +="QID="+key.qid+",";
		                                        });        
		                                    }                                    
		                                return QIDString;       
		                           }
		                }
		            ],
		            "order": [[ 0, "desc" ]]
		        });
			
			}
			
			function renderContents(imageId, tab){
				switch(tab){
					case "summary":
							updateSummary(imageId);
							break;
					case "vulns":
							updateVulns(imageId);
							break;
					case "softwares":
							updateSoftwares(imageId);
							break;
					case "layers":
							updateLayers(imageId);
							break;
				}
				jQuery("div.left-panel").css("height",jQuery("div.right-panel").height());
			}
				
		</script>
	[#else]
		<b>${reportResult.message}</b>
	[/#if]
	
</body>
</html>