/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;

class NativeLoader {
    private static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final boolean isMac;
    private static final boolean isLinux;
    private static final boolean isWindows;
    private static final String pid;
    private static final String tempFilePrefix = "libsbtipcsocket";

    NativeLoader() {
    }

    private static Path runtimeDir() {
        String string;
        String string2 = System.getProperty("sbt.ipcsocket.tmpdir");
        if (string2 != null) {
            return Paths.get(string2, new String[0]);
        }
        String string3 = System.getenv("XDG_RUNTIME_DIR");
        if (string3 == null) {
            string3 = System.getProperty("java.io.tmpdir");
        }
        if ((string = System.getProperty("user.home")) == null) {
            string = "unknown_home";
        }
        return Paths.get(string3, new String[0]).resolve(".sbt" + Integer.toString(string.hashCode())).resolve("ipcsocket");
    }

    static void load() throws UnsatisfiedLinkError {
        if (!loaded.get()) {
            String string = System.getProperty("os.name", "").toLowerCase();
            boolean bl = string.startsWith("mac");
            boolean bl2 = string.startsWith("linux");
            boolean bl3 = string.startsWith("windows");
            boolean bl4 = System.getProperty("sun.arch.data.model", "64").equals("64");
            String string2 = System.getProperty("os.arch", "").toLowerCase();
            if (string2.equals("amd64")) {
                string2 = "x86_64";
            }
            if (bl || bl3) {
                string2 = "x86_64";
            }
            if (bl4 && (bl || bl2 || bl3)) {
                String string3 = "." + (bl ? "dylib" : (bl3 ? "dll" : "so"));
                String string4 = (bl3 ? "" : "lib") + "sbtipcsocket" + string3;
                String string5 = bl ? "darwin" : (bl2 ? "linux" : "win32");
                String string6 = string5 + "/" + string2 + "/" + string4;
                URL uRL = NativeLoader.class.getClassLoader().getResource(string6);
                if (uRL == null) {
                    throw new UnsatisfiedLinkError(string6 + " not found on classpath");
                }
                try {
                    Object object;
                    Path path = Files.createDirectories(NativeLoader.runtimeDir(), new FileAttribute[0]);
                    Path path2 = Files.createTempFile(path, tempFilePrefix, string3, new FileAttribute[0]);
                    try {
                        object = uRL.openStream();
                        Throwable throwable = null;
                        try (FileChannel fileChannel = FileChannel.open(path2, StandardOpenOption.WRITE);){
                            boolean bl5 = false;
                            int n = 0;
                            byte[] byArray = new byte[1024];
                            do {
                                if ((n = ((InputStream)object).read(byArray)) <= 0) continue;
                                fileChannel.write(ByteBuffer.wrap(byArray, 0, n));
                            } while (n > 0);
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((InputStream)object).close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw new UnsatisfiedLinkError();
                    }
                    path2.toFile().deleteOnExit();
                    if (!pid.isEmpty()) {
                        object = Paths.get(path2.toString() + ".pid", new String[0]);
                        Files.write((Path)object, pid.getBytes(), new OpenOption[0]);
                        object.toFile().deleteOnExit();
                    }
                    try {
                        System.load(path2.toString());
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        Files.deleteIfExists(path2);
                        throw unsatisfiedLinkError;
                    }
                    loaded.set(true);
                    object = new Thread((Runnable)new CleanupRunnable(), "ipcsocket-jni-cleanup");
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                    return;
                }
                catch (IOException iOException) {
                    throw new UnsatisfiedLinkError(iOException.getMessage());
                }
            }
            throw new UnsatisfiedLinkError();
        }
    }

    static {
        String string = System.getProperty("os.name", "").toLowerCase();
        isMac = string.startsWith("mac");
        isLinux = string.startsWith("linux");
        isWindows = string.startsWith("windows");
        pid = isWindows ? "" : ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", "");
    }

    private static class CleanupRunnable
    implements Runnable {
        private CleanupRunnable() {
        }

        @Override
        public void run() {
            try {
                Files.walkFileTree(NativeLoader.runtimeDir(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (!path.getFileName().toString().startsWith(NativeLoader.tempFilePrefix)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (isWindows) {
                            try {
                                Files.deleteIfExists(path);
                            }
                            catch (IOException iOException) {}
                        } else if (path.toString().endsWith(".pid")) {
                            String string = new String(Files.readAllBytes(path));
                            boolean bl = true;
                            Process process = new ProcessBuilder("ps", "-p", string).start();
                            try {
                                process.waitFor();
                                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                                String string2 = bufferedReader.readLine();
                                while (string2 != null) {
                                    bl = string2.contains(string + " ");
                                    string2 = bufferedReader.readLine();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!bl) {
                                Files.deleteIfExists(Paths.get(path.toString().replaceAll(".pid", ""), new String[0]));
                                Files.deleteIfExists(path);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                        try {
                            Files.deleteIfExists(path);
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        }
                        catch (IOException iOException2) {
                            throw iOException2;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

