/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Helper {
    public static final String TASK_SECURE_TOKEN = "qualys_task_secure_token";
    public static final String ARTIFACT_DIR_NAME = "Qualys_Plugin_Artifacts";
    public static final String QUALYS_GLOBAL_CONFIG = "QualysPluginGlobalConfig";
    private static final Logger logger = Logger.getLogger(Helper.class.getName());

    public static void createNewFile(String rootDir, String filename, String content, BuildLogger buildLogger) {
        File f = new File(rootDir + File.separator + filename + ".json");
        buildLogger.addBuildLogEntry("Writing file =" + f.getAbsolutePath());
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            logger.info("Directory cannot be created");
        }
        if (!f.exists()) {
            try {
                if (!f.createNewFile()) {
                    logger.info("File already exists or failed creating file " + filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                buildLogger.addBuildLogEntry("Failed creating file " + filename + ", reason =" + e.getMessage());
            }
        }
        try {
            File dir = new File(f.getParentFile(), f.getName());
            PrintWriter writer = new PrintWriter(dir, "UTF-8");
            writer.print(content);
            writer.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            buildLogger.addBuildLogEntry("Failed writing to file " + filename + ", reason =" + e.getMessage());
        }
        buildLogger.addBuildLogEntry("Created new file = " + filename + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(String zipFile, String srcDir) {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        FileInputStream fis = null;
        try {
            byte[] buffer = new byte[1024];
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            File dir = new File(srcDir);
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".json");
                }
            });
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                int length;
                System.out.println("Adding file: " + files[i].getName());
                fis = new FileInputStream(files[i]);
                zos.putNextEntry(new ZipEntry(files[i].getName()));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
        }
        catch (IOException ioe) {
            System.out.println("Error creating zip file" + ioe);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    logger.info("Error creating zip file" + e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.info("Error creating zip file" + e);
                }
            }
        }
    }
}

