/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity.httpClient;

import com.google.common.base.Preconditions;
import com.qualys.bamboo.plugin.containerSecurity.util.CertificateUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LocalDirectorySSLConfig
implements Serializable {
    private static final long serialVersionUID = -4736328026418377358L;
    private final String dockerCertPath;

    public LocalDirectorySSLConfig(String dockerCertPath) {
        Preconditions.checkNotNull((Object)dockerCertPath);
        this.dockerCertPath = dockerCertPath;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public SSLContext getSSLContext() throws Exception {
        boolean certificatesExist = CertificateUtils.verifyCertificatesExist(this.dockerCertPath);
        if (certificatesExist) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                String caPemPath = this.dockerCertPath + File.separator + "ca.pem";
                String keyPemPath = this.dockerCertPath + File.separator + "key.pem";
                String certPemPath = this.dockerCertPath + File.separator + "cert.pem";
                SSLContext sslContext = null;
                String keypem = new String(Files.readAllBytes(Paths.get(keyPemPath, new String[0])));
                String certpem = new String(Files.readAllBytes(Paths.get(certPemPath, new String[0])));
                String capem = new String(Files.readAllBytes(Paths.get(caPemPath, new String[0])));
                String kmfAlgorithm = System.getProperty("ssl.keyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                keyManagerFactory.init(CertificateUtils.createKeyStore(keypem, certpem), "docker".toCharArray());
                String tmfAlgorithm = System.getProperty("ssl.trustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                trustManagerFactory.init(CertificateUtils.createTrustStore(capem));
                try {
                    sslContext = SSLContext.getInstance("TLSv1.3");
                }
                catch (Exception e) {
                    sslContext = SSLContext.getInstance("TLSv1.2");
                }
                if (sslContext != null) {
                    sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                }
                return sslContext;
            }
            catch (Exception e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        return null;
    }

    private PrivilegedAction<String> getSystemProperty(String name, String def) {
        return () -> System.getProperty(name, def);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDirectorySSLConfig that = (LocalDirectorySSLConfig)o;
        return this.dockerCertPath.equals(that.dockerCertPath);
    }

    public int hashCode() {
        return this.dockerCertPath.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "dockerCertPath=" + this.dockerCertPath + "}";
    }
}

