/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.security.SecureToken;
import com.qualys.bamboo.plugin.containerSecurity.util.BambooFileStorageHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.JsonParser;
import qshaded.com.google.gson.reflect.TypeToken;

@AnonymousSiteAccess
public class ViewBuildQualysReport
extends ViewBuildResults {
    private List<String> vulns;
    private List<String> images;
    private JsonObject imageSummary;
    private String totalVulnsCountSummary;
    private String buildSummary;
    private int prevRunBuildNumber;
    private String prevRunSummary;
    private File workingDirectory;
    private JsonObject totalVulnsTrend;
    private Map<String, String> reportResult;
    private String buildStatus;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ViewBuildQualysReport.class.getName());
    private String filename;

    public String execute() throws Exception {
        try {
            this.reportResult = new HashMap<String, String>();
            this.reportResult.put("status", "1");
            this.totalVulnsTrend = new JsonObject();
            String planKey = this.getPlanKey();
            PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)planKey, (int)this.buildNumber);
            BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
            ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(null);
            storageHelper.setArtifactDefinition(artifact);
            storageHelper.setResultKey(resultKey);
            try {
                this.workingDirectory = storageHelper.buildArtifactRootDirectory();
            }
            catch (Exception e1) {
                logger.info("Error building artifact root directory; " + e1.getMessage());
            }
            this.filename = this.workingDirectory.getAbsolutePath() + File.separator + "qualys_images_summary.json";
            this.extractImageIds();
            this.setPreviousRunSummary();
            logger.info("######## Previous run summary set");
            ImmutableResultsSummary rs = Objects.requireNonNull(this.getImmutablePlan()).getLatestResultsSummary();
            if (rs == null) {
                return "error";
            }
            Map buildData = rs.getCustomBuildData();
            this.populateResult(buildData);
            if (this.images == null || this.images.isEmpty() || this.images.size() == 0) {
                this.reportResult.put("status", "0");
                this.reportResult.put("message", "No Images found to scan!");
            }
            logger.info("######## End of execute");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Error while executing Build Report = " + e.getMessage());
            return "error";
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousRunSummary() {
        this.prevRunBuildNumber = this.buildNumber;
        String result = null;
        Reader fr = null;
        for (int i = this.buildNumber - 1; i > 0; --i) {
            try {
                String planKey = this.getPlanKey();
                PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)planKey, (int)i);
                BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
                SecureToken token = SecureToken.createFromString((String)"qualys_task_secure_token");
                ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(token);
                storageHelper.setArtifactDefinition(artifact);
                storageHelper.setResultKey(resultKey);
                File buildDir = storageHelper.buildArtifactRootDirectory();
                String tempFilename = buildDir.getAbsolutePath() + File.separator + "qualys_images_summary.json";
                File f = new File(tempFilename);
                FileInputStream inputStream = new FileInputStream(tempFilename);
                fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
                if (!f.exists()) continue;
                JsonElement jsonElement = JsonParser.parseReader(fr);
                JsonArray trending = jsonElement.getAsJsonObject().get("trendingData").getAsJsonArray();
                result = trending.toString();
                this.prevRunBuildNumber = i;
                break;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                logger.info("Error getting Previous build result");
                continue;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        logger.info("Error closing file reader");
                    }
                }
            }
        }
        this.prevRunSummary = result;
    }

    public Map<String, String> getReportResult() {
        return this.reportResult;
    }

    public String getBuildStatus() {
        this.buildStatus = this.buildStatusHelper.getBuild().getCurrentStatus();
        return this.buildStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateResult(Map<String, String> buildData) {
        JsonElement jsonElement;
        FileInputStream inputStream;
        Reader fr = null;
        try {
            inputStream = new FileInputStream(this.filename);
            fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            jsonElement = JsonParser.parseReader(fr);
            if (this.images != null && !this.images.isEmpty()) {
                this.imageSummary = jsonElement.getAsJsonObject().get("scanResult").getAsJsonObject();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.reportResult.put("status", "0");
            this.reportResult.put("message", "image-summary.json file artifact not found!" + e.getMessage());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    logger.info("Error closing file reader");
                }
            }
        }
        try {
            inputStream = new FileInputStream(this.filename);
            fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            jsonElement = JsonParser.parseReader(fr);
            this.totalVulnsCountSummary = jsonElement.getAsJsonObject().get("trendingData").getAsJsonArray().toString();
            logger.info("########totalVulnsCountSummary =" + this.totalVulnsCountSummary);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.totalVulnsCountSummary = "";
            logger.info("Error while reading totalVulnsCountSummary file. Reason: " + e.getMessage());
            this.reportResult.put("status", "0");
            this.reportResult.put("message", "totalVulnsCountSummary.json file artifact not found!");
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    logger.info("Error closing file reader");
                }
            }
        }
        try {
            this.buildSummary = "";
        }
        catch (Exception e) {
            this.buildSummary = "";
        }
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractImageIds() {
        Reader fr = null;
        try {
            logger.info("ViewBuildQualysReport extractImageIds filename: " + this.filename);
            FileInputStream inputStream = new FileInputStream(this.filename);
            fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JsonElement jsonElement = JsonParser.parseReader(fr);
            JsonObject scanResultObj = jsonElement.getAsJsonObject().get("scanResult").getAsJsonObject();
            this.images = new ArrayList<String>();
            this.images.addAll(scanResultObj.keySet());
            logger.info("############### Images = " + scanResultObj.keySet().toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Error while reading imagesList file. Reason: " + e.getMessage());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    logger.info("Error closing file reader");
                }
            }
        }
    }

    public List<String> getImages() {
        return this.images;
    }

    public JsonObject getTotalVulnsTrend() {
        if (this.totalVulnsCountSummary == null || this.totalVulnsCountSummary.equals("")) {
            return null;
        }
        Gson gson = new Gson();
        JsonArray totalVulns = null;
        for (String image : this.images) {
            JsonObject obj = new JsonObject();
            JsonObject obj1 = null;
            JsonArray rposArr = new JsonArray();
            JsonParser parser = new JsonParser();
            JsonElement element = JsonParser.parseString(this.totalVulnsCountSummary);
            JsonArray array = element.getAsJsonArray();
            for (JsonElement el : array) {
                obj1 = el.getAsJsonObject();
                String imageId = obj1.get("imageId").getAsString();
                if (!imageId.equals(image)) continue;
                rposArr = obj1.get("repos").getAsJsonArray();
                JsonElement arrEl = obj1.get("confirmedVulns");
                if (arrEl == null || arrEl.isJsonNull()) continue;
                totalVulns = obj1.get("confirmedVulns").getAsJsonArray();
            }
            try {
                obj.add("current", totalVulns);
                obj.addProperty("prevBuildNumber", this.prevRunBuildNumber);
                obj.addProperty("addChart", "1");
                obj.addProperty("prev", "null");
                if (rposArr == null) {
                    obj.addProperty("addChart", "0");
                }
                if (this.prevRunSummary != null && rposArr != null) {
                    element = JsonParser.parseString(this.prevRunSummary);
                    JsonArray sumArray = element.getAsJsonArray();
                    Type listType = TypeToken.getParameterized(List.class, new Type[]{String.class}).getType();
                    List currRepos = (List)gson.fromJson(rposArr.toString(), listType);
                    for (JsonElement el : sumArray) {
                        JsonArray vulnsArr;
                        JsonElement vulnsArrEl;
                        JsonObject rpoObj = el.getAsJsonObject();
                        JsonArray repoArray = rpoObj.get("repos").getAsJsonArray();
                        List reposArrayList = (List)gson.fromJson(repoArray.toString(), listType);
                        if (currRepos == null || reposArrayList == null || currRepos.size() != reposArrayList.size()) continue;
                        currRepos.removeAll(reposArrayList);
                        if (!currRepos.isEmpty() || (vulnsArrEl = rpoObj.get("confirmedVulns")) == null || vulnsArrEl.isJsonNull() || !vulnsArrEl.isJsonArray() || (vulnsArr = vulnsArrEl.getAsJsonArray()) == null || vulnsArr.isJsonNull()) continue;
                        obj.add("prev", vulnsArr);
                    }
                }
                this.totalVulnsTrend.add(image, obj);
                logger.info("Total Vulns Trend = " + this.totalVulnsTrend.toString());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Exception in rendering report =" + e.getMessage());
            }
        }
        return this.totalVulnsTrend;
    }

    public JsonArray getLayers() {
        Gson gson = new Gson();
        JsonObject result = this.getImageSummary();
        JsonObject element = gson.fromJson((JsonElement)result, JsonObject.class);
        JsonObject jsonObj = element.getAsJsonObject();
        return jsonObj.get("layers").getAsJsonArray();
    }

    public JsonObject getFailReason() {
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("status", "Success");
        resultObj.addProperty("failReason", "");
        if (this.buildSummary == null || this.buildSummary.isEmpty()) {
            return resultObj;
        }
        try {
            JsonElement element = JsonParser.parseString(this.buildSummary);
            JsonArray jsonArr = element.getAsJsonArray();
            Object QIDstatus = "";
            Object SeverityStatus = "";
            Object CVEstatus = "";
            for (JsonElement pa : jsonArr) {
                JsonObject obj = pa.getAsJsonObject();
                QIDstatus = (String)QIDstatus + (String)(obj.has("QID") ? "\n" + obj.get("QID").getAsString() : "");
                CVEstatus = (String)CVEstatus + (String)(obj.has("CVE") ? "\n" + obj.get("CVE").getAsString() : "");
                SeverityStatus = (String)SeverityStatus + (String)(obj.has("Severity") ? "\n" + obj.get("Severity").getAsString() : "");
            }
            String status = (String)QIDstatus + (String)CVEstatus + (String)SeverityStatus;
            String replaceMsg = status.replace("\n", "<br />");
            if (QIDstatus == "" && SeverityStatus == "" && CVEstatus == "") {
                resultObj.addProperty("status", "Success");
                resultObj.addProperty("failReason", "");
            } else {
                resultObj.addProperty("failReason", replaceMsg);
                resultObj.addProperty("status", "Failed");
            }
            return resultObj;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Error : " + e.getMessage());
            return null;
        }
    }

    public JsonObject getImageSummary() {
        return this.imageSummary;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

