/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.BambooTextProvider;
import com.qualys.bamboo.plugin.containerSecurity.QualysImageScanTask;
import com.qualys.plugins.common.QualysAuth.QualysAuth;
import com.qualys.plugins.common.QualysClient.QualysCSClient;
import com.qualys.plugins.common.QualysClient.QualysCSTestConnectionResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualysImageScanTaskConfigurator
extends AbstractTaskConfigurator {
    private transient BambooTextProvider bambooTextProvider;
    private LinkedHashMap<String, String> cvssVersionsList;
    private transient EncryptionService encryptionService;
    public static final String CREATE_MODE = "create";
    public static final String EDIT_MODE = "edit";
    public static final String MODE = "mode";
    public static final String GLOBAL_CONFIG = "globalConfig";
    public static final String LOCAL_CONFIG = "localConfig";
    public static final String GLOBAL_CONFIG_MSG = "Use Global Config (configured using Admin UI)";
    public static final String LOCAL_CONFIG_MSG = "Configure locally";
    public static final String EXCLUDE_BY_QID = "excludeQid";
    public static final String EXCLUDE_BY_CVE = "excludeCve";
    public static final String EXCLUDE_BY_QID_MSG = "QIDs";
    public static final String EXCLUDE_BY_CVE_MSG = "CVEs";
    public static final String ENCRYPTED_PASSWORD = "password_is_encrypted";
    private String originalPassword;
    private String originalProxyPassword;
    public static final String failOnQID = "failOnQID";
    private static final List<String> FIELDS_TO_COPY_ALWAYS = List.of("apiServer", "username", "password", "pollingInterval", "vulnsTimeout", "failOnQID", "qidList", "failOnCve", "cveList", "failOnSoftware", "failOnCvss", "cvssThreshold", "cvssVersion", "softwareList", "failOnSeverity", "isSev1Vulns", "isSev2Vulns", "isSev3Vulns", "isSev4Vulns", "isSev5Vulns", "severity1", "severity2", "severity3", "severity4", "severity5", "potential", "imageIds", "useProxy", "proxyServer", "proxyPort", "proxyUsername", "proxyPassword", "pluginConfigOptions", "addExclusion", "excludeOptions", "excludeByQid", "excludeByCve", "webhook", "dockerUrl", "dockerCert");
    private static final List<String> FIELDS_TO_COPY_SECURE = List.of("apiServer", "username", "password", "pollingInterval", "vulnsTimeout", "failOnQID", "qidList", "failOnCve", "cveList", "failOnSoftware", "failOnCvss", "cvssThreshold", "cvssVersion", "softwareList", "failOnSeverity", "isSev1Vulns", "isSev2Vulns", "isSev3Vulns", "isSev4Vulns", "isSev5Vulns", "severity1", "severity2", "severity3", "severity4", "severity5", "potential", "imageIds", "useProxy", "proxyServer", "proxyPort", "proxyUsername", "proxyPassword", "pluginConfigOptions", "addExclusion", "excludeOptions", "excludeByQid", "excludeByCve", "webhook", "dockerUrl", "dockerCert");
    private static final Logger logger = Logger.getLogger(QualysImageScanTaskConfigurator.class.getName());
    private static final Map PLUGIN_CONFIG_OPTIONS = new HashMap();
    private static final Map EXCLUDE_OPTIONS = new HashMap();

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.copyFromParams(config, params, FIELDS_TO_COPY_ALWAYS);
        String password = params.getString("password");
        String proxyPassword = params.getString("proxyPassword");
        if (previousTaskDefinition != null && (password == null || password.equals("") || password.isEmpty() || password.equals(ENCRYPTED_PASSWORD))) {
            config.put("password", (String)previousTaskDefinition.getConfiguration().get("password"));
            this.originalPassword = (String)previousTaskDefinition.getConfiguration().get("password");
        } else {
            config.put("password", password);
            this.originalPassword = password;
        }
        if (proxyPassword != null) {
            if (previousTaskDefinition != null && proxyPassword.equals(ENCRYPTED_PASSWORD)) {
                config.put("proxyPassword", (String)previousTaskDefinition.getConfiguration().get("proxyPassword"));
                this.originalProxyPassword = (String)previousTaskDefinition.getConfiguration().get("proxyPassword");
            } else {
                config.put("proxyPassword", proxyPassword);
                this.originalProxyPassword = proxyPassword;
            }
        }
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForLists(context);
        context.put("apiServer", "https://qualysapi.qualys.com");
        context.put("pollingInterval", "30");
        context.put("vulnsTimeout", "600");
        context.put("severity1", "0");
        context.put("severity2", "0");
        context.put("severity3", "0");
        context.put("severity4", "0");
        context.put("severity5", "0");
        context.put("dockerUrl", "unix:///var/run/docker.sock");
        context.put("pluginConfigOptions", LOCAL_CONFIG);
        context.put("excludeOptions", EXCLUDE_BY_CVE);
        this.cvssVersionsList = new LinkedHashMap();
        this.cvssVersionsList.put("2", "2");
        this.cvssVersionsList.put("3", "3");
        context.put("cvssVersionsList", this.cvssVersionsList);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForLists(context);
        this.copyFromDefinition(context, taskDefinition, FIELDS_TO_COPY_SECURE);
        context.put(MODE, EDIT_MODE);
        if (context.get("password") != null) {
            if (!context.get("password").toString().equals(ENCRYPTED_PASSWORD)) {
                this.originalPassword = context.get("password").toString();
            }
            context.put("password", ENCRYPTED_PASSWORD);
        }
        if (context.get("proxyPassword") != null && !context.get("proxyPassword").toString().isEmpty()) {
            if (!context.get("proxyPassword").toString().equals(ENCRYPTED_PASSWORD)) {
                this.originalProxyPassword = context.get("proxyPassword").toString();
            }
            context.put("proxyPassword", ENCRYPTED_PASSWORD);
        }
        if (context.get("dockerUrl") == null || context.get("dockerUrl").toString().isEmpty()) {
            context.put("dockerUrl", "unix:///var/run/docker.sock");
        }
        if (context.get("pollingInterval") == null || context.get("pollingInterval").toString().isEmpty()) {
            context.put("pollingInterval", TimeUnit.MILLISECONDS.toSeconds(QualysImageScanTask.DEFAULT_POLLING_INTERVAL_FOR_VULNS));
        }
        if (context.get("vulnsTimeout") == null || context.get("vulnsTimeout").toString().isEmpty()) {
            context.put("vulnsTimeout", TimeUnit.MILLISECONDS.toSeconds(QualysImageScanTask.DEFAULT_TIMEOUT_FOR_VULNS));
        }
        if (context.get("excludeOptions") == null || context.get("excludeOptions").toString().isEmpty()) {
            context.put("excludeOptions", EXCLUDE_BY_CVE);
        }
        this.cvssVersionsList = new LinkedHashMap();
        this.cvssVersionsList.put("2", "2");
        this.cvssVersionsList.put("3", "3");
        context.put("cvssVersionsList", this.cvssVersionsList);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        this.copyFromDefinition(context, taskDefinition, FIELDS_TO_COPY_ALWAYS);
    }

    private void copyFromParams(Map<String, String> target, ActionParametersMap params, List<String> keys) {
        for (String key : keys) {
            String value = params.getString(key);
            if (value == null) continue;
            target.put(key, value);
        }
    }

    private void copyFromDefinition(Map<String, Object> context, TaskDefinition def, List<String> keys) {
        Map cfg = def.getConfiguration();
        for (String key : keys) {
            String value = (String)cfg.get(key);
            if (value == null) continue;
            context.put(key, value);
        }
    }

    private void populateContextForLists(@NotNull Map<String, Object> context) {
        if (PLUGIN_CONFIG_OPTIONS.isEmpty()) {
            PLUGIN_CONFIG_OPTIONS.put(GLOBAL_CONFIG, GLOBAL_CONFIG_MSG);
            PLUGIN_CONFIG_OPTIONS.put(LOCAL_CONFIG, LOCAL_CONFIG_MSG);
        }
        context.put("pluginConfigOptionsMap", PLUGIN_CONFIG_OPTIONS);
        if (EXCLUDE_OPTIONS.isEmpty()) {
            EXCLUDE_OPTIONS.put(EXCLUDE_BY_QID, EXCLUDE_BY_QID_MSG);
            EXCLUDE_OPTIONS.put(EXCLUDE_BY_CVE, EXCLUDE_BY_CVE_MSG);
        }
        context.put("excludeOptionsMap", EXCLUDE_OPTIONS);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String URL_REGEX = "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String CVE_REGEX = "CVE-\\d{4}-\\d{4,7}";
        String PROXY_REGEX = "^[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";
        String DOCKER_URL_REGEX = "^(unix|tcp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*";
        String IMAGE_ID_REGEX = "^([A-Fa-f0-9]{12}|[A-Fa-f0-9]{64})$";
        String IMAGE_NAME_REGEX = "^(?:(?=[^:\\/]{4,253})(?!-)[a-zA-Z0-9-]{1,63}(?<!-)(?:\\.(?!-)[a-zA-Z0-9-]{1,63}(?<!-))*(?::[0-9]{1,5})?/)?((?![:\\/._-])(?:[a-z0-9._-]*)(?<![:\\/._-])(?:/(?![._-])[a-z0-9._-]+(?<![._-]))*)(?::(?![.-])[a-zA-Z0-9_.-]{1,128})?$";
        String IMAGE_ENV_VAR = "\\$\\{(.*?)}";
        super.validate(params, errorCollection);
        String pluginConfigOptions = params.getString("pluginConfigOptions");
        if (pluginConfigOptions == null) {
            errorCollection.addError("pluginConfigOptions", "You must select one of the Plugin config options");
            return;
        }
        if (pluginConfigOptions.equals(LOCAL_CONFIG)) {
            boolean addExclusion;
            boolean isPotentialVulnsToBeChecked;
            boolean failOnSeverity;
            Pattern patt2;
            Matcher matcher;
            String imageIds;
            Pattern patt3;
            Matcher matcher2;
            String stageTimeout;
            Pattern patt4;
            Matcher matcher3;
            String pollingInterval;
            String password;
            String apiServer = params.getString("apiServer");
            if (StringUtils.isEmpty((CharSequence)apiServer)) {
                errorCollection.addError("apiServer", "You must specify a Qualys API server to connect to");
            } else {
                Pattern patt5 = Pattern.compile(URL_REGEX);
                Matcher matcher4 = patt5.matcher(apiServer);
                if (!matcher4.matches()) {
                    errorCollection.addError("apiServer", "API Server URL is not valid!");
                }
            }
            String dockerUrl = params.getString("dockerUrl");
            if (!StringUtils.isEmpty((CharSequence)dockerUrl)) {
                Pattern pattern = Pattern.compile(DOCKER_URL_REGEX);
                Matcher matcher5 = pattern.matcher(dockerUrl);
                if (!matcher5.matches()) {
                    errorCollection.addError("dockerUrl", "Docker URL is not valid! Only 'tcp://' or 'unix://' supported");
                }
            } else {
                errorCollection.addError("dockerUrl", "You must specify a valid docker daemon URL");
            }
            String string = params.getString("username");
            if (StringUtils.isEmpty((CharSequence)string)) {
                errorCollection.addError("username", "You must specify a username");
            }
            if (StringUtils.isEmpty((CharSequence)(password = params.getString("password")))) {
                errorCollection.addError("password", "You must specify the password");
            }
            if (!StringUtils.isEmpty((CharSequence)(pollingInterval = params.getString("pollingInterval"))) && !(matcher3 = (patt4 = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(pollingInterval)).matches()) {
                errorCollection.addError("pollingInterval", "Timeout period is not valid!");
            }
            if (!StringUtils.isEmpty((CharSequence)(stageTimeout = params.getString("vulnsTimeout"))) && !(matcher2 = (patt3 = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(stageTimeout)).matches()) {
                errorCollection.addError("vulnsTimeout", "Timeout period is not valid!");
            }
            if (StringUtils.isEmpty((CharSequence)(imageIds = params.getString("imageIds")))) {
                errorCollection.addError("imageIds", "Image Ids cannot be empty");
            } else {
                String[] imageIdsString;
                for (String imageId : imageIdsString = imageIds.split(",")) {
                    Pattern pattern3;
                    Matcher matcher32;
                    Pattern pattern2;
                    Matcher matcher22;
                    Pattern pattern = Pattern.compile(IMAGE_ID_REGEX);
                    Matcher matcher5 = pattern.matcher(imageId.trim());
                    if (matcher5.find() || (matcher22 = (pattern2 = Pattern.compile(IMAGE_NAME_REGEX)).matcher(imageId.trim())).find() || (matcher32 = (pattern3 = Pattern.compile(IMAGE_ENV_VAR)).matcher(imageId.trim())).find()) continue;
                    errorCollection.addError("imageIds", imageId.trim() + " is not a valid image ID or name");
                }
            }
            boolean failOnQID = params.getBoolean(failOnQID);
            String QIDs = params.getString("qidList");
            if (failOnQID) {
                if (QIDs == null || StringUtils.isEmpty((CharSequence)QIDs)) {
                    errorCollection.addError("qidList", "Enter valid QID range/numbers");
                } else {
                    try {
                        String[] qidsString;
                        for (String string2 : qidsString = QIDs.split(",")) {
                            if (string2.contains("-")) {
                                int lastInRange;
                                String[] range = string2.split("-");
                                int firstInRange = Integer.parseInt(range[0].trim());
                                if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                                errorCollection.addError("qidList", "Enter valid QID range");
                                continue;
                            }
                            int range = Integer.parseInt(string2.trim());
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        errorCollection.addError("qidList", "Enter valid QID range/numbers");
                    }
                }
            }
            boolean failOnCve = params.getBoolean("failOnCve");
            String cveList = params.getString("cveList");
            if (failOnCve) {
                if (cveList == null || StringUtils.isEmpty((CharSequence)cveList)) {
                    errorCollection.addError("cveList", "Enter valid CVE IDs list");
                } else {
                    String[] cveString;
                    Pattern patt6 = Pattern.compile(CVE_REGEX);
                    for (String cve : cveString = cveList.split(",")) {
                        Matcher matcher7 = patt6.matcher(cve.trim());
                        if (matcher7.matches()) continue;
                        errorCollection.addError("cveList", cve + " is not a valid CVE ID!");
                    }
                }
            }
            boolean failOnSoftware = params.getBoolean("failOnSoftware");
            String softwareList = params.getString("softwareList");
            if (failOnSoftware && (cveList == null || StringUtils.isEmpty((CharSequence)softwareList))) {
                errorCollection.addError("softwareList", "Enter valid software list");
            }
            boolean bl = params.getBoolean("failOnCvss");
            String cvssThreshold = params.getString("cvssThreshold");
            if (bl) {
                if (cvssThreshold == null || StringUtils.isEmpty((CharSequence)cvssThreshold)) {
                    errorCollection.addError("cvssThreshold", "Enter valid CVSS Score");
                } else {
                    double cvssDouble = 0.0;
                    try {
                        cvssDouble = Double.parseDouble(cvssThreshold);
                        if (cvssDouble < 0.0 || cvssDouble > 10.0) {
                            errorCollection.addError("cvssThreshold", "Please enter a number in range of 0.0 to 10.0");
                        }
                    }
                    catch (NumberFormatException e) {
                        errorCollection.addError("cvssThreshold", "Input is not a valid number.");
                    }
                }
            }
            boolean useProxy = params.getBoolean("useProxy");
            String proxyServer = params.getString("proxyServer");
            if (useProxy) {
                if (StringUtils.isEmpty((CharSequence)proxyServer)) {
                    errorCollection.addError("proxyServer", "You must specify a Proxy server to connect to");
                } else {
                    Pattern patt7 = Pattern.compile(PROXY_REGEX);
                    Matcher matcher8 = patt7.matcher(proxyServer);
                    if (!matcher8.matches()) {
                        errorCollection.addError("proxyServer", "Enter valid Proxy server!");
                    }
                }
            }
            String port = params.getString("proxyPort");
            this.validateNumberField("proxyPort", port, useProxy, errorCollection);
            boolean isSev1 = params.getBoolean("isSev1Vulns");
            String sev1 = params.getString("severity1");
            this.validateNumberField("severity1", sev1, isSev1, errorCollection);
            boolean isSev2 = params.getBoolean("isSev2Vulns");
            String sev2 = params.getString("severity2");
            this.validateNumberField("severity2", sev2, isSev2, errorCollection);
            boolean isSev3 = params.getBoolean("isSev3Vulns");
            String sev3 = params.getString("severity3");
            this.validateNumberField("severity3", sev3, isSev3, errorCollection);
            boolean isSev4 = params.getBoolean("isSev4Vulns");
            String sev4 = params.getString("severity4");
            this.validateNumberField("severity4", sev4, isSev4, errorCollection);
            boolean isSev5 = params.getBoolean("isSev5Vulns");
            String sev5 = params.getString("severity5");
            this.validateNumberField("severity5", sev5, isSev5, errorCollection);
            String webhook = params.getString("webhook");
            if (webhook != null && !webhook.isEmpty() && !(matcher = (patt2 = Pattern.compile(URL_REGEX)).matcher(webhook)).matches()) {
                errorCollection.addError("webhook", "Webhook URL is not valid!");
            }
            if (!(!(failOnSeverity = params.getBoolean("failOnSeverity")) || isSev1 || isSev2 || isSev3 || isSev4 || isSev5)) {
                errorCollection.addError("failOnSeverity", "None of the severity level settings selected");
            }
            if (!(!(isPotentialVulnsToBeChecked = params.getBoolean("potential")) || failOnCve || failOnQID || failOnSeverity || failOnSoftware || bl)) {
                errorCollection.addError("potential", "None of the Fail-on conditions above is selected to apply this condition");
            }
            if (addExclusion = params.getBoolean("addExclusion")) {
                String excludeOptions = params.getString("excludeOptions");
                if (excludeOptions != null) {
                    if (excludeOptions.equals(EXCLUDE_BY_QID)) {
                        String excludeByQid = params.getString("excludeByQid");
                        if (StringUtils.isEmpty((CharSequence)excludeByQid)) {
                            errorCollection.addError("addExclusion", "Enter valid QID range/numbers");
                        } else {
                            try {
                                String[] qidsString;
                                for (String qid : qidsString = excludeByQid.split(",")) {
                                    if (qid.contains("-")) {
                                        int lastInRange;
                                        String[] range = qid.split("-");
                                        int firstInRange = Integer.parseInt(range[0].trim());
                                        if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                                        errorCollection.addError("addExclusion", "Enter valid QID range");
                                        continue;
                                    }
                                    Integer.parseInt(qid.trim());
                                }
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                errorCollection.addError("addExclusion", "Enter valid QID range/numbers");
                            }
                        }
                    } else if (excludeOptions.equals(EXCLUDE_BY_CVE)) {
                        String excludeByCve = params.getString("excludeByCve");
                        if (StringUtils.isEmpty((CharSequence)excludeByCve)) {
                            errorCollection.addError("addExclusion", "Enter valid CVE IDs list");
                        } else {
                            String[] cveString;
                            Pattern patt8 = Pattern.compile(CVE_REGEX);
                            for (String cve : cveString = excludeByCve.split(",")) {
                                Matcher matcher9 = patt8.matcher(cve.trim());
                                if (matcher9.matches()) continue;
                                errorCollection.addError("excludeByCve", cve + " is not a valid CVE ID!");
                            }
                        }
                    }
                } else {
                    errorCollection.addError("addExclusion", "Select one of the options to exclude");
                }
            }
            try {
                if (apiServer != null) {
                    apiServer = apiServer.trim();
                }
                if (password.equals(ENCRYPTED_PASSWORD) && this.originalPassword != null) {
                    password = this.originalPassword;
                }
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(apiServer, string, password);
                if (useProxy) {
                    String proxyUser = params.getString("proxyUsername");
                    String proxyPass = params.getString("proxyPassword");
                    if (proxyPass != null && proxyPass.equals(ENCRYPTED_PASSWORD) && this.originalProxyPassword != null) {
                        proxyPass = this.originalProxyPassword;
                    }
                    int proxyPort = 0;
                    if (port != null && !port.isEmpty()) {
                        proxyPort = Integer.parseInt(port);
                    }
                    if (proxyServer != null) {
                        proxyServer = proxyServer.trim();
                    }
                    auth.setProxyCredentials(proxyServer, proxyUser, proxyPass, proxyPort);
                }
                QualysCSClient qcs = new QualysCSClient(auth);
                QualysCSTestConnectionResponse response = qcs.testConnection();
                logger.info("Test connection : Response Code:" + response.responseCode + "; message:" + response.message);
                if (response.success) {
                    logger.info("Test Connection Successful!");
                } else {
                    String errorMsg = response.message;
                    logger.info("Test connection failed :" + errorMsg);
                    errorCollection.addError("password", errorMsg);
                }
            }
            catch (Exception e) {
                logger.info("Error testing connection to Qualys server. Please check API server and proxy credentials." + e.getMessage());
                errorCollection.addError("password", "Error testing connection to Qualys server. Please check API server and proxy credentials." + e.getMessage());
            }
        }
        if (pluginConfigOptions.equals(GLOBAL_CONFIG)) {
            Pattern pattern;
            Matcher matcher;
            String imageIds = params.getString("imageIds");
            if (StringUtils.isEmpty((CharSequence)imageIds)) {
                errorCollection.addError("imageIds", "Image Ids cannot be empty");
            } else {
                String[] imageIdsString;
                for (String imageId : imageIdsString = imageIds.split(",")) {
                    Pattern pattern3;
                    Matcher matcher3;
                    Pattern pattern2;
                    Matcher matcher2;
                    Pattern pattern4 = Pattern.compile(IMAGE_ID_REGEX);
                    Matcher matcher10 = pattern4.matcher(imageId.trim());
                    if (matcher10.find() || (matcher2 = (pattern2 = Pattern.compile(IMAGE_NAME_REGEX)).matcher(imageId.trim())).find() || (matcher3 = (pattern3 = Pattern.compile(IMAGE_ENV_VAR)).matcher(imageId.trim())).find()) continue;
                    errorCollection.addError("imageIds", imageId.trim() + " is not a valid image ID or name");
                }
            }
            String webhook = params.getString("webhook");
            if (webhook != null && !webhook.isEmpty() && !(matcher = (pattern = Pattern.compile(URL_REGEX)).matcher(webhook)).matches()) {
                errorCollection.addError("webhook", "Webhook URL is not valid!");
            }
        }
    }

    public void validateNumberField(String field, String value, boolean isEnabled, ErrorCollection errorCollection) {
        if (isEnabled) {
            if (value == null || StringUtils.isEmpty((CharSequence)value)) {
                errorCollection.addError(field, "Enter valid number!");
            } else {
                try {
                    int severity = Integer.parseInt(value);
                    if (severity < 0 || severity > Integer.MAX_VALUE) {
                        errorCollection.addError(field, "Please enter a valid number.");
                    }
                }
                catch (Exception e) {
                    errorCollection.addError(field, "Enter a valid number!");
                }
            }
        }
    }

    public void setBambooTextProvider(BambooTextProvider textProvider) {
        this.bambooTextProvider = textProvider;
    }

    public void setTaskConfiguratorHelper(TaskConfiguratorHelper taskConfiguratorHelper) {
        this.taskConfiguratorHelper = taskConfiguratorHelper;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

