/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.spring.container.ContainerManager;
import com.qualys.bamboo.plugin.containerSecurity.BuildFailureException;
import com.qualys.bamboo.plugin.containerSecurity.GetImageVulnsCallable;
import com.qualys.bamboo.plugin.containerSecurity.QualysGlobalConfigAction;
import com.qualys.bamboo.plugin.containerSecurity.QualysPluginConfiguration;
import com.qualys.bamboo.plugin.containerSecurity.Webhook;
import com.qualys.bamboo.plugin.containerSecurity.model.ProxyConfiguration;
import com.qualys.bamboo.plugin.containerSecurity.util.BambooFileStorageHelper;
import com.qualys.bamboo.plugin.containerSecurity.util.DockerClientHelper;
import com.qualys.bamboo.plugin.containerSecurity.util.Helper;
import com.qualys.plugins.common.QualysAuth.QualysAuth;
import com.qualys.plugins.common.QualysClient.QualysCSClient;
import com.qualys.plugins.common.QualysClient.QualysCSTestConnectionResponse;
import com.qualys.plugins.common.QualysCriteria.InvalidCriteriaException;
import com.qualys.plugins.common.QualysCriteria.QualysCriteria;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jetbrains.annotations.NotNull;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.JsonParser;

public class QualysImageScanTask
implements TaskType {
    public static final long DEFAULT_POLLING_INTERVAL_FOR_VULNS = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_TIMEOUT_FOR_VULNS = TimeUnit.MINUTES.toMillis(10L);
    private QualysAuth qualysAuth;
    private long pollingIntervalForVulnsInMillis;
    private long vulnsTimeoutInMillis;
    private String pollingIntervalForVulns;
    private String vulnsTimeout;
    private boolean isFailOnSevereVulns;
    private int severity1;
    private int severity2;
    private int severity3;
    private int severity4;
    private int severity5;
    private boolean isSev5Vulns;
    private boolean isSev4Vulns;
    private boolean isSev3Vulns;
    private boolean isSev2Vulns;
    private boolean isSev1Vulns;
    private boolean isPotentialVulnsToBeChecked;
    private boolean isFailOnQidFound;
    private ArrayList<String> qidList;
    private boolean isFailOnCVEs;
    private ArrayList<String> cveList;
    private boolean isFailOnSoftware;
    private ArrayList<String> softwareList;
    private TaskContext taskContext;
    private BuildContext buildContext;
    private int buildNumber;
    private String webhook;
    private String dockerUrl;
    private String dockerCert;
    private boolean addExclusion;
    private String excludeOptions;
    private ArrayList<String> excludeByCveList;
    private ArrayList<String> excludeByQidList;
    private boolean failOnCvss;
    private String cvssThreshold;
    private String cvssVersion;
    private QualysCSClient qcs;
    private long taggingTime;
    ProxyConfiguration proxyConfiguration;
    File artifactDirPath;
    private BuildLogger buildLogger;
    private static final Logger logger = Logger.getLogger(QualysImageScanTask.class.getName());
    private ArtifactManager artifactManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        this.taskContext = taskContext;
        this.buildContext = taskContext.getBuildContext();
        this.buildNumber = this.buildContext.getBuildNumber();
        this.buildLogger = taskContext.getBuildLogger();
        try {
            StackTraceElement[] model;
            MavenXpp3Reader reader = new MavenXpp3Reader();
            if (new File("pom.xml").exists()) {
                FileInputStream inputStream = new FileInputStream("pom.xml");
                model = reader.read(new InputStreamReader((InputStream)inputStream, "UTF-8"));
            } else {
                model = reader.read(new InputStreamReader(QualysImageScanTask.class.getResourceAsStream("/META-INF/maven/com.qualys.bamboo.plugin/QualysContainerSecurityBambooPlugin/pom.xml"), "UTF-8"));
            }
            this.buildLogger.addBuildLogEntry("###### Qualys Container Scanning Connector version : " + model.getVersion());
            logger.info(" ########## Qualys Container Scanning Connector version = " + model.getVersion());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Exception while reading plugin version; Reason :" + e.getMessage());
        }
        try {
            this.artifactDirPath = new File(taskContext.getWorkingDirectory(), "Qualys_Plugin_Artifacts");
        }
        catch (Exception e1) {
            this.buildLogger.addErrorLogEntry("Error finding build dir path : " + this.artifactDirPath + " ; " + e1.getMessage() + "Cause " + e1.getCause());
            for (StackTraceElement traceElement : e1.getStackTrace()) {
                this.buildLogger.addErrorLogEntry("\tat " + traceElement);
            }
            logger.log(Level.INFO, e1.getMessage(), e1.getCause());
        }
        ConfigurationMap config = taskContext.getConfigurationMap();
        this.initialize(config);
        String imageIds = (String)config.get((Object)"imageIds");
        if (imageIds != null && !imageIds.isEmpty()) {
            String[] imageList = imageIds.split(",");
            try {
                this.getImageScanResult(config, new ArrayList<String>(Arrays.asList(imageList)));
            }
            catch (Exception e) {
                this.buildLogger.addErrorLogEntry("Error: " + e.getMessage());
                e.printStackTrace();
                ArrayList<String> errors = new ArrayList<String>();
                errors.add(e.getMessage());
                this.buildContext.getBuildResult().addBuildErrors(errors);
                TaskResult taskResult = taskResultBuilder.failed().build();
                return taskResult;
            }
            finally {
                this.generateArtifacts();
            }
        } else {
            this.buildLogger.addBuildLogEntry("No image Id values found.");
            return taskResultBuilder.failed().build();
        }
        this.buildContext.getBuildResult().getCustomBuildData().put("buildDirPath", this.artifactDirPath.getAbsolutePath());
        this.buildContext.getBuildResult().getCustomBuildData().put("images", imageIds);
        return taskResultBuilder.build();
    }

    public void generateArtifacts() {
        PlanResultKey planResultKey = this.buildContext.getPlanResultKey();
        BuildLogger buildLogger = this.taskContext.getBuildLogger();
        BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
        File baseDirectory = this.artifactDirPath;
        Map runtimeMap = this.taskContext.getRuntimeTaskContext();
        if (runtimeMap == null) {
            logger.info("ERROR: Runtime Task context is null; cannot process artifacts");
            return;
        }
        SecureToken token = SecureToken.createFromString((String)((String)runtimeMap.get("qualys_task_secure_token")));
        ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(token);
        HashMap config = new HashMap();
        logger.info("##############  Custom build data key 'published' =" + (String)this.buildContext.getBuildResult().getCustomBuildData().get("published"));
        ArtifactPublishingResult publishResult = this.getArtifactManager().publish(buildLogger, planResultKey, baseDirectory, artifact, config, 1);
        this.taskContext.getBuildContext().getArtifactContext().addPublishingResult(publishResult);
        try {
            if (!publishResult.shouldContinueBuild()) {
                logger.info("ERROR: Could not publish the artifact for the Qualys scan Report");
                Helper.createZip(this.artifactDirPath.getParent() + File.separator + "Qualys_Plugin_Artifacts-" + this.buildNumber + ".zip", this.artifactDirPath.getAbsolutePath());
                FileUtils.deleteDirectory((File)this.artifactDirPath);
            } else {
                FileUtils.deleteDirectory((File)this.artifactDirPath);
                logger.info("Deleting the artifacts from working directory after publish to server");
            }
        }
        catch (IOException e) {
            logger.info("Failed deleting the artifacts from working directory : " + e.getMessage());
        }
    }

    private ArtifactManager getArtifactManager() {
        if (this.artifactManager == null) {
            try {
                this.artifactManager = (ArtifactManager)ContainerManager.getComponent((String)"artifactManager");
            }
            catch (Exception e) {
                logger.severe("Unable to resolve ArtifactManager from ContainerManager: " + e.getMessage());
            }
        }
        return this.artifactManager;
    }

    public void initialize(ConfigurationMap config) {
        String configType = (String)config.get((Object)"pluginConfigOptions");
        if (configType == null) {
            configType = "localConfig";
        }
        if (configType.equals("localConfig")) {
            this.fetchValuesFromLocalConfig(config);
        } else if (configType.equals("globalConfig")) {
            this.fetchValuesFromGlobalConfig(config);
        }
    }

    private void fetchValuesFromGlobalConfig(ConfigurationMap config) {
        QualysGlobalConfigAction action = new QualysGlobalConfigAction();
        QualysPluginConfiguration globalconfig = action.getQualysPluginConfiguration();
        if (globalconfig == null) {
            Map runtimeMap = this.taskContext.getRuntimeTaskContext();
            if (runtimeMap == null) {
                logger.info("ERROR: Runtime Task context is null; cannot fetch plugin global config");
                return;
            }
            String configStr = (String)runtimeMap.get("QualysPluginGlobalConfig");
            if (configStr != null) {
                try {
                    Gson gson = new Gson();
                    globalconfig = gson.fromJson(configStr, QualysPluginConfiguration.class);
                    if (globalconfig == null) {
                        this.buildLogger.addErrorLogEntry("Plugin Global Configuration not configured properly and is null;");
                        return;
                    }
                }
                catch (Exception e) {
                    this.buildLogger.addErrorLogEntry("Cannot parse Plugin Global Configuration");
                    logger.info("Error converting stored global config to Qulays Plugin Config object while on remote." + e.getMessage());
                    return;
                }
            }
        }
        if (globalconfig == null) {
            this.buildLogger.addErrorLogEntry("Plugin Global Configuration not configured properly and is null;");
            return;
        }
        String apiServer = globalconfig.getServerURL();
        String apiUser = globalconfig.getUsername();
        String apiPassword = globalconfig.getPassword();
        boolean useProxy = globalconfig.getUseProxy();
        String proxyServer = globalconfig.getProxyServer();
        int proxyPort = globalconfig.getProxyPort();
        String proxyUsername = globalconfig.getProxyUsername();
        String proxyPassword = globalconfig.getProxyPassword();
        this.proxyConfiguration = new ProxyConfiguration(useProxy, proxyServer, proxyPort, proxyUsername, proxyPassword);
        this.qualysAuth = new QualysAuth();
        this.qualysAuth.setQualysCredentials(apiServer, apiUser, apiPassword);
        if (useProxy) {
            this.qualysAuth.setProxyCredentials(proxyServer, proxyUsername, proxyPassword, proxyPort);
        }
        this.pollingIntervalForVulns = globalconfig.getPollingInterval();
        this.pollingIntervalForVulnsInMillis = this.setTimeoutInMillis("polling", DEFAULT_POLLING_INTERVAL_FOR_VULNS, this.pollingIntervalForVulns);
        this.vulnsTimeout = globalconfig.getVulnsTimeout();
        this.vulnsTimeoutInMillis = this.setTimeoutInMillis("vulns", DEFAULT_TIMEOUT_FOR_VULNS, this.vulnsTimeout);
        this.isSev1Vulns = globalconfig.getIsSev1Vulns();
        this.isSev2Vulns = globalconfig.getIsSev2Vulns();
        this.isSev3Vulns = globalconfig.getIsSev3Vulns();
        this.isSev4Vulns = globalconfig.getIsSev4Vulns();
        this.isSev5Vulns = globalconfig.getIsSev5Vulns();
        this.severity1 = globalconfig.getSeverity1();
        this.severity2 = globalconfig.getSeverity2();
        this.severity3 = globalconfig.getSeverity3();
        this.severity4 = globalconfig.getSeverity4();
        this.severity5 = globalconfig.getSeverity5();
        this.isFailOnSevereVulns = globalconfig.getFailOnSevereVulns();
        this.isPotentialVulnsToBeChecked = globalconfig.getIsPotentialVulnsToBeChecked();
        this.isFailOnQidFound = globalconfig.getFailOnQidFound();
        String qidListString = globalconfig.getQidList();
        try {
            if (qidListString != null && !qidListString.isEmpty() && this.isFailOnQidFound) {
                this.qidList = this.expandQidStringToList(qidListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if QIDs list not a valid list.");
        }
        this.isFailOnCVEs = globalconfig.getFailOnCve();
        String cveListString = globalconfig.getCveList();
        try {
            if (cveListString != null && !cveListString.isEmpty() && this.isFailOnCVEs) {
                this.cveList = this.expandCommaSeparatedStringToList(cveListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if CVEs list not a valid list.");
        }
        this.isFailOnSoftware = globalconfig.getFailOnSoftware();
        String softwareListString = globalconfig.getSoftwareList();
        try {
            if (softwareListString != null && !softwareListString.isEmpty() && this.isFailOnSoftware) {
                this.softwareList = this.expandCommaSeparatedStringToList(softwareListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if software list not a valid list.");
        }
        this.failOnCvss = globalconfig.getFailOnCvss();
        this.cvssThreshold = globalconfig.getCvssThreshold();
        this.cvssVersion = globalconfig.getCvssVersion();
        this.dockerUrl = globalconfig.getDockerUrl();
        this.dockerCert = globalconfig.getDockerCert();
        this.addExclusion = globalconfig.getAddExclusion();
        this.excludeOptions = globalconfig.getExcludeOptions();
        String cveExcludeListString = globalconfig.getExcludeByCve();
        try {
            if (cveExcludeListString != null && !cveExcludeListString.isEmpty()) {
                this.excludeByCveList = this.expandCommaSeparatedStringToList(cveExcludeListString);
            }
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if CVEs exclude list not a valid list.");
        }
        String qidExcludeListString = globalconfig.getExcludeByQid();
        try {
            if (qidExcludeListString != null && !qidExcludeListString.isEmpty()) {
                this.excludeByQidList = this.expandQidStringToList(qidExcludeListString);
            }
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if QIDs exclude list not a valid list.");
        }
        this.webhook = (String)config.get((Object)"webhook");
        if (StringUtils.isEmpty((CharSequence)this.webhook)) {
            this.buildLogger.addBuildLogEntry("No Webhook URL configured locally. Checking global config..");
            this.webhook = globalconfig.getWebhook();
            if (this.webhook == null || this.webhook.isEmpty()) {
                this.buildLogger.addBuildLogEntry("Webhook URL in Plugin Global Configuration not configured.");
            }
        }
    }

    private ArrayList<String> expandCommaSeparatedStringToList(String csvString) {
        if (csvString == null || csvString.isEmpty()) {
            return null;
        }
        ArrayList<String> csvList = new ArrayList<String>();
        try {
            String[] csvArray;
            for (String csv : csvArray = csvString.split(",")) {
                csvList.add(csv.trim());
            }
        }
        catch (Exception e) {
            logger.info("Error processing CSV string ; " + e.getMessage());
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(csvList);
        csvList.clear();
        csvList.addAll(hs);
        return csvList;
    }

    private void fetchValuesFromLocalConfig(ConfigurationMap config) {
        String apiServer = (String)config.get((Object)"apiServer");
        String apiUser = (String)config.get((Object)"username");
        String apiPassword = (String)config.get((Object)"password");
        boolean useProxy = Boolean.parseBoolean((String)config.get((Object)"useProxy"));
        String proxyServer = (String)config.get((Object)"proxyServer");
        String port = (String)config.get((Object)"proxyPort");
        int proxyPort = 80;
        if (port != null && !port.isEmpty()) {
            proxyPort = Integer.parseInt(port);
        }
        String proxyUsername = (String)config.get((Object)"proxyUsername");
        String proxyPassword = (String)config.get((Object)"proxyPassword");
        this.proxyConfiguration = new ProxyConfiguration(useProxy, proxyServer, proxyPort, proxyUsername, proxyPassword);
        this.qualysAuth = new QualysAuth();
        this.qualysAuth.setQualysCredentials(apiServer, apiUser, apiPassword);
        if (useProxy) {
            this.qualysAuth.setProxyCredentials(proxyServer, proxyUsername, proxyPassword, proxyPort);
        }
        this.pollingIntervalForVulns = (String)config.get((Object)"pollingInterval");
        this.pollingIntervalForVulnsInMillis = this.setTimeoutInMillis("polling", DEFAULT_POLLING_INTERVAL_FOR_VULNS, this.pollingIntervalForVulns);
        this.vulnsTimeout = (String)config.get((Object)"vulnsTimeout");
        this.vulnsTimeoutInMillis = this.setTimeoutInMillis("vulns", DEFAULT_TIMEOUT_FOR_VULNS, this.vulnsTimeout);
        this.isSev1Vulns = Boolean.parseBoolean((String)config.get((Object)"isSev1Vulns"));
        this.isSev2Vulns = Boolean.parseBoolean((String)config.get((Object)"isSev2Vulns"));
        this.isSev3Vulns = Boolean.parseBoolean((String)config.get((Object)"isSev3Vulns"));
        this.isSev4Vulns = Boolean.parseBoolean((String)config.get((Object)"isSev4Vulns"));
        this.isSev5Vulns = Boolean.parseBoolean((String)config.get((Object)"isSev5Vulns"));
        String sev1 = (String)config.get((Object)"severity1");
        String sev2 = (String)config.get((Object)"severity2");
        String sev3 = (String)config.get((Object)"severity3");
        String sev4 = (String)config.get((Object)"severity4");
        String sev5 = (String)config.get((Object)"severity5");
        this.severity1 = sev1 != null && !sev1.equals("") ? Integer.parseInt(sev1) : -1;
        this.severity2 = sev2 != null && !sev2.equals("") ? Integer.parseInt(sev2) : -1;
        this.severity3 = sev3 != null && !sev3.equals("") ? Integer.parseInt(sev3) : -1;
        this.severity4 = sev4 != null && !sev4.equals("") ? Integer.parseInt(sev4) : -1;
        this.severity5 = sev5 != null && !sev5.equals("") ? Integer.parseInt(sev5) : -1;
        boolean isFailOnSevVulnsFound = Boolean.parseBoolean((String)config.get((Object)"failOnSeverity"));
        this.isFailOnSevereVulns = isFailOnSevVulnsFound && (this.isSev1Vulns || this.isSev2Vulns || this.isSev3Vulns || this.isSev4Vulns || this.isSev5Vulns);
        this.isPotentialVulnsToBeChecked = Boolean.parseBoolean((String)config.get((Object)"potential"));
        this.isFailOnQidFound = Boolean.parseBoolean((String)config.get((Object)"failOnQID"));
        this.webhook = (String)config.get((Object)"webhook");
        this.dockerUrl = (String)config.get((Object)"dockerUrl");
        this.dockerCert = (String)config.get((Object)"dockerCert");
        this.addExclusion = Boolean.parseBoolean((String)config.get((Object)"addExclusion"));
        this.excludeOptions = (String)config.get((Object)"excludeOptions");
        String cveExcludeListString = (String)config.get((Object)"excludeByCve");
        try {
            if (cveExcludeListString != null && !cveExcludeListString.isEmpty()) {
                this.excludeByCveList = this.expandCommaSeparatedStringToList(cveExcludeListString);
            }
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if CVEs exclude list not a valid list.");
        }
        String qidExcludeListString = (String)config.get((Object)"excludeByQid");
        try {
            if (qidExcludeListString != null && !qidExcludeListString.isEmpty()) {
                this.excludeByQidList = this.expandQidStringToList(qidExcludeListString);
            }
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if QIDs exclude list not a valid list.");
        }
        if (StringUtils.isEmpty((CharSequence)this.webhook)) {
            this.buildLogger.addBuildLogEntry("No Webhook URL configured locally. Checking global config..");
            QualysGlobalConfigAction action = new QualysGlobalConfigAction();
            QualysPluginConfiguration globalconfig = action.getQualysPluginConfiguration();
            if (globalconfig == null) {
                Map runtimeMap = this.taskContext.getRuntimeTaskContext();
                if (runtimeMap == null) {
                    logger.info("ERROR: Runtime Task context is null; cannot fetch plugin global config");
                    return;
                }
                String configStr = (String)runtimeMap.get("QualysPluginGlobalConfig");
                if (configStr != null) {
                    try {
                        Gson gson = new Gson();
                        globalconfig = gson.fromJson(configStr, QualysPluginConfiguration.class);
                        if (globalconfig != null && globalconfig.getWebhook() != null) {
                            this.webhook = globalconfig.getWebhook();
                        }
                        this.buildLogger.addBuildLogEntry("Webhook URL in Plugin Global Configuration not configured.");
                    }
                    catch (Exception e) {
                        this.buildLogger.addErrorLogEntry("Cannot parse Plugin Global Configuration to get webhook URL; " + globalconfig);
                        logger.info("Error converting stored global config to Qulays Plugin Config object while fetching webhook." + e.getMessage());
                        return;
                    }
                }
            } else {
                this.webhook = globalconfig.getWebhook();
            }
        }
        String qidListString = (String)config.get((Object)"qidList");
        try {
            if (qidListString != null && !qidListString.isEmpty() && this.isFailOnQidFound) {
                this.qidList = this.expandQidStringToList(qidListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if QIDs list not a valid list.");
        }
        this.isFailOnCVEs = Boolean.parseBoolean((String)config.get((Object)"failOnCve"));
        String cveListString = (String)config.get((Object)"cveList");
        try {
            if (cveListString != null && !cveListString.isEmpty() && this.isFailOnCVEs) {
                this.cveList = this.expandCommaSeparatedStringToList(cveListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if CVEs list not a valid list.");
        }
        this.isFailOnSoftware = Boolean.parseBoolean((String)config.get((Object)"failOnSoftware"));
        String softwareListString = (String)config.get((Object)"softwareList");
        try {
            if (softwareListString != null && !softwareListString.isEmpty() && this.isFailOnSoftware) {
                this.softwareList = this.expandCommaSeparatedStringToList(softwareListString);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.buildLogger.addBuildLogEntry("Fail if software list not a valid list.");
        }
        this.failOnCvss = Boolean.parseBoolean((String)config.get((Object)"failOnCvss"));
        this.cvssThreshold = (String)config.get((Object)"cvssThreshold");
        this.cvssVersion = (String)config.get((Object)"cvssVersion");
    }

    private ArrayList<String> expandQidStringToList(String qidList) {
        if (qidList == null || qidList.isEmpty()) {
            return null;
        }
        ArrayList<String> qids = new ArrayList<String>();
        try {
            String[] qidsString;
            for (String qid : qidsString = qidList.split(",")) {
                qids.add(qid.trim());
            }
        }
        catch (Exception e) {
            logger.info("Error processing string of QIDs to list of integers; " + e.getMessage());
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(qids);
        qids.clear();
        qids.addAll(hs);
        return qids;
    }

    public void getImageScanResult(ConfigurationMap config, ArrayList<String> imageList) throws Exception {
        if (imageList == null || imageList.isEmpty()) {
            this.buildLogger.addBuildLogEntry("No image ids found.");
            if (this.isFailOnSevereVulns || this.isFailOnQidFound || this.isFailOnCVEs) {
                throw new Exception("No image ids found");
            }
            return;
        }
        LinkedHashSet<String> imageSet = new LinkedHashSet<String>(imageList);
        HashMap<String, String> dedupedImageList = this.processImages(imageSet);
        this.buildLogger.addBuildLogEntry("Qualys task - Started fetching docker image scan results for : " + dedupedImageList.values());
        this.getAndProcessDockerImagesScanResult(dedupedImageList);
        this.buildLogger.addBuildLogEntry("Qualys task - Finished.");
    }

    private HashMap<String, String> processImages(Set<String> imageList) throws Exception {
        HashMap<String, String> finalImagesList = new HashMap<String, String>();
        ArrayList<String> listOfImageIds = new ArrayList<String>();
        if (this.dockerUrl == null || this.dockerUrl.isEmpty()) {
            this.dockerUrl = "unix:///var/run/docker.sock";
        }
        DockerClientHelper helper = new DockerClientHelper(this.buildLogger, this.dockerUrl, this.dockerCert);
        this.buildLogger.addBuildLogEntry("Using docker daemon URL : " + this.dockerUrl);
        boolean isCICDSensorRunning = helper.isCICDSensorUp();
        this.buildLogger.addBuildLogEntry("*** Qualys CS sensor container is up and running!! ***");
        if (!isCICDSensorRunning) {
            throw new Exception("Qualys CS sensor is not deployed in CICD mode");
        }
        this.buildLogger.addBuildLogEntry("*** Qualys CS sensor is deployed in CICD mode ***");
        Instant instant = Instant.now();
        this.taggingTime = instant.getEpochSecond();
        this.buildLogger.addBuildLogEntry("***Epoch Time in seconds before tagging = " + this.taggingTime);
        for (String OriginalImage : imageList) {
            String image = OriginalImage.trim();
            String imageSha = helper.fetchImageSha(image, this.dockerCert);
            if (imageSha == null) continue;
            if (!listOfImageIds.contains(imageSha)) {
                listOfImageIds.add(imageSha);
                finalImagesList.put(imageSha, image);
                this.buildLogger.addBuildLogEntry("Adding qualys specific docker tag to the image " + image);
                helper.tagImage(image, imageSha);
                continue;
            }
            this.buildLogger.addErrorLogEntry(image + " has same image Id as one of the configured image: " + finalImagesList.get(imageSha) + ". So processing it only once.");
        }
        return finalImagesList;
    }

    private long setTimeoutInMillis(String timeoutType, long defaultTimeoutInMillis, String timeout) {
        long timeoutToFetchInMillis = defaultTimeoutInMillis;
        if (timeout != null && !timeout.isEmpty()) {
            try {
                String[] numbers = timeout.split("\\*");
                long timeoutInSecs = 1L;
                for (int i = 0; i < numbers.length; ++i) {
                    timeoutInSecs *= Long.parseLong(numbers[i]);
                }
                return TimeUnit.SECONDS.toMillis(timeoutInSecs);
            }
            catch (Exception e) {
                this.buildLogger.addBuildLogEntry("Invalid " + timeoutType + " time value. Cannot parse -" + e.getMessage());
                this.buildLogger.addBuildLogEntry("Using default value of " + TimeUnit.MILLISECONDS.toSeconds(defaultTimeoutInMillis) + " secs for " + timeoutType + " data");
            }
        }
        return timeoutToFetchInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResultToFile(String rootDir, JsonObject failReasonObj) {
        String filename = rootDir + File.separator + "build-summary.json";
        File f = new File(filename);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            logger.info("Directory cannot be created");
        }
        if (!f.exists()) {
            FileOutputStream fos = null;
            try {
                if (!f.createNewFile()) {
                    logger.info("File already exists or failed creating file " + filename);
                }
                File dir = new File(f.getParentFile(), f.getName());
                fos = new FileOutputStream(dir);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                writer.print("[]");
                writer.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.buildLogger.addBuildLogEntry("Failed creating file " + filename + ", reason =" + e.getMessage());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.info("Error closing file output stream");
                    }
                }
            }
        }
        Reader fr = null;
        try {
            JsonParser parser = new JsonParser();
            FileInputStream inputStream = new FileInputStream(filename);
            fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JsonElement jsonElement = parser.parse(fr);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            jsonArray.add(failReasonObj);
            String jsonContent = jsonArray.toString();
            File dir = new File(f.getParentFile(), f.getName());
            PrintWriter writer = new PrintWriter(dir, "UTF-8");
            writer.print(jsonContent);
            writer.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildLogger.addBuildLogEntry("Failed writing to file " + filename + ", reason =" + e.getMessage());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    logger.info("Error closing file reader");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndProcessDockerImagesScanResult(HashMap<String, String> imageList) throws Exception {
        if (imageList == null || imageList.isEmpty()) {
            return;
        }
        boolean isFailConditionsConfigured = false;
        if (this.isFailOnCVEs || this.isFailOnQidFound || this.isFailOnSevereVulns || this.isFailOnSoftware || this.failOnCvss) {
            isFailConditionsConfigured = true;
        }
        QualysCSTestConnectionResponse resp = null;
        try {
            if (this.qualysAuth == null) {
                throw new Exception("Please check if Qualys credentials are set properly.");
            }
            PrintStream printLogger = new PrintStream((OutputStream)new NullOutputStream(), true, "UTF-8"){

                @Override
                public void println(String x) {
                    QualysImageScanTask.this.buildLogger.addBuildLogEntry(x);
                }
            };
            this.qcs = new QualysCSClient(this.qualysAuth, printLogger);
            int retry = 0;
            do {
                resp = this.qcs.testConnection();
                int responseCode = resp.responseCode;
                this.buildLogger.addBuildLogEntry("Test connection API call returned status code : " + responseCode);
                logger.info("Test connection : Response Code:" + responseCode + "; response:" + resp.message);
                if (responseCode >= 500 && responseCode <= 599 || resp.responseCode == 400) {
                    if (++retry > 2) {
                        throw new Exception("Error connecting Qualys API server. Server returned :" + responseCode + " Please check logs for details.");
                    }
                    this.buildLogger.addBuildLogEntry("Something went wrong with server; Could be a temporary glitch. Retrying in 5 secs...");
                    Thread.sleep(5000L);
                    continue;
                }
                if (responseCode >= 200 && responseCode < 300 && resp.success) continue;
                throw new Exception("Error connecting Qualys API server. Server returned :" + responseCode + " Please check logs for details.");
            } while (!resp.success);
        }
        catch (TaskException e) {
            throw new Exception(e);
        }
        catch (Exception ex) {
            logger.info("Exception while testing connection :" + ex);
            throw new Exception("Error testing connection; Reason: " + ex.getMessage());
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(imageList.size());
        HashMap<String, Object> list = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : imageList.entrySet()) {
            String imageSha = entry.getKey();
            Future<String> future = executor.submit(new GetImageVulnsCallable(this.taggingTime, this.artifactDirPath.getAbsolutePath(), imageSha, this.qualysAuth, this.qcs, this.buildLogger, this.pollingIntervalForVulnsInMillis, this.vulnsTimeoutInMillis, isFailConditionsConfigured));
            list.put(imageSha, future);
        }
        executor.shutdown();
        ArrayList<String> exceptionMessages = new ArrayList<String>();
        ArrayList<String> otherExceptions = new ArrayList<String>();
        boolean hasAtleastOneResult = false;
        for (Map.Entry<String, String> entry : imageList.entrySet()) {
            String imageDetails;
            String imageName;
            block37: {
                String imageID = entry.getKey();
                imageName = entry.getValue();
                Future future = (Future)list.get(imageID);
                imageDetails = null;
                try {
                    imageDetails = (String)future.get();
                }
                catch (Exception e) {
                    if (!isFailConditionsConfigured) break block37;
                    otherExceptions.add(e.getMessage());
                }
            }
            if (imageDetails == null || imageDetails.isEmpty()) continue;
            try {
                hasAtleastOneResult = true;
                this.passBuildBasedOnFailConditions(imageName, imageDetails);
            }
            catch (BuildFailureException e) {
                exceptionMessages.add(e.getMessage());
            }
        }
        if (!hasAtleastOneResult && !otherExceptions.isEmpty()) {
            throw new Exception(otherExceptions.stream().collect(Collectors.joining("\n")));
        }
        String planName = this.buildContext.getPlanName();
        String planKey = this.buildContext.getPlanKey();
        if (!StringUtils.isEmpty((CharSequence)this.webhook)) {
            JsonArray failReasonArray;
            JsonObject webhookPostData = new JsonObject();
            webhookPostData.addProperty("buildNumber", this.buildNumber);
            webhookPostData.addProperty("planName", planName);
            webhookPostData.addProperty("planKey", planKey);
            webhookPostData.addProperty("buildStatus", exceptionMessages.isEmpty() ? "Success" : "Failed");
            Gson gson = new Gson();
            String filename = this.artifactDirPath.getAbsolutePath() + File.separator + "qualys_images_summary.json";
            Reader fr = null;
            JsonObject scanResultObj = null;
            try {
                JsonParser parser = new JsonParser();
                StackTraceElement[] inputStream = new FileInputStream(filename);
                fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
                JsonElement jsonElement = parser.parse(fr);
                scanResultObj = jsonElement.getAsJsonObject().get("scanResult").getAsJsonObject();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                logger.info("Error processing scan data from qualys_images_summary file; Reason: " + e.getMessage());
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        for (StackTraceElement traceElement : e.getStackTrace()) {
                            logger.info("\tat " + traceElement);
                        }
                    }
                }
            }
            if ((failReasonArray = this.makeFailReasonArray(scanResultObj)).size() > 0) {
                webhookPostData.add("failReason", failReasonArray);
            }
            JsonArray imagesDataWebhookArray = this.makeWebhookData(scanResultObj);
            webhookPostData.add("images", imagesDataWebhookArray);
            if (!webhookPostData.isJsonNull()) {
                Webhook wh = new Webhook(this.webhook, gson.toJson(webhookPostData), this.buildLogger, this.proxyConfiguration);
                wh.post();
            }
        } else {
            this.buildLogger.addBuildLogEntry("Webhook URL not configured; skipping the webhook post call.");
        }
        if (!otherExceptions.isEmpty()) {
            exceptionMessages.addAll(otherExceptions);
        }
        if (!exceptionMessages.isEmpty()) {
            throw new Exception(String.join((CharSequence)"\n", exceptionMessages));
        }
    }

    private JsonArray makeFailReasonArray(JsonObject scanResultObj) throws Exception {
        if (scanResultObj == null) {
            logger.info("Scan result object is null");
            return new JsonArray();
        }
        JsonArray failReasonArray = new JsonArray();
        try {
            for (Map.Entry<String, JsonElement> entry : scanResultObj.entrySet()) {
                JsonObject software;
                JsonObject cveIds;
                JsonObject jsonObj = entry.getValue().getAsJsonObject();
                String imageId = jsonObj.get("imageId").getAsString();
                JsonObject result = new JsonObject();
                JsonObject imageSummaryObj = jsonObj.getAsJsonObject("imageSummary");
                boolean pass = imageSummaryObj.get("pass").getAsBoolean();
                if (pass) continue;
                result.addProperty("imageId", imageId);
                JsonObject qids = jsonObj.getAsJsonObject("qids");
                if (!qids.get("result").getAsBoolean()) {
                    JsonObject webhookQids = new JsonObject();
                    webhookQids.add("configured", qids.get("configured"));
                    webhookQids.add("found", qids.get("found"));
                    result.add("qids", webhookQids);
                }
                if (!(cveIds = jsonObj.getAsJsonObject("cveIds")).get("result").getAsBoolean()) {
                    JsonObject webhookCveIds = new JsonObject();
                    webhookCveIds.add("configured", cveIds.get("configured"));
                    webhookCveIds.add("found", cveIds.get("found"));
                    result.add("cveIds", webhookCveIds);
                }
                if (!(software = jsonObj.getAsJsonObject("software")).get("result").getAsBoolean()) {
                    JsonObject webhookSoftware = new JsonObject();
                    webhookSoftware.add("configured", software.get("configured"));
                    webhookSoftware.add("found", software.get("found"));
                    result.add("software", webhookSoftware);
                }
                JsonObject severity = new JsonObject();
                JsonObject severities = jsonObj.getAsJsonObject("severities");
                for (Map.Entry<String, JsonElement> sevLevel : severities.entrySet()) {
                    JsonObject sevResult = sevLevel.getValue().getAsJsonObject();
                    String sev = sevLevel.getKey();
                    if (sevResult.get("result").getAsBoolean()) continue;
                    JsonObject webhookSev = new JsonObject();
                    webhookSev.add("configured", sevResult.get("configured"));
                    webhookSev.add("found", sevResult.get("found"));
                    severity.add(sev, webhookSev);
                }
                if (severity.size() > 0) {
                    result.add("severities", severity);
                }
                JsonObject cvssObj = jsonObj.getAsJsonObject("cvss");
                JsonObject cvssNewObj = null;
                if (!cvssObj.get("result").getAsBoolean()) {
                    cvssNewObj = new JsonObject();
                    cvssNewObj.add("configured", cvssObj.get("configured"));
                    cvssNewObj.add("found", cvssObj.get("found"));
                    if (cvssObj.has("version") && cvssObj.get("version").getAsString().equalsIgnoreCase("3")) {
                        cvssNewObj.addProperty("version", 3);
                    } else {
                        cvssNewObj.addProperty("version", 2);
                    }
                }
                if (cvssNewObj != null) {
                    result.add("cvss", cvssNewObj);
                }
                failReasonArray.add(result);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Error processing scan data to build failReason object for webhook; Reason: " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
        return failReasonArray;
    }

    private void passBuildBasedOnFailConditions(String imageID, String imageDetails) throws BuildFailureException {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("name", "fail on severity");
        HashMap<String, String> timeout = new HashMap<String, String>();
        timeout.put("frequency", this.pollingIntervalForVulns);
        timeout.put("timeout", this.vulnsTimeout);
        criteria.put("dataCollection", timeout);
        HashMap<String, Object> failConditions = new HashMap<String, Object>();
        if (this.isFailOnQidFound) {
            failConditions.put("qids", this.qidList);
        }
        if (this.isFailOnCVEs) {
            failConditions.put("cves", this.cveList);
        }
        if (this.isFailOnSevereVulns) {
            HashMap<String, String> severities = new HashMap<String, String>();
            if (this.isSev1Vulns) {
                severities.put("1", String.valueOf(this.severity1));
            }
            if (this.isSev2Vulns) {
                severities.put("2", String.valueOf(this.severity2));
            }
            if (this.isSev3Vulns) {
                severities.put("3", String.valueOf(this.severity3));
            }
            if (this.isSev4Vulns) {
                severities.put("4", String.valueOf(this.severity4));
            }
            if (this.isSev5Vulns) {
                severities.put("5", String.valueOf(this.severity5));
            }
            failConditions.put("severities", severities);
        }
        if (this.addExclusion) {
            if ("excludeCve".equals(this.excludeOptions)) {
                failConditions.put("excludeBy", "cve");
                failConditions.put("excludeCVEs", this.excludeByCveList);
            } else if ("excludeQid".equals(this.excludeOptions)) {
                failConditions.put("excludeBy", "qid");
                failConditions.put("excludeQids", this.excludeByQidList);
            }
        }
        if (this.isFailOnSoftware) {
            failConditions.put("software", this.softwareList);
        }
        if (this.failOnCvss && this.cvssThreshold != null && !this.cvssThreshold.isEmpty() && this.cvssVersion != null && !this.cvssVersion.isEmpty()) {
            HashMap<String, String> cvssObj = new HashMap<String, String>();
            cvssObj.put("version", this.cvssVersion);
            cvssObj.put("configured", this.cvssThreshold);
            failConditions.put("cvss", cvssObj);
        }
        failConditions.put("checkPotentialVulns", this.isPotentialVulnsToBeChecked);
        criteria.put("failConditions", failConditions);
        Gson gson = new Gson();
        String criteriaString = gson.toJson(criteria);
        logger.info(" ######## Criteria for fail conditions : " + criteriaString);
        this.buildLogger.addBuildLogEntry("Criteria Json =" + criteriaString);
        try {
            QualysCriteria qcriteria = new QualysCriteria(criteriaString);
            boolean result = qcriteria.evaluate(gson.fromJson(imageDetails, JsonObject.class));
            JsonObject reportObj = qcriteria.getResult();
            logger.info("Report from Common lib = " + reportObj);
            logger.info("###############   file params= " + this.artifactDirPath.getAbsolutePath() + " " + imageID);
            this.writeImageSummary(imageID, imageDetails, reportObj);
            this.raiseBuildFailureException(imageID, reportObj, result);
        }
        catch (InvalidCriteriaException e) {
            this.buildLogger.addBuildLogEntry("Failed to evaluate criteria of build failure; Reason = " + e.getMessage());
            logger.info("Failed to evaluate criteria of build failure; " + e);
        }
        catch (NullPointerException e) {
            this.buildLogger.addBuildLogEntry("Failed to evaluate criteria of build failure; Reason = " + e.getMessage());
            logger.info("Failed to evaluate criteria of build failure; " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageSummary(String imageId, String imageDetails, JsonObject reportObj) {
        String filename = this.artifactDirPath.getAbsolutePath() + File.separator + "qualys_images_summary.json";
        File f = new File(filename);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            logger.info("Directory cannot be created");
        }
        if (!f.exists()) {
            try {
                if (!f.createNewFile()) {
                    logger.info("File already exists or failed creating file " + filename);
                }
                File dir = new File(f.getParentFile(), f.getName());
                PrintWriter writer = new PrintWriter(dir, "UTF-8");
                writer.print("{\"trendingData\":[], \"scanResult\": {}}");
                writer.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                logger.info("Failed creating file " + filename + ", reason = " + e);
                this.buildLogger.addBuildLogEntry("Failed creating file " + filename + ", reason =" + e.getMessage());
            }
        }
        Reader fr = null;
        try {
            Gson gson = new Gson();
            JsonParser parser = new JsonParser();
            FileInputStream inputStream = new FileInputStream(filename);
            fr = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JsonElement jsonElement = parser.parse(fr);
            if (jsonElement.getAsJsonObject().get("scanResult") == null) {
                jsonElement.getAsJsonObject().add("scanResult", new JsonObject());
            }
            JsonObject scanResultObj = jsonElement.getAsJsonObject().get("scanResult").getAsJsonObject();
            reportObj.getAsJsonObject("imageSummary").addProperty("serverURL", this.qualysAuth.getPortalURL());
            scanResultObj.add(imageId, reportObj);
            JsonElement element = gson.fromJson(imageDetails, JsonElement.class);
            JsonObject jsonObj = element.getAsJsonObject();
            JsonElement repoObj = jsonObj.get("repo");
            HashSet<String> repos = new HashSet<String>();
            if (repoObj != null && !repoObj.isJsonNull()) {
                JsonArray repoArray = repoObj.getAsJsonArray();
                for (int i = 0; i < repoArray.size(); ++i) {
                    JsonObject obj = repoArray.get(i).getAsJsonObject();
                    JsonElement repoNameObj = obj.get("repository");
                    if (repoNameObj == null || repoNameObj.isJsonNull()) continue;
                    repos.add(repoNameObj.getAsString());
                }
            }
            JsonObject confirmedVulnsElement = reportObj.get("confirmedVulnsBySev").getAsJsonObject();
            int[] confirmedVulns = new int[5];
            if (confirmedVulnsElement != null) {
                for (int i = 0; i < 5; ++i) {
                    confirmedVulns[i] = confirmedVulnsElement.get(String.valueOf(i + 1)).getAsInt();
                }
            }
            JsonObject obj = new JsonObject();
            JsonElement confirmedVulnsEl = gson.toJsonTree(confirmedVulns);
            obj.add("confirmedVulns", confirmedVulnsEl);
            JsonElement repoElement = gson.toJsonTree(repos);
            obj.add("repos", repoElement);
            obj.addProperty("imageId", imageId);
            if (jsonElement.getAsJsonObject().get("trendingData") == null) {
                jsonElement.getAsJsonObject().add("trendingData", new JsonArray());
            }
            JsonArray jsonArray = jsonElement.getAsJsonObject().get("trendingData").getAsJsonArray();
            jsonArray.add(obj);
            String jsonContent = jsonElement.toString();
            File dir = new File(f.getParentFile(), f.getName());
            PrintWriter writer = new PrintWriter(dir, "UTF-8");
            writer.print(jsonContent);
            writer.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            this.buildLogger.addBuildLogEntry("Error writing " + filename + " ;Reason = " + e.getCause() + e.getMessage());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    for (StackTraceElement traceElement : e.getStackTrace()) {
                        logger.info("\tat " + traceElement);
                    }
                }
            }
        }
    }

    public JsonArray makeWebhookData(JsonObject scanResultObj) {
        if (scanResultObj == null) {
            logger.info("Scan result object is null in makeWebhookData");
            return new JsonArray();
        }
        JsonArray imagesDataWebhookArray = new JsonArray();
        try {
            for (Map.Entry<String, JsonElement> entry : scanResultObj.entrySet()) {
                JsonObject jsonObj = entry.getValue().getAsJsonObject();
                JsonObject result = new JsonObject();
                JsonObject imageSummaryObj = jsonObj.getAsJsonObject("imageSummary");
                result.addProperty("imageId/name", entry.getKey());
                result.add("imageId", jsonObj.get("imageId"));
                result.add("uuid", imageSummaryObj.get("uuid"));
                result.add("sha", imageSummaryObj.get("sha"));
                result.add("size", imageSummaryObj.get("size"));
                result.add("repo", imageSummaryObj.get("repo"));
                result.add("operatingSystem", imageSummaryObj.get("operatingSystem"));
                result.add("layersCount", imageSummaryObj.get("layersCount"));
                result.add("dockerVersion", imageSummaryObj.get("dockerVersion"));
                result.add("architecture", imageSummaryObj.get("architecture"));
                JsonObject vulns = new JsonObject();
                vulns.add("totalVulnerabilities", jsonObj.get("totalVulnerabilities"));
                vulns.add("typeDetected", jsonObj.get("typeDetected"));
                JsonObject severity = new JsonObject();
                severity.add("Potential", jsonObj.get("potentialVulnsBySev"));
                severity.add("Confirmed", jsonObj.get("confirmedVulnsBySev"));
                vulns.add("severity", severity);
                vulns.add("patchable", jsonObj.get("patchability"));
                result.add("vulnerabilities", vulns);
                imagesDataWebhookArray.add(result);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Error creating webhook data. Reason = " + e.getMessage());
            this.buildLogger.addBuildLogEntry("Error creating webhook data. Reason = " + e.getMessage());
        }
        return imagesDataWebhookArray;
    }

    private void raiseBuildFailureException(String imageID, JsonObject result, boolean pass) throws BuildFailureException {
        JsonObject qidsObj;
        Object msg = "";
        if (this.addExclusion) {
            JsonObject cveIdsObj;
            if (result.has("qids") && result.get("qids") != null && !result.get("qids").isJsonNull() && (qidsObj = result.get("qids").getAsJsonObject()).get("excluded") != null && !qidsObj.get("excluded").isJsonNull()) {
                String excludedQids = qidsObj.get("excluded").getAsString();
                this.buildLogger.addErrorLogEntry("QIDs excluded from failure condition evaluation of " + imageID + " = " + excludedQids);
            }
            if (result.has("cveIds") && result.get("cveIds") != null && !result.get("cveIds").isJsonNull() && (cveIdsObj = result.get("cveIds").getAsJsonObject()).get("excluded") != null && !cveIdsObj.get("excluded").isJsonNull()) {
                String excludedCveIds = cveIdsObj.get("excluded").getAsString();
                this.buildLogger.addErrorLogEntry("CVEs excluded from failure condition evaluation of " + imageID + " = " + excludedCveIds);
            }
        }
        if (!pass) {
            JsonObject cvssObj;
            boolean cvssPass;
            String found;
            JsonObject cveObj;
            boolean cvePass;
            JsonObject cveObj2;
            boolean cvePass2;
            String found2;
            boolean qidsPass;
            if (result.has("qids") && result.get("qids") != null && !result.get("qids").isJsonNull() && !(qidsPass = (qidsObj = result.get("qids").getAsJsonObject()).get("result").getAsBoolean())) {
                found2 = qidsObj.get("found").getAsString();
                msg = (String)msg + "QIDs configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found2 + ";\n";
            }
            if (result.has("cveIds") && result.get("cveIds") != null && !result.get("cveIds").isJsonNull() && !(cvePass2 = (cveObj2 = result.get("cveIds").getAsJsonObject()).get("result").getAsBoolean())) {
                found2 = cveObj2.get("found").getAsString();
                msg = (String)msg + "CVE IDs configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found2 + ";\n";
            }
            StringBuffer sevConfigured = new StringBuffer();
            sevConfigured.append("\nConfigured : ");
            Object sevFound = "\nFound : ";
            boolean severityFailed = false;
            if (result.has("severities") && result.get("severities") != null) {
                JsonObject severities = result.get("severities").getAsJsonObject();
                for (int i = 1; i <= 5; ++i) {
                    JsonObject sevObj;
                    if (severities.get(String.valueOf(i)) == null || severities.get(String.valueOf(i)).isJsonNull() || !(sevObj = severities.get(String.valueOf(i)).getAsJsonObject()).has("configured") || sevObj.get("configured").isJsonNull() || sevObj.get("configured").getAsInt() == -1) continue;
                    sevFound = (String)sevFound + " Severity " + i + ": " + (Serializable)(sevObj.get("found").isJsonNull() ? Integer.valueOf(0) : sevObj.get("found").getAsString()) + ";";
                    sevConfigured.append(" Severity " + i + " > " + sevObj.get("configured").getAsString() + ";");
                    boolean sevPass = sevObj.get("result").getAsBoolean();
                    if (sevPass) continue;
                    severityFailed = true;
                }
            }
            if (severityFailed) {
                msg = (String)msg + "The vulnerabilities count by severity for image id " + imageID + " exceeded one of the configured threshold value :" + sevConfigured.toString() + (String)sevFound;
            }
            if (result.has("software") && result.get("software") != null && !result.get("software").isJsonNull() && !(cvePass = (cveObj = result.get("software").getAsJsonObject()).get("result").getAsBoolean())) {
                found = cveObj.get("found").getAsString();
                msg = (String)msg + "Softwares configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found + ";\n";
            }
            if (result.has("cvss") && result.get("cvss") != null && !result.get("cvss").isJsonNull() && !(cvssPass = (cvssObj = result.get("cvss").getAsJsonObject()).get("result").getAsBoolean())) {
                found = cvssObj.get("foundMap").getAsJsonObject().toString().replaceAll("[{}]", "");
                msg = (String)msg + "CVSS Score configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found;
            }
            throw new BuildFailureException((String)msg);
        }
    }
}

