/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalasbt.ipcsocket.NativeErrorException;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;

public class UnixDomainServerSocket
extends ServerSocket {
    private static final int DEFAULT_BACKLOG = 50;
    private static final int PF_LOCAL = 1;
    private static final int AF_LOCAL = 1;
    private static final int SOCK_STREAM = 1;
    private final AtomicInteger fd;
    private final int backlog;
    private boolean isBound;
    private boolean isClosed;
    private final UnixDomainSocketLibraryProvider provider;
    private final boolean useJNI;

    public UnixDomainServerSocket() throws IOException {
        this(50, null, false);
    }

    public UnixDomainServerSocket(int n) throws IOException {
        this(n, null, false);
    }

    public UnixDomainServerSocket(String string) throws IOException {
        this(50, string, false);
    }

    public UnixDomainServerSocket(String string, boolean bl) throws IOException {
        this(50, string, bl);
    }

    public UnixDomainServerSocket(int n, String string) throws IOException {
        this(n, string, false);
    }

    public UnixDomainServerSocket(int n, String string, boolean bl) throws IOException {
        try {
            this.useJNI = bl;
            this.provider = UnixDomainSocketLibraryProvider.get(bl);
            this.fd = new AtomicInteger(this.provider.socket(1, 1, 0));
            this.backlog = n;
            if (string != null) {
                this.bind(new UnixDomainServerSocketAddress(string));
            }
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }

    @Override
    public synchronized void bind(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof UnixDomainServerSocketAddress)) {
            throw new IllegalArgumentException("endpoint must be an instance of UnixDomainServerSocketAddress");
        }
        if (this.isBound) {
            throw new IllegalStateException("Socket is already bound");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        UnixDomainServerSocketAddress unixDomainServerSocketAddress = (UnixDomainServerSocketAddress)socketAddress;
        byte[] byArray = unixDomainServerSocketAddress.getPath().getBytes();
        try {
            int n = this.fd.get();
            this.provider.bind(n, byArray, byArray.length);
            this.provider.listen(n, this.backlog);
            this.isBound = true;
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        UnixDomainServerSocket unixDomainServerSocket = this;
        synchronized (unixDomainServerSocket) {
            if (!this.isBound) {
                throw new IllegalStateException("Socket is not bound");
            }
            if (this.isClosed) {
                throw new IllegalStateException("Socket is already closed");
            }
        }
        try {
            int n = this.provider.accept(this.fd.get());
            return new UnixDomainSocket(n, this.useJNI);
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        try {
            this.provider.close(this.fd.getAndSet(-1));
            this.isClosed = true;
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }

    public static class UnixDomainServerSocketAddress
    extends SocketAddress {
        private final String path;

        public UnixDomainServerSocketAddress(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }
    }
}

