/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import org.scalasbt.ipcsocket.NativeErrorException;
import org.scalasbt.ipcsocket.NativeLoader;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;

class JNIUnixDomainSocketLibraryProvider
implements UnixDomainSocketLibraryProvider {
    private static final JNIUnixDomainSocketLibraryProvider instance = new JNIUnixDomainSocketLibraryProvider();

    JNIUnixDomainSocketLibraryProvider() {
    }

    static final JNIUnixDomainSocketLibraryProvider instance() {
        return instance;
    }

    @Override
    public int socket(int n, int n2, int n3) throws NativeErrorException {
        return this.returnOrThrow(this.socketNative(n, n2, n3), 0);
    }

    @Override
    public int bind(int n, byte[] byArray, int n2) throws NativeErrorException {
        return this.returnOrThrow(this.bindNative(n, byArray, n2), 0);
    }

    @Override
    public int listen(int n, int n2) throws NativeErrorException {
        return this.returnOrThrow(this.listenNative(n, n2), 0);
    }

    @Override
    public int accept(int n) throws NativeErrorException {
        return this.returnOrThrow(this.acceptNative(n), 0);
    }

    @Override
    public int connect(int n, byte[] byArray, int n2) throws NativeErrorException {
        return this.returnOrThrow(this.connectNative(n, byArray, n2), 0);
    }

    @Override
    public int read(int n, byte[] byArray, int n2, int n3) throws NativeErrorException {
        return this.returnOrThrow(this.readNative(n, byArray, n2, n3), -1);
    }

    @Override
    public int write(int n, byte[] byArray, int n2, int n3) throws NativeErrorException {
        return this.returnOrThrow(this.writeNative(n, byArray, n2, n3), 0);
    }

    @Override
    public int close(int n) throws NativeErrorException {
        return this.returnOrThrow(this.closeNative(n), 0);
    }

    @Override
    public int shutdown(int n, int n2) throws NativeErrorException {
        return this.returnOrThrow(this.shutdownNative(n, n2), 0);
    }

    private int returnOrThrow(int n, int n2) throws NativeErrorException {
        if (n < n2) {
            String string = "Error " + -n + ": " + this.errString(-n);
            throw new NativeErrorException(-n, string);
        }
        return n;
    }

    native int socketNative(int var1, int var2, int var3);

    native int bindNative(int var1, byte[] var2, int var3);

    native int listenNative(int var1, int var2);

    native int acceptNative(int var1);

    native int connectNative(int var1, byte[] var2, int var3);

    native int readNative(int var1, byte[] var2, int var3, int var4);

    native int writeNative(int var1, byte[] var2, int var3, int var4);

    native int closeNative(int var1);

    native int shutdownNative(int var1, int var2);

    @Override
    public native int maxSocketLength();

    native String errString(int var1);

    static {
        NativeLoader.load();
    }
}

