/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.common.QualysCriteria;

import java.util.ArrayList;
import java.util.Set;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonNull;
import qshaded.com.google.gson.JsonObject;

public class SoftwareCriteria {
    ArrayList<String> filters = new ArrayList(0);
    JsonObject criteriaObject;
    Set<String> namesSet;
    ArrayList<JsonObject> namesFound = new ArrayList(0);
    ArrayList<String> softwareFound = new ArrayList(0);

    public SoftwareCriteria(JsonArray softwareFilter) {
        this.criteriaObject = new JsonObject();
        for (JsonElement software : softwareFilter) {
            String filter = software.getAsString();
            this.filters.add(filter);
            JsonObject swFilterObject = this.getSoftwareNameAndVersion(filter);
            String name = swFilterObject.get("name").getAsString().toLowerCase();
            if (!this.criteriaObject.has(name)) {
                this.criteriaObject.add(name, new JsonArray());
            }
            swFilterObject.remove("name");
            JsonArray conditions = this.criteriaObject.get(name).getAsJsonArray();
            conditions.add(swFilterObject);
        }
        this.namesSet = this.criteriaObject.keySet();
    }

    private JsonObject getSoftwareNameAndVersion(String filter) {
        String splitOn = "";
        JsonObject swFilterObject = new JsonObject();
        swFilterObject.add("name", JsonNull.INSTANCE);
        swFilterObject.add("operator", JsonNull.INSTANCE);
        swFilterObject.add("version", JsonNull.INSTANCE);
        if (filter.contains(">=")) {
            splitOn = ">=";
        } else if (filter.contains("<=")) {
            splitOn = "<=";
        } else if (filter.contains(">")) {
            splitOn = ">";
        } else if (filter.contains("<")) {
            splitOn = "<";
        } else if (filter.contains("=")) {
            splitOn = "=";
        }
        if (!splitOn.equals("")) {
            String[] filterParts = filter.split(splitOn);
            swFilterObject.addProperty("name", filterParts[0]);
            swFilterObject.addProperty("operator", splitOn);
            swFilterObject.addProperty("version", filterParts[1]);
        } else {
            swFilterObject.addProperty("name", filter);
        }
        return swFilterObject;
    }

    public JsonObject evaluate(JsonArray softwareArray) {
        for (JsonElement softwareElement : softwareArray) {
            JsonObject software = softwareElement.getAsJsonObject();
            String name = software.get("name").getAsString();
            for (String n : this.namesSet) {
                if (!name.toLowerCase().matches(n)) continue;
                software.addProperty("criteriaKey", n);
                this.namesFound.add(software);
            }
        }
        if (this.namesFound.size() > 0) {
            for (JsonObject software : this.namesFound) {
                boolean matches = this.compareSoftware(software);
                if (!matches) continue;
                software.remove("vulnerabilities");
                String matched = software.get("name").getAsString() + "=" + software.get("version").getAsString();
                this.softwareFound.add(matched);
            }
        }
        String configured = this.filters.toString().replace("[", "").replace("]", "");
        String found = this.softwareFound.toString().replace("[", "").replace("]", "");
        JsonObject softwareResult = new JsonObject();
        softwareResult.addProperty("configured", configured);
        softwareResult.addProperty("found", found);
        if (this.softwareFound.size() > 0) {
            softwareResult.addProperty("result", false);
        } else {
            softwareResult.addProperty("result", true);
        }
        return softwareResult;
    }

    private boolean compareSoftware(JsonObject software) {
        String name = software.get("criteriaKey").getAsString().toLowerCase();
        JsonArray filtersArray = this.criteriaObject.getAsJsonArray(name);
        boolean result = false;
        for (JsonElement filter : filtersArray) {
            JsonObject configuredFilter = filter.getAsJsonObject();
            if (configuredFilter.get("operator").isJsonNull()) {
                if (!result) {
                    // empty if block
                }
                result = true;
                continue;
            }
            if (!configuredFilter.get("operator").getAsString().equals("=") || !software.get("version").getAsString().matches(configuredFilter.get("version").getAsString())) continue;
            if (!result) {
                // empty if block
            }
            result = true;
        }
        return result;
    }
}

