/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qualys.bamboo.plugin.containerSecurity.httpClient.LocalDirectorySSLConfig;
import com.qualys.bamboo.plugin.containerSecurity.util.Helper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.JsonParser;

public class DockerClientHelper {
    private BuildLogger buildLogger;
    private static final Logger logger = Logger.getLogger(Helper.class.getName());
    private CloseableHttpClient httpClient = null;
    private String dockerURL;
    private String dockerCert;

    public DockerClientHelper() {
    }

    public DockerClientHelper(BuildLogger buildLogger, String dockerURL, String dockerCert) {
        this.buildLogger = buildLogger;
        this.dockerURL = dockerURL;
        this.dockerCert = dockerCert;
    }

    private static String get(String path) {
        return "GET " + path + " HTTP/1.1\r\nHost: qualys\r\nUser-Agent: java-unix-socket-client/1.0\r\nAccept: application/json\r\n\r\n";
    }

    private static String post(String path) {
        return "POST " + path + " HTTP/1.1\r\nHost: qualys\r\nUser-Agent: java-unix-socket-client/1.0\r\nAccept: application/json\r\n\r\n";
    }

    public JsonObject executeSocketRequest(String method, String api) throws Exception, IOException {
        JsonObject json_response = new JsonObject();
        String outputData = null;
        String apiResponseCode = "0";
        String dockerURL = this.dockerURL.replace("unix://", "");
        File f = new File(dockerURL);
        if (!f.exists()) {
            this.buildLogger.addBuildLogEntry("Socket file does not exist: " + dockerURL);
            throw new Exception("Socket file does not exist: " + dockerURL);
        }
        try (UnixDomainSocket socket = new UnixDomainSocket(dockerURL);){
            try (OutputStream os = ((Socket)socket).getOutputStream();){
                if (method.toLowerCase().equals("get")) {
                    os.write(DockerClientHelper.get(api).getBytes(StandardCharsets.UTF_8));
                }
                if (method.toLowerCase().equals("post")) {
                    os.write(DockerClientHelper.post(api).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
                this.buildLogger.addBuildLogEntry("API call failed using socket: " + e.getMessage());
                throw new Exception("API call failed using socket: " + e.getMessage());
            }
            try (BufferedReader response = new BufferedReader(new InputStreamReader(((Socket)socket).getInputStream()));){
                String line;
                long len = -1L;
                while ((line = response.readLine()) != null) {
                    if (line.toLowerCase().startsWith("content-length:")) {
                        len = Long.parseLong(line.substring("content-length:".length()).trim());
                        if (len != 0L) continue;
                    } else {
                        if (line.startsWith("HTTP/1.1 ")) {
                            apiResponseCode = line.split(" ")[1];
                            continue;
                        }
                        if (!line.toLowerCase().startsWith("{") && !line.toLowerCase().startsWith("[")) continue;
                        outputData = line;
                    }
                    break;
                }
            }
            catch (Exception e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\t Exception occurred at " + traceElement);
                }
                this.buildLogger.addBuildLogEntry("Error reading response from socket: " + e.getMessage());
                throw new Exception("Error reading response from socket: " + e.getMessage());
            }
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\t Exception occurred at " + traceElement);
            }
            this.buildLogger.addBuildLogEntry("Socket error: " + e.getMessage());
            throw new Exception("Socket error: " + e.getMessage());
        }
        json_response.addProperty("responseCode", apiResponseCode);
        if (outputData != null) {
            JsonElement jelement = JsonParser.parseString(outputData);
            if (jelement.isJsonObject()) {
                JsonObject jobject = jelement.getAsJsonObject();
                json_response.add("data", jobject);
            } else if (jelement.isJsonArray()) {
                JsonArray jarray = jelement.getAsJsonArray();
                json_response.add("data", jarray);
            }
        } else {
            json_response.addProperty("data", "");
        }
        return json_response;
    }

    public JsonObject executeHttpRequest(String action, String path) throws Exception {
        JsonObject json_response = new JsonObject();
        Registry<SSLConnectionSocketFactory> socketFactoryRegistry = null;
        LocalDirectorySSLConfig sslConfig = null;
        HttpRequestBase request = null;
        if (!StringUtils.isEmpty((String)this.dockerCert)) {
            path = path.replace("http://", "https://");
            RegistryBuilder<SSLConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create();
            String dockerCertPath = this.checkDockerCertPath(this.dockerCert);
            sslConfig = new LocalDirectorySSLConfig(dockerCertPath);
            if (sslConfig != null) {
                try {
                    SSLContext sslContext = sslConfig.getSSLContext();
                    if (sslContext == null) {
                        throw new Exception("SSLContext context not found");
                    }
                    socketFactoryRegistry = socketFactoryRegistryBuilder.register("https", new SSLConnectionSocketFactory(sslContext)).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager(socketFactoryRegistry);
            this.httpClient = HttpClients.custom().setConnectionManager(connectionManager).build();
        } else {
            this.httpClient = HttpClients.custom().build();
        }
        try {
            BasicHttpContext context = new BasicHttpContext();
            if (action.toLowerCase().equals("get")) {
                request = new HttpGet(URI.create(path));
            }
            if (action.toLowerCase().equals("post")) {
                request = new HttpPost(URI.create(path));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request, context);
            String outputData = EntityUtils.toString(response.getEntity());
            json_response.addProperty("responseCode", response.getStatusLine().getStatusCode());
            if (outputData != null) {
                JsonElement jelement = JsonParser.parseString(outputData);
                if (jelement.isJsonObject()) {
                    JsonObject jobject = jelement.getAsJsonObject();
                    json_response.add("data", jobject);
                } else if (jelement.isJsonArray()) {
                    JsonArray jarray = jelement.getAsJsonArray();
                    json_response.add("data", jarray);
                }
            } else {
                json_response.addProperty("data", "");
            }
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                logger.info("Unable to execute http request, Please check Qualys credentials or docker configuration");
                throw new Exception("Unable to execute http request, Please check Qualys credentials or docker configuration");
            }
            logger.info("Unable to execute http request, Msg: " + e.getMessage());
            throw new Exception("Unable to execute http request, Msg: " + e.getMessage());
        }
        return json_response;
    }

    public boolean tagImage(String imageIdOrName, String imageSha) throws Exception, IOException {
        JsonObject api_response = null;
        String dockerURL = null;
        String api = "/images/" + imageIdOrName + "/tag?repo=qualys_scan_target&tag=" + imageSha;
        try {
            if (this.isUnixHostScheme()) {
                this.buildLogger.addBuildLogEntry("Calling executeSocketRequestForImageTagging with API: " + api);
                api_response = this.executeSocketRequestForImageTagging("POST", api);
            } else {
                dockerURL = this.dockerURL.replace("tcp://", "http://");
                this.buildLogger.addBuildLogEntry("Calling executeHttpRequest with API: " + dockerURL + api);
                api_response = this.executeHttpRequest("POST", dockerURL + api);
            }
            if (api_response.has("responseCode") && api_response.get("responseCode").getAsString().equals("201")) {
                this.buildLogger.addBuildLogEntry("Tagged image(" + imageIdOrName + ") successfully");
                return true;
            }
            throw new Exception("API response code is not 201, Response Code: " + api_response.get("responseCode").getAsString());
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            this.buildLogger.addErrorLogEntry("Failed to tag the image " + imageIdOrName + " with qualys_scan_target.. Reason : " + e.getMessage());
            throw new Exception("Failed to tag the image " + imageIdOrName + " with qualys_scan_target.. Reason : " + e.getMessage());
        }
    }

    public String fetchImageSha(String image, String dockerCert) throws Exception {
        try {
            JsonObject api_response = null;
            String dockerURL = null;
            String api = "/images/" + image + "/json";
            if (this.isUnixHostScheme()) {
                api_response = this.executeSocketRequest("GET", api);
            } else {
                dockerURL = this.dockerURL.replace("tcp://", "http://");
                api_response = this.executeHttpRequest("GET", dockerURL + api);
            }
            if (api_response.has("responseCode") && api_response.get("responseCode").getAsString().equals("200")) {
                JsonObject json_response = JsonParser.parseString(api_response.get("data").toString()).getAsJsonObject();
                String imageId = json_response.get("Id").getAsString();
                String[] imageIds = imageId.split(":");
                String imageSha = imageIds[1];
                this.buildLogger.addBuildLogEntry("### Image sha for " + image + " is = " + imageSha);
                return imageSha;
            }
            throw new Exception(api_response.get("data").getAsString());
        }
        catch (Exception e) {
            String errorMsg = "Failed to extract image sha associated with " + image + " ; Reason : " + e.getMessage();
            logger.info(errorMsg);
            throw new Exception(errorMsg);
        }
    }

    public boolean isCICDSensorUp() throws IOException, Exception {
        JsonObject api_response = null;
        String dockerURL = null;
        if (this.isUnixHostScheme()) {
            api_response = this.executeSocketRequest("GET", "/containers/json");
        } else {
            dockerURL = this.dockerURL.replace("tcp://", "http://");
            api_response = this.executeHttpRequest("GET", dockerURL + "/containers/json");
        }
        if (api_response.get("responseCode").getAsString().equals("200")) {
            JsonArray containerArray = JsonParser.parseString(api_response.get("data").toString()).getAsJsonArray();
            Iterator<JsonElement> iterator = containerArray.iterator();
            while (iterator.hasNext()) {
                Gson gson = new Gson();
                JsonElement containerInnerData = iterator.next();
                JsonObject containerObj = containerInnerData.getAsJsonObject();
                String label = containerObj.get("Labels").toString();
                Map map = gson.fromJson(label, Map.class);
                if (!map.containsKey("VersionInfo") || !((String)map.get("VersionInfo")).contains("Qualys Sensor") || !containerObj.has("Id") || containerObj.get("Id").getAsString() == null || containerObj.get("Id").getAsString().isEmpty()) continue;
                String id = containerObj.get("Id").getAsString();
                String state = this.getContainerState(id);
                if (state != null && !state.isEmpty() && state.equals("paused")) {
                    this.buildLogger.addBuildLogEntry("Sensor Container State - paused ");
                    throw new Exception("Qualys CS sensor container is in paused state. Sensor won't be able to scan the image. Please check the sensor container.");
                }
                if (!containerObj.has("Command") || containerObj.get("Command").getAsString() == null || containerObj.get("Command").getAsString().isEmpty() || !containerObj.get("Command").getAsString().contains("cicd-deployed-sensor")) continue;
                return true;
            }
            throw new Exception("Qualys CS sensor container is not running... Please check if sensor is configured correctly.");
        }
        return false;
    }

    private String getContainerState(String id) throws IOException, Exception {
        JsonObject api_response = null;
        String state = null;
        String dockerURL = null;
        if (this.isUnixHostScheme()) {
            api_response = this.executeSocketRequest("GET", "/containers/" + id + "/json");
        } else {
            dockerURL = this.dockerURL.replace("tcp://", "http://");
            api_response = this.executeHttpRequest("GET", dockerURL + "/containers/" + id + "/json");
        }
        if (api_response.get("responseCode").getAsString().equals("200")) {
            JsonObject json_response = JsonParser.parseString(api_response.get("data").toString()).getAsJsonObject();
            JsonObject stateObject = json_response.get("State").getAsJsonObject();
            state = stateObject.has("Status") ? stateObject.get("Status").getAsString() : "";
        }
        return state;
    }

    private boolean isUnixHostScheme() {
        return this.dockerURL.startsWith("unix://");
    }

    private String checkDockerCertPath(String dockerCertPath) throws Exception {
        File certPath = new File(dockerCertPath);
        if (!certPath.exists()) {
            this.buildLogger.addBuildLogEntry("Docker Cert File Path does not exist");
            throw new Exception("Docker Cert File Path " + dockerCertPath + "' doesn't exist.");
        }
        if (!certPath.isDirectory()) {
            throw new Exception("Docker Cert File Path " + dockerCertPath + "' doesn't point to a directory.");
        }
        return dockerCertPath;
    }

    private List<String> getResponseListOfString(InputStream inputStream) throws IOException {
        String[] lines;
        ArrayList<String> list = new ArrayList<String>();
        byte[] buffer = new byte[1024];
        StringBuilder builder = new StringBuilder();
        int len = -1;
        while ((len = inputStream.read(buffer)) != -1) {
            byte[] temp = new byte[len];
            System.arraycopy(buffer, 0, temp, 0, len);
            builder.append(new String(temp, StandardCharsets.UTF_8));
            if (len >= 1024) continue;
            break;
        }
        for (String line : lines = builder.toString().split("\\r?\\n")) {
            if (StringUtils.isEmpty((String)line)) continue;
            list.add(line);
        }
        return list;
    }

    public JsonObject executeSocketRequestForImageTagging(String method, String api) throws Exception, IOException {
        JsonObject json_response = new JsonObject();
        String outputData = null;
        String apiResponseCode = "0";
        String dockerURL = this.dockerURL.replace("unix://", "");
        File f = new File(dockerURL);
        if (!f.exists()) {
            this.buildLogger.addBuildLogEntry("Socket file does not exist: " + dockerURL);
            throw new Exception("Socket file does not exist: " + dockerURL);
        }
        try (UnixDomainSocket socket = new UnixDomainSocket(dockerURL);){
            try (OutputStream os = ((Socket)socket).getOutputStream();){
                if (method.toLowerCase().equals("get")) {
                    os.write(DockerClientHelper.get(api).getBytes(StandardCharsets.UTF_8));
                }
                if (method.toLowerCase().equals("post")) {
                    os.write(DockerClientHelper.post(api).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
                this.buildLogger.addBuildLogEntry("API call failed using socket: " + e.getMessage());
                throw new Exception("API call failed using socket: " + e.getMessage());
            }
            try (InputStream inputStream = ((Socket)socket).getInputStream();){
                List<String> resposneList = this.getResponseListOfString(inputStream);
                long len = -1L;
                for (String response : resposneList) {
                    if (response.toLowerCase().startsWith("content-length:")) {
                        len = Long.parseLong(response.substring("content-length:".length()).trim());
                        if (len != 0L) continue;
                    } else {
                        if (response.startsWith("HTTP/1.1 ")) {
                            apiResponseCode = response.split(" ")[1];
                            continue;
                        }
                        if (!response.toLowerCase().startsWith("{") && !response.toLowerCase().startsWith("[")) continue;
                        outputData = response;
                    }
                    break;
                }
            }
            catch (Exception e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\t Exception occurred at " + traceElement);
                }
                this.buildLogger.addBuildLogEntry("Error reading response from socket: " + e.getMessage());
                throw new Exception("Error reading response from socket: " + e.getMessage());
            }
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\t Exception occurred at " + traceElement);
            }
            this.buildLogger.addBuildLogEntry("Socket error: " + e.getMessage());
            throw new Exception("Socket error: " + e.getMessage());
        }
        json_response.addProperty("responseCode", apiResponseCode);
        if (outputData != null) {
            JsonElement jelement = JsonParser.parseString(outputData);
            if (jelement.isJsonObject()) {
                JsonObject jobject = jelement.getAsJsonObject();
                json_response.add("data", jobject);
            } else if (jelement.isJsonArray()) {
                JsonArray jarray = jelement.getAsJsonArray();
                json_response.add("data", jarray);
            }
        } else {
            json_response.addProperty("data", "");
        }
        return json_response;
    }
}

