/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qualys.bamboo.plugin.containerSecurity.model.ProxyConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Webhook {
    private BuildLogger buildLogger;
    private final String url;
    private final String data;
    private final ProxyConfiguration proxy;
    private static final int timeout = 30;
    private static final int RETRIES = 1;
    private static final Logger logger = Logger.getLogger(Webhook.class.getName());

    public Webhook(String url, String data, BuildLogger logger, ProxyConfiguration proxy) {
        this.url = url;
        this.data = data;
        this.buildLogger = logger;
        this.proxy = proxy;
    }

    private CloseableHttpClient getHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.proxy.getUseProxy()) {
            HttpHost proxyHost = new HttpHost(this.proxy.getProxyServer(), this.proxy.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxyHost);
            String username = this.proxy.getProxyUsername();
            String password = this.proxy.getProxyPassword();
            if (StringUtils.isNotBlank((CharSequence)username)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(this.proxy.getProxyServer(), this.proxy.getProxyPort()), new UsernamePasswordCredentials(username, password));
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    public void post() {
        int tried = 0;
        boolean success = false;
        CloseableHttpClient client = this.getHttpClient();
        this.buildLogger.addBuildLogEntry("Sending scanned result data to webhook URL - " + this.url);
        logger.info("Sending scanned result data to webhook URL - " + this.url);
        do {
            ++tried;
            try {
                HttpPost postRequest = new HttpPost(this.url);
                StringEntity requestEntity = new StringEntity(this.data, StandardCharsets.UTF_8);
                postRequest.setEntity(requestEntity);
                postRequest.setHeader("Content-Type", "application/json");
                try (CloseableHttpResponse response = client.execute(postRequest);){
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode != 200) {
                        HttpEntity responseEntity = response.getEntity();
                        String responseBody = EntityUtils.toString(responseEntity, StandardCharsets.UTF_8);
                        this.buildLogger.addErrorLogEntry("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                        logger.info("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                        logger.info("Message from webhook: " + responseBody);
                    } else {
                        success = true;
                    }
                }
                catch (IOException e) {
                    this.buildLogger.addBuildLogEntry("Failed to post data to webhook URL - " + this.url);
                    logger.info("Failed to post data to webhook URL - " + this.url);
                }
            }
            catch (Exception e) {
                this.buildLogger.addBuildLogEntry("Unable to process POST request to Webhook URL. Reason = " + e.getMessage());
                break;
            }
        } while (tried < 1 && !success);
        if (success) {
            this.buildLogger.addBuildLogEntry("Successfully posted data to webhook URL - " + this.url);
            logger.info("Successfully posted data to webhook URL - " + this.url);
        }
    }
}

