/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.messages.AuthenticableMessage;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.qualys.bamboo.plugin.containerSecurity.QualysPluginConfiguration;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import qshaded.com.google.gson.Gson;

public class QualysTaskDataProvider
implements RuntimeTaskDataProvider {
    private SecureTokenService tokenService;
    private BandanaManager bandanaManager;
    private static final Logger logger = Logger.getLogger(QualysTaskDataProvider.class.getName());

    public Map<String, String> populateRuntimeTaskData(TaskDefinition taskDef, CommonContext context) {
        Object config;
        HashMap<String, String> map = new HashMap<String, String>();
        SecureToken token = this.tokenService.generate((Key)AuthenticableMessage.Identification.forResultKey((ResultKey)context.getResultKey()));
        map.put("qualys_task_secure_token", token.getToken());
        logger.info("populateRuntimeTaskData running on server....");
        if (this.bandanaManager != null && (config = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "QualysPluginGlobalConfig")) != null) {
            map.put("QualysPluginGlobalConfig", config.toString());
            String jsonString = (String)config;
            try {
                Gson gson = new Gson();
                QualysPluginConfiguration pluginConfig = gson.fromJson(jsonString, QualysPluginConfiguration.class);
                if (pluginConfig != null) {
                    pluginConfig.setPassword("*****");
                    String proxyPassword = pluginConfig.getProxyPassword();
                    if (proxyPassword != null && !proxyPassword.isEmpty()) {
                        pluginConfig.setProxyPassword("*****");
                    }
                    String printConfigStr = gson.toJson((Object)pluginConfig, (Type)((Object)QualysPluginConfiguration.class));
                    logger.info("Get value of QualysPluginGlobalConfig from bandanacontext in populateRuntimeTaskData =" + printConfigStr);
                }
            }
            catch (Exception e) {
                logger.info("Error in processing runtime task data:" + e.getMessage());
            }
        }
        return map;
    }

    public void processRuntimeTaskData(TaskDefinition taskDef, CommonContext context) {
        this.tokenService.invalidate((Key)context.getResultKey());
    }

    public void setSecureTokenService(SecureTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void processRuntimeTaskData(RuntimeTaskDefinition taskDef, CommonContext context) {
        this.tokenService.invalidate((Key)context.getResultKey());
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        logger.info("#### bandanamanager set on server....= " + bandanaManager);
    }

    public Map<String, WhitelistedSerializable> createRuntimeTaskData(RuntimeTaskDefinition arg0, CommonContext arg1) {
        return new HashMap<String, WhitelistedSerializable>();
    }
}

