/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.bandana.DefaultBandanaManager;
import com.atlassian.bandana.impl.MemoryBandanaPersister;
import com.qualys.bamboo.plugin.containerSecurity.QualysPluginConfiguration;
import com.qualys.plugins.common.QualysAuth.QualysAuth;
import com.qualys.plugins.common.QualysClient.QualysCSClient;
import com.qualys.plugins.common.QualysClient.QualysCSTestConnectionResponse;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import qshaded.com.google.gson.Gson;

public class QualysGlobalConfigAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private String apiServer;
    private String username;
    private String password;
    private String pollingInterval;
    private String vulnsTimeout;
    private boolean failOnSevereVulns;
    private int severity1;
    private int severity2;
    private int severity3;
    private int severity4;
    private int severity5;
    private boolean isSev5Vulns;
    private boolean isSev4Vulns;
    private boolean isSev3Vulns;
    private boolean isSev2Vulns;
    private boolean isSev1Vulns;
    private boolean isPotentialVulnsToBeChecked;
    private boolean failOnQidFound;
    private String qidList;
    private String proxyServer;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean useProxy;
    private String webhook;
    private String dockerUrl = "unix:///var/run/docker.sock";
    private String dockerCert;
    private boolean addExclusion;
    private String excludeOptions;
    private String excludeByCve;
    private String excludeByQid;
    private boolean failOnCve;
    private String cveList;
    private boolean failOnSoftware;
    private String softwareList;
    private boolean failOnCvss;
    private String cvssThreshold;
    private String cvssVersion;
    private static final long serialVersionUID = 1L;
    private static BandanaManager bandanaManager = null;
    private static QualysPluginConfiguration qualysPluginConfiguration = new QualysPluginConfiguration();
    private static final Logger log = Logger.getLogger(QualysGlobalConfigAction.class.getName());
    public static final String EXCLUDE_BY_QID = "excludeQid";
    public static final String EXCLUDE_BY_CVE = "excludeCve";
    public static final String EXCLUDE_BY_QID_MSG = "QIDs";
    public static final String EXCLUDE_BY_CVE_MSG = "CVEs";
    public static final String ENCRYPTED_PASSWORD = "password_is_encrypted";
    private static final Map EXCLUDE_OPTIONS = new HashMap();

    public QualysPluginConfiguration getQualysPluginConfiguration() {
        Object config;
        if (this.getBandanaManager() != null && (config = bandanaManager.getValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "QualysPluginGlobalConfig")) != null) {
            String jsonString = (String)config;
            try {
                Gson gson = new Gson();
                QualysPluginConfiguration globalconfig = gson.fromJson(jsonString, QualysPluginConfiguration.class);
                if (globalconfig != null) {
                    String password = globalconfig.getPassword();
                    globalconfig.setPassword("*****");
                    String proxyPassword = globalconfig.getProxyPassword();
                    if (proxyPassword != null && !proxyPassword.isEmpty()) {
                        globalconfig.setProxyPassword("*****");
                    }
                    String printConfigStr = gson.toJson((Object)globalconfig, (Type)((Object)QualysPluginConfiguration.class));
                    log.info("Get value of QualysPluginGlobalConfig from bandanacontext =" + printConfigStr);
                    globalconfig.setPassword(password);
                    globalconfig.setProxyPassword(proxyPassword);
                    return globalconfig;
                }
            }
            catch (Exception e) {
                log.info("Error converting stored global config to Qualys Plugin Config object." + e.getMessage());
            }
        }
        log.info("Global Config not found or saved properly. Try saving again.");
        return null;
    }

    public Map<String, String> getExcludeOptionsMap() {
        if (EXCLUDE_OPTIONS.isEmpty()) {
            EXCLUDE_OPTIONS.put(EXCLUDE_BY_QID, EXCLUDE_BY_QID_MSG);
            EXCLUDE_OPTIONS.put(EXCLUDE_BY_CVE, EXCLUDE_BY_CVE_MSG);
        }
        return EXCLUDE_OPTIONS;
    }

    public Map<String, String> getCvssVersionsList() {
        LinkedHashMap<String, String> cvssVersionsList = new LinkedHashMap<String, String>();
        cvssVersionsList.put("2", "2");
        cvssVersionsList.put("3", "3");
        return cvssVersionsList;
    }

    public boolean getFailOnSoftware() {
        return this.failOnSoftware;
    }

    public void setFailOnSoftware(boolean failOnSoftware) {
        this.failOnSoftware = failOnSoftware;
    }

    public boolean getFailOnCvss() {
        return this.failOnCvss;
    }

    public String getCvssThreshold() {
        return this.cvssThreshold;
    }

    public String getCvssVersion() {
        return this.cvssVersion;
    }

    public void setFailOnCvss(boolean failOnCvss) {
        this.failOnCvss = failOnCvss;
    }

    public void setCvssThreshold(String cvssThreshold) {
        this.cvssThreshold = cvssThreshold;
    }

    public void setCvssVersion(String cvssVersion) {
        this.cvssVersion = cvssVersion;
    }

    public String getSoftwareList() {
        return this.softwareList;
    }

    public void setSoftwareList(String softwareList) {
        this.softwareList = softwareList;
    }

    public boolean getFailOnCve() {
        return this.failOnCve;
    }

    public void setFailOnCve(boolean failOnCve) {
        this.failOnCve = failOnCve;
    }

    public String getCveList() {
        return this.cveList;
    }

    public void setCveList(String cveList) {
        this.cveList = cveList;
    }

    public String getExcludeByCve() {
        return this.excludeByCve;
    }

    public void setExcludeByCve(String excludeByCve) {
        this.excludeByCve = excludeByCve;
    }

    public String getExcludeByQid() {
        return this.excludeByQid;
    }

    public void setExcludeByQid(String excludeByQid) {
        this.excludeByQid = excludeByQid;
    }

    public String getDockerUrl() {
        return this.dockerUrl;
    }

    public void setDockerUrl(String dockerUrl) {
        this.dockerUrl = dockerUrl;
    }

    public String getDockerCert() {
        return this.dockerCert;
    }

    public void setDockerCert(String dockerCert) {
        this.dockerCert = dockerCert;
    }

    public boolean getAddExclusion() {
        return this.addExclusion;
    }

    public void setAddExclusion(boolean addExclusion) {
        this.addExclusion = addExclusion;
    }

    public String getExcludeOptions() {
        if (StringUtils.isEmpty((String)this.excludeOptions)) {
            return EXCLUDE_BY_CVE;
        }
        return this.excludeOptions;
    }

    public void setExcludeOptions(String excludeOptions) {
        this.excludeOptions = excludeOptions;
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public String getVulnsTimeout() {
        return this.vulnsTimeout;
    }

    public void setVulnsTimeout(String vulnsTimeout) {
        this.vulnsTimeout = vulnsTimeout;
    }

    public boolean getFailOnSevereVulns() {
        return this.failOnSevereVulns;
    }

    public void setFailOnSevereVulns(boolean failOnSevereVulns) {
        this.failOnSevereVulns = failOnSevereVulns;
    }

    public int getSeverity1() {
        return this.severity1;
    }

    public void setSeverity1(int severity1) {
        this.severity1 = severity1;
    }

    public int getSeverity2() {
        return this.severity2;
    }

    public void setSeverity2(int severity2) {
        this.severity2 = severity2;
    }

    public int getSeverity3() {
        return this.severity3;
    }

    public void setSeverity3(int severity3) {
        this.severity3 = severity3;
    }

    public int getSeverity4() {
        return this.severity4;
    }

    public void setSeverity4(int severity4) {
        this.severity4 = severity4;
    }

    public int getSeverity5() {
        return this.severity5;
    }

    public void setSeverity5(int severity5) {
        this.severity5 = severity5;
    }

    public boolean getIsSev5Vulns() {
        return this.isSev5Vulns;
    }

    public void setIsSev5Vulns(boolean isSev5Vulns) {
        this.isSev5Vulns = isSev5Vulns;
    }

    public boolean getIsSev4Vulns() {
        return this.isSev4Vulns;
    }

    public void setIsSev4Vulns(boolean isSev4Vulns) {
        this.isSev4Vulns = isSev4Vulns;
    }

    public boolean getIsSev3Vulns() {
        return this.isSev3Vulns;
    }

    public void setIsSev3Vulns(boolean isSev3Vulns) {
        this.isSev3Vulns = isSev3Vulns;
    }

    public boolean getIsSev2Vulns() {
        return this.isSev2Vulns;
    }

    public void setIsSev2Vulns(boolean isSev2Vulns) {
        this.isSev2Vulns = isSev2Vulns;
    }

    public boolean getIsSev1Vulns() {
        return this.isSev1Vulns;
    }

    public void setIsSev1Vulns(boolean isSev1Vulns) {
        this.isSev1Vulns = isSev1Vulns;
    }

    public boolean getIsPotentialVulnsToBeChecked() {
        return this.isPotentialVulnsToBeChecked;
    }

    public void setIsPotentialVulnsToBeChecked(boolean isPotentialVulnsToBeChecked) {
        this.isPotentialVulnsToBeChecked = isPotentialVulnsToBeChecked;
    }

    public boolean getFailOnQidFound() {
        return this.failOnQidFound;
    }

    public void setFailOnQidFound(boolean isFailOnQidFound) {
        this.failOnQidFound = isFailOnQidFound;
    }

    public String getQidList() {
        return this.qidList;
    }

    public void setQidList(String qidList) {
        this.qidList = qidList;
    }

    public BandanaManager getBandanaManager() {
        if (bandanaManager != null) {
            return bandanaManager;
        }
        MemoryBandanaPersister persister = new MemoryBandanaPersister();
        bandanaManager = new DefaultBandanaManager((BandanaPersister)persister);
        log.info("Get bandana manager in QualysGlobalConfigAction = " + bandanaManager);
        return bandanaManager;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getApiServer() {
        return this.apiServer;
    }

    public void setApiServer(String apiServer) {
        this.apiServer = apiServer;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        QualysGlobalConfigAction.bandanaManager = bandanaManager;
        log.info("Bandana manager = " + bandanaManager);
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        Pattern patt;
        String cve;
        String[] cveString;
        int lastInRange;
        String[] auth2;
        Pattern patt2;
        Object matcher;
        String URL_REGEX = "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String CVE_REGEX = "CVE-\\d{4}-\\d{4,7}";
        String PROXY_REGEX = "^[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";
        String DOCKER_URL_REGEX = "^(unix|tcp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*";
        super.validate();
        if (StringUtils.isEmpty((String)this.apiServer)) {
            this.addFieldError("apiServer", "You must specify a Qualys API server to connect to");
        } else {
            Pattern patt22 = Pattern.compile(URL_REGEX);
            matcher = patt22.matcher(this.apiServer);
            if (!((Matcher)matcher).matches()) {
                this.addFieldError("apiServer", "API Server URL is not valid!");
            }
        }
        if (!StringUtils.isEmpty((String)this.dockerUrl)) {
            patt2 = Pattern.compile(DOCKER_URL_REGEX);
            matcher = patt2.matcher(this.dockerUrl);
            if (!((Matcher)matcher).matches()) {
                this.addFieldError("dockerUrl", "Docker URL is not valid! Only 'tcp://' or 'unix://' supported");
            }
        } else {
            this.addFieldError("dockerUrl", "You must specify a valid docker daemon URL");
        }
        if (StringUtils.isEmpty((String)this.username)) {
            this.addFieldError("username", "You must specify a username");
        }
        if (StringUtils.isEmpty((String)this.password)) {
            this.addFieldError("password", "You must specify the password");
        }
        try {
            String originalProxyPassword;
            String originalPassword;
            if (this.apiServer != null) {
                this.apiServer = this.apiServer.trim();
            }
            String string = originalPassword = this.getQualysPluginConfiguration() != null ? this.getQualysPluginConfiguration().getPassword() : "";
            if (this.password != null && !this.password.equals(ENCRYPTED_PASSWORD)) {
                originalPassword = this.password;
            }
            String string2 = originalProxyPassword = this.getQualysPluginConfiguration() != null ? this.getQualysPluginConfiguration().getProxyPassword() : "";
            if (this.proxyPassword != null && !this.proxyPassword.isEmpty() && !this.proxyPassword.equals(ENCRYPTED_PASSWORD)) {
                originalProxyPassword = this.proxyPassword;
            }
            auth2 = new QualysAuth();
            auth2.setQualysCredentials(this.apiServer, this.username, originalPassword);
            if (this.useProxy) {
                if (this.proxyServer != null) {
                    this.proxyServer = this.proxyServer.trim();
                }
                auth2.setProxyCredentials(this.proxyServer, this.proxyUsername, originalProxyPassword, this.proxyPort);
            }
            QualysCSClient qcs = new QualysCSClient((QualysAuth)auth2);
            QualysCSTestConnectionResponse qualysCSTestConnectionResponse = qcs.testConnection();
            log.info("Test connection : Response Code:" + qualysCSTestConnectionResponse.responseCode + "; message:" + qualysCSTestConnectionResponse.message);
            if (qualysCSTestConnectionResponse.success) {
                log.info("Test Connection Successful!");
            } else {
                String errorMsg = qualysCSTestConnectionResponse.message;
                log.info("Test connection failed :" + errorMsg);
                this.addFieldError("password", errorMsg);
            }
        }
        catch (Exception e) {
            log.info("Error testing connection to Qualys server. Please check API server and proxy credentials." + e.getMessage());
            this.addFieldError("password", "Error testing connection to Qualys server. Please check API server and proxy credentials." + e.getMessage());
        }
        if (!StringUtils.isEmpty((String)this.pollingInterval) && !((Matcher)(matcher = (patt2 = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(this.pollingInterval))).matches()) {
            this.addFieldError("pollingInterval", "Timeout period is not valid!");
        }
        if (!StringUtils.isEmpty((String)this.vulnsTimeout) && !((Matcher)(matcher = (patt2 = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(this.vulnsTimeout))).matches()) {
            this.addFieldError("vulnsTimeout", "Timeout period is not valid!");
        }
        if (this.failOnQidFound) {
            if (this.qidList == null || StringUtils.isEmpty((String)this.qidList)) {
                this.addFieldError("qidList", "Enter valid QID range/numbers");
            } else {
                try {
                    String[] qidsString = this.qidList.split(",");
                    matcher = qidsString;
                    int auth2 = ((String[])matcher).length;
                    for (int i = 0; i < auth2; ++i) {
                        String string = matcher[i];
                        if (string.contains("-")) {
                            String[] range = string.split("-");
                            int firstInRange = Integer.parseInt(range[0].trim());
                            if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                            this.addFieldError("qidList", "Enter valid QID range");
                            continue;
                        }
                        int range = Integer.parseInt(string.trim());
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.addFieldError("qidList", "Enter valid QID range/numbers");
                }
            }
        }
        if (this.failOnCve) {
            if (this.cveList == null || StringUtils.isEmpty((String)this.cveList)) {
                this.addFieldError("cveList", "Enter valid CVE IDs list");
            } else {
                void var10_31;
                patt2 = Pattern.compile(CVE_REGEX);
                auth2 = cveString = this.cveList.split(",");
                int n = auth2.length;
                boolean bl = false;
                while (var10_31 < n) {
                    cve = auth2[var10_31];
                    Matcher matcher2 = patt2.matcher(cve.trim());
                    if (!matcher2.matches()) {
                        this.addFieldError("cveList", cve + " is not a valid CVE ID!");
                    }
                    ++var10_31;
                }
            }
        }
        if (this.failOnSoftware && (this.softwareList == null || StringUtils.isEmpty((String)this.softwareList))) {
            this.addFieldError("softwareList", "Enter valid software list");
        }
        if (this.failOnCvss) {
            if (this.cvssThreshold == null || StringUtils.isEmpty((String)this.cvssThreshold)) {
                this.addFieldError("cvssThreshold", "Enter valid CVSS Score");
            } else {
                double cvssDouble = 0.0;
                try {
                    cvssDouble = Double.parseDouble(this.cvssThreshold);
                    if (cvssDouble < 0.0 || cvssDouble > 10.0) {
                        this.addFieldError("cvssThreshold", "Please enter a number in range of 0.0 to 10.0");
                    }
                }
                catch (NumberFormatException e) {
                    this.addFieldError("cvssThreshold", "Input is not a valid number.");
                }
            }
        }
        if (this.useProxy) {
            if (StringUtils.isEmpty((String)this.proxyServer)) {
                this.addFieldError("proxyServer", "You must specify a Proxy server to connect to");
            } else {
                Pattern patt3 = Pattern.compile(PROXY_REGEX);
                matcher = patt3.matcher(this.proxyServer);
                if (!((Matcher)matcher).matches()) {
                    this.addFieldError("proxyServer", "Enter valid Proxy server!");
                }
            }
        }
        this.validateNumberField("proxyPort", this.proxyPort, this.useProxy);
        this.validateNumberField("severity1", this.severity1, this.isSev1Vulns);
        this.validateNumberField("severity2", this.severity2, this.isSev2Vulns);
        this.validateNumberField("severity3", this.severity3, this.isSev3Vulns);
        this.validateNumberField("severity4", this.severity4, this.isSev4Vulns);
        this.validateNumberField("severity5", this.severity5, this.isSev5Vulns);
        if (!StringUtils.isEmpty((String)this.webhook) && !((Matcher)(matcher = (patt = Pattern.compile(URL_REGEX)).matcher(this.webhook))).matches()) {
            this.addFieldError("webhook", "Webhook URL is not valid!");
        }
        if (!(!this.failOnSevereVulns || this.isSev1Vulns || this.isSev2Vulns || this.isSev3Vulns || this.isSev4Vulns || this.isSev5Vulns)) {
            this.addFieldError("failOnSevereVulns", "None of the severity level settings selected");
        }
        if (!(!this.isPotentialVulnsToBeChecked || this.failOnCve || this.failOnQidFound || this.failOnSevereVulns || this.failOnSoftware || this.failOnCvss)) {
            this.addFieldError("isPotentialVulnsToBeChecked", "None of the Fail-on conditions above is selected to apply this condition");
        }
        if (this.addExclusion) {
            if (this.excludeOptions != null) {
                if (this.excludeOptions.equals(EXCLUDE_BY_QID)) {
                    if (StringUtils.isEmpty((String)this.excludeByQid)) {
                        this.addFieldError("addExclusion", "Enter valid QID range/numbers");
                    } else {
                        try {
                            String[] qidsString = this.excludeByQid.split(",");
                            for (String string : qidsString) {
                                if (string.contains("-")) {
                                    String[] range = string.split("-");
                                    int firstInRange = Integer.parseInt(range[0].trim());
                                    if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                                    this.addFieldError("addExclusion", "Enter valid QID range");
                                    continue;
                                }
                                int range = Integer.parseInt(string.trim());
                            }
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            this.addFieldError("addExclusion", "Enter valid QID range/numbers");
                        }
                    }
                } else if (this.excludeOptions.equals(EXCLUDE_BY_CVE)) {
                    if (StringUtils.isEmpty((String)this.excludeByCve)) {
                        this.addFieldError("addExclusion", "Enter valid CVE IDs list");
                    } else {
                        void var10_35;
                        Pattern patt4 = Pattern.compile(CVE_REGEX);
                        String[] stringArray = cveString = this.excludeByCve.split(",");
                        int n = stringArray.length;
                        boolean bl = false;
                        while (var10_35 < n) {
                            cve = stringArray[var10_35];
                            Matcher matcher3 = patt4.matcher(cve.trim());
                            if (!matcher3.matches()) {
                                this.addFieldError("excludeByCve", cve + " is not a valid CVE ID!");
                            }
                            ++var10_35;
                        }
                    }
                }
            } else {
                this.addFieldError("addExclusion", "Select one of the options to exclude");
            }
        }
    }

    private void validateNumberField(String field, int value, boolean isEnabled) {
        if (isEnabled && (value < 0 || value > Integer.MAX_VALUE)) {
            this.addFieldError(field, "Enter a valid number!");
        }
    }

    public String doInput() throws Exception {
        log.info("Setting Plugin Global configuration");
        return "input";
    }

    public String doDefault() throws Exception {
        log.info("In do Default method");
        return "input";
    }

    public String execute() throws Exception {
        String originalProxyPassword;
        String originalPassword;
        qualysPluginConfiguration.setServerURL(this.apiServer);
        qualysPluginConfiguration.setUsername(this.username);
        String string = originalPassword = this.getQualysPluginConfiguration() != null ? this.getQualysPluginConfiguration().getPassword() : "";
        if (this.password != null && !this.password.equals(ENCRYPTED_PASSWORD)) {
            qualysPluginConfiguration.setPassword(this.password);
        } else {
            qualysPluginConfiguration.setPassword(originalPassword);
        }
        String string2 = originalProxyPassword = this.getQualysPluginConfiguration() != null ? this.getQualysPluginConfiguration().getProxyPassword() : "";
        if (this.proxyPassword != null && !this.proxyPassword.equals(ENCRYPTED_PASSWORD)) {
            qualysPluginConfiguration.setProxyPassword(this.proxyPassword);
        } else {
            qualysPluginConfiguration.setProxyPassword(originalProxyPassword);
        }
        qualysPluginConfiguration.setPollingInterval(this.pollingInterval);
        qualysPluginConfiguration.setVulnsTimeout(this.vulnsTimeout);
        qualysPluginConfiguration.setFailOnSevereVulns(this.failOnSevereVulns);
        qualysPluginConfiguration.setFailOnQidFound(this.failOnQidFound);
        qualysPluginConfiguration.setUseProxy(this.useProxy);
        qualysPluginConfiguration.setProxyServer(this.proxyServer);
        qualysPluginConfiguration.setProxyUsername(this.proxyUsername);
        qualysPluginConfiguration.setProxyPort(this.proxyPort);
        qualysPluginConfiguration.setFailOnSevereVulns(this.failOnSevereVulns);
        qualysPluginConfiguration.setFailOnQidFound(this.failOnQidFound);
        qualysPluginConfiguration.setIsSev1Vulns(this.isSev1Vulns);
        qualysPluginConfiguration.setIsSev2Vulns(this.isSev2Vulns);
        qualysPluginConfiguration.setIsSev3Vulns(this.isSev3Vulns);
        qualysPluginConfiguration.setIsSev4Vulns(this.isSev4Vulns);
        qualysPluginConfiguration.setIsSev5Vulns(this.isSev5Vulns);
        qualysPluginConfiguration.setSeverity1(this.severity1);
        qualysPluginConfiguration.setSeverity2(this.severity2);
        qualysPluginConfiguration.setSeverity3(this.severity3);
        qualysPluginConfiguration.setSeverity4(this.severity4);
        qualysPluginConfiguration.setSeverity5(this.severity5);
        qualysPluginConfiguration.setFailOnQidFound(this.failOnQidFound);
        qualysPluginConfiguration.setQidList(this.qidList);
        qualysPluginConfiguration.setIsPotentialVulnsToBeChecked(this.isPotentialVulnsToBeChecked);
        qualysPluginConfiguration.setWebhook(this.webhook);
        qualysPluginConfiguration.setFailOnCve(this.failOnCve);
        qualysPluginConfiguration.setCveList(this.cveList);
        qualysPluginConfiguration.setFailOnSoftware(this.failOnSoftware);
        qualysPluginConfiguration.setSoftwareList(this.softwareList);
        qualysPluginConfiguration.setFailOnCvss(this.failOnCvss);
        qualysPluginConfiguration.setCvssThreshold(this.cvssThreshold);
        qualysPluginConfiguration.setCvssVersion(this.cvssVersion);
        qualysPluginConfiguration.setDockerUrl(this.dockerUrl);
        qualysPluginConfiguration.setDockerCert(this.dockerCert);
        qualysPluginConfiguration.setAddExclusion(this.addExclusion);
        qualysPluginConfiguration.setExcludeOptions(this.excludeOptions);
        qualysPluginConfiguration.setExcludeByCve(this.excludeByCve);
        qualysPluginConfiguration.setExcludeByQid(this.excludeByQid);
        Gson gson = new Gson();
        String jsonString = gson.toJson(qualysPluginConfiguration);
        bandanaManager.setValue((com.atlassian.bandana.BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "QualysPluginGlobalConfig", (Object)jsonString);
        return "success";
    }

    public static class BandanaContext
    extends PlanAwareBandanaContext {
        private static final long serialVersionUID = 1L;

        public BandanaContext(@Nullable BambooBandanaContext parentContext, long chainId, long planId, @Nullable String pluginKey) {
            super(parentContext, chainId, planId, pluginKey);
        }
    }
}

