/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.qualys.bamboo.plugin.containerSecurity.util.BambooFileStorageHelper;
import java.io.File;
import java.util.Map;
import java.util.logging.Logger;

public class QualysCSReportCondition
implements Condition {
    public static final String KEY_BUILD_NUMBER = "buildNumber";
    public static final String KEY_PLAN_KEY = "planKey";
    private static final Logger logger = Logger.getLogger(QualysCSReportCondition.class.getName());

    public boolean shouldDisplay(Map<String, Object> buildContextMap) {
        String filename = null;
        String planKey = "";
        int buildNumber = -1;
        try {
            if (buildContextMap.containsKey(KEY_PLAN_KEY)) {
                planKey = buildContextMap.get(KEY_PLAN_KEY).toString();
            }
            if (buildContextMap.containsKey(KEY_BUILD_NUMBER)) {
                buildNumber = Integer.parseInt(buildContextMap.get(KEY_BUILD_NUMBER).toString());
            }
            PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)planKey, (int)buildNumber);
            BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
            ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(null);
            storageHelper.setResultKey(resultKey);
            storageHelper.setArtifactDefinition(artifact);
            storageHelper.setResultKey(resultKey);
            File workingDirectory = storageHelper.buildArtifactRootDirectory();
            filename = workingDirectory.getAbsolutePath() + File.separator + "qualys_images_summary.json";
            File f = new File(filename);
            if (f.exists()) {
                return true;
            }
            logger.info("Error: Artifact file name: " + filename + " Not Found");
            return false;
        }
        catch (Throwable t) {
            logger.info("Error: Artifact file name: " + filename + " Not Found");
            return false;
        }
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }
}

