/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.scalasbt.ipcsocket.Handle;
import org.scalasbt.ipcsocket.JNAWin32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.JNIWin32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.Win32NamedPipeLibraryProvider;

public class Win32NamedPipeSocket
extends Socket {
    static final boolean DEFAULT_REQUIRE_STRICT_LENGTH = false;
    private final Handle handle;
    private final CloseCallback closeCallback;
    private final boolean requireStrictLength;
    private final InputStream is;
    private final OutputStream os;
    private final Handle readerWaitable;
    private final Handle writerWaitable;
    private final Win32NamedPipeLibraryProvider provider;

    private static Handle createFile(String string, boolean bl) throws IOException {
        Win32NamedPipeLibraryProvider win32NamedPipeLibraryProvider = Win32NamedPipeLibraryProvider.get(bl);
        return win32NamedPipeLibraryProvider.CreateFile(string);
    }

    private static CloseCallback emptyCallback() {
        return new CloseCallback(){

            @Override
            public void onNamedPipeSocketClose(Handle handle) throws IOException {
            }
        };
    }

    public Win32NamedPipeSocket(Handle handle, CloseCallback closeCallback, boolean bl) throws IOException {
        this(handle, closeCallback, bl, false);
    }

    public Win32NamedPipeSocket(Handle handle, CloseCallback closeCallback, boolean bl, boolean bl2) throws IOException {
        this.provider = bl2 ? JNIWin32NamedPipeLibraryProvider.instance() : JNAWin32NamedPipeLibraryProvider.instance();
        this.handle = handle;
        this.closeCallback = closeCallback;
        this.requireStrictLength = bl;
        this.readerWaitable = this.provider.CreateEvent(true, false, null);
        this.writerWaitable = this.provider.CreateEvent(true, false, null);
        this.is = new Win32NamedPipeSocketInputStream(handle);
        this.os = new Win32NamedPipeSocketOutputStream(handle);
    }

    Win32NamedPipeSocket(Handle handle, CloseCallback closeCallback) throws IOException {
        this(handle, closeCallback, false, false);
    }

    public Win32NamedPipeSocket(String string) throws IOException {
        this(Win32NamedPipeSocket.createFile(string, false), Win32NamedPipeSocket.emptyCallback(), false, false);
    }

    public Win32NamedPipeSocket(String string, boolean bl) throws IOException {
        this(Win32NamedPipeSocket.createFile(string, bl), Win32NamedPipeSocket.emptyCallback(), false, bl);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void close() throws IOException {
        this.closeCallback.onNamedPipeSocketClose(this.handle);
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    private class Win32NamedPipeSocketOutputStream
    extends OutputStream {
        private final Handle handle;

        Win32NamedPipeSocketOutputStream(Handle handle) {
            this.handle = handle;
        }

        @Override
        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)(0xFF & n)});
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Win32NamedPipeSocket.this.provider.write(Win32NamedPipeSocket.this.writerWaitable, this.handle, byArray, n, n2);
        }
    }

    private class Win32NamedPipeSocketInputStream
    extends InputStream {
        private final Handle handle;

        Win32NamedPipeSocketInputStream(Handle handle) {
            this.handle = handle;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray) == 0 ? -1 : 0xFF & byArray[0];
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return Win32NamedPipeSocket.this.provider.read(Win32NamedPipeSocket.this.readerWaitable, this.handle, byArray, n, n2, Win32NamedPipeSocket.this.requireStrictLength);
        }
    }

    static interface CloseCallback {
        public void onNamedPipeSocketClose(Handle var1) throws IOException;
    }
}

