/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.scalasbt.ipcsocket.Handle;
import org.scalasbt.ipcsocket.Overlapped;
import org.scalasbt.ipcsocket.Win32NamedPipeLibrary;
import org.scalasbt.ipcsocket.Win32NamedPipeLibraryProvider;
import org.scalasbt.ipcsocket.Win32SecurityLibrary;

class JNAWin32NamedPipeLibraryProvider
implements Win32NamedPipeLibraryProvider {
    static final Win32NamedPipeLibrary delegate = Win32NamedPipeLibrary.INSTANCE;
    static final Win32NamedPipeLibraryProvider instance = new JNAWin32NamedPipeLibraryProvider();

    static Win32NamedPipeLibraryProvider instance() {
        return instance;
    }

    private JNAWin32NamedPipeLibraryProvider() {
    }

    @Override
    public Handle CreateNamedPipe(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = Win32SecurityLibrary.createSecurityWithDacl(n7, n8);
        return JNAHandle.make(delegate.CreateNamedPipe(string, n, n2, n3, n4, n5, n6, sECURITY_ATTRIBUTES));
    }

    @Override
    public Handle CreateFile(String string) throws IOException {
        WinNT.HANDLE hANDLE = delegate.CreateFile(string, -1073741824, 0, null, 3, 0x40000000, null);
        if (hANDLE == Win32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
            throw new IOException("Couldn't open pipe for " + string + " (" + this.GetLastError() + ")");
        }
        return JNAHandle.make(hANDLE);
    }

    @Override
    public int ConnectNamedPipe(Handle handle, Overlapped overlapped) {
        WinBase.OVERLAPPED oVERLAPPED;
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        if (delegate.ConnectNamedPipe(hANDLE, (oVERLAPPED = this.getOverlap(overlapped)).getPointer())) {
            return -1;
        }
        return this.GetLastError();
    }

    @Override
    public boolean DisconnectNamedPipe(Handle handle) {
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        return delegate.DisconnectNamedPipe(hANDLE);
    }

    @Override
    public int read(Handle handle, Handle handle2, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3;
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        WinNT.HANDLE hANDLE2 = this.getHandle(handle2);
        Memory memory = new Memory(n2);
        WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
        oVERLAPPED.hEvent = hANDLE;
        oVERLAPPED.write();
        boolean bl2 = delegate.ReadFile(hANDLE2, memory, n2, null, oVERLAPPED.getPointer());
        if (!bl2 && (n3 = delegate.GetLastError()) != 997) {
            throw new IOException("ReadFile() failed: " + n3);
        }
        IntByReference intByReference = new IntByReference();
        if (!delegate.GetOverlappedResult(hANDLE2, oVERLAPPED.getPointer(), intByReference, true)) {
            int n4 = delegate.GetLastError();
            throw new IOException("GetOverlappedResult() failed for read operation: " + n4);
        }
        int n5 = intByReference.getValue();
        if (bl && n5 != n2) {
            throw new IOException("ReadFile() read less bytes than requested: expected " + n2 + " bytes, but read " + n5 + " bytes");
        }
        byte[] byArray2 = memory.getByteArray(0L, n5);
        System.arraycopy(byArray2, 0, byArray, n, n5);
        return n5;
    }

    @Override
    public void write(Handle handle, Handle handle2, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        WinNT.HANDLE hANDLE2 = this.getHandle(handle2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
        oVERLAPPED.hEvent = hANDLE;
        oVERLAPPED.write();
        boolean bl = delegate.WriteFile(hANDLE2, byteBuffer, n2, null, oVERLAPPED.getPointer());
        if (!bl && (n3 = delegate.GetLastError()) != 997) {
            throw new IOException("WriteFile() failed: " + n3);
        }
        IntByReference intByReference = new IntByReference();
        if (!delegate.GetOverlappedResult(hANDLE2, oVERLAPPED.getPointer(), intByReference, true)) {
            int n4 = delegate.GetLastError();
            throw new IOException("GetOverlappedResult() failed for write operation: " + n4);
        }
        if (intByReference.getValue() != n2) {
            throw new IOException("WriteFile() wrote less bytes than requested");
        }
    }

    @Override
    public boolean CloseHandle(Handle handle) {
        return delegate.CloseHandle(this.getHandle(handle));
    }

    @Override
    public boolean GetOverlappedResult(Handle handle, Overlapped overlapped) {
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        WinBase.OVERLAPPED oVERLAPPED = this.getOverlap(overlapped);
        return delegate.GetOverlappedResult(hANDLE, oVERLAPPED.getPointer(), new IntByReference(), true);
    }

    @Override
    public boolean CancelIoEx(Handle handle) {
        return delegate.CancelIoEx(this.getHandle(handle), null);
    }

    @Override
    public Handle CreateEvent(boolean bl, boolean bl2, String string) throws IOException {
        return JNAHandle.make(delegate.CreateEvent(null, bl, bl2, string));
    }

    @Override
    public int GetLastError() {
        return delegate.GetLastError();
    }

    @Override
    public Overlapped NewOverlapped(Handle handle) {
        WinNT.HANDLE hANDLE = this.getHandle(handle);
        WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
        oVERLAPPED.hEvent = hANDLE;
        oVERLAPPED.write();
        return new JNAOverlapped(oVERLAPPED);
    }

    @Override
    public void DeleteOverlapped(Overlapped overlapped) {
    }

    @Override
    public boolean FlushFileBuffers(Handle handle) {
        return delegate.FlushFileBuffers(this.getHandle(handle));
    }

    @Override
    public int ERROR_IO_PENDING() {
        return 997;
    }

    @Override
    public int ERROR_NO_DATA() {
        return 232;
    }

    @Override
    public int ERROR_PIPE_CONNECTED() {
        return 535;
    }

    @Override
    public int FILE_ALL_ACCESS() {
        return 0x1F01FF;
    }

    @Override
    public int FILE_FLAG_FIRST_PIPE_INSTANCE() {
        return 524288;
    }

    @Override
    public int FILE_FLAG_OVERLAPPED() {
        return 0x40000000;
    }

    @Override
    public int FILE_GENERIC_READ() {
        return 1179785;
    }

    @Override
    public int GENERIC_READ() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int GENERIC_WRITE() {
        return 0x40000000;
    }

    @Override
    public int PIPE_ACCESS_DUPLEX() {
        return 3;
    }

    private WinNT.HANDLE getHandle(Handle handle) {
        if (handle instanceof JNAHandle) {
            return ((JNAHandle)handle).handle;
        }
        throw new IllegalStateException("Incompatible handle " + handle + " of type: " + handle.getClass());
    }

    private WinBase.OVERLAPPED getOverlap(Overlapped overlapped) {
        if (overlapped instanceof JNAOverlapped) {
            return ((JNAOverlapped)overlapped).overlapped;
        }
        throw new IllegalStateException("Incompatible overlapped of type: " + overlapped.getClass());
    }

    private static class JNAOverlapped
    implements Overlapped {
        final WinBase.OVERLAPPED overlapped;

        JNAOverlapped(WinBase.OVERLAPPED oVERLAPPED) {
            this.overlapped = oVERLAPPED;
        }
    }

    private static class JNAHandle
    implements Handle {
        final WinNT.HANDLE handle;

        private JNAHandle(WinNT.HANDLE hANDLE) {
            this.handle = hANDLE;
        }

        static Handle make(WinNT.HANDLE hANDLE) throws IOException {
            if (hANDLE == Win32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
                throw new IOException("Invalid handle");
            }
            return new JNAHandle(hANDLE);
        }
    }
}

