/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import com.sun.jna.LastErrorException;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.scalasbt.ipcsocket.NativeErrorException;
import org.scalasbt.ipcsocket.UnixDomainSocketLibrary;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;

class JNAUnixDomainSocketLibraryProvider
implements UnixDomainSocketLibraryProvider {
    private static final JNAUnixDomainSocketLibraryProvider instance = new JNAUnixDomainSocketLibraryProvider();

    JNAUnixDomainSocketLibraryProvider() {
    }

    static final JNAUnixDomainSocketLibraryProvider instance() {
        return instance;
    }

    @Override
    public int socket(int n, int n2, int n3) throws NativeErrorException {
        try {
            return UnixDomainSocketLibrary.socket(n, n2, n3);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int bind(int n, byte[] byArray, int n2) throws NativeErrorException {
        try {
            UnixDomainSocketLibrary.SockaddrUn sockaddrUn = new UnixDomainSocketLibrary.SockaddrUn(new String(byArray));
            return UnixDomainSocketLibrary.bind(n, sockaddrUn, sockaddrUn.size());
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
        catch (IOException iOException) {
            throw new NativeErrorException(0, iOException.getMessage());
        }
    }

    @Override
    public int listen(int n, int n2) throws NativeErrorException {
        try {
            UnixDomainSocketLibrary.SockaddrUn sockaddrUn = new UnixDomainSocketLibrary.SockaddrUn();
            return UnixDomainSocketLibrary.listen(n, n2);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int accept(int n) throws NativeErrorException {
        try {
            UnixDomainSocketLibrary.SockaddrUn sockaddrUn = new UnixDomainSocketLibrary.SockaddrUn();
            IntByReference intByReference = new IntByReference();
            intByReference.setValue(sockaddrUn.size());
            return UnixDomainSocketLibrary.accept(n, sockaddrUn, intByReference);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int connect(int n, byte[] byArray, int n2) throws NativeErrorException {
        try {
            UnixDomainSocketLibrary.SockaddrUn sockaddrUn = new UnixDomainSocketLibrary.SockaddrUn(new String(byArray));
            return UnixDomainSocketLibrary.connect(n, sockaddrUn, sockaddrUn.size());
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
        catch (IOException iOException) {
            throw new NativeErrorException(-1, iOException.getMessage());
        }
    }

    @Override
    public int read(int n, byte[] byArray, int n2, int n3) throws NativeErrorException {
        try {
            if (n2 > byArray.length - 1) {
                String string = "offset: " + n2 + " greater than buffer size " + byArray.length;
                throw new IllegalArgumentException(string);
            }
            if (n2 + n3 > byArray.length) {
                String string = "Tried to read more bytes " + n3 + " than available from position " + n2 + " in buffer of size " + byArray.length;
                throw new IllegalArgumentException(string);
            }
            return UnixDomainSocketLibrary.read(n, ByteBuffer.wrap(byArray, n2, n3), n3);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int write(int n, byte[] byArray, int n2, int n3) throws NativeErrorException {
        try {
            return UnixDomainSocketLibrary.write(n, ByteBuffer.wrap(byArray, n2, n3), n3);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int close(int n) throws NativeErrorException {
        try {
            return UnixDomainSocketLibrary.close(n);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int shutdown(int n, int n2) throws NativeErrorException {
        try {
            return UnixDomainSocketLibrary.shutdown(n, n2);
        }
        catch (LastErrorException lastErrorException) {
            throw new NativeErrorException(lastErrorException.getErrorCode(), lastErrorException.getMessage());
        }
    }

    @Override
    public int maxSocketLength() {
        return new UnixDomainSocketLibrary.SockaddrUn().sunPath.length;
    }
}

