/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.common.QualysCriteria;

import com.qualys.plugins.common.QualysCriteria.CvssCriteria;
import com.qualys.plugins.common.QualysCriteria.InvalidCriteriaException;
import com.qualys.plugins.common.QualysCriteria.SoftwareCriteria;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.GsonBuilder;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonNull;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.JsonParser;

public class QualysCriteria {
    ArrayList<Integer> qidList;
    ArrayList<String> cveList;
    SoftwareCriteria softwareCriteria;
    CvssCriteria cvssCriteria;
    HashMap<Integer, Integer> severityMap;
    boolean checkPotentialVulns;
    boolean sevStaus = true;
    ArrayList<Integer> qidExcludeList = new ArrayList(0);
    ArrayList<String> cveExcludeList = new ArrayList(0);
    String excludeBy = "";
    ArrayList<Integer> qidExcludeFound = new ArrayList(0);
    ArrayList<String> cveExcludeFound = new ArrayList(0);
    boolean finalImageStatus = true;
    ArrayList<String> failedReasons = new ArrayList(0);
    Gson gsonObject = new Gson();
    public JsonObject returnObject;
    ArrayList<String> configuredQids;
    ArrayList<Integer> qidsFound = new ArrayList(0);
    ArrayList<String> cvesFound = new ArrayList(0);

    public QualysCriteria(String criteriaJson) throws InvalidCriteriaException {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonTree = jsonParser.parse(criteriaJson);
        if (!jsonTree.isJsonObject()) {
            throw new InvalidCriteriaException();
        }
        this.setDefaultValues();
        JsonObject jsonObject = jsonTree.getAsJsonObject();
        if (jsonObject.has("failConditions")) {
            int i;
            int end;
            int start;
            JsonObject failConditions = jsonObject.getAsJsonObject("failConditions");
            if (failConditions.has("qids") && !failConditions.get("qids").isJsonNull()) {
                JsonArray qids = failConditions.getAsJsonArray("qids");
                for (JsonElement qid : qids) {
                    String qidString = qid.getAsString();
                    this.configuredQids.add(qidString);
                    if (qidString.contains("-")) {
                        String[] qidElements = qidString.split("-");
                        start = Integer.parseInt(qidElements[0]);
                        end = Integer.parseInt(qidElements[1]);
                        for (i = start; i <= end; ++i) {
                            this.qidList.add(i);
                        }
                        continue;
                    }
                    this.qidList.add(Integer.parseInt(qidString));
                }
            } else {
                System.out.println("'qids' not found in given JSON.");
            }
            if (failConditions.has("cves") && !failConditions.get("cves").isJsonNull()) {
                JsonArray cves = failConditions.getAsJsonArray("cves");
                for (JsonElement cve : cves) {
                    this.cveList.add(cve.getAsString());
                }
            } else {
                System.out.println("'cves' not found in given JSON.");
            }
            if (failConditions.has("severities") && !failConditions.get("severities").isJsonNull()) {
                JsonObject severities = failConditions.getAsJsonObject("severities");
                this.severityMap.put(1, severities.get("1") != null && !severities.get("1").isJsonNull() ? severities.get("1").getAsInt() : -1);
                this.severityMap.put(2, severities.get("2") != null && !severities.get("2").isJsonNull() ? severities.get("2").getAsInt() : -1);
                this.severityMap.put(3, severities.get("3") != null && !severities.get("3").isJsonNull() ? severities.get("3").getAsInt() : -1);
                this.severityMap.put(4, severities.get("4") != null && !severities.get("4").isJsonNull() ? severities.get("4").getAsInt() : -1);
                this.severityMap.put(5, severities.get("5") != null && !severities.get("5").isJsonNull() ? severities.get("5").getAsInt() : -1);
            } else {
                this.severityMap.clear();
                this.severityMap.put(1, -1);
                this.severityMap.put(2, -1);
                this.severityMap.put(3, -1);
                this.severityMap.put(4, -1);
                this.severityMap.put(5, -1);
                System.out.println("'severities' not found in given JSON.");
            }
            if (failConditions.has("software") && !failConditions.get("software").isJsonNull()) {
                JsonArray softwareArray = failConditions.getAsJsonArray("software");
                this.softwareCriteria = new SoftwareCriteria(softwareArray);
            } else {
                System.out.println("'software' key not found in given JSON.");
            }
            if (failConditions.has("checkPotentialVulns")) {
                this.checkPotentialVulns = failConditions.get("checkPotentialVulns").getAsBoolean();
            } else {
                System.out.println("'checkPotentialVulns' not found in given JSON.");
                this.checkPotentialVulns = false;
            }
            if (failConditions.has("cvss") && !failConditions.get("cvss").isJsonNull()) {
                JsonObject cvssObject = failConditions.getAsJsonObject("cvss");
                this.cvssCriteria = new CvssCriteria(cvssObject, this.checkPotentialVulns);
            } else {
                System.out.println("'cvss' key not found in given JSON.");
            }
            if (failConditions.has("excludeBy") && !failConditions.get("excludeBy").isJsonNull()) {
                if (failConditions.get("excludeBy").getAsString().equals("cve") && failConditions.has("excludeCVEs") && !failConditions.get("excludeCVEs").isJsonNull()) {
                    this.excludeBy = "cve";
                    JsonArray excludeCVEsList = failConditions.getAsJsonArray("excludeCVEs");
                    for (JsonElement excludeCVEElement : excludeCVEsList) {
                        String excludeCVEString = excludeCVEElement.getAsString();
                        this.cveExcludeList.add(excludeCVEString);
                    }
                }
                if (failConditions.get("excludeBy").getAsString().equals("qid") && failConditions.has("excludeQids") && !failConditions.get("excludeQids").isJsonNull()) {
                    this.excludeBy = "qid";
                    JsonArray excludeQidsList = failConditions.getAsJsonArray("excludeQids");
                    for (JsonElement excludeQidElement : excludeQidsList) {
                        String excludeQidString = excludeQidElement.getAsString();
                        if (excludeQidString.contains("-")) {
                            String[] excludeQids = excludeQidString.split("-");
                            start = Integer.parseInt(excludeQids[0]);
                            end = Integer.parseInt(excludeQids[1]);
                            for (i = start; i <= end; ++i) {
                                this.qidExcludeList.add(i);
                            }
                            continue;
                        }
                        this.qidExcludeList.add(Integer.parseInt(excludeQidString));
                    }
                }
            }
        } else {
            System.out.println("'failConditions' not found in given JSON.");
        }
    }

    private void setDefaultValues() {
        this.qidList = new ArrayList(0);
        this.cveList = new ArrayList(0);
        this.configuredQids = new ArrayList(0);
        this.severityMap = new HashMap();
        this.checkPotentialVulns = false;
        this.returnObject = new JsonObject();
        this.returnObject.add("imageId", null);
        this.returnObject.add("imageSummary", null);
        this.returnObject.add("qids", null);
        this.returnObject.add("cveIds", null);
        this.returnObject.add("severities", null);
        this.returnObject.add("potentialVulnsBySev", null);
        this.returnObject.add("patchability", null);
        this.returnObject.add("vulnsTable", null);
        this.returnObject.add("softwaresTable", null);
        this.returnObject.add("layersTable", null);
        this.returnObject.add("qidExcludeFound", null);
        this.returnObject.add("cveExcludeFound", null);
    }

    private JsonArray excludeVulns(JsonArray vulns) {
        JsonArray vulnsAfterExclusion = new JsonArray();
        for (JsonElement vuln : vulns) {
            JsonObject vulnObject = vuln.getAsJsonObject();
            if (this.excludeBy.equals("qid")) {
                int qid = vulnObject.get("qid").getAsInt();
                if (this.qidExcludeList.contains(qid)) continue;
                vulnsAfterExclusion.add(vuln);
                continue;
            }
            if (!this.excludeBy.equals("cve")) continue;
            JsonArray cveIds = new JsonArray();
            if (vulnObject.has("cveids") && !vulnObject.get("cveids").isJsonNull()) {
                cveIds = vulnObject.getAsJsonArray("cveids");
            }
            if (cveIds.size() == 0) {
                vulnsAfterExclusion.add(vuln);
                continue;
            }
            int countOfCvesInExcludeList = 0;
            for (JsonElement cve : cveIds) {
                String cveString = cve.getAsString();
                if (!this.cveExcludeList.contains(cveString)) continue;
                ++countOfCvesInExcludeList;
            }
            if (countOfCvesInExcludeList >= cveIds.size()) continue;
            vulnsAfterExclusion.add(vuln);
        }
        return vulnsAfterExclusion;
    }

    public Boolean evaluate(JsonObject response) {
        JsonObject softwareResult;
        Boolean finalImageStatus = true;
        Boolean sevStatus = true;
        Boolean qidStatus = true;
        Boolean cveStatus = true;
        Boolean softStatus = true;
        Boolean cvssStatus = true;
        if (response.has("vulnerabilities") && !response.get("vulnerabilities").isJsonNull()) {
            JsonArray vulns = response.getAsJsonArray("vulnerabilities");
            this.returnObject.add("vulnsTable", vulns);
            sevStatus = this.evaluateSev(vulns);
            qidStatus = this.evaluateQids(vulns);
            cveStatus = this.evaluateCves(vulns);
            if (this.cvssCriteria != null) {
                JsonArray vulnsForEvaluation = vulns;
                if (!this.excludeBy.trim().equals("")) {
                    vulnsForEvaluation = this.excludeVulns(vulns);
                }
                JsonObject cvssResult = this.cvssCriteria.evaluate(vulnsForEvaluation);
                this.returnObject.add("cvss", cvssResult);
                cvssStatus = cvssResult.get("result").getAsBoolean();
            } else {
                JsonObject cvssResult = new JsonObject();
                cvssResult.add("configured", JsonNull.INSTANCE);
                cvssResult.add("found", JsonNull.INSTANCE);
                cvssResult.addProperty("result", true);
                this.returnObject.add("cvss", cvssResult);
            }
            JsonObject qidsJsonObject = this.returnObject.getAsJsonObject("qids");
            if (!this.qidExcludeFound.isEmpty()) {
                this.qidExcludeFound = (ArrayList)this.qidExcludeFound.stream().distinct().collect(Collectors.toList());
                String qidExcludeFoundString = this.qidExcludeFound.toString().replace("[", "").replace("]", "");
                qidsJsonObject.addProperty("excluded", qidExcludeFoundString);
            } else {
                qidsJsonObject.add("excluded", null);
            }
            JsonObject cveJsonObject = this.returnObject.getAsJsonObject("cveIds");
            if (!this.cveExcludeFound.isEmpty()) {
                this.cveExcludeFound = (ArrayList)this.cveExcludeFound.stream().distinct().collect(Collectors.toList());
                String cveExcludeFoundString = this.cveExcludeFound.toString().replace("[", "").replace("]", "");
                cveJsonObject.addProperty("excluded", cveExcludeFoundString);
            } else {
                cveJsonObject.add("excluded", null);
            }
        }
        JsonArray softwareArray = new JsonArray();
        if (response.has("softwares") && !response.get("softwares").isJsonNull()) {
            softwareArray = response.getAsJsonArray("softwares");
        }
        if (this.softwareCriteria != null) {
            softwareResult = this.softwareCriteria.evaluate(softwareArray);
            this.returnObject.add("software", softwareResult);
            softStatus = softwareResult.get("result").getAsBoolean();
        } else {
            softwareResult = new JsonObject();
            softwareResult.add("configured", JsonNull.INSTANCE);
            softwareResult.add("found", JsonNull.INSTANCE);
            softwareResult.addProperty("result", true);
            this.returnObject.add("software", softwareResult);
        }
        if (response.has("softwares") && !response.get("softwares").isJsonNull()) {
            this.returnObject.add("softwaresTable", response.getAsJsonArray("softwares"));
        }
        if (response.has("layers") && !response.get("layers").isJsonNull()) {
            this.returnObject.add("layersTable", response.getAsJsonArray("layers"));
        }
        JsonArray tagsArray = null;
        if (response.has("repo") && !response.get("repo").isJsonNull()) {
            tagsArray = this.getTags(response.getAsJsonArray("repo"));
        }
        if (!(sevStatus.booleanValue() && qidStatus.booleanValue() && cveStatus.booleanValue() && softStatus.booleanValue() && cvssStatus.booleanValue())) {
            finalImageStatus = false;
        }
        JsonObject imageSummary = new JsonObject();
        imageSummary.addProperty("pass", finalImageStatus);
        imageSummary.add("Tags", tagsArray);
        imageSummary.add("size", response.get("size"));
        imageSummary.add("uuid", response.get("uuid"));
        imageSummary.add("sha", response.get("sha"));
        imageSummary.add("repo", response.get("repo"));
        imageSummary.add("operatingSystem", response.get("operatingSystem"));
        imageSummary.add("layersCount", response.get("layersCount"));
        imageSummary.add("dockerVersion", response.get("dockerVersion"));
        imageSummary.add("architecture", response.get("architecture"));
        this.returnObject.add("imageSummary", imageSummary);
        if (response.has("imageId") && !response.get("imageId").isJsonNull()) {
            this.returnObject.add("imageId", response.get("imageId"));
        }
        return finalImageStatus;
    }

    private void addSeverities(HashMap<Integer, Integer> counts) {
        HashMap<Integer, JsonObject> severityResult = new HashMap<Integer, JsonObject>();
        for (int i = 5; i >= 1; --i) {
            boolean result = true;
            if (this.severityMap.get(i) != -1 && counts.get(i) > this.severityMap.get(i)) {
                result = false;
                if (this.sevStaus) {
                    this.sevStaus = false;
                }
            }
            JsonObject sevJson = new JsonObject();
            if (this.severityMap.get(i) > -1) {
                sevJson.addProperty("configured", (int)this.severityMap.get(i));
            } else {
                sevJson.add("configured", null);
            }
            if (counts.get(i) > 0) {
                sevJson.addProperty("found", counts.get(i));
            } else if (this.severityMap.get(i) > -1) {
                sevJson.addProperty("found", 0);
            } else {
                sevJson.add("found", null);
            }
            sevJson.addProperty("result", result);
            severityResult.put(i, sevJson);
        }
        GsonBuilder builder = new GsonBuilder();
        this.gsonObject = builder.serializeNulls().create();
        String sevVulnsJson = this.gsonObject.toJson(severityResult);
        JsonElement sevVulnsElement = this.gsonObject.fromJson(sevVulnsJson, JsonElement.class);
        this.returnObject.add("severities", sevVulnsElement);
    }

    private JsonArray getTags(JsonArray repoArray) {
        JsonArray tagsArray = new JsonArray();
        for (JsonElement repoDetails : repoArray) {
            JsonObject repoObject = repoDetails.getAsJsonObject();
            if (!repoObject.has("tag")) continue;
            tagsArray.add(repoObject.get("tag"));
        }
        return tagsArray;
    }

    public String getMyNumbersAsString(ArrayList<Integer> arrayList) {
        if (arrayList.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            int myNumbersInt = arrayList.get(i);
            str.append(myNumbersInt + ",");
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    public JsonObject getResult() {
        return this.returnObject;
    }

    public Boolean evaluateSev(JsonArray vulns) {
        HashMap<Integer, Integer> evaluationSev = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> confirmVulnsCount = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> potentialVulnsCount = new HashMap<Integer, Integer>();
        int patchable = 0;
        int unpatchable = 0;
        int totalVulnerabilities = 0;
        int totalConfVuln = 0;
        int totalPotlVuln = 0;
        for (int count = 1; count <= 5; ++count) {
            evaluationSev.put(count, 0);
            confirmVulnsCount.put(count, 0);
            potentialVulnsCount.put(count, 0);
        }
        boolean sevStatus = true;
        for (JsonElement vuln : vulns) {
            int sevCount;
            JsonObject vulnObject = vuln.getAsJsonObject();
            String typeDetected = "";
            int severity = 0;
            if (vulnObject.has("typeDetected")) {
                typeDetected = vulnObject.get("typeDetected").getAsString();
            }
            if (vulnObject.has("severity")) {
                severity = vulnObject.get("severity").getAsInt();
            }
            ++totalVulnerabilities;
            if (typeDetected.equals("POTENTIAL")) {
                sevCount = (Integer)potentialVulnsCount.get(severity) + 1;
                potentialVulnsCount.put(severity, sevCount);
                ++totalPotlVuln;
            } else if (typeDetected.equals("CONFIRMED")) {
                sevCount = (Integer)confirmVulnsCount.get(severity) + 1;
                confirmVulnsCount.put(severity, sevCount);
                ++totalConfVuln;
            }
            if (vulnObject.has("patchAvailable") && !vulnObject.get("patchAvailable").isJsonNull()) {
                boolean patchAvailable = vulnObject.get("patchAvailable").getAsBoolean();
                if (patchAvailable) {
                    ++patchable;
                } else {
                    ++unpatchable;
                }
            } else {
                ++unpatchable;
            }
            if (typeDetected.equals("POTENTIAL") && !this.checkPotentialVulns) continue;
            int evaluationSevCount = evaluationSev.getOrDefault(severity, 0);
            if (this.excludeBy == "qid") {
                Integer qid = 0;
                if (vulnObject.has("qid")) {
                    qid = vulnObject.get("qid").getAsInt();
                }
                if (this.qidExcludeList.contains(qid)) {
                    this.qidExcludeFound.add(qid);
                } else {
                    evaluationSev.put(severity, ++evaluationSevCount);
                }
            } else if (this.excludeBy == "cve") {
                JsonArray cves = null;
                if (vulnObject.has("cveids")) {
                    cves = vulnObject.get("cveids").getAsJsonArray();
                }
                int tempCount = 0;
                if (cves != null && cves.size() > 0) {
                    for (JsonElement cve : cves) {
                        String cveString = cve.getAsString();
                        if (this.cveExcludeList.contains(cveString)) {
                            this.cveExcludeFound.add(cveString);
                            continue;
                        }
                        ++tempCount;
                    }
                } else {
                    ++tempCount;
                }
                if (tempCount > 0) {
                    evaluationSev.put(severity, ++evaluationSevCount);
                }
            } else {
                evaluationSev.put(severity, ++evaluationSevCount);
            }
            if (this.severityMap.isEmpty() || this.severityMap.get(severity) == -1 || evaluationSev.get(severity) <= this.severityMap.get(severity)) continue;
            sevStatus = false;
            this.failedReasons.add("Failing this image because found severity" + severity + " has more than configured after exclusion");
        }
        this.addSeverities(evaluationSev);
        String confirmVulnsJson = this.gsonObject.toJson(confirmVulnsCount);
        JsonElement confirmVulnsElement = this.gsonObject.fromJson(confirmVulnsJson, JsonElement.class);
        String potentialVulnsJson = this.gsonObject.toJson(potentialVulnsCount);
        JsonElement potentialVulnsElement = this.gsonObject.fromJson(potentialVulnsJson, JsonElement.class);
        this.returnObject.add("confirmedVulnsBySev", confirmVulnsElement);
        this.returnObject.add("potentialVulnsBySev", potentialVulnsElement);
        JsonObject patchability = new JsonObject();
        patchability.addProperty("yes", patchable);
        patchability.addProperty("no", unpatchable);
        this.returnObject.add("patchability", patchability);
        this.returnObject.addProperty("totalVulnerabilities", totalVulnerabilities);
        this.returnObject.addProperty("potentialVulnsChecked", this.checkPotentialVulns);
        JsonObject typeDetected = new JsonObject();
        typeDetected.addProperty("Confirmed", totalConfVuln);
        typeDetected.addProperty("Potential", totalPotlVuln);
        this.returnObject.add("typeDetected", typeDetected);
        return sevStatus;
    }

    public Boolean evaluateQids(JsonArray vulns) {
        Boolean qidStatus = true;
        for (JsonElement vuln : vulns) {
            JsonObject vulnObject = vuln.getAsJsonObject();
            if (vulnObject.has("typeDetected") && vulnObject.get("typeDetected").getAsString().equals("POTENTIAL") && !this.checkPotentialVulns) continue;
            Integer qid = 0;
            if (vulnObject.has("qid")) {
                qid = vulnObject.get("qid").getAsInt();
            }
            if (this.qidList.contains(qid)) {
                this.qidsFound.add(qid);
            }
            if (this.excludeBy == "qid") {
                if (this.qidExcludeList.contains(qid)) {
                    this.qidExcludeFound.add(qid);
                    continue;
                }
                if (this.qidExcludeList.contains(qid) || !this.qidList.contains(qid)) continue;
                qidStatus = false;
                this.failedReasons.add("Failing this image because found qid - " + qid + " after exclusion");
                continue;
            }
            if (this.excludeBy != "cve") continue;
            JsonArray cves = null;
            if (vulnObject.has("cveids")) {
                cves = vulnObject.get("cveids").getAsJsonArray();
            }
            if ((cves == null || cves.size() == 0) && this.qidsFound.contains(qid)) {
                qidStatus = false;
                this.failedReasons.add("Failing this image because found qid - " + qid + " after exclusion");
            }
            for (JsonElement cve : cves) {
                String cveString = cve.getAsString();
                if (this.cveExcludeList.contains(cveString)) {
                    this.cveExcludeFound.add(cveString);
                    continue;
                }
                if (this.cveExcludeList.contains(cveString) || !this.qidList.contains(qid)) continue;
                qidStatus = false;
                this.failedReasons.add("Failing this image because found CVE - " + cveString + " after exclusion");
            }
        }
        JsonObject qids = new JsonObject();
        if (this.configuredQids.size() > 0) {
            qids.addProperty("configured", String.join((CharSequence)",", this.configuredQids));
        } else {
            qids.add("configured", null);
        }
        String foundQidsString = this.getMyNumbersAsString(this.qidsFound);
        if (!foundQidsString.isEmpty()) {
            qids.addProperty("found", foundQidsString);
        } else {
            qids.add("found", null);
        }
        if (this.excludeBy.isEmpty() && this.qidsFound.size() > 0) {
            qidStatus = false;
            this.failedReasons.add("Failing this image because found qid(s) - " + this.qidsFound.toString());
        }
        qids.addProperty("result", qidStatus);
        this.returnObject.add("qids", qids);
        return qidStatus;
    }

    public Boolean evaluateCves(JsonArray vulns) {
        Boolean cveStatus = true;
        for (JsonElement vuln : vulns) {
            String cveString;
            JsonObject vulnObject = vuln.getAsJsonObject();
            if (vulnObject.has("typeDetected") && vulnObject.get("typeDetected").getAsString().equals("POTENTIAL") && !this.checkPotentialVulns) continue;
            boolean partialCvetatus = true;
            JsonArray cves = null;
            if (vulnObject.has("cveids")) {
                cves = vulnObject.get("cveids").getAsJsonArray();
            }
            for (JsonElement cve : cves) {
                cveString = cve.getAsString();
                if (!this.cveList.contains(cveString)) continue;
                partialCvetatus = false;
                if (this.cvesFound.contains(cveString)) continue;
                this.cvesFound.add(cveString);
            }
            if (this.excludeBy == "cve") {
                for (JsonElement cve : cves) {
                    cveString = cve.getAsString();
                    if (this.cveExcludeList.contains(cveString)) {
                        this.cveExcludeFound.add(cveString);
                        continue;
                    }
                    if (!this.cveList.contains(cveString) || this.cveExcludeList.contains(cveString)) continue;
                    cveStatus = false;
                    this.failedReasons.add("Failing this image because found CVE - " + cveString + " after exclusion");
                }
                continue;
            }
            if (this.excludeBy != "qid") continue;
            Integer qid = 0;
            if (vulnObject.has("qid")) {
                qid = vulnObject.get("qid").getAsInt();
            }
            if (this.qidExcludeList.contains(qid)) {
                this.qidExcludeFound.add(qid);
                continue;
            }
            if (partialCvetatus || this.qidExcludeList.contains(qid)) continue;
            cveStatus = false;
            this.failedReasons.add("Failing this image because found qid - " + qid + " after exclusion");
        }
        JsonObject cvesJson = new JsonObject();
        if (this.cveList.size() > 0) {
            cvesJson.addProperty("configured", String.join((CharSequence)",", this.cveList));
        } else {
            cvesJson.add("configured", null);
        }
        if (!String.join((CharSequence)",", this.cvesFound).isEmpty()) {
            cvesJson.addProperty("found", String.join((CharSequence)",", this.cvesFound));
        } else {
            cvesJson.add("found", null);
        }
        if (this.excludeBy.isEmpty() && this.cvesFound.size() > 0) {
            cveStatus = false;
            this.failedReasons.add("Failing this image because found CVE - " + this.cvesFound.toString() + " after exclusion");
        }
        cvesJson.addProperty("result", cveStatus);
        this.returnObject.add("cveIds", cvesJson);
        return cveStatus;
    }

    public ArrayList<String> getBuildFailedReasons() {
        return (ArrayList)this.failedReasons.stream().distinct().collect(Collectors.toList());
    }
}

