/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.common.QualysCriteria;

import java.util.HashMap;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.GsonBuilder;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.JsonParser;

public class CvssCriteria {
    String version;
    double configuredScore;
    int found;
    HashMap<String, Integer> foundMap;
    boolean checkPotentialVulns = false;

    public CvssCriteria(JsonObject cvssFilter) {
        this.processFilter(cvssFilter);
    }

    public CvssCriteria(JsonObject cvssFilter, boolean checkPotentialVulns) {
        this.checkPotentialVulns = checkPotentialVulns;
        this.processFilter(cvssFilter);
    }

    private void processFilter(JsonObject cvssFilter) {
        this.version = "";
        this.configuredScore = 0.0;
        this.found = 0;
        this.foundMap = new HashMap();
        this.version = cvssFilter.get("version").getAsString();
        if (this.version.equals("2")) {
            this.version = "";
        }
        this.configuredScore = cvssFilter.get("configured").getAsDouble();
    }

    public JsonObject evaluate(JsonArray vulns) {
        JsonObject cvssResult = new JsonObject();
        cvssResult.addProperty("configured", this.configuredScore);
        String cvssVersion = String.format("cvss%sInfo", this.version);
        this.found = 0;
        this.foundMap = new HashMap();
        for (JsonElement vuln : vulns) {
            Integer currentCount;
            JsonObject cvssObject;
            String baseScoreString;
            double baseScore;
            JsonObject vulnObject = vuln.getAsJsonObject();
            String typeDetected = "";
            if (vulnObject.has("typeDetected")) {
                typeDetected = vulnObject.get("typeDetected").getAsString();
            }
            if (typeDetected.equals("POTENTIAL") && !this.checkPotentialVulns || !vulnObject.has(cvssVersion) || vulnObject.get(cvssVersion).isJsonNull() || !((baseScore = Double.parseDouble(baseScoreString = (cvssObject = vulnObject.get(cvssVersion).getAsJsonObject()).get("baseScore").getAsString())) >= this.configuredScore)) continue;
            ++this.found;
            if (!this.foundMap.containsKey(baseScoreString)) {
                this.foundMap.put(baseScoreString, 0);
            }
            Integer n = currentCount = this.foundMap.get(baseScoreString);
            Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
            this.foundMap.put(baseScoreString, currentCount);
        }
        cvssResult.addProperty("found", this.found);
        cvssResult.addProperty("version", this.version);
        if (this.found > 0) {
            cvssResult.addProperty("result", false);
            Gson gson = new GsonBuilder().create();
            String foundMapJson = gson.toJson(this.foundMap);
            JsonParser parser = new JsonParser();
            JsonObject foundMapObject = parser.parse(foundMapJson).getAsJsonObject();
            cvssResult.add("foundMap", foundMapObject);
        } else {
            cvssResult.addProperty("result", true);
        }
        return cvssResult;
    }
}

