/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qualys.bamboo.plugin.containerSecurity.model.ProxyConfiguration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;

public class Webhook {
    private BuildLogger buildLogger;
    private final String url;
    private final String data;
    private final ProxyConfiguration proxy;
    private static final int timeout = 30;
    private static final int RETRIES = 1;
    private static final Logger logger = Logger.getLogger(Webhook.class.getName());

    public Webhook(String url, String data, BuildLogger logger, ProxyConfiguration proxy) {
        this.url = url;
        this.data = data;
        this.buildLogger = logger;
        this.proxy = proxy;
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        if (this.proxy.getUseProxy()) {
            client.getHostConfiguration().setProxy(this.proxy.getProxyServer(), this.proxy.getProxyPort());
            String username = this.proxy.getProxyUsername();
            String password = this.proxy.getProxyPassword();
            if (StringUtils.isNotBlank((String)username)) {
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        int tried = 0;
        boolean success = false;
        HttpClient client = this.getHttpClient();
        client.getParams().setConnectionManagerTimeout(30L);
        this.buildLogger.addBuildLogEntry("Sending scanned result data to webhook URL - " + this.url);
        logger.info("Sending scanned result data to webhook URL - " + this.url);
        do {
            StringRequestEntity requestEntity;
            ++tried;
            try {
                logger.info("Posted JSON: " + this.data);
                requestEntity = new StringRequestEntity(this.data, "application/json", StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                this.buildLogger.addBuildLogEntry("Unable to process POST request to Webhook URL. Reaason = " + e.getMessage());
                break;
            }
            PostMethod post = new PostMethod(this.url);
            try {
                post.setRequestEntity((RequestEntity)requestEntity);
                int responseCode = client.executeMethod((HttpMethod)post);
                if (responseCode != 200) {
                    String response = post.getResponseBodyAsString();
                    this.buildLogger.addErrorLogEntry("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                    logger.info("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                    logger.info("Message from webhook - " + response);
                    continue;
                }
                success = true;
            }
            catch (IOException e) {
                this.buildLogger.addBuildLogEntry("Failed to post data to webhook URL - " + this.url);
                logger.info("Failed to post data to webhook URL - " + this.url);
            }
            finally {
                post.releaseConnection();
            }
        } while (tried < 1 && !success);
        if (success) {
            this.buildLogger.addBuildLogEntry("Successfully posted data to webhook URL - " + this.url);
            logger.info("Successfully posted data to webhook URL - " + this.url);
        }
    }
}

