/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.containerSecurity;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qualys.bamboo.plugin.containerSecurity.QualysTaggingFailException;
import com.qualys.bamboo.plugin.containerSecurity.util.Helper;
import com.qualys.plugins.common.QualysAuth.QualysAuth;
import com.qualys.plugins.common.QualysClient.QualysCSClient;
import com.qualys.plugins.common.QualysClient.QualysCSResponse;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;

public class GetImageVulnsCallable
implements Callable<String> {
    private String buildDirPath;
    private String imageSha;
    private String imageId;
    private BuildLogger buildLogger;
    private long pollingIntervalForVulns;
    private long vulnsTimeout;
    private boolean isFailConditionsConfigured;
    private QualysAuth qualysAuth;
    private QualysCSClient qualysCsClient;
    private long taggingTime;
    public Set<String> reposArray;
    private static final Logger logger = Logger.getLogger(GetImageVulnsCallable.class.getName());

    public GetImageVulnsCallable(long taggingtime, String buildDirPath, String imageSha, QualysAuth qualysAuth, QualysCSClient qualysCsClient, BuildLogger listener, long pollingIntervalForVulns, long vulnsTimeout, boolean isFailConditionsConfigured) throws Exception {
        this.buildDirPath = buildDirPath;
        this.imageId = imageSha.substring(0, 12);
        this.imageSha = imageSha;
        this.qualysAuth = qualysAuth;
        this.buildLogger = listener;
        this.pollingIntervalForVulns = pollingIntervalForVulns;
        this.vulnsTimeout = vulnsTimeout;
        this.isFailConditionsConfigured = isFailConditionsConfigured;
        this.qualysCsClient = qualysCsClient;
        this.taggingTime = taggingtime;
    }

    @Override
    public String call() throws Exception {
        this.buildLogger.addBuildLogEntry("Thread for Image '" + this.imageId + "' - " + Thread.currentThread().getName() + " Started");
        return this.fetchScanResult();
    }

    public String fetchScanResult() throws Exception {
        if (this.qualysAuth == null || this.qualysAuth.getServer() == null || this.qualysAuth.getUsername() == null || this.qualysAuth.getPassword() == null) {
            this.buildLogger.addBuildLogEntry("Qualys server credentials not configured properly.. Aborting 'Get scan result' call.");
        }
        String scanResult = null;
        long startTime = System.currentTimeMillis();
        Instant instant = Instant.now();
        long currentTime = instant.getEpochSecond();
        this.buildLogger.addBuildLogEntry("***Current Epoch Time in seconds = " + currentTime);
        long nowMinusSeconds = currentTime - this.taggingTime;
        long pollingIntervalInSec = TimeUnit.MILLISECONDS.toSeconds(this.pollingIntervalForVulns);
        block4: while (true) {
            while ((scanResult = this.getScanReport(this.imageSha, nowMinusSeconds)) == null) {
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > this.vulnsTimeout) {
                    this.buildLogger.addBuildLogEntry("Failed to get scan result; timeout of ~" + TimeUnit.MILLISECONDS.toMinutes(this.vulnsTimeout) + " mins (" + TimeUnit.MILLISECONDS.toSeconds(this.vulnsTimeout) + " secs) reached. Please check if image " + this.imageId + " is synced with API server.");
                    if (!this.isFailConditionsConfigured) break block4;
                    throw new Exception("Timeout reached fetching scan result for image " + this.imageId);
                }
                try {
                    this.buildLogger.addBuildLogEntry("Waiting for " + pollingIntervalInSec + " seconds before making next attempt for " + this.imageId + " ...");
                    Thread.sleep(this.pollingIntervalForVulns);
                    nowMinusSeconds += pollingIntervalInSec;
                    continue block4;
                }
                catch (InterruptedException e) {
                    this.buildLogger.addBuildLogEntry("Error waiting for scan result..");
                }
            }
            break;
        }
        if (scanResult == null || scanResult.isEmpty()) {
            if (this.isFailConditionsConfigured) {
                throw new Exception("No vulnerabilities data for image " + this.imageId + " found.");
            }
            this.buildLogger.addBuildLogEntry("No vulnerabilities data for image " + this.imageId + " found.");
            return null;
        }
        Helper.createNewFile(this.buildDirPath, "qualys_" + this.imageId, scanResult, this.buildLogger);
        return scanResult;
    }

    private String getScanReport(String imageSha, long nowMinusSeconds) throws Exception {
        try {
            this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " [" + Thread.currentThread().getName() + "] - Calling API to fetch image data for " + this.imageId);
            QualysCSResponse resp = null;
            resp = this.qualysCsClient.getImages(imageSha, nowMinusSeconds);
            if (resp.errored) {
                logger.info("Qualys API server URL is not correct or it is not reachable. Error message: " + resp.errorMessage);
                throw new Exception("Qualys API server URL is not correct or it is not reachable. Error message: " + resp.errorMessage);
            }
            if (resp.responseCode == 400) {
                this.buildLogger.addBuildLogEntry("Bad request. response code: " + resp.responseCode + " Message: " + resp.response.get("message").toString());
                return null;
            }
            if (resp.responseCode >= 500 && resp.responseCode <= 599) {
                this.buildLogger.addBuildLogEntry("HTTP Code: " + resp.responseCode + ". Image: N/A. Vulnerabilities: N/A.");
                this.buildLogger.addBuildLogEntry("Waiting for image data from Qualys for image id " + this.imageId);
                return null;
            }
            if (resp.responseCode == 204) {
                this.buildLogger.addBuildLogEntry("HTTP Code: " + resp.responseCode + ". Image details for " + this.imageId + " last scanned within last " + nowMinusSeconds + " seconds not found yet.");
                return null;
            }
            if (resp.responseCode == 200 && resp.response != null) {
                this.buildLogger.addBuildLogEntry("HTTP Code: " + resp.responseCode + ". Data available; Now fetching image details for imageId " + this.imageId);
                resp = this.qualysCsClient.getImageDetails(imageSha);
                JsonObject jsonObj = resp.response;
                String scanResult = jsonObj.toString();
                JsonElement vulns = jsonObj.get("vulnerabilities");
                if (vulns == null || vulns.isJsonNull()) {
                    this.buildLogger.addBuildLogEntry("Waiting for vulnerabilities data from Qualys for image id " + this.imageId);
                    this.buildLogger.addBuildLogEntry("HTTP Code: 200. Image: known to Qualys. Vulnerabilities: To be processed.");
                    return null;
                }
                return scanResult;
            }
            this.buildLogger.addBuildLogEntry("HTTP Code: " + resp.responseCode + ". API Response for " + this.imageId + " : " + resp.response + ". Image: Not known to Qualys. Vulnerabilities: To be processed.");
        }
        catch (QualysTaggingFailException e) {
            this.buildLogger.addBuildLogEntry("Error: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.info("Error fetching scan report for image " + this.imageId + ", reason : " + e.getMessage());
            this.buildLogger.addBuildLogEntry("Error fetching scan report for image " + this.imageId + ", reason : " + e.getMessage());
        }
        return null;
    }

    public String toString() {
        return this.imageId;
    }
}

