/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class ThresholdFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = -1899610620205446828L;
    private int lowerThreshold;
    private int lowerThreshold3;
    private int upperThreshold;
    private int upperThreshold3;
    private int white = 0xFFFFFF;
    private int black = 0;

    public ThresholdFilter() {
        this(127);
    }

    public ThresholdFilter(int n) {
        this.setLowerThreshold(n);
        this.setUpperThreshold(n);
    }

    public void setLowerThreshold(int n) {
        this.lowerThreshold = n;
        this.lowerThreshold3 = n * 3;
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setUpperThreshold(int n) {
        this.upperThreshold = n;
        this.upperThreshold3 = n * 3;
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public void setWhite(int n) {
        this.white = n;
    }

    public int getWhite() {
        return this.white;
    }

    public void setBlack(int n) {
        this.black = n;
    }

    public int getBlack() {
        return this.black;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        int n8 = n5 + n6 + n7;
        if (n8 < this.lowerThreshold3) {
            return n4 | this.black;
        }
        if (n8 > this.upperThreshold3) {
            return n4 | this.white;
        }
        return n3;
    }

    public String toString() {
        return "Stylize/Threshold...";
    }
}

