/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Histogram;
import com.jhlabs.image.WholeImageFilter;
import java.io.Serializable;

public class EqualizeFilter
extends WholeImageFilter
implements Serializable {
    protected int[][] lut;

    public void imageComplete(int n) {
        int n2;
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n3 = this.originalSpace.width;
        int n4 = this.originalSpace.height;
        Histogram histogram = new Histogram(this.inPixels, n3, n4, 0, n3);
        if (histogram.getNumSamples() > 0) {
            double d = 255.0 / (double)histogram.getNumSamples();
            this.lut = new int[3][256];
            n2 = 0;
            while (n2 < 3) {
                this.lut[n2][0] = histogram.getFrequency(n2, 0);
                int n5 = 1;
                while (n5 < 256) {
                    this.lut[n2][n5] = this.lut[n2][n5 - 1] + histogram.getFrequency(n2, n5);
                    ++n5;
                }
                n5 = 0;
                while (n5 < 256) {
                    this.lut[n2][n5] = (int)Math.round((double)this.lut[n2][n5] * d);
                    ++n5;
                }
                ++n2;
            }
        } else {
            this.lut = null;
        }
        n2 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n3) {
                this.inPixels[n2] = this.filterRGB(n7, n6, this.inPixels[n2]);
                ++n2;
                ++n7;
            }
            ++n6;
        }
        this.lut = null;
        this.consumer.setPixels(0, 0, n3, n4, this.defaultRGBModel, this.inPixels, 0, n3);
        this.consumer.imageComplete(n);
    }

    public int filterRGB(int n, int n2, int n3) {
        if (this.lut != null) {
            int n4 = n3 & 0xFF000000;
            int n5 = this.lut[0][n3 >> 16 & 0xFF];
            int n6 = this.lut[1][n3 >> 8 & 0xFF];
            int n7 = this.lut[2][n3 & 0xFF];
            return n4 | n5 << 16 | n6 << 8 | n7;
        }
        return n3;
    }

    public String toString() {
        return "Colors/Equalize";
    }
}

