/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.qmetry.EncryptionHelper;
import com.qmetry.QMetryConnection;
import com.qmetry.QMetryException;
import com.qmetry.ZipUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;

public class QTM4JResultPublisher
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException, RuntimeException {
        String pluginName = "QMetry for JIRA";
        BuildLogger bambooBuildLogger = taskContext.getBuildLogger();
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        try {
            File workspaceDir;
            File resultFile;
            String matchTestStepsValue;
            String cloudUrl = null;
            String region = ((String)taskContext.getConfigurationMap().get((Object)"region")).trim();
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("qmetry_prop.properties");
                Properties p = new Properties();
                p.load(is);
                cloudUrl = StringUtils.isNotBlank((CharSequence)region) && Objects.equals(region, "Australia") ? p.getProperty("qmetry.cloudv4.url.aus") : p.getProperty("qmetry.cloudv4.url.us");
            }
            catch (Exception e) {
                System.out.println(pluginName + " : ERROR : " + e.toString());
                throw new QMetryException("Failed to read QMetry properties");
            }
            String serverUrl = "";
            String serverUsername = "";
            String serverPassword = "";
            String personalAccessToken = "";
            boolean isBasicAuth = false;
            boolean isJiraServer = false;
            if (((String)taskContext.getConfigurationMap().get((Object)"jiraInstance")).equals("server")) {
                isJiraServer = true;
                serverUrl = ((String)taskContext.getConfigurationMap().get((Object)"serverUrl")).trim();
                String authenticationType = ((String)taskContext.getConfigurationMap().get((Object)"serverAuthenticationType")).trim();
                boolean bl = isBasicAuth = authenticationType.equals("basicAuth");
                if (isBasicAuth) {
                    serverUsername = ((String)taskContext.getConfigurationMap().get((Object)"serverUsername")).trim();
                    String isDES = (String)taskContext.getConfigurationMap().get((Object)"isDES");
                    if (isDES == null) {
                        String toDecode = (String)taskContext.getConfigurationMap().get((Object)"serverPassword");
                        serverPassword = new String(DatatypeConverter.parseBase64Binary((String)toDecode), "UTF-8");
                    } else {
                        String encryptedPassword = (String)taskContext.getConfigurationMap().get((Object)"serverPassword");
                        serverPassword = EncryptionHelper.decrypt(encryptedPassword);
                    }
                } else {
                    personalAccessToken = ((String)taskContext.getConfigurationMap().get((Object)"personalAccessToken")).trim();
                }
            }
            String displayName = pluginName + " : Uploading result file(s) to JIRA " + (isJiraServer ? "Server" : "Cloud");
            String repeated = new String(new char[displayName.length()]).replace("\u0000", "-");
            System.out.println("\n" + repeated + "\n" + displayName + "\n" + repeated);
            bambooBuildLogger.addBuildLogEntry("\n");
            bambooBuildLogger.addBuildLogEntry(repeated);
            bambooBuildLogger.addBuildLogEntry(displayName);
            bambooBuildLogger.addBuildLogEntry(repeated);
            System.out.println(pluginName + " : Build ID : " + taskContext.getBuildContext().getBuildNumber());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Build ID : " + taskContext.getBuildContext().getBuildNumber());
            String apiKey = ((String)taskContext.getConfigurationMap().get((Object)"apiKey")).trim();
            String filePath = ((String)taskContext.getConfigurationMap().get((Object)"filePath")).trim();
            String attachFile = ((String)taskContext.getConfigurationMap().get((Object)"attachFile")).trim();
            Boolean attach = false;
            if (attachFile != null && !attachFile.isEmpty() && attachFile.equals("true")) {
                attach = true;
            }
            if ((matchTestStepsValue = (String)taskContext.getConfigurationMap().get((Object)"matchTestSteps")) == null) {
                matchTestStepsValue = "true";
            }
            boolean matchTestSteps = Boolean.parseBoolean(matchTestStepsValue);
            String formatType = ((String)taskContext.getConfigurationMap().get((Object)"formatType")).trim();
            String testCycleToReuse = ((String)taskContext.getConfigurationMap().get((Object)"testCycleToReuse")).trim();
            String buildname = ((String)taskContext.getConfigurationMap().get((Object)"buildname")).trim();
            String environment = ((String)taskContext.getConfigurationMap().get((Object)"environment")).trim();
            String testcycleSummary = ((String)taskContext.getConfigurationMap().get((Object)"testcycleSummary")).trim();
            String testcycleDescription = ((String)taskContext.getConfigurationMap().get((Object)"testcycleDescription")).trim();
            String testCycleFolderPath = ((String)taskContext.getConfigurationMap().get((Object)"testCycleFolderPath")).trim();
            String testcyclePriority = ((String)taskContext.getConfigurationMap().get((Object)"testcyclePriority")).trim();
            String testcycleStatus = ((String)taskContext.getConfigurationMap().get((Object)"testcycleStatus")).trim();
            String testcycleComponents = ((String)taskContext.getConfigurationMap().get((Object)"testcycleComponents")).trim();
            String testcycleLabels = ((String)taskContext.getConfigurationMap().get((Object)"testcycleLabels")).trim();
            String testcycleFixVersionId = ((String)taskContext.getConfigurationMap().get((Object)"testcycleFixVersionId")).trim();
            String testcycleSprintId = ((String)taskContext.getConfigurationMap().get((Object)"testcycleSprintId")).trim();
            String testcycleAssignee = ((String)taskContext.getConfigurationMap().get((Object)"testcycleAssignee")).trim();
            String testcycleReporter = ((String)taskContext.getConfigurationMap().get((Object)"testcycleReporter")).trim();
            String testcycleStartDate = ((String)taskContext.getConfigurationMap().get((Object)"testcycleStartDate")).trim();
            String testcycleEndDate = ((String)taskContext.getConfigurationMap().get((Object)"testcycleEndDate")).trim();
            String testcycleCustomFields = ((String)taskContext.getConfigurationMap().get((Object)"testcycleCustomFields")).trim();
            String testcaseDescription = ((String)taskContext.getConfigurationMap().get((Object)"testcaseDescription")).trim();
            String testcasePrecondition = ((String)taskContext.getConfigurationMap().get((Object)"testcasePrecondition")).trim();
            String testCaseFolderPath = ((String)taskContext.getConfigurationMap().get((Object)"testCaseFolderPath")).trim();
            String testcasePriority = ((String)taskContext.getConfigurationMap().get((Object)"testcasePriority")).trim();
            String testcaseStatus = ((String)taskContext.getConfigurationMap().get((Object)"testcaseStatus")).trim();
            String testcaseComponents = ((String)taskContext.getConfigurationMap().get((Object)"testcaseComponents")).trim();
            String testcaseLabels = ((String)taskContext.getConfigurationMap().get((Object)"testcaseLabels")).trim();
            String testcaseFixVersionId = ((String)taskContext.getConfigurationMap().get((Object)"testcaseFixVersionId")).trim();
            String testcaseSprintId = ((String)taskContext.getConfigurationMap().get((Object)"testcaseSprintId")).trim();
            String testcaseAssignee = ((String)taskContext.getConfigurationMap().get((Object)"testcaseAssignee")).trim();
            String testcaseReporter = ((String)taskContext.getConfigurationMap().get((Object)"testcaseReporter")).trim();
            String testcaseCustomFields = ((String)taskContext.getConfigurationMap().get((Object)"testcaseCustomFields")).trim();
            String testCaseExecutionComment = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionComment")).trim();
            String testCaseExecutionAssignee = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionAssignee")).trim();
            String testCaseExecutionCustomFields = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionCustomFields")).trim();
            String testCaseExecutionPlannedDate = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionPlannedDate")).trim();
            String testCycleFolderId = ((String)taskContext.getConfigurationMap().get((Object)"testCycleFolderId")).trim();
            String testCaseFolderId = ((String)taskContext.getConfigurationMap().get((Object)"testCaseFolderId")).trim();
            String testcaseEstimatedTime = "";
            String testCaseExecutionActualTime = "";
            if (isJiraServer) {
                testcaseEstimatedTime = ((String)taskContext.getConfigurationMap().get((Object)"testcaseEstimatedTimeServer")).trim();
                testCaseExecutionActualTime = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionActualTimeServer")).trim();
            } else {
                testcaseEstimatedTime = ((String)taskContext.getConfigurationMap().get((Object)"testcaseEstimatedTimeCloud")).trim();
                testCaseExecutionActualTime = ((String)taskContext.getConfigurationMap().get((Object)"testCaseExecutionActualTimeCloud")).trim();
            }
            String automationHierarchyKey = null;
            String appendTestNameKey = null;
            if (formatType.equals("junit/xml")) {
                automationHierarchyKey = "automationHierarchyJunit";
                appendTestNameKey = "appendTestNameJunit";
            } else if (formatType.equals("testng/xml")) {
                automationHierarchyKey = "automationHierarchyTestNG";
                appendTestNameKey = "appendTestNameTestNG";
            }
            Integer automationHierarchy = null;
            Boolean appendTestName = null;
            if (formatType.equals("junit/xml") || formatType.equals("testng/xml")) {
                String automationHierarchyValue = (String)taskContext.getConfigurationMap().get((Object)automationHierarchyKey);
                String appendTestNameValue = (String)taskContext.getConfigurationMap().get((Object)appendTestNameKey);
                if (StringUtils.isNotBlank((CharSequence)automationHierarchyValue)) {
                    automationHierarchy = this.parseAutomationHierarchyOption(automationHierarchyValue);
                    if (StringUtils.isNotBlank((CharSequence)appendTestNameValue) && !Objects.equals(automationHierarchy, 1)) {
                        Boolean bl = appendTestNameValue.startsWith("Yes") ? Boolean.TRUE : (appendTestName = appendTestNameValue.startsWith("No") ? Boolean.FALSE : null);
                    }
                }
            }
            if ((resultFile = new File(workspaceDir = taskContext.getWorkingDirectory(), filePath = filePath.replace("\\", "/"))) == null || !resultFile.exists()) {
                throw new QMetryException("Result file(s) not found : '" + workspaceDir.getAbsolutePath() + "/" + filePath + "'");
            }
            String finalPath = resultFile.getAbsolutePath();
            boolean isZip = false;
            if (testcycleSummary != null && !testcycleSummary.isEmpty()) {
                testcycleSummary = testcycleSummary + " #" + taskContext.getBuildContext().getBuildNumber();
            }
            if (resultFile.isFile()) {
                isZip = false;
                String fileName = resultFile.getName();
                if (fileName.endsWith(".xml") && !formatType.equals("junit/xml") && !formatType.equals("testng/xml") && !formatType.equals("hpuft/xml")) {
                    throw new QMetryException("Cannot upload xml files when format is " + formatType);
                }
                if (fileName.endsWith(".json") && !formatType.equals("cucumber/json") && !formatType.equals("specflow/json")) {
                    throw new QMetryException("Cannot upload json files when format is " + formatType);
                }
                if (fileName.endsWith(".zip")) {
                    isZip = true;
                    System.out.println(pluginName + " : Given result file is a zip file");
                }
                System.out.println(pluginName + " : Given path is a result file");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Given path is a result file");
            } else if (resultFile.isDirectory()) {
                isZip = true;
                System.out.println(pluginName + " : Given path is a directory. Creating zip archive...");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Given path is a directory. Creating zip archive...");
                new ZipUtils(formatType);
                ZipUtils.zipDirectory(finalPath, "qmetry_result.zip", pluginName, bambooBuildLogger, attach);
                finalPath = finalPath + "/qmetry_result.zip";
                System.out.println(pluginName + " : Zip file created successfully : '" + finalPath + "'");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Zip file created successfully : '" + finalPath + "'");
            } else {
                throw new QMetryException("Result File '" + finalPath + "' is neither a file nor a directory.");
            }
            QMetryConnection connection = new QMetryConnection();
            if (isJiraServer) {
                connection.uploadToServerV4(serverUrl, apiKey, serverUsername, serverPassword, personalAccessToken, formatType, finalPath, attach, isZip, matchTestSteps, testCycleToReuse, buildname, environment, testcycleSummary, testcycleDescription, testcyclePriority, testcycleStatus, testcycleComponents, testcycleLabels, testcycleFixVersionId, testcycleSprintId, testcycleAssignee, testcycleReporter, testcycleStartDate, testcycleEndDate, testcaseDescription, testcasePrecondition, testcasePriority, testcaseStatus, testcaseComponents, testcaseLabels, testcaseFixVersionId, testcaseSprintId, testcaseAssignee, testcaseReporter, testcaseEstimatedTime, testcycleCustomFields, testcaseCustomFields, pluginName, bambooBuildLogger, testCycleFolderPath, testCaseFolderPath, testCaseExecutionComment, testCaseExecutionActualTime, testCaseExecutionAssignee, testCaseExecutionCustomFields, testCaseExecutionPlannedDate, automationHierarchy, appendTestName);
            } else {
                connection.uploadToCloudV4(cloudUrl, apiKey, formatType, finalPath, attach, isZip, matchTestSteps, testCycleToReuse, buildname, environment, testcycleSummary, testcycleDescription, testcyclePriority, testcycleStatus, testcycleComponents, testcycleLabels, testcycleFixVersionId, testcycleSprintId, testcycleAssignee, testcycleReporter, testcycleStartDate, testcycleEndDate, testcaseDescription, testcasePrecondition, testcasePriority, testcaseStatus, testcaseComponents, testcaseLabels, testcaseFixVersionId, testcaseSprintId, testcaseAssignee, testcaseReporter, testcaseEstimatedTime, testcycleCustomFields, testcaseCustomFields, pluginName, bambooBuildLogger, testCycleFolderId, testCaseFolderId, testCaseExecutionComment, testCaseExecutionActualTime, testCaseExecutionAssignee, testCaseExecutionCustomFields, testCaseExecutionPlannedDate, automationHierarchy, appendTestName);
            }
            builder.success();
        }
        catch (QMetryException e) {
            builder.failed();
            e.printStackTrace();
            System.out.println(pluginName + " : ERROR : " + e.toString());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e.getMessage());
        }
        catch (Exception e) {
            builder.failed();
            e.printStackTrace();
            bambooBuildLogger.addBuildLogEntry("ERROR : Could not upload result files to QMetry for JIRA!");
            System.out.println(pluginName + " : ERROR : " + e.toString());
        }
        bambooBuildLogger.addBuildLogEntry(pluginName + " : Task completed\n\n");
        System.out.println(pluginName + " : Task completed\n\n");
        return builder.build();
    }

    private Integer parseAutomationHierarchyOption(String automationHierarchyValue) {
        Integer automationHierarchy = null;
        if (automationHierarchyValue.startsWith("1")) {
            automationHierarchy = 1;
        } else if (automationHierarchyValue.startsWith("2")) {
            automationHierarchy = 2;
        } else if (automationHierarchyValue.startsWith("3")) {
            automationHierarchy = 3;
        }
        return automationHierarchy;
    }
}

