/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.qmetry.QTM4JResultPublisherConfigurator;
import org.apache.commons.lang3.StringUtils;

public class QTM4JResultPublisherValidateConfigurator
extends QTM4JResultPublisherConfigurator {
    @Override
    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString("apiKey"))) {
            errorCollection.addError("apiKey", "Please enter your API Key");
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("jiraInstance"))) {
            errorCollection.addError("jiraInstance", "Please select a JIRA instance");
        } else if (params.getString("jiraInstance").equals("server")) {
            if (StringUtils.isEmpty((CharSequence)params.getString("serverAuthenticationType"))) {
                errorCollection.addError("serverAuthenticationType", "Please select an authentication type.");
            } else if (params.getString("serverAuthenticationType").equals("basicAuth")) {
                if (StringUtils.isBlank((CharSequence)params.getString("serverUsername"))) {
                    errorCollection.addError("serverUsername", "Please enter your JIRA Username");
                }
                if (StringUtils.isEmpty((CharSequence)params.getString("serverPassword"))) {
                    errorCollection.addError("serverPassword", "Please enter your JIRA Password");
                }
            } else if (StringUtils.isBlank((CharSequence)params.getString("personalAccessToken"))) {
                errorCollection.addError("personalAccessToken", "Please enter your Personal Access Token");
            }
            if (StringUtils.isEmpty((CharSequence)params.getString("serverUrl"))) {
                errorCollection.addError("serverUrl", "Please enter JIRA URL");
            }
            if (!params.getString("serverUrl").startsWith("https") && !params.getString("serverUrl").startsWith("http")) {
                errorCollection.addError("serverUrl", "Invalid JIRA server URL");
            }
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("filePath"))) {
            errorCollection.addError("filePath", "Please give a File path");
        }
    }
}

