/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qmetry.QMetryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class QMetryConnection {
    public synchronized void uploadToServer(String serverUrl, String apiKey, String serverUsername, String serverPassword, String personalAccessToken, String testRunName, String formatType, String filePath, boolean attachFile, String labels, String sprint, String versions, String components, String platform, String comment, String testAssetHierarchy, String testCaseUpdateLevel, String testRunKey, JSONArray jiraFieldsJsonArray, boolean isZip, String pluginName, BuildLogger bambooBuildLogger) throws IOException, QMetryException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            System.out.println(pluginName + " : Uploading file '" + filePath + "' to JIRA server...");
            bambooBuildLogger.addBuildLogEntry(pluginName + " : JIRA URL : " + serverUrl);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : File Path :" + filePath);
            httpClient = HttpClients.createDefault();
            HttpPost postCall = new HttpPost(serverUrl + "/rest/qtm/latest/automation/importresults");
            System.out.println(pluginName + " : Using server URL : '" + serverUrl + "/rest/qtm/latest/automation/importresults'");
            if (StringUtils.isNotBlank((CharSequence)personalAccessToken)) {
                String bearerToken = "Bearer " + personalAccessToken;
                postCall.addHeader("Authorization", bearerToken);
            } else {
                String toEncode = serverUsername + ":" + serverPassword;
                byte[] message = toEncode.getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                String basicAuth = "Basic " + encoded;
                postCall.addHeader("Authorization", basicAuth);
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("apiKey", apiKey, ContentType.TEXT_PLAIN);
            if (testRunName != null && !testRunName.isEmpty()) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Run Name : '" + testRunName + "'");
                System.out.println(pluginName + " : Test Run Name : '" + testRunName + "'");
                builder.addTextBody("testRunName", testRunName, ContentType.TEXT_PLAIN);
            }
            builder.addTextBody("format", formatType, ContentType.TEXT_PLAIN);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Format : " + formatType);
            System.out.println(pluginName + " : Format : '" + formatType + "'");
            builder.addTextBody("isZip", isZip ? "true" : "false", ContentType.TEXT_PLAIN);
            if (isZip) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Result file is a Zip archive");
                System.out.println(pluginName + " : Result file is a Zip archive");
            }
            if ("TestCase-TestStep".equalsIgnoreCase(testAssetHierarchy) || "TestScenario-TestCase".equalsIgnoreCase(testAssetHierarchy)) {
                builder.addTextBody("testAssetHierarchy", testAssetHierarchy, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test asset hierarchy : " + testAssetHierarchy);
                System.out.println(pluginName + " : Test asset hierarchy : '" + testAssetHierarchy + "'");
                if ("TestCase-TestStep".equalsIgnoreCase(testAssetHierarchy)) {
                    builder.addTextBody("testCaseUpdateLevel", testCaseUpdateLevel, ContentType.TEXT_PLAIN);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Update Level : " + testCaseUpdateLevel);
                    System.out.println(pluginName + " : Test Case Update Level : " + testCaseUpdateLevel);
                }
            }
            if (attachFile) {
                builder.addTextBody("attachFile", "true", ContentType.TEXT_PLAIN);
            }
            if (platform != null && !platform.isEmpty()) {
                builder.addTextBody("platform", platform, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Platform : " + platform);
                System.out.println(pluginName + " : Platform '" + platform + "'");
            }
            if (labels != null && !labels.isEmpty()) {
                builder.addTextBody("labels", labels, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Labels : " + labels);
                System.out.println(pluginName + " : Labels '" + labels + "'");
            }
            if (versions != null && !versions.isEmpty()) {
                builder.addTextBody("versions", versions, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Versions : " + versions);
                System.out.println(pluginName + " : Versions '" + versions + "'");
            }
            if (components != null && !components.isEmpty()) {
                builder.addTextBody("components", components, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Components : " + components);
                System.out.println(pluginName + " : Components '" + components + "'");
            }
            if (sprint != null && !sprint.isEmpty()) {
                builder.addTextBody("sprint", sprint, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Sprint : " + sprint);
                System.out.println(pluginName + " : Sprint '" + sprint + "'");
            }
            if (comment != null && !comment.isEmpty()) {
                builder.addTextBody("comment", comment, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Comment : " + comment);
                System.out.println(pluginName + " : Comment '" + comment + "'");
            }
            if (testRunKey != null && !testRunKey.isEmpty()) {
                builder.addTextBody("testRunKey", testRunKey, ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Run Key : " + testRunKey);
                System.out.println(pluginName + " : Test Run Key '" + testRunKey + "'");
            }
            if (jiraFieldsJsonArray != null) {
                builder.addTextBody("JIRAFields", jiraFieldsJsonArray.toString(), ContentType.TEXT_PLAIN);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : JIRA Fields : " + jiraFieldsJsonArray.toString());
                System.out.println(pluginName + " : JIRA Fields : " + jiraFieldsJsonArray.toString());
            }
            File resultFile = new File(filePath);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(resultFile), ContentType.APPLICATION_OCTET_STREAM, resultFile.getName());
            HttpEntity multipart = builder.build();
            postCall.setEntity(multipart);
            response = httpClient.execute((HttpUriRequest)postCall);
            if (response.getStatusLine().getStatusCode() == 401) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Status Code : " + response.getStatusLine().getStatusCode());
                throw new QMetryException("JIRA authentication failed!");
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Status Code : " + response.getStatusLine().getStatusCode());
                throw new QMetryException("Error uploading results to server.");
            }
            HttpEntity entity = response.getEntity();
            String responseContent = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJson = null;
            responseJson = (JSONObject)new JSONParser().parse(responseContent);
            if (responseJson.get("success").toString().equals("true")) {
                JSONObject resultdata = (JSONObject)responseJson.get("result");
                System.out.println(pluginName + " : Test Result URL : " + resultdata.get("testRunUrl").toString());
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Result URL : " + resultdata.get("testRunUrl").toString());
                System.out.println(pluginName + " : Test Run Key : " + resultdata.get("testRunKey").toString());
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Run Key : " + resultdata.get("testRunKey").toString());
                System.out.println(pluginName + " : Response Message : " + resultdata.get("message").toString());
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Response Message : " + resultdata.get("message").toString());
            } else {
                if (responseJson.get("success").toString().equals("false")) {
                    System.out.println(pluginName + " : Error Message : " + responseJson.get("errorMessage").toString());
                    throw new QMetryException(responseJson.get("errorMessage").toString());
                }
                if (responseJson.get("success").toString().equals("error")) {
                    System.out.println(pluginName + " : Error has occurred while uploading the file with response code : " + response.getStatusLine().getStatusCode());
                    throw new QMetryException(pluginName + " : Error has occurred while uploading the file with response code : " + response.getStatusLine().getStatusCode());
                }
            }
        }
        catch (Exception e) {
            System.out.println(pluginName + " : ERROR : " + e.toString());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e.toString());
            e.printStackTrace();
            throw new QMetryException("Error uploading result file(s) to JIRA server!");
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
        }
    }

    public synchronized void uploadToCloud(String cloudUrl, String apiKey, String formatType, String testAssetHierarchy, String testCaseUpdateLevel, String testRunName, String platform, String labels, String versions, String components, String sprint, String comment, String testRunKey, JSONArray jiraFieldsJsonArray, String filePath, boolean attachFile, boolean isZip, String pluginName, BuildLogger bambooBuildLogger) throws ParseException, IOException, QMetryException {
        try {
            System.out.println(pluginName + " : Uploading file '" + filePath + "' to JIRA cloud...");
            bambooBuildLogger.addBuildLogEntry(pluginName + " : File Path : " + filePath);
            CloseableHttpResponse response = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(cloudUrl);
            System.out.println(pluginName + " : Using cloud URL : '" + cloudUrl + "'");
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Accept", "application/json");
            JSONObject reqJson = new JSONObject();
            reqJson.put("apiKey", apiKey);
            reqJson.put("format", formatType);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Format : '" + formatType + "'");
            System.out.println(pluginName + " : Format : '" + formatType + "'");
            reqJson.put("isZip", isZip);
            if (isZip) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Result file is a Zip archive");
                System.out.println(pluginName + " : Result file is a Zip archive");
            }
            if (testRunName != null && !testRunName.isEmpty()) {
                reqJson.put("testRunName", testRunName);
            }
            if ("TestCase-TestStep".equalsIgnoreCase(testAssetHierarchy) || "TestScenario-TestCase".equalsIgnoreCase(testAssetHierarchy)) {
                reqJson.put("testAssetHierarchy", testAssetHierarchy);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test asset hierarchy : " + testAssetHierarchy);
                System.out.println(pluginName + " : Test asset hierarchy : '" + testAssetHierarchy + "'");
                if ("TestCase-TestStep".equalsIgnoreCase(testAssetHierarchy)) {
                    reqJson.put("testCaseUpdateLevel", testCaseUpdateLevel);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Update Level : " + testCaseUpdateLevel);
                    System.out.println(pluginName + "Test Case Update Level " + testCaseUpdateLevel);
                }
            }
            if (attachFile) {
                reqJson.put("attachFile", attachFile);
            }
            if (platform != null && !platform.isEmpty()) {
                reqJson.put("platform", platform);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Platform : " + platform);
                System.out.println(pluginName + " : Platform '" + platform + "'");
            }
            if (labels != null && !labels.isEmpty()) {
                reqJson.put("labels", labels);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Labels : " + labels);
                System.out.println(pluginName + " : Labels '" + labels + "'");
            }
            if (versions != null && !versions.isEmpty()) {
                reqJson.put("versions", versions);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Versions : " + versions);
                System.out.println(pluginName + " : Versions '" + versions + "'");
            }
            if (components != null && !components.isEmpty()) {
                reqJson.put("components", components);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Components : " + components);
                System.out.println(pluginName + " : Components '" + components + "'");
            }
            if (sprint != null && !sprint.isEmpty()) {
                reqJson.put("sprint", sprint);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Sprint : " + sprint);
                System.out.println(pluginName + " : Sprint '" + sprint + "'");
            }
            if (comment != null && !comment.isEmpty()) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Comment : " + comment);
                System.out.println(pluginName + " : Comment '" + comment + "'");
                reqJson.put("comment", comment);
            }
            if (testRunKey != null && !testRunKey.isEmpty()) {
                reqJson.put("testRunKey", testRunKey);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Run Key : " + testRunKey);
                System.out.println(pluginName + " : Test Run Key '" + testRunKey + "'");
            }
            if (jiraFieldsJsonArray != null) {
                reqJson.put("JIRAFields", jiraFieldsJsonArray);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : JIRA Fields : " + jiraFieldsJsonArray.toString());
                System.out.println(pluginName + " : JIRA Fields : " + jiraFieldsJsonArray.toString());
            }
            post.setEntity((HttpEntity)new StringEntity(reqJson.toJSONString()));
            response = httpClient.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)entity);
            JSONParser parser = new JSONParser();
            JSONObject responseJson = (JSONObject)parser.parse(content);
            if (!((Boolean)responseJson.get("isSuccess")).booleanValue()) {
                throw new QMetryException("Error uploading result(s) to JIRA cloud. " + responseJson.get("errorMessage").toString());
            }
            response.close();
            httpClient.close();
            File resultFile = new File(filePath);
            String fileUploadUrl = (String)responseJson.get("url");
            URL url = new URL(fileUploadUrl);
            boolean repeatRequest = true;
            for (int maxRepeat = 3; repeatRequest && maxRepeat > 0; --maxRepeat) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(resultFile);
                    OutputStream outputStream = null;
                    HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "multipart/form-data");
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    outputStream = connection.getOutputStream();
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                    fileInputStream.close();
                    outputStream.close();
                    InputStream inputStream = connection.getInputStream();
                    if (connection.getResponseCode() != 200) {
                        throw new QMetryException("Error uploading result File.");
                    }
                    repeatRequest = false;
                    inputStream.close();
                    continue;
                }
                catch (SSLException e) {
                    System.out.println(e.toString() + " : attempts remaining (" + maxRepeat + ")");
                    repeatRequest = true;
                    if (maxRepeat != 0) continue;
                    throw new QMetryException("Could not upload result file. Please try again after sometime...");
                }
            }
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
            System.out.println(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
        }
        catch (Exception e) {
            System.out.println(pluginName + " : ERROR : " + e);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e);
            e.printStackTrace();
            throw new QMetryException("Error uploading result file(s) to JIRA cloud!");
        }
    }

    public synchronized void uploadToCloudV4(String cloudUrl, String apiKey, String formatType, String filePath, boolean attach, boolean isZip, boolean matchTestSteps, String testCycleToReuse, String build, String environment, String testcycleSummary, String testcycleDescription, String testcyclePriority, String testcycleStatus, String testcycleComponents, String testcycleLabels, String testcycleFixVersionId, String testcycleSprintId, String testcycleAssignee, String testcycleReporter, String testcycleStartDate, String testcycleEndDate, String testcaseDescription, String testcasePrecondition, String testcasePriority, String testcaseStatus, String testcaseComponents, String testcaseLabels, String testcaseFixVersionId, String testcaseSprintId, String testcaseAssignee, String testcaseReporter, String testcaseEstimatedTime, String testcycleCustomFields, String testcaseCustomFields, String pluginName, BuildLogger bambooBuildLogger, String testCycleFolderId, String testCaseFolderId) throws ParseException, IOException, QMetryException {
        try {
            JSONParser parser;
            int i;
            ArrayList<String> jsArray;
            String[] arr;
            System.out.println(pluginName + " : Uploading file '" + filePath + "' to JIRA cloud...");
            bambooBuildLogger.addBuildLogEntry(pluginName + " : File Path : " + filePath);
            CloseableHttpResponse response = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(cloudUrl);
            System.out.println(pluginName + " : Using cloud URL : '" + cloudUrl + "'");
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Accept", "application/json");
            post.addHeader("apiKey", apiKey);
            JSONObject reqJson = new JSONObject();
            String format = "";
            if (formatType.equals("junit/xml")) {
                format = "junit";
            }
            if (formatType.equals("testng/xml")) {
                format = "testng";
            }
            if (formatType.equals("cucumber/json")) {
                format = "cucumber";
            }
            if (formatType.equals("qaf/json")) {
                format = "qaf";
            }
            if (formatType.equals("hpuft/xml")) {
                format = "hpuft";
            }
            if (formatType.equals("specflow/json")) {
                format = "specflow";
            }
            reqJson.put("format", format);
            reqJson.put("isZip", isZip);
            if (isZip) {
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Result file is a Zip archive");
                System.out.println(pluginName + " : Result file is a Zip archive");
            }
            reqJson.put("attachFile", attach);
            reqJson.put("matchTestSteps", matchTestSteps);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Match Test Steps for Cloud : " + matchTestSteps);
            System.out.println(pluginName + " : Match Test Steps for Cloud : " + matchTestSteps);
            if (testCycleToReuse != null && !testCycleToReuse.isEmpty()) {
                reqJson.put("testCycleToReuse", testCycleToReuse);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle To Reuse : " + testCycleToReuse);
                System.out.println(pluginName + " : Test Cycle To Reuse : " + testCycleToReuse);
            }
            if (build != null && !build.isEmpty()) {
                reqJson.put("build", build);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Build : " + build);
                System.out.println(pluginName + " : Build : " + build);
            }
            if (environment != null && !environment.isEmpty()) {
                reqJson.put("environment", environment);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Environment : " + environment);
                System.out.println(pluginName + " : Environment : " + environment);
            }
            JSONObject fieldJson = new JSONObject();
            JSONObject testcycleJson = new JSONObject();
            JSONObject testcaseJson = new JSONObject();
            if (testcycleSummary != null && !testcycleSummary.isEmpty()) {
                testcycleJson.put("summary", testcycleSummary);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Summary : " + testcycleSummary);
                System.out.println(pluginName + " : Test Cycle Summary : " + testcycleSummary);
            }
            if (testcycleDescription != null && !testcycleDescription.isEmpty()) {
                testcycleJson.put("description", testcycleDescription);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Description : " + testcycleDescription);
                System.out.println(pluginName + " : Test Cycle Description : " + testcycleDescription);
            }
            if (testCycleFolderId != null && !testCycleFolderId.isEmpty()) {
                testcycleJson.put("folderId", testCycleFolderId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Folder Id : " + testCycleFolderId);
                System.out.println(pluginName + " : Test Cycle Folder Id : " + testCycleFolderId);
            }
            if (testcyclePriority != null && !testcyclePriority.isEmpty()) {
                testcycleJson.put("priority", testcyclePriority);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Priority : " + testcyclePriority);
                System.out.println(pluginName + " : Test Cycle Priority : " + testcyclePriority);
            }
            if (testcycleStatus != null && !testcycleStatus.isEmpty()) {
                testcycleJson.put("status", testcycleStatus);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Status : " + testcycleStatus);
                System.out.println(pluginName + " : Test Cycle Status : " + testcycleStatus);
            }
            if (testcycleComponents != null && !testcycleComponents.isEmpty()) {
                arr = testcycleComponents.split(",");
                jsArray = new ArrayList<String>();
                for (i = 0; i < arr.length; ++i) {
                    jsArray.add(arr[i].trim());
                }
                testcycleJson.put("components", jsArray);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Components : " + testcycleComponents);
                System.out.println(pluginName + " : Test Cycle Components : " + testcycleComponents);
            }
            if (testcycleLabels != null && !testcycleLabels.isEmpty()) {
                arr = testcycleLabels.split(",");
                jsArray = new ArrayList();
                for (i = 0; i < arr.length; ++i) {
                    jsArray.add(arr[i].trim());
                }
                testcycleJson.put("labels", jsArray);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Labels : " + testcycleLabels);
                System.out.println(pluginName + " : Test Cycle Labels : " + testcycleLabels);
            }
            if (testcycleFixVersionId != null && !testcycleFixVersionId.isEmpty()) {
                testcycleJson.put("fixVersionId", testcycleFixVersionId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Fix VersionId : " + testcycleFixVersionId);
                System.out.println(pluginName + " : Test Cycle Fix VersionId : " + testcycleFixVersionId);
            }
            if (testcycleSprintId != null && !testcycleSprintId.isEmpty()) {
                testcycleJson.put("sprintId", testcycleSprintId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle SprintId : " + testcycleSprintId);
                System.out.println(pluginName + " : Test Cycle SprintId : " + testcycleSprintId);
            }
            if (testcycleAssignee != null && !testcycleAssignee.isEmpty()) {
                testcycleJson.put("assignee", testcycleAssignee);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Assignee : " + testcycleAssignee);
                System.out.println(pluginName + " : Test Cycle Assignee : " + testcycleAssignee);
            }
            if (testcycleReporter != null && !testcycleReporter.isEmpty()) {
                testcycleJson.put("reporter", testcycleReporter);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Reporter : " + testcycleReporter);
                System.out.println(pluginName + " : Test Cycle Reporter : " + testcycleReporter);
            }
            if (testcycleStartDate != null && !testcycleStartDate.isEmpty()) {
                testcycleJson.put("plannedStartDate", testcycleStartDate);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Planned Start Date : " + testcycleStartDate);
                System.out.println(pluginName + " : Test Cycle Planned Start Date : " + testcycleStartDate);
            }
            if (testcycleEndDate != null && !testcycleEndDate.isEmpty()) {
                testcycleJson.put("plannedEndDate", testcycleEndDate);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Planned End Date : " + testcycleEndDate);
                System.out.println(pluginName + " : Test Cycle Planned End Date : " + testcycleEndDate);
            }
            if (testcycleCustomFields != null && !testcycleCustomFields.isEmpty()) {
                parser = new JSONParser();
                JSONArray testcycleCustomFieldsJson = (JSONArray)parser.parse(testcycleCustomFields);
                testcycleJson.put("customFields", testcycleCustomFieldsJson);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Custom Fields : " + testcycleCustomFieldsJson);
                System.out.println(pluginName + " : Test Cycle Custom Fields : " + testcycleCustomFields);
            }
            if (testcaseDescription != null && !testcaseDescription.isEmpty()) {
                testcaseJson.put("description", testcaseDescription);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Description : " + testcaseDescription);
                System.out.println(pluginName + " : Test Case Description : " + testcaseDescription);
            }
            if (testcasePrecondition != null && !testcasePrecondition.isEmpty()) {
                testcaseJson.put("precondition", testcasePrecondition);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Precondition : " + testcasePrecondition);
                System.out.println(pluginName + " : Test Case Precondition : " + testcasePrecondition);
            }
            if (testCaseFolderId != null && !testCaseFolderId.isEmpty()) {
                testcaseJson.put("folderId", testCaseFolderId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Folder Id : " + testCaseFolderId);
                System.out.println(pluginName + " : Test Case Folder Id : " + testCaseFolderId);
            }
            if (testcasePriority != null && !testcasePriority.isEmpty()) {
                testcaseJson.put("priority", testcasePriority);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Priority : " + testcasePriority);
                System.out.println(pluginName + " : Test Case Priority : " + testcasePriority);
            }
            if (testcaseStatus != null && !testcaseStatus.isEmpty()) {
                testcaseJson.put("status", testcaseStatus);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Status : " + testcaseStatus);
                System.out.println(pluginName + " : Test Case Status : " + testcaseStatus);
            }
            if (testcaseComponents != null && !testcaseComponents.isEmpty()) {
                arr = testcaseComponents.split(",");
                jsArray = new ArrayList();
                for (i = 0; i < arr.length; ++i) {
                    jsArray.add(arr[i].trim());
                }
                testcaseJson.put("components", jsArray);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Components : " + testcaseComponents);
                System.out.println(pluginName + " : Test Case Components : " + testcaseComponents);
            }
            if (testcaseLabels != null && !testcaseLabels.isEmpty()) {
                arr = testcaseLabels.split(",");
                jsArray = new ArrayList();
                for (i = 0; i < arr.length; ++i) {
                    jsArray.add(arr[i].trim());
                }
                testcaseJson.put("labels", jsArray);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Labels : " + testcaseLabels);
                System.out.println(pluginName + " : Test Case Labels : " + testcaseLabels);
            }
            if (testcaseFixVersionId != null && !testcaseFixVersionId.isEmpty()) {
                testcaseJson.put("fixVersionId", testcaseFixVersionId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Fix VersionId : " + testcaseFixVersionId);
                System.out.println(pluginName + " : Test Case Fix VersionId : " + testcaseFixVersionId);
            }
            if (testcaseSprintId != null && !testcaseSprintId.isEmpty()) {
                testcaseJson.put("sprintId", testcaseSprintId);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case SprintId : " + testcaseSprintId);
                System.out.println(pluginName + " : Test Case SprintId : " + testcaseSprintId);
            }
            if (testcaseAssignee != null && !testcaseAssignee.isEmpty()) {
                testcaseJson.put("assignee", testcaseAssignee);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Assignee : " + testcaseAssignee);
                System.out.println(pluginName + " : Test Case Assignee : " + testcaseAssignee);
            }
            if (testcaseReporter != null && !testcaseReporter.isEmpty()) {
                testcaseJson.put("reporter", testcaseReporter);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Reporter : " + testcaseReporter);
                System.out.println(pluginName + " : Test Case Reporter : " + testcaseReporter);
            }
            if (testcaseEstimatedTime != null && !testcaseEstimatedTime.isEmpty()) {
                testcaseJson.put("estimatedTime", testcaseEstimatedTime);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Estimated Time : " + testcaseEstimatedTime);
                System.out.println(pluginName + " : Test Case Estimated Time : " + testcaseEstimatedTime);
            }
            if (testcaseCustomFields != null && !testcaseCustomFields.isEmpty()) {
                parser = new JSONParser();
                JSONArray testcaseCustomFieldsJson = (JSONArray)parser.parse(testcaseCustomFields);
                testcaseJson.put("customFields", testcaseCustomFieldsJson);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Custom Fields : " + testcaseCustomFieldsJson);
                System.out.println(pluginName + " : Test Case Custom Fields : " + testcaseCustomFields);
            }
            fieldJson.put("testCycle", testcycleJson);
            fieldJson.put("testCase", testcaseJson);
            reqJson.put("fields", fieldJson);
            post.setEntity((HttpEntity)new StringEntity(reqJson.toJSONString()));
            response = httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)entity);
            response.close();
            httpClient.close();
            if (statusCode != 200) {
                throw new QMetryException("Error uploading result(s) to JIRA cloud. " + content);
            }
            JSONParser parser2 = new JSONParser();
            JSONObject responseJson = (JSONObject)parser2.parse(content);
            if (responseJson.get("url") == null) {
                throw new QMetryException("Error uploading result(s) to JIRA cloud. " + responseJson.toJSONString());
            }
            File resultFile = new File(filePath);
            String fileUploadUrl = (String)responseJson.get("url");
            URL url = new URL(fileUploadUrl);
            FileInputStream fileInputStream = new FileInputStream(resultFile);
            OutputStream outputStream = null;
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "multipart/form-data");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            outputStream = connection.getOutputStream();
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            fileInputStream.close();
            outputStream.close();
            InputStream inputStream = connection.getInputStream();
            if (connection.getResponseCode() != 200) {
                throw new QMetryException("Error uploading result File.");
            }
            inputStream.close();
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
            System.out.println(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
        }
        catch (Exception e) {
            System.out.println(pluginName + " : ERROR : " + e);
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e);
            e.printStackTrace();
            throw new QMetryException("Error uploading result file(s) to JIRA cloud!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void uploadToServerV4(String serverUrl, String apiKey, String serverUsername, String serverPassword, String personalAccessToken, String formatType, String filePath, boolean attach, boolean isZip, boolean matchTestSteps, String testCycleToReuse, String build, String environment, String testcycleSummary, String testcycleDescription, String testcyclePriority, String testcycleStatus, String testcycleComponents, String testcycleLabels, String testcycleFixVersionId, String testcycleSprintId, String testcycleAssignee, String testcycleReporter, String testcycleStartDate, String testcycleEndDate, String testcaseDescription, String testcasePrecondition, String testcasePriority, String testcaseStatus, String testcaseComponents, String testcaseLabels, String testcaseFixVersionId, String testcaseSprintId, String testcaseAssignee, String testcaseReporter, String testcaseEstimatedTime, String testcycleCustomFields, String testcaseCustomFields, String pluginName, BuildLogger bambooBuildLogger, String testCycleFolderPath, String testCaseFolderPath, String testCaseExecutionComment, String testCaseExecutionActualTime, String testCaseExecutionAssignee, String testCaseExecutionCustomFields) throws ParseException, IOException, QMetryException {
        block65: {
            if (serverUrl != null && serverUrl.length() > 0 && serverUrl.charAt(serverUrl.length() - 1) == '/') {
                serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
            }
            try {
                JSONParser parser;
                int i;
                ArrayList<String> jsArray;
                String[] arr;
                System.out.println(pluginName + " : Uploading file '" + filePath + "' to JIRA Server...");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : JIRA URL : " + serverUrl);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : File Path : " + filePath);
                CloseableHttpResponse response = null;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                HttpPost post = new HttpPost(serverUrl + "/rest/qtm4j/automation/latest/importresult");
                System.out.println(pluginName + " : Using Server URL : '" + serverUrl + "/rest/qtm4j/automation/latest/importresult'");
                post.addHeader("Content-Type", "application/json");
                post.addHeader("Accept", "application/json");
                post.addHeader("apiKey", apiKey);
                if (StringUtils.isNotBlank((CharSequence)personalAccessToken)) {
                    String bearerToken = "Bearer " + personalAccessToken;
                    post.addHeader("Authorization", bearerToken);
                } else {
                    String toEncode = serverUsername + ":" + serverPassword;
                    byte[] message = toEncode.getBytes("UTF-8");
                    String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                    String basicAuth = "Basic " + encoded;
                    post.addHeader("Authorization", basicAuth);
                }
                JSONObject reqJson = new JSONObject();
                String format = "";
                if (formatType.equals("junit/xml")) {
                    format = "junit";
                }
                if (formatType.equals("testng/xml")) {
                    format = "testng";
                }
                if (formatType.equals("cucumber/json")) {
                    format = "cucumber";
                }
                if (formatType.equals("qaf/json")) {
                    format = "qaf";
                }
                if (formatType.equals("hpuft/xml")) {
                    format = "hpuft";
                }
                if (formatType.equals("specflow/json")) {
                    format = "specflow";
                }
                reqJson.put("format", format);
                reqJson.put("isZip", isZip);
                if (isZip) {
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Result file is a Zip archive");
                    System.out.println(pluginName + " : Result file is a Zip archive");
                }
                reqJson.put("attachFile", attach);
                reqJson.put("matchTestSteps", matchTestSteps);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Match Test Steps for Server : " + matchTestSteps);
                System.out.println(pluginName + " : Match Test Steps for Server : " + matchTestSteps);
                if (testCycleToReuse != null && !testCycleToReuse.isEmpty()) {
                    reqJson.put("testCycleToReuse", testCycleToReuse);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle To Reuse : " + testCycleToReuse);
                    System.out.println(pluginName + " : Test Cycle To Reuse : " + testCycleToReuse);
                }
                if (build != null && !build.isEmpty()) {
                    reqJson.put("build", build);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Build : " + build);
                    System.out.println(pluginName + " : Build : " + build);
                }
                if (environment != null && !environment.isEmpty()) {
                    reqJson.put("environment", environment);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Environment : " + environment);
                    System.out.println(pluginName + " : Environment : " + environment);
                }
                JSONObject fieldJson = new JSONObject();
                JSONObject testcycleJson = new JSONObject();
                JSONObject testcaseJson = new JSONObject();
                JSONObject testCaseExecutionJson = new JSONObject();
                if (testcycleSummary != null && !testcycleSummary.isEmpty()) {
                    testcycleJson.put("summary", testcycleSummary);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Summary : " + testcycleSummary);
                    System.out.println(pluginName + " : Test Cycle Summary : " + testcycleSummary);
                }
                if (testcycleDescription != null && !testcycleDescription.isEmpty()) {
                    testcycleJson.put("description", testcycleDescription);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Description : " + testcycleDescription);
                    System.out.println(pluginName + " : Test Cycle Description : " + testcycleDescription);
                }
                if (testCycleFolderPath != null && !testCycleFolderPath.isEmpty()) {
                    testcycleJson.put("folderPath", testCycleFolderPath);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Folder Path : " + testCycleFolderPath);
                    System.out.println(pluginName + " : Test Cycle Folder Path : " + testCycleFolderPath);
                }
                if (testcyclePriority != null && !testcyclePriority.isEmpty()) {
                    testcycleJson.put("priority", testcyclePriority);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Priority : " + testcyclePriority);
                    System.out.println(pluginName + " : Test Cycle Priority : " + testcyclePriority);
                }
                if (testcycleStatus != null && !testcycleStatus.isEmpty()) {
                    testcycleJson.put("status", testcycleStatus);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Status : " + testcycleStatus);
                    System.out.println(pluginName + " : Test Cycle Status : " + testcycleStatus);
                }
                if (testcycleComponents != null && !testcycleComponents.isEmpty()) {
                    arr = testcycleComponents.split(",");
                    jsArray = new ArrayList<String>();
                    for (i = 0; i < arr.length; ++i) {
                        jsArray.add(arr[i].trim());
                    }
                    testcycleJson.put("components", jsArray);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Components : " + testcycleComponents);
                    System.out.println(pluginName + " : Test Cycle Components : " + testcycleComponents);
                }
                if (testcycleLabels != null && !testcycleLabels.isEmpty()) {
                    arr = testcycleLabels.split(",");
                    jsArray = new ArrayList();
                    for (i = 0; i < arr.length; ++i) {
                        jsArray.add(arr[i].trim());
                    }
                    testcycleJson.put("labels", jsArray);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Labels : " + testcycleLabels);
                    System.out.println(pluginName + " : Test Cycle Labels : " + testcycleLabels);
                }
                if (testcycleFixVersionId != null && !testcycleFixVersionId.isEmpty()) {
                    testcycleJson.put("fixVersionId", testcycleFixVersionId);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Fix VersionId : " + testcycleFixVersionId);
                    System.out.println(pluginName + " : Test Cycle Fix VersionId : " + testcycleFixVersionId);
                }
                if (testcycleSprintId != null && !testcycleSprintId.isEmpty()) {
                    testcycleJson.put("sprintId", testcycleSprintId);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle SprintId : " + testcycleSprintId);
                    System.out.println(pluginName + " : Test Cycle SprintId : " + testcycleSprintId);
                }
                if (testcycleAssignee != null && !testcycleAssignee.isEmpty()) {
                    testcycleJson.put("assignee", testcycleAssignee);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Assignee : " + testcycleAssignee);
                    System.out.println(pluginName + " : Test Cycle Assignee : " + testcycleAssignee);
                }
                if (testcycleReporter != null && !testcycleReporter.isEmpty()) {
                    testcycleJson.put("reporter", testcycleReporter);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Reporter : " + testcycleReporter);
                    System.out.println(pluginName + " : Test Cycle Reporter : " + testcycleReporter);
                }
                if (testcycleStartDate != null && !testcycleStartDate.isEmpty()) {
                    testcycleJson.put("plannedStartDate", testcycleStartDate);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Planned Start Date : " + testcycleStartDate);
                    System.out.println(pluginName + " : Test Cycle Planned Start Date : " + testcycleStartDate);
                }
                if (testcycleEndDate != null && !testcycleEndDate.isEmpty()) {
                    testcycleJson.put("plannedEndDate", testcycleEndDate);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Planned End Date : " + testcycleEndDate);
                    System.out.println(pluginName + " : Test Cycle Planned End Date : " + testcycleEndDate);
                }
                if (testcycleCustomFields != null && !testcycleCustomFields.isEmpty()) {
                    parser = new JSONParser();
                    JSONArray testcycleCustomFieldsJson = (JSONArray)parser.parse(testcycleCustomFields);
                    testcycleJson.put("customFields", testcycleCustomFieldsJson);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Cycle Custom Fields : " + testcycleCustomFieldsJson);
                    System.out.println(pluginName + " : Test Cycle Custom Fields : " + testcycleCustomFields);
                }
                if (testcaseDescription != null && !testcaseDescription.isEmpty()) {
                    testcaseJson.put("description", testcaseDescription);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Description : " + testcaseDescription);
                    System.out.println(pluginName + " : Test Case Description : " + testcaseDescription);
                }
                if (testcasePrecondition != null && !testcasePrecondition.isEmpty()) {
                    testcaseJson.put("precondition", testcasePrecondition);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Precondition : " + testcasePrecondition);
                    System.out.println(pluginName + " : Test Case Precondition : " + testcasePrecondition);
                }
                if (testCaseFolderPath != null && !testCaseFolderPath.isEmpty()) {
                    testcaseJson.put("folderPath", testCaseFolderPath);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Folder Path : " + testCaseFolderPath);
                    System.out.println(pluginName + " : Test Case Folder Path : " + testCaseFolderPath);
                }
                if (testcasePriority != null && !testcasePriority.isEmpty()) {
                    testcaseJson.put("priority", testcasePriority);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Priority : " + testcasePriority);
                    System.out.println(pluginName + " : Test Case Priority : " + testcasePriority);
                }
                if (testcaseStatus != null && !testcaseStatus.isEmpty()) {
                    testcaseJson.put("status", testcaseStatus);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Status : " + testcaseStatus);
                    System.out.println(pluginName + " : Test Case Status : " + testcaseStatus);
                }
                if (testcaseComponents != null && !testcaseComponents.isEmpty()) {
                    arr = testcaseComponents.split(",");
                    jsArray = new ArrayList();
                    for (i = 0; i < arr.length; ++i) {
                        jsArray.add(arr[i].trim());
                    }
                    testcaseJson.put("components", jsArray);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Components : " + testcaseComponents);
                    System.out.println(pluginName + " : Test Case Components : " + testcaseComponents);
                }
                if (testcaseLabels != null && !testcaseLabels.isEmpty()) {
                    arr = testcaseLabels.split(",");
                    jsArray = new ArrayList();
                    for (i = 0; i < arr.length; ++i) {
                        jsArray.add(arr[i].trim());
                    }
                    testcaseJson.put("labels", jsArray);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Labels : " + testcaseLabels);
                    System.out.println(pluginName + " : Test Case Labels : " + testcaseLabels);
                }
                if (testcaseFixVersionId != null && !testcaseFixVersionId.isEmpty()) {
                    testcaseJson.put("fixVersionId", testcaseFixVersionId);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Fix VersionId : " + testcaseFixVersionId);
                    System.out.println(pluginName + " : Test Case Fix VersionId : " + testcaseFixVersionId);
                }
                if (testcaseSprintId != null && !testcaseSprintId.isEmpty()) {
                    testcaseJson.put("sprintId", testcaseSprintId);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case SprintId : " + testcaseSprintId);
                    System.out.println(pluginName + " : Test Case SprintId : " + testcaseSprintId);
                }
                if (testcaseAssignee != null && !testcaseAssignee.isEmpty()) {
                    testcaseJson.put("assignee", testcaseAssignee);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Assignee : " + testcaseAssignee);
                    System.out.println(pluginName + " : Test Case Assignee : " + testcaseAssignee);
                }
                if (testcaseReporter != null && !testcaseReporter.isEmpty()) {
                    testcaseJson.put("reporter", testcaseReporter);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Reporter : " + testcaseReporter);
                    System.out.println(pluginName + " : Test Case Reporter : " + testcaseReporter);
                }
                if (testcaseEstimatedTime != null && !testcaseEstimatedTime.isEmpty()) {
                    testcaseJson.put("estimatedTime", testcaseEstimatedTime);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Estimated Time : " + testcaseEstimatedTime);
                    System.out.println(pluginName + " : Test Case Estimated Time : " + testcaseEstimatedTime);
                }
                if (testcaseCustomFields != null && !testcaseCustomFields.isEmpty()) {
                    parser = new JSONParser();
                    JSONArray testcaseCustomFieldsJson = (JSONArray)parser.parse(testcaseCustomFields);
                    testcaseJson.put("customFields", testcaseCustomFieldsJson);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Custom Fields : " + testcaseCustomFieldsJson);
                    System.out.println(pluginName + " : Test Case Custom Fields : " + testcaseCustomFields);
                }
                if (testCaseExecutionComment != null && !testCaseExecutionComment.isEmpty()) {
                    testCaseExecutionJson.put("comment", testCaseExecutionComment);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Execution Comment : " + testCaseExecutionComment);
                    System.out.println(pluginName + " : Test Case Execution Comment : " + testCaseExecutionComment);
                }
                if (testCaseExecutionActualTime != null && !testCaseExecutionActualTime.isEmpty()) {
                    testCaseExecutionJson.put("actualTime", testCaseExecutionActualTime);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Execution Actual Time : " + testCaseExecutionActualTime);
                    System.out.println(pluginName + " : Test Case Execution Actual Time : " + testCaseExecutionActualTime);
                }
                if (testCaseExecutionAssignee != null && !testCaseExecutionAssignee.isEmpty()) {
                    testCaseExecutionJson.put("assignee", testCaseExecutionAssignee);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Execution Assignee : " + testCaseExecutionAssignee);
                    System.out.println(pluginName + " : Test Case Execution Assignee : " + testCaseExecutionAssignee);
                }
                if (testCaseExecutionCustomFields != null && !testCaseExecutionCustomFields.isEmpty()) {
                    parser = new JSONParser();
                    JSONArray testCaseExecutionCustomFieldsJson = (JSONArray)parser.parse(testCaseExecutionCustomFields);
                    testCaseExecutionJson.put("customFields", testCaseExecutionCustomFieldsJson);
                    bambooBuildLogger.addBuildLogEntry(pluginName + " : Test Case Execution Custom Fields : " + testCaseExecutionCustomFieldsJson);
                    System.out.println(pluginName + " : Test Case Execution Custom Fields : " + testCaseExecutionCustomFields);
                }
                fieldJson.put("testCycle", testcycleJson);
                fieldJson.put("testCase", testcaseJson);
                fieldJson.put("testCaseExecution", testCaseExecutionJson);
                reqJson.put("fields", fieldJson);
                post.setEntity((HttpEntity)new StringEntity(reqJson.toJSONString()));
                response = httpClient.execute((HttpUriRequest)post);
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity);
                response.close();
                httpClient.close();
                if (statusCode != 200) {
                    throw new QMetryException("Error uploading result(s) to JIRA Server. " + content);
                }
                JSONParser parser2 = new JSONParser();
                JSONObject responseJson = (JSONObject)parser2.parse(content);
                if (responseJson.get("url") == null) {
                    throw new QMetryException("Error uploading result(s) to JIRA Server. " + responseJson.toJSONString());
                }
                String fileUploadUrl = (String)responseJson.get("url");
                try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                    HttpPost httppost = new HttpPost(fileUploadUrl);
                    httppost.addHeader("apikey", apiKey);
                    if (StringUtils.isNotBlank((CharSequence)personalAccessToken)) {
                        String bearerToken = "Bearer " + personalAccessToken;
                        httppost.addHeader("Authorization", bearerToken);
                    } else {
                        String toEncode = serverUsername + ":" + serverPassword;
                        byte[] message = toEncode.getBytes("UTF-8");
                        String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                        String basicAuth = "Basic " + encoded;
                        httppost.addHeader("Authorization", basicAuth);
                    }
                    FileBody fileBody = new FileBody(new File(filePath));
                    HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody).build();
                    httppost.setEntity(reqEntity);
                    try (CloseableHttpResponse uploadResponse = httpclient.execute((HttpUriRequest)httppost);){
                        int responseCode = uploadResponse.getStatusLine().getStatusCode();
                        bambooBuildLogger.addBuildLogEntry(pluginName + " : File upload status code : " + uploadResponse.getStatusLine().getStatusCode());
                        if (responseCode == 204) {
                            bambooBuildLogger.addBuildLogEntry(pluginName + "File uploaded successfully.");
                            bambooBuildLogger.addBuildLogEntry(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
                            System.out.println(pluginName + " : Result(s) have been published to QMetry for JIRA successfully");
                            break block65;
                        }
                        throw new QMetryException("Error uploading result File.");
                    }
                }
            }
            catch (Exception e) {
                System.out.println(pluginName + " : ERROR : " + e);
                bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e);
                e.printStackTrace();
                throw new QMetryException("Error uploading result file(s) to JIRA Server!");
            }
        }
    }
}

