/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.google.common.collect.ImmutableList;
import com.qmetry.EncryptionHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;

public class ReportDeployTaskConfigurator
extends AbstractTaskConfigurator {
    String encoded = "";
    private static final List<String> formatTypeList = ImmutableList.of((Object)"junit/xml", (Object)"testng/xml", (Object)"cucumber/json", (Object)"qas/json", (Object)"hpuft/xml", (Object)"specflow/json");
    private static final List<String> testAssetHierarchyList = ImmutableList.of((Object)"TestScenario-TestCase", (Object)"TestCase-TestStep");
    private static final List<String> testCaseUpdateLevelList = ImmutableList.of((Object)"2-No change in test steps while reusing Test Case.", (Object)"1-Override test steps while reusing Test Case.", (Object)"0-Append test steps  while reusing Test Case.");

    @NotNull
    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) throws RuntimeException {
        this.encoded = "";
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("apiKey", params.getString("apiKey"));
        if (params.getString("jiraInstance").equals("server")) {
            config.put("serverUrl", params.getString("serverUrl"));
            config.put("serverAuthenticationType", params.getString("serverAuthenticationType"));
            if (params.getString("serverAuthenticationType").equals("basicAuth")) {
                config.put("serverUsername", params.getString("serverUsername"));
                config.put("isDES", "true");
                String toEncode = params.getString("serverPassword");
                String encodedPassword = EncryptionHelper.encrypt(toEncode);
                config.put("serverPassword", encodedPassword);
            } else {
                config.put("personalAccessToken", params.getString("personalAccessToken"));
            }
        }
        config.put("jiraInstance", params.getString("jiraInstance"));
        config.put("testRunName", params.getString("testRunName"));
        config.put("labels", params.getString("labels"));
        config.put("sprint", params.getString("sprint"));
        config.put("versions", params.getString("versions"));
        config.put("components", params.getString("components"));
        config.put("platform", params.getString("platform"));
        config.put("comment", params.getString("comment"));
        config.put("filePath", params.getString("filePath"));
        config.put("attachFile", params.getString("attachFile"));
        config.put("formatType", params.getString("formatType"));
        config.put("testAssetHierarchy", params.getString("testAssetHierarchy"));
        config.put("testCaseUpdateLevel", params.getString("testCaseUpdateLevel"));
        config.put("testRunKey", params.getString("testRunKey"));
        config.put("jiraFields", params.getString("jiraFields"));
        Map map = config;
        if (map == null) {
            ReportDeployTaskConfigurator.$$$reportNull$$$0(0);
        }
        return map;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("formatTypeList", formatTypeList);
        context.put("testAssetHierarchyList", testAssetHierarchyList);
        context.put("testCaseUpdateLevelList", testCaseUpdateLevelList);
        context.put("jiraInstance", "cloud");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) throws RuntimeException {
        super.populateContextForEdit(context, taskDefinition);
        context.put("apiKey", taskDefinition.getConfiguration().get("apiKey"));
        if (((String)taskDefinition.getConfiguration().get("jiraInstance")).equals("server")) {
            context.put("serverUrl", taskDefinition.getConfiguration().get("serverUrl"));
            String authType = (String)taskDefinition.getConfiguration().get("serverAuthenticationType");
            if (authType == null) {
                authType = "basicAuth";
            }
            context.put("serverAuthenticationType", authType);
            if (authType.equals("basicAuth")) {
                context.put("serverUsername", taskDefinition.getConfiguration().get("serverUsername"));
                String isDES = (String)taskDefinition.getConfiguration().get("isDES");
                if (isDES == null) {
                    try {
                        String toDecode = (String)taskDefinition.getConfiguration().get("serverPassword");
                        String decoded = new String(DatatypeConverter.parseBase64Binary((String)toDecode), "UTF-8");
                        context.put("serverPassword", decoded);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Cannot Authenticate User");
                    }
                } else {
                    String toDecode = (String)taskDefinition.getConfiguration().get("serverPassword");
                    String decodedPassword = EncryptionHelper.decrypt(toDecode);
                    context.put("serverPassword", decodedPassword);
                }
            } else {
                context.put("personalAccessToken", taskDefinition.getConfiguration().get("personalAccessToken"));
            }
        }
        context.put("jiraInstance", taskDefinition.getConfiguration().get("jiraInstance"));
        context.put("testRunName", taskDefinition.getConfiguration().get("testRunName"));
        context.put("labels", taskDefinition.getConfiguration().get("labels"));
        context.put("sprint", taskDefinition.getConfiguration().get("sprint"));
        context.put("versions", taskDefinition.getConfiguration().get("versions"));
        context.put("components", taskDefinition.getConfiguration().get("components"));
        context.put("platform", taskDefinition.getConfiguration().get("platform"));
        context.put("comment", taskDefinition.getConfiguration().get("comment"));
        context.put("filePath", taskDefinition.getConfiguration().get("filePath"));
        context.put("attachFile", taskDefinition.getConfiguration().get("attachFile"));
        context.put("formatTypeList", formatTypeList);
        context.put("formatType", taskDefinition.getConfiguration().get("formatType"));
        context.put("testAssetHierarchyList", testAssetHierarchyList);
        context.put("testAssetHierarchy", taskDefinition.getConfiguration().get("testAssetHierarchy"));
        context.put("testCaseUpdateLevelList", testCaseUpdateLevelList);
        context.put("testCaseUpdateLevel", taskDefinition.getConfiguration().get("testCaseUpdateLevel"));
        context.put("testRunKey", taskDefinition.getConfiguration().get("testRunKey"));
        context.put("jiraFields", taskDefinition.getConfiguration().get("jiraFields"));
    }

    public void populateContextForView(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("apiKey", taskDefinition.getConfiguration().get("apiKey"));
        if (((String)taskDefinition.getConfiguration().get("jiraInstance")).equals("server")) {
            context.put("serverUrl", taskDefinition.getConfiguration().get("serverUrl"));
            context.put("serverUsername", taskDefinition.getConfiguration().get("serverUsername"));
        }
        context.put("jiraInstance", taskDefinition.getConfiguration().get("jiraInstance"));
        context.put("testRunName", taskDefinition.getConfiguration().get("testRunName"));
        context.put("labels", taskDefinition.getConfiguration().get("labels"));
        context.put("sprint", taskDefinition.getConfiguration().get("sprint"));
        context.put("versions", taskDefinition.getConfiguration().get("versions"));
        context.put("components", taskDefinition.getConfiguration().get("components"));
        context.put("platform", taskDefinition.getConfiguration().get("platform"));
        context.put("comment", taskDefinition.getConfiguration().get("comment"));
        context.put("filePath", taskDefinition.getConfiguration().get("filePath"));
        context.put("attachFile", taskDefinition.getConfiguration().get("attachFile"));
        context.put("formatTypeList", formatTypeList);
        context.put("formatType", taskDefinition.getConfiguration().get("formatType"));
        context.put("testAssetHierarchyList", testAssetHierarchyList);
        context.put("testAssetHierarchy", taskDefinition.getConfiguration().get("testAssetHierarchy"));
        context.put("testCaseUpdateLevelList", testCaseUpdateLevelList);
        context.put("testCaseUpdateLevel", taskDefinition.getConfiguration().get("testCaseUpdateLevel"));
        context.put("testRunKey", taskDefinition.getConfiguration().get("testRunKey"));
        context.put("jiraFields", taskDefinition.getConfiguration().get("jiraFields"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/qmetry/ReportDeployTaskConfigurator", "generateTaskConfigMap"));
    }
}

