/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableList;
import com.qmetry.EncryptionHelper;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public class QTM4JResultPublisherConfigurator
extends AbstractTaskConfigurator {
    private static final List<String> formatTypeList = ImmutableList.of((Object)"junit/xml", (Object)"testng/xml", (Object)"cucumber/json", (Object)"qaf/json", (Object)"hpuft/xml", (Object)"specflow/json");

    @NotNull
    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) throws RuntimeException {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("apiKey", params.getString("apiKey"));
        config.put("jiraInstance", params.getString("jiraInstance"));
        if (params.getString("jiraInstance").equals("server")) {
            config.put("serverUrl", params.getString("serverUrl"));
            config.put("serverAuthenticationType", params.getString("serverAuthenticationType"));
            if (params.getString("serverAuthenticationType").equals("basicAuth")) {
                config.put("serverUsername", params.getString("serverUsername"));
                config.put("isDES", "true");
                String toEncode = params.getString("serverPassword");
                String encodedPassword = EncryptionHelper.encrypt(toEncode);
                config.put("serverPassword", encodedPassword);
            } else {
                config.put("personalAccessToken", params.getString("personalAccessToken"));
            }
        }
        config.put("filePath", params.getString("filePath"));
        config.put("attachFile", params.getString("attachFile"));
        config.put("matchTestSteps", params.getString("matchTestSteps"));
        config.put("formatType", params.getString("formatType"));
        config.put("testCycleToReuse", params.getString("testCycleToReuse"));
        config.put("buildname", params.getString("buildname"));
        config.put("environment", params.getString("environment"));
        config.put("testcycleSummary", params.getString("testcycleSummary"));
        config.put("testcycleDescription", params.getString("testcycleDescription"));
        config.put("testCycleFolderPath", params.getString("testCycleFolderPath"));
        config.put("testcyclePriority", params.getString("testcyclePriority"));
        config.put("testcycleStatus", params.getString("testcycleStatus"));
        config.put("testcycleComponents", params.getString("testcycleComponents"));
        config.put("testcycleLabels", params.getString("testcycleLabels"));
        config.put("testcycleFixVersionId", params.getString("testcycleFixVersionId"));
        config.put("testcycleSprintId", params.getString("testcycleSprintId"));
        config.put("testcycleAssignee", params.getString("testcycleAssignee"));
        config.put("testcycleReporter", params.getString("testcycleReporter"));
        config.put("testcycleStartDate", params.getString("testcycleStartDate"));
        config.put("testcycleEndDate", params.getString("testcycleEndDate"));
        config.put("testcycleCustomFields", params.getString("testcycleCustomFields"));
        config.put("testcaseDescription", params.getString("testcaseDescription"));
        config.put("testcasePrecondition", params.getString("testcasePrecondition"));
        config.put("testCaseFolderPath", params.getString("testCaseFolderPath"));
        config.put("testcasePriority", params.getString("testcasePriority"));
        config.put("testcaseStatus", params.getString("testcaseStatus"));
        config.put("testcaseComponents", params.getString("testcaseComponents"));
        config.put("testcaseLabels", params.getString("testcaseLabels"));
        config.put("testcaseFixVersionId", params.getString("testcaseFixVersionId"));
        config.put("testcaseSprintId", params.getString("testcaseSprintId"));
        config.put("testcaseAssignee", params.getString("testcaseAssignee"));
        config.put("testcaseReporter", params.getString("testcaseReporter"));
        config.put("testcaseEstimatedTime", params.getString("testcaseEstimatedTime"));
        config.put("testcaseCustomFields", params.getString("testcaseCustomFields"));
        config.put("testCaseExecutionComment", params.getString("testCaseExecutionComment"));
        config.put("testCaseExecutionActualTime", params.getString("testCaseExecutionActualTime"));
        config.put("testCaseExecutionAssignee", params.getString("testCaseExecutionAssignee"));
        config.put("testCaseExecutionCustomFields", params.getString("testCaseExecutionCustomFields"));
        config.put("testCycleFolderId", params.getString("testCycleFolderId"));
        config.put("testCaseFolderId", params.getString("testCaseFolderId"));
        Map map = config;
        if (map == null) {
            QTM4JResultPublisherConfigurator.$$$reportNull$$$0(0);
        }
        return map;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String testCaseExecutionCustomFields;
        String regex;
        Pattern p;
        Matcher m;
        boolean result;
        String testCaseExecutionActualTime;
        String testcycleEndDate;
        String testcycleStartDate;
        String regex2;
        Pattern p2;
        Matcher m2;
        Boolean result2;
        String testcaseEstimatedTime;
        String testcycleCustomFields;
        String testcaseCustomFields = params.getString("testcaseCustomFields");
        if (!testcaseCustomFields.isEmpty() && testcaseCustomFields != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONArray j = (JSONArray)parser.parse(testcaseCustomFields);
                testcaseCustomFields = j.toString();
            }
            catch (Exception ex) {
                errorCollection.addError("testcaseCustomFields", "Invalid JSON Array");
            }
        }
        if (!(testcycleCustomFields = params.getString("testcycleCustomFields")).isEmpty() && testcycleCustomFields != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONArray j = (JSONArray)parser.parse(testcycleCustomFields);
                testcycleCustomFields = j.toString();
            }
            catch (Exception ex) {
                errorCollection.addError("testcycleCustomFields", "Invalid JSON Array");
            }
        }
        if (!(testcaseEstimatedTime = params.getString("testcaseEstimatedTime")).isEmpty() && testcaseEstimatedTime != null && !(result2 = Boolean.valueOf((m2 = (p2 = Pattern.compile(regex2 = "([0-1][0-9]|2[0-3]):[0-5][0-9]")).matcher(testcaseEstimatedTime)).matches())).booleanValue()) {
            errorCollection.addError("testcaseEstimatedTime", "Either invalid time or invalid time format for estimated time. Pass in 'HH:mm' format");
        }
        if (!(testcycleStartDate = params.getString("testcycleStartDate")).isEmpty() && testcycleStartDate != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy HH:mm");
                format.setLenient(false);
                format.parse(testcycleStartDate);
            }
            catch (ParseException e) {
                errorCollection.addError("testcycleStartDate", "Either Invalid date passed or format is not correct for planned start date. Pass in 'dd/MMM/yyyy HH:mm' format");
            }
        }
        if (!(testcycleEndDate = params.getString("testcycleEndDate")).isEmpty() && testcycleEndDate != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy HH:mm");
                format.setLenient(false);
                format.parse(testcycleEndDate);
            }
            catch (ParseException e) {
                errorCollection.addError("testcycleEndDate", "Either Invalid date passed or format is not correct for planned end date. Pass in 'dd/MMM/yyyy HH:mm' format");
            }
        }
        if (!(testCaseExecutionActualTime = params.getString("testCaseExecutionActualTime")).isEmpty() && testCaseExecutionActualTime != null && !(result = (m = (p = Pattern.compile(regex = "([0-1][0-9]|2[0-3]):[0-5][0-9]")).matcher(testCaseExecutionActualTime)).matches())) {
            errorCollection.addError("testCaseExecutionActualTime", "Either invalid time or invalid time format for actual time. Pass in 'HH:mm' format");
        }
        if (!(testCaseExecutionCustomFields = params.getString("testCaseExecutionCustomFields")).isEmpty() && testCaseExecutionCustomFields != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONArray j = (JSONArray)parser.parse(testCaseExecutionCustomFields);
                testCaseExecutionCustomFields = j.toString();
            }
            catch (Exception ex) {
                errorCollection.addError("testCaseExecutionCustomFields", "Invalid JSON Array");
            }
        }
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("formatTypeList", formatTypeList);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) throws RuntimeException {
        super.populateContextForEdit(context, taskDefinition);
        context.put("apiKey", taskDefinition.getConfiguration().get("apiKey"));
        context.put("jiraInstance", taskDefinition.getConfiguration().get("jiraInstance"));
        if (((String)taskDefinition.getConfiguration().get("jiraInstance")).equals("server")) {
            context.put("serverUrl", taskDefinition.getConfiguration().get("serverUrl"));
            String authType = (String)taskDefinition.getConfiguration().get("serverAuthenticationType");
            if (authType == null) {
                authType = "basicAuth";
            }
            context.put("serverAuthenticationType", authType);
            if (authType.equals("basicAuth")) {
                context.put("serverUsername", taskDefinition.getConfiguration().get("serverUsername"));
                String isDES = (String)taskDefinition.getConfiguration().get("isDES");
                if (isDES == null) {
                    try {
                        String toDecode = (String)taskDefinition.getConfiguration().get("serverPassword");
                        String decoded = new String(DatatypeConverter.parseBase64Binary((String)toDecode), "UTF-8");
                        context.put("serverPassword", decoded);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Cannot Authenticate User");
                    }
                } else {
                    String toDecode = (String)taskDefinition.getConfiguration().get("serverPassword");
                    String decodedPassword = EncryptionHelper.decrypt(toDecode);
                    context.put("serverPassword", decodedPassword);
                }
            } else {
                context.put("personalAccessToken", taskDefinition.getConfiguration().get("personalAccessToken"));
            }
        }
        context.put("filePath", taskDefinition.getConfiguration().get("filePath"));
        context.put("attachFile", taskDefinition.getConfiguration().get("attachFile"));
        context.put("matchTestSteps", taskDefinition.getConfiguration().get("matchTestSteps"));
        context.put("formatTypeList", formatTypeList);
        context.put("formatType", taskDefinition.getConfiguration().get("formatType"));
        context.put("testCycleToReuse", taskDefinition.getConfiguration().get("testCycleToReuse"));
        context.put("buildname", taskDefinition.getConfiguration().get("buildname"));
        context.put("environment", taskDefinition.getConfiguration().get("environment"));
        context.put("testcycleSummary", taskDefinition.getConfiguration().get("testcycleSummary"));
        context.put("testcycleDescription", taskDefinition.getConfiguration().get("testcycleDescription"));
        context.put("testCycleFolderPath", taskDefinition.getConfiguration().get("testCycleFolderPath"));
        context.put("testcyclePriority", taskDefinition.getConfiguration().get("testcyclePriority"));
        context.put("testcycleStatus", taskDefinition.getConfiguration().get("testcycleStatus"));
        context.put("testcycleComponents", taskDefinition.getConfiguration().get("testcycleComponents"));
        context.put("testcycleLabels", taskDefinition.getConfiguration().get("testcycleLabels"));
        context.put("testcycleFixVersionId", taskDefinition.getConfiguration().get("testcycleFixVersionId"));
        context.put("testcycleSprintId", taskDefinition.getConfiguration().get("testcycleSprintId"));
        context.put("testcycleAssignee", taskDefinition.getConfiguration().get("testcycleAssignee"));
        context.put("testcycleReporter", taskDefinition.getConfiguration().get("testcycleReporter"));
        context.put("testcycleStartDate", taskDefinition.getConfiguration().get("testcycleStartDate"));
        context.put("testcycleEndDate", taskDefinition.getConfiguration().get("testcycleEndDate"));
        context.put("testcycleCustomFields", taskDefinition.getConfiguration().get("testcycleCustomFields"));
        context.put("testcaseDescription", taskDefinition.getConfiguration().get("testcaseDescription"));
        context.put("testcasePrecondition", taskDefinition.getConfiguration().get("testcasePrecondition"));
        context.put("testCaseFolderPath", taskDefinition.getConfiguration().get("testCaseFolderPath"));
        context.put("testcasePriority", taskDefinition.getConfiguration().get("testcasePriority"));
        context.put("testcaseStatus", taskDefinition.getConfiguration().get("testcaseStatus"));
        context.put("testcaseComponents", taskDefinition.getConfiguration().get("testcaseComponents"));
        context.put("testcaseLabels", taskDefinition.getConfiguration().get("testcaseLabels"));
        context.put("testcaseFixVersionId", taskDefinition.getConfiguration().get("testcaseFixVersionId"));
        context.put("testcaseSprintId", taskDefinition.getConfiguration().get("testcaseSprintId"));
        context.put("testcaseAssignee", taskDefinition.getConfiguration().get("testcaseAssignee"));
        context.put("testcaseReporter", taskDefinition.getConfiguration().get("testcaseReporter"));
        context.put("testcaseEstimatedTime", taskDefinition.getConfiguration().get("testcaseEstimatedTime"));
        context.put("testcaseCustomFields", taskDefinition.getConfiguration().get("testcaseCustomFields"));
        context.put("testCaseExecutionComment", taskDefinition.getConfiguration().get("testCaseExecutionComment"));
        context.put("testCaseExecutionActualTime", taskDefinition.getConfiguration().get("testCaseExecutionActualTime"));
        context.put("testCaseExecutionAssignee", taskDefinition.getConfiguration().get("testCaseExecutionAssignee"));
        context.put("testCaseExecutionCustomFields", taskDefinition.getConfiguration().get("testCaseExecutionCustomFields"));
        context.put("testCycleFolderId", taskDefinition.getConfiguration().get("testCycleFolderId"));
        context.put("testCaseFolderId", taskDefinition.getConfiguration().get("testCaseFolderId"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/qmetry/QTM4JResultPublisherConfigurator", "generateTaskConfigMap"));
    }
}

