/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.qmetry.QMetryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static String extension;
    private static String format;

    public ZipUtils(String resultFormat) {
        format = resultFormat;
        if (resultFormat.endsWith("xml")) {
            extension = ".xml";
        } else if (resultFormat.endsWith("json")) {
            extension = ".json";
        }
    }

    public static void zipDirectory(String sourceDir, String zipFileName, String pluginName, BuildLogger bambooBuildLogger, Boolean attachFile) throws QMetryException {
        try {
            File dir = new File(sourceDir);
            FileOutputStream fout = new FileOutputStream(sourceDir + "/" + zipFileName, false);
            ZipOutputStream zout = new ZipOutputStream(fout);
            ZipUtils.zipSubDirectory("", dir, zout, pluginName, bambooBuildLogger, extension);
            if (attachFile.booleanValue() && format.equals("qas/json")) {
                File imageDir = new File(sourceDir + "/img");
                ZipUtils.zipSubDirectory("img/", imageDir, zout, pluginName, bambooBuildLogger, ".png");
            }
            zout.close();
            ZipFile zf = new ZipFile(sourceDir + "/" + zipFileName);
            int size = zf.size();
            if (size == 0) {
                throw new FileNotFoundException("can not find files of proper format in directory : " + sourceDir);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e.toString());
            throw new QMetryException("Failed to create zip archive in directory '" + sourceDir + "'");
        }
    }

    private static void zipSubDirectory(String basePath, File dir, ZipOutputStream zout, String pluginName, BuildLogger bambooBuildLogger, String filter) throws IOException {
        File[] files;
        byte[] buffer = new byte[4096];
        for (File file : files = dir.listFiles()) {
            int length;
            if (file.isDirectory()) {
                String path = basePath + file.getName() + "/";
                ZipUtils.zipSubDirectory(path, file, zout, pluginName, bambooBuildLogger, filter);
                continue;
            }
            if (!file.getName().endsWith(filter)) continue;
            System.out.println(pluginName + " : adding result file to zip : '" + file.getAbsolutePath() + "'");
            bambooBuildLogger.addBuildLogEntry(pluginName + " : adding result file to zip : '" + file.getAbsolutePath() + "'");
            FileInputStream fin = new FileInputStream(file);
            zout.putNextEntry(new ZipEntry(basePath + file.getName()));
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
            fin.close();
        }
    }
}

