<div style="padding:10px 0px 10px 0px;">
	<input type="radio" name="jiraInstance" value="cloud" onclick="serverDisplayToggle(this.value)" [#if jiraInstance??][#if jiraInstance=="cloud"] checked="true" [/#if][#else] checked="true" [/#if] /> JIRA Cloud
	<input type="radio" name="jiraInstance" value="server" onclick="serverDisplayToggle(this.value)" [#if jiraInstance??][#if jiraInstance=="server"] checked="true" [/#if][/#if]  /> JIRA Server
</div>
<div id="serverBlock" [#if jiraInstance??][#if jiraInstance=="cloud"] style="display:none;" [/#if][#else] style="display:none;" [/#if] >
	[@ww.textfield label="JIRA URL" name="serverUrl" required='true' style="max-width:100%;width:100%;" description="<i>Example: http://qtm4j.qmetry.com<del>/rest/qtm4j/automation/latest/importresult</del></i>"/]

	<div style="padding:10px 0px 10px 0px;">
    	<input type="radio" name="serverAuthenticationType" value="basicAuth" onclick="authenticationDisplayToggle(this.value)" [#if serverAuthenticationType??][#if serverAuthenticationType=="basicAuth"] checked="true" [/#if][#else] checked="true" [/#if]/> Basic Authentication
    	<input type="radio" name="serverAuthenticationType" value="tokenAuth" onclick="authenticationDisplayToggle(this.value)" [#if serverAuthenticationType??][#if serverAuthenticationType=="tokenAuth"] checked="true" [/#if][/#if]  /> Personal Access Token
    </div>

    <div id="basicAuthBlock" [#if serverAuthenticationType??][#if serverAuthenticationType=="tokenAuth"] style="display:none;" [/#if][/#if] >
	    [@ww.textfield label="JIRA Username" name="serverUsername" required='true' style="max-width:100%;width:100%;" /]
	    [@ww.password label="JIRA Password" name="serverPassword" required='true' showPassword='true' style="max-width:100%;width:100%;" /]
	</div>

	<div id="tokenAuthBlock" [#if serverAuthenticationType??][#if serverAuthenticationType=="basicAuth"] style="display:none;" [/#if][#else] style="display:none;" [/#if] >
	    [@ww.textfield label="Personal Access Token" name="personalAccessToken" required='true' style="max-width:100%;width:100%;" /]
	</div>

</div>
[@ww.textfield label="Automation API Key" name="apiKey" required='true' style="max-width:100%;width:100%;" /]
[@ww.textfield label="Result File path/Result Directory" name="filePath" required='true' style="max-width:100%;width:100%;" /]
[@ww.checkbox label="Attachment" name="attachFile" /]
[@ww.select name="formatType" label="Format" list="formatTypeList" style="max-width:100%;width:100%;"  /]
[@ww.textfield label= "Test Cycle To Reuse" name="testCycleToReuse" required='false' style="max-width:100%;width:100%;" description="<i>Issue Key of the Test Cycle to be reused</i>" /]
[@ww.textfield label= "Build" name="buildname" required='false' style="max-width:100%;width:100%;" description="<i>Name of the Build</i>" /]
[@ww.textfield label="Environment" name="environment" required='false' style="max-width:100%;width:100%;" description="<i>Name of the Environment</i>" /]

[@ui.bambooSection title = "<b>Test Cycle</b>"]
    [@ww.textfield label="Summary" name="testcycleSummary" style="max-width:100%;width:100%;" /]
    [@ww.textarea label="Description" name="testcycleDescription" style="max-width:100%;width:100%;height: 75px;" /]
    <div id="testCycleFolderPath" [#if jiraInstance??][#if jiraInstance=="cloud"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
            		[@ww.textfield label="Folder Path" name="testCycleFolderPath" style="max-width:100%;width:100%;" description="<i>Enter Folder Path for Test Cycle. For example: F1/F2/F3</i>" /]
    </div>
    <div id="testCycleFolderId" [#if jiraInstance??][#if jiraInstance=="server"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
                    [@ww.textfield label="Folder Id" name="testCycleFolderId" style="max-width:100%;width:100%;" description="<i>Enter Folder Id for Test Cycle. To get it, Go to QTM4J Test Cycle panel >  Right click on any folder > select 'Copy Folder Id' option > Paste it here.</i>" /]
    </div>
    [@ww.textfield label="Priority" name="testcyclePriority" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Status" name="testcycleStatus" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Components" name="testcycleComponents" style="max-width:100%;width:100%;" description="<i>Enter Comma separated names of the Components</i>" /]
    [@ww.textfield label="Labels" name="testcycleLabels" style="max-width:100%;width:100%;" description="<i>Enter Comma separated names of the Labels</i>" /]
    [@ww.textfield label="Fix Version Id" name="testcycleFixVersionId" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Sprint Id" name="testcycleSprintId" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Assignee" name="testcycleAssignee" style="max-width:100%;width:100%;" description="<i>Enter valid User Account Id</i>" /]
    [@ww.textfield label="Reporter" name="testcycleReporter" style="max-width:100%;width:100%;" description="<i>Enter valid User Account Id</i>" /]
    [@ww.textfield label="Planned Start Date" name="testcycleStartDate" style="max-width:100%;width:100%;" description="<i>Enter Date in 'dd/MMM/yyyy HH:mm' Format</i>" /]
    [@ww.textfield label="Planned End Date" name="testcycleEndDate" style="max-width:100%;width:100%;" description="<i>Enter Date in 'dd/MMM/yyyy HH:mm' Format</i>" /]
	[@ww.textarea label="Custom Fields" name="testcycleCustomFields" style="max-width:100%;width:100%;height: 75px;" description="<i>Enter Test Cycle Custom Fields in Json Array Format</i>" /]
    
[/@ui.bambooSection]

[@ui.bambooSection title = "<b>Test Case</b>"]
 	[@ww.textarea label="Description" name="testcaseDescription" style="max-width:100%;width:100%;height: 75px;" /]
 	<div id="testcasePrecondition" [#if jiraInstance??][#if jiraInstance=="server"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
		[@ww.textarea label="Precondition" name="testcasePrecondition" style="max-width:100%;width:100%;height: 75px;" /]
	</div>
	<div id="testCaseFolderPath" [#if jiraInstance??][#if jiraInstance=="cloud"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
        		[@ww.textfield label="Folder Path" name="testCaseFolderPath" style="max-width:100%;width:100%;" description="<i>Enter Folder Path for Test Case. For example: F1/F2/F3</i>" /]
    </div>
    <div id="testCaseFolderId" [#if jiraInstance??][#if jiraInstance=="server"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
                [@ww.textfield label="Folder Id" name="testCaseFolderId" style="max-width:100%;width:100%;" description="<i>Enter Folder Id for Test Case. To get it, Go to QTM4J Test Case panel >  Right click on any folder > select 'Copy Folder Id' option > Paste it here.</i>" /]
    </div>
    [@ww.textfield label="Priority" name="testcasePriority" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Status" name="testcaseStatus" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Components" name="testcaseComponents" style="max-width:100%;width:100%;" description="<i>Enter Comma separated names of the Components</i>" /]
    [@ww.textfield label="Labels" name="testcaseLabels" style="max-width:100%;width:100%;" description="<i>Enter Comma separated names of the Labels</i>" /]
    [@ww.textfield label="Fix Version Id" name="testcaseFixVersionId" style="max-width:100%;width:100%;" /]
    [@ww.textfield label="Sprint Id" name="testcaseSprintId" style="max-width:100%;width:100%;" /]
	[@ww.textfield label="Assignee" name="testcaseAssignee" style="max-width:100%;width:100%;" description="<i>Enter valid User Account Id</i>" /]
    [@ww.textfield label="Reporter" name="testcaseReporter" style="max-width:100%;width:100%;" description="<i>Enter valid User Account Id</i>" /]
    [@ww.textfield label="EstimatedTime" name="testcaseEstimatedTime" style="max-width:100%;width:100%;" description="<i>Enter Time in 'HH:mm' Format</i>" /]
	[@ww.textarea label="Custom Fields" name="testcaseCustomFields" style="max-width:100%;width:100%;height: 75px;" description=" <i>Enter Test Case Custom Fields in Json Array Format</i>" /]
[/@ui.bambooSection]

<div id="testCaseExecutionBlock" [#if jiraInstance??][#if jiraInstance=="cloud"] style="display:none;" [/#if][#else] style="display:none;" [/#if]>
    [@ui.bambooSection title = "<b>Test Case Execution</b>"]
        [@ww.textfield label="Comment" name="testCaseExecutionComment" style="max-width:100%;width:100%;" /]
        [@ww.textfield label="Actual Time" name="testCaseExecutionActualTime" style="max-width:100%;width:100%;" description="<i>Enter Time in 'HH:mm' Format</i>" /]
        [@ww.textfield label="Assignee" name="testCaseExecutionAssignee" style="max-width:100%;width:100%;" description="<i>Enter valid User Account Id</i>" /]
        [@ww.textarea label="Custom Fields" name="testCaseExecutionCustomFields" style="max-width:100%;width:100%;height: 75px;" description=" <i>Enter Test Case Execution Custom Fields in Json Array Format</i>" /]
    [/@ui.bambooSection]
</div>

<script type="text/javascript">
	
	jQuery(document).ready(function() 
	{
		document.getElementById("taskHelpLink").setAttribute('target', '_blank');
	});
	
	function serverDisplayToggle(value)
	{
		if(value=="server") {
			document.getElementById("serverBlock").style.display = "block";
			document.getElementById("testcasePrecondition").style.display = "none";
			document.getElementById("testCaseFolderPath").style.display = "block";
            document.getElementById("testCycleFolderPath").style.display = "block";
            document.getElementById("testCaseExecutionBlock").style.display = "block";
            document.getElementById("testCycleFolderId").style.display = "none";
            document.getElementById("testCaseFolderId").style.display = "none";
		}
		else {
			document.getElementById("serverBlock").style.display = "none";
			document.getElementById("testcasePrecondition").style.display = "block";
			document.getElementById("testCaseFolderPath").style.display = "none";
            document.getElementById("testCycleFolderPath").style.display = "none";
            document.getElementById("testCaseExecutionBlock").style.display = "none";
            document.getElementById("testCycleFolderId").style.display = "block";
            document.getElementById("testCaseFolderId").style.display = "block";
		}
	}
	
	function jiraInstance() {
		var ele = document.getElementsByName('jiraInstance');
		for(i = 0; i < ele.length; i++) {
            if(ele[i].checked) {
            	serverDisplayToggle(ele[i].value);
            }
	    }
	}

	function authenticationDisplayToggle(value)
    {
    	if(value=="basicAuth") {
    		document.getElementById("basicAuthBlock").style.display = "block";
   			document.getElementById("tokenAuthBlock").style.display = "none";
   		}
   		else {
    		document.getElementById("basicAuthBlock").style.display = "none";
    		document.getElementById("tokenAuthBlock").style.display = "block";
   		}
   	}

	window.onload = jiraInstance();

</script>