/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.qmetry.ReportDeployTaskConfigurator;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ReportDeployTaskValidateConfigurator
extends ReportDeployTaskConfigurator {
    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString("apiKey"))) {
            errorCollection.addError("apiKey", "Please enter your API Key");
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("jiraInstance"))) {
            errorCollection.addError("jiraInstance", "Please select a JIRA instance");
        } else if (params.getString("jiraInstance").equals("server")) {
            if (StringUtils.isEmpty((CharSequence)params.getString("serverAuthenticationType"))) {
                errorCollection.addError("serverAuthenticationType", "Please select an authentication type.");
            } else if (params.getString("serverAuthenticationType").equals("basicAuth")) {
                if (StringUtils.isEmpty((CharSequence)params.getString("serverUsername"))) {
                    errorCollection.addError("serverUsername", "Please enter your JIRA Username");
                }
                if (StringUtils.isEmpty((CharSequence)params.getString("serverPassword"))) {
                    errorCollection.addError("serverPassword", "Please enter your JIRA Password");
                }
            } else if (StringUtils.isEmpty((CharSequence)params.getString("personalAccessToken"))) {
                errorCollection.addError("personalAccessToken", "Please enter your Personal Access Token");
            }
            if (StringUtils.isEmpty((CharSequence)params.getString("serverUrl"))) {
                errorCollection.addError("serverUrl", "Please enter JIRA URL");
            }
            if (!params.getString("serverUrl").startsWith("https") && !params.getString("serverUrl").startsWith("http")) {
                errorCollection.addError("serverUrl", "Invalid JIRA server URL");
            }
        }
        if (params.getString("testRunName") != null && params.getString("testRunName").length() >= 200) {
            errorCollection.addError("testRunName", "Cannot exceed 200 characters");
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("filePath"))) {
            errorCollection.addError("filePath", "Please give a File path");
        }
        if (params.getString("comment") != null && params.getString("comment").length() >= 255) {
            errorCollection.addError("comment", "Cannot exceed 255 characters");
        }
        if (!StringUtils.isEmpty((CharSequence)params.getString("testRunKey")) && params.getString("testRunKey").length() >= 255) {
            errorCollection.addError("testRunKey", "Cannot exceed 255 characters");
        }
        if (params.getString("jiraFields") != null && !StringUtils.isEmpty((CharSequence)params.getString("jiraFields"))) {
            try {
                JSONArray jSONArray = (JSONArray)new JSONParser().parse(params.getString("jiraFields"));
            }
            catch (ParseException e) {
                errorCollection.addError("jiraFields", "Please provide a valid JSON Array for JIRA Fields");
            }
        }
    }
}

