/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.qmetry.EncryptionHelper;
import com.qmetry.QMetryConnection;
import com.qmetry.QMetryException;
import com.qmetry.ZipUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public class ReportDeployTask
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException, RuntimeException {
        String pluginName = "QMetry for JIRA";
        BuildLogger bambooBuildLogger = taskContext.getBuildLogger();
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        try {
            File resultFile;
            String cloudUrl = null;
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("qmetry_prop.properties");
                Properties p = new Properties();
                p.load(is);
                cloudUrl = p.getProperty("qmetry.cloud.url").toString();
            }
            catch (Exception e) {
                System.out.println(pluginName + " : ERROR : " + e.toString());
                throw new QMetryException("Failed to read QMetry properties");
            }
            String serverUrl = "";
            String serverUsername = "";
            String serverPassword = "";
            String personalAccessToken = "";
            boolean isBasicAuth = false;
            boolean isJiraServer = false;
            if (((String)taskContext.getConfigurationMap().get((Object)"jiraInstance")).equals("server")) {
                isJiraServer = true;
                serverUrl = ((String)taskContext.getConfigurationMap().get((Object)"serverUrl")).trim();
                String authenticationType = ((String)taskContext.getConfigurationMap().get((Object)"serverAuthenticationType")).trim();
                boolean bl = isBasicAuth = authenticationType.equals("basicAuth");
                if (isBasicAuth) {
                    serverUsername = ((String)taskContext.getConfigurationMap().get((Object)"serverUsername")).trim();
                    String isDES = (String)taskContext.getConfigurationMap().get((Object)"isDES");
                    if (isDES == null) {
                        String toDecode = (String)taskContext.getConfigurationMap().get((Object)"serverPassword");
                        serverPassword = new String(DatatypeConverter.parseBase64Binary((String)toDecode), "UTF-8");
                    } else {
                        String encryptedPassword = (String)taskContext.getConfigurationMap().get((Object)"serverPassword");
                        serverPassword = EncryptionHelper.decrypt(encryptedPassword);
                    }
                } else {
                    personalAccessToken = ((String)taskContext.getConfigurationMap().get((Object)"personalAccessToken")).trim();
                }
            }
            String displayName = pluginName + " : Uploading result file(s) to JIRA " + (isJiraServer ? "Server" : "Cloud");
            String repeated = new String(new char[displayName.length()]).replace("\u0000", "-");
            System.out.println("\n" + repeated + "\n" + displayName + "\n" + repeated);
            bambooBuildLogger.addBuildLogEntry("\n");
            bambooBuildLogger.addBuildLogEntry(repeated);
            bambooBuildLogger.addBuildLogEntry(displayName);
            bambooBuildLogger.addBuildLogEntry(repeated);
            System.out.println(pluginName + " : Build ID : " + taskContext.getBuildContext().getBuildNumber());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : Build ID : " + taskContext.getBuildContext().getBuildNumber());
            String apiKey = ((String)taskContext.getConfigurationMap().get((Object)"apiKey")).trim();
            String testRunName = ((String)taskContext.getConfigurationMap().get((Object)"testRunName")).trim();
            String labels = (String)taskContext.getConfigurationMap().get((Object)"labels");
            String sprint = ((String)taskContext.getConfigurationMap().get((Object)"sprint")).trim();
            String versions = ((String)taskContext.getConfigurationMap().get((Object)"versions")).trim();
            String components = ((String)taskContext.getConfigurationMap().get((Object)"components")).trim();
            String platform = ((String)taskContext.getConfigurationMap().get((Object)"platform")).trim();
            String comment = (String)taskContext.getConfigurationMap().get((Object)"comment");
            String filePath = ((String)taskContext.getConfigurationMap().get((Object)"filePath")).trim();
            String attachFile = (String)taskContext.getConfigurationMap().get((Object)"attachFile");
            Boolean attach = false;
            if (attachFile != null && !attachFile.isEmpty() && attachFile.equals("true")) {
                attach = true;
            }
            String formatType = (String)taskContext.getConfigurationMap().get((Object)"formatType");
            String testAssetHierarchy = (String)taskContext.getConfigurationMap().get((Object)"testAssetHierarchy");
            String testCaseUpdateLevel = (String)taskContext.getConfigurationMap().get((Object)"testCaseUpdateLevel");
            String testRunKey = (String)taskContext.getConfigurationMap().get((Object)"testRunKey");
            String jiraFields = (String)taskContext.getConfigurationMap().get((Object)"jiraFields");
            String testCaseUpdateLevelNumber = "";
            if (testCaseUpdateLevel.equals("0-Append test steps  while reusing Test Case.")) {
                testCaseUpdateLevelNumber = "0";
            } else if (testCaseUpdateLevel.equals("1-Override test steps while reusing Test Case.")) {
                testCaseUpdateLevelNumber = "1";
            } else if (testCaseUpdateLevel.equals("2-No change in test steps while reusing Test Case.")) {
                testCaseUpdateLevelNumber = "2";
            }
            File workspaceDir = taskContext.getWorkingDirectory();
            JSONArray jiraFieldsJsonArray = null;
            if (jiraFields != null && !jiraFields.isEmpty()) {
                jiraFieldsJsonArray = (JSONArray)new JSONParser().parse(jiraFields);
            }
            if (testRunName != null && !testRunName.isEmpty()) {
                testRunName = testRunName + " #" + taskContext.getBuildContext().getBuildNumber();
            }
            if ((resultFile = new File(workspaceDir, filePath = filePath.replace("\\", "/"))) == null || !resultFile.exists()) {
                throw new QMetryException("Result file(s) not found : '" + workspaceDir.getAbsolutePath() + "/" + filePath + "'");
            }
            String finalPath = resultFile.getAbsolutePath();
            boolean isZip = false;
            if (formatType.equals("qas/json") && resultFile.isDirectory()) {
                System.out.println(pluginName + " : Given path is a directory. Looking for QAS result directory...");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Given path is a directory. Looking for QAS result directory...");
                isZip = true;
                File[] dirs = resultFile.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File directory, String fileName) {
                        return directory.isDirectory() && fileName.length() == 20;
                    }
                });
                Long last_mod = new Long(0L);
                File latest_dir = null;
                for (File adir : dirs) {
                    if (!adir.isDirectory() || adir.lastModified() <= last_mod) continue;
                    latest_dir = adir;
                    last_mod = adir.lastModified();
                }
                if (latest_dir == null) {
                    throw new QMetryException("Results' directory of type QAS not found in given directory '" + resultFile.getAbsolutePath() + "'");
                }
                System.out.println(pluginName + " : Creating zip archive for QAS in directory '" + latest_dir.getAbsolutePath() + "'");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Creating zip archive for QAS in directory '" + latest_dir.getAbsolutePath() + "'");
                new ZipUtils(formatType);
                ZipUtils.zipDirectory(latest_dir.getAbsolutePath(), "qmetry_result.zip", pluginName, bambooBuildLogger, attach);
                File zipArchive = new File(latest_dir, "qmetry_result.zip");
                if (zipArchive == null || !zipArchive.exists()) {
                    throw new QMetryException("Failed to create zip archive for QAS results at directory '" + latest_dir.getAbsolutePath() + "'");
                }
                finalPath = zipArchive.getAbsolutePath();
                System.out.println(pluginName + " : Zip file created successfully : '" + finalPath + "'");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Zip file created successfully : '" + finalPath + "'");
            } else if (resultFile.isFile()) {
                String fileName = resultFile.getName();
                if (fileName.endsWith(".xml") && !formatType.equals("junit/xml") && !formatType.equals("testng/xml") && !formatType.equals("hpuft/xml")) {
                    throw new QMetryException("Cannot upload xml files when format is " + formatType);
                }
                if (fileName.endsWith(".json") && !formatType.equals("cucumber/json") && !formatType.equals("specflow/json")) {
                    throw new QMetryException("Cannot upload json files when format is " + formatType);
                }
                isZip = false;
                System.out.println(pluginName + " : Given path is a result file");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Given path is a result file");
            } else if (resultFile.isDirectory()) {
                isZip = true;
                System.out.println(pluginName + " : Given path is a directory. Creating zip archive...");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Given path is a directory. Creating zip archive...");
                new ZipUtils(formatType);
                ZipUtils.zipDirectory(finalPath, "qmetry_result.zip", pluginName, bambooBuildLogger, attach);
                finalPath = finalPath + "/qmetry_result.zip";
                System.out.println(pluginName + " : Zip file created successfully : '" + finalPath + "'");
                bambooBuildLogger.addBuildLogEntry(pluginName + " : Zip file created successfully : '" + finalPath + "'");
            } else {
                throw new QMetryException("Result File '" + finalPath + "' is neither a file nor a directory.");
            }
            QMetryConnection connection = new QMetryConnection();
            if (isJiraServer) {
                connection.uploadToServer(serverUrl, apiKey, serverUsername, serverPassword, personalAccessToken, testRunName, formatType, finalPath, attach, labels, sprint, versions, components, platform, comment, testAssetHierarchy, testCaseUpdateLevelNumber, testRunKey, jiraFieldsJsonArray, isZip, pluginName, bambooBuildLogger);
            } else {
                connection.uploadToCloud(cloudUrl, apiKey, formatType, testAssetHierarchy, testCaseUpdateLevelNumber, testRunName, platform, labels, versions, components, sprint, comment, testRunKey, jiraFieldsJsonArray, finalPath, attach, isZip, pluginName, bambooBuildLogger);
            }
            builder.success();
        }
        catch (QMetryException e) {
            builder.failed();
            e.printStackTrace();
            System.out.println(pluginName + " : ERROR : " + e.toString());
            bambooBuildLogger.addBuildLogEntry(pluginName + " : ERROR : " + e.getMessage());
        }
        catch (Exception e) {
            builder.failed();
            e.printStackTrace();
            bambooBuildLogger.addBuildLogEntry("ERROR : Could not upload result files to QMetry for JIRA!");
            System.out.println(pluginName + " : ERROR : " + e.toString());
        }
        bambooBuildLogger.addBuildLogEntry(pluginName + " : Task completed\n\n");
        System.out.println(pluginName + " : Task completed\n\n");
        return builder.build();
    }
}

