
/**
 * New design for qtest-plugin-for-bamboo.js
 * @author tuanle
 * @since Dec 1 2015
 * @deprecated by tuanle on 28 Jun 2017, using qtest-plugin-for-bamboo-cors.js instead
 */
'use strict';
console.log('enter new.js');
window.QTESTPLUGIN = window.QTESTPLUGIN || {};
var QTESTPLUGIN = window.QTESTPLUGIN;


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * HttpRequest
 */
var HttpRequest = function(url){
  this._url = url;
  this._method = 'GET';
  this._body = undefined;
  this._headers = undefined;
}

HttpRequest.prototype.setMethod = function(method) {
  this._method = method;
  return this;
};
HttpRequest.prototype.setHeaders = function(headers) {
  this._headers = headers;
  return this;
};
HttpRequest.prototype.setBody = function(body) {
  this._body = body;
  return this;
};
HttpRequest.prototype.execute = function(onSuccess, onError) {
  jQuery.ajax({
    type: this._method,
    url: this._url,
    data: this._body,
    headers: this._headers,
    dataType: 'json',
    success: function(response){
      onSuccess(response);
    },
    error: function(error){
      onError(error);
    }
  });
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var Utils = {};
/* 
 * String Format
 *
 * Ex: "{0} is dead, but {1} is alive! {0} {2}".format("ASP", "ASP.NET")
 * -->> ASP is dead, but ASP.NET is alive! ASP {2}
 *
 */
Utils.format = function(string, args){
  return string.replace(
            /{(\d+)}/g,
            function(match, number) {
              return typeof args[number] != 'undefined' ? args[number] : match;
            }
          );
}

Utils.error = function(title, errorObject){
  if(!title){
    title = 'Unkown error';
  }

  var body = '';
  if(errorObject){
    body = '<p>' + errorObject.statusText + ': ' + errorObject.responseText + '</p>';
  }

  AJS.messages.error("#message-bar", {
     title: title,
     isCloseable: true,
     fadeout: true,
     body: body
  });
}

Utils.hint = function(title, message){
  AJS.messages.hint("#message-bar", {
    title: title,
    isCloseable: true,
    fadeout: true,
    body: '<p>' + message + '</p>'
  });
}

Utils.spin = function(selector){
  AJS.$(selector).addClass('icon icon-loading');
}

Utils.stopSpin = function(selector){
  AJS.$(selector).removeClass('icon icon-loading');
}

Utils.escapeHtml = function(html){
  var entityMap = {
     "&": "&amp;",
     "<": "&lt;",
     ">": "&gt;",
     '"': '&quot;',
     "'": '&#39;',
     "/": '&#x2F;'
   };

   return String(html).replace(/[&<>"'\/]/g, function (s) {
     return entityMap[s];
   });
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var QTestAccessor = function(url, apikey){
  this._url = url;
  this._apikey = apikey;
}

QTestAccessor.API_REFRESH_TOKEN = '/oauth/token?grant_type=refresh_token&refresh_token={0}';
QTestAccessor.API_CI_SETTING = '/api/v3/projects/{0}/ci';
QTestAccessor.API_PROJECT = '/api/v3/projects?assigned=true';
QTestAccessor.API_RELEASE = '/api/v3/projects/{0}/releases?includeClosed=true';
QTestAccessor.API_ENVIRONMENT = '/api/v3/projects/{0}/settings/test-suites/fields?includeInactive=true';
QTestAccessor.TEST_SUITE_ENVIRONMENT_FIELD = 'EnvironmentTestSuite';

/**
 * refresh access token
 * @param  Array    callbacks array of callbacks
 * @return {[type]}           [description]
 */
QTestAccessor.prototype._refreshAcessToken = function(callbacks){
  // keep this reference
  var self = this;

  var args = [];
  args.push(this._apikey);
  var url = Utils.format(this._url + QTestAccessor.API_REFRESH_TOKEN, args);

  var request = new HttpRequest(url);
  request.setMethod('POST')
    .setHeaders({'Authorization': 'Basic YmFtYm9vOldGZGlXWHY4a3lhdnlQNDFJQnY1N3hSMVdNUHBtT2Ex'})
    .setBody(null)
    .execute(function(response){
      var headers = {
        'Authorization': response.token_type + ' ' + response.access_token
      }

      self._headers = headers;

      if(callbacks){
        for (var i = 0; i < callbacks.length ; i++) {
          callbacks[i](self);
        };
      }
    }, function(error){
      Utils.error('Could not connect to qTest. Please check your qTest URL and API Token.');
    });
}


QTestAccessor.prototype.query = function(callback) {
  if(this._headers){
    callback(this);
  } else {
    this._refreshAcessToken(new Array(callback));
  }
};

QTestAccessor.prototype.queryChain = function(callbacks) {
  if(this._headers){
    for(var i = 0; i < callbacks.length; i ++){
      callbacks[i](this);
    }
  } else {
    this._refreshAcessToken(callbacks);
  }
};

/**
 * Retrieve projects
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveProjects = function(onSuccess, onError) {
  var url = this._url + QTestAccessor.API_PROJECT;
  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
    .execute(
      function(response){
        onSuccess(response);
      },
      function(error){
        onError(error);
      }
    );
};

/**
 * Retrieve releases of a project
 * @param  {[type]} projectId [description]
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveReleases = function(projectId, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  var url = Utils.format(this._url + QTestAccessor.API_RELEASE, args);

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
    .execute(
      function(response){
        onSuccess(response);
      },
      function(error){
        onError(error);
      }
    );
};


/**
 * retrieve environments of a project
 * @param  {[type]} projectId [description]
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveEnvironments = function(projectId, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  var url = Utils.format(this._url + QTestAccessor.API_ENVIRONMENT, args);

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
    .execute(
      function(response){
        onSuccess(response);
      },
      function(error){
        onError(error);
      }
    );
};

/**
 * Retrieve CI Setting
 * @param  {[type]} projectId    [description]
 * @param  {[type]} bambooServer [description]
 * @param  {[type]} planKey      [description]
 * @param  {[type]} onSuccess    [description]
 * @param  {[type]} onError      [description]
 * @return {[type]}              [description]
 */
QTestAccessor.prototype.retrieveCISetting = function(projectId, bambooServer, planKey, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  var url = Utils.format(this._url + QTestAccessor.API_CI_SETTING, args);
  var body = {
    'server' : bambooServer,
    'project' : planKey,
    'type': 'bamboo'
  };

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
    .setBody(body)
    .execute(
      function(response){
        onSuccess(response);
      },
      function(error){
        onError(error);
      }
    );
};



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
QTESTPLUGIN.Utils = Utils;
QTESTPLUGIN.QTestAccessor = QTestAccessor;