/**
 * New design for qtest-plugin-for-bamboo.js
 * @author tuanle
 * @since Dec 1 2015
 */
'use strict';
console.log('hook qtest-plugin-for-bamboo-cors.js');
window.QTESTPLUGIN = window.QTESTPLUGIN || {};
var QTESTPLUGIN = window.QTESTPLUGIN;
var contextPath = jQuery("#context_path").text();
console.log('Bamboo context path:', contextPath);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * HttpRequest
 */
var HttpRequest = function (url) {
  this._url = url;
  this._method = 'GET';
  this._body = undefined;
  this._headers = undefined;
}

HttpRequest.prototype.setMethod = function (method) {
  this._method = method;
  return this;
};
HttpRequest.prototype.setHeaders = function (headers) {
  this._headers = {...headers, 'User-Agent': 'qtest-bamboo'};
  return this;
};
HttpRequest.prototype.setBody = function (body) {
  this._body = body;
  return this;
};
HttpRequest.prototype.execute = function (onSuccess, onError) {
  jQuery.ajax({
    type: this._method,
    url: this._url,
    data: this._body,
    headers: this._headers,
    dataType: 'json',
    success: function (response) {
      onSuccess(response);
    },
    error: function (error) {
      onError(error);
    }
  });
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var Utils = {};
/* 
 * String Format
 *
 * Ex: "{0} is dead, but {1} is alive! {0} {2}".format("ASP", "ASP.NET")
 * -->> ASP is dead, but ASP.NET is alive! ASP {2}
 *
 */
Utils.format = function (string, args) {
  return string.replace(
      /{(\d+)}/g,
      function (match, number) {
        return typeof args[number] != 'undefined' ? args[number] : match;
      }
  );
}

Utils.error = function (title, errorObject) {
  if (!title) {
    title = 'Unkown error';
  }

  var body = '';
  if (errorObject) {
    body = '<p>' + errorObject.statusText + ': ' + errorObject.responseText + '</p>';
  }

  AJS.messages.error("#message-bar", {
    title: title,
    isCloseable: true,
    fadeout: true,
    body: body
  });
}

Utils.hint = function (title, message) {
  AJS.messages.hint("#message-bar", {
    title: title,
    isCloseable: true,
    fadeout: true,
    body: '<p>' + message + '</p>'
  });
}

Utils.spin = function (selector) {
  AJS.$(selector).addClass('icon icon-loading');
}

Utils.stopSpin = function (selector) {
  AJS.$(selector).removeClass('icon icon-loading');
}

Utils.escapeHtml = function (html) {
  var entityMap = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': '&quot;',
    "'": '&#39;',
    "/": '&#x2F;'
  };

  return String(html).replace(/[&<>"'\/]/g, function (s) {
    return entityMap[s];
  });
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var QTestAccessor = function (url, apikey) {
  this._url = url;
  this._apikey = apikey;
}

QTestAccessor.API_CI_SETTING = contextPath + '/rest/qtest/1.0/projects/{0}/ci-setting?qTestUrl={1}&serverName={2}&projectName={3}';
QTestAccessor.API_PROJECT = contextPath + '/rest/qtest/1.0/projects?qTestUrl={0}';
QTestAccessor.API_RELEASE = contextPath + '/rest/qtest/1.0/projects/{0}/releases?qTestUrl={1}';
QTestAccessor.API_ENVIRONMENT = contextPath + '/rest/qtest/1.0/projects/{0}/environments?qTestUrl={1}';
QTestAccessor.TEST_SUITE_ENVIRONMENT_FIELD = 'EnvironmentTestSuite';


QTestAccessor.prototype.query = function (callback) {
  callback(this);
  // if (this._headers) {
  //   callback(this);
  // } else {
  //   // this._refreshAcessToken(new Array(callback));
  //   // TODO Set headers here
  // }
};

QTestAccessor.prototype.queryChain = function (callbacks) {
  for (var i = 0; i < callbacks.length; i++) {
    callbacks[i](this);
  }
  // if (this._headers) {
  //   for (var i = 0; i < callbacks.length; i++) {
  //     callbacks[i](this);
  //   }
  // } else {
  //   // this._refreshAcessToken(callbacks);
  //   // TODO Set headers here
  // }
};

/**
 * Retrieve projects
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveProjects = function (onSuccess, onError) {
  var args = [];
  args.push(this._url);

  var url = Utils.format(QTestAccessor.API_PROJECT, args);
  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
      .execute(
          function (response) {
            onSuccess(response);
          },
          function (error) {
            onError(error);
          }
      );
};

/**
 * Retrieve releases of a project
 * @param  {[type]} projectId [description]
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveReleases = function (projectId, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  args.push(this._url);

  var url = Utils.format(QTestAccessor.API_RELEASE, args);

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
      .execute(
          function (response) {
            onSuccess(response);
          },
          function (error) {
            onError(error);
          }
      );
};


/**
 * retrieve environments of a project
 * @param  {[type]} projectId [description]
 * @param  {[type]} onSuccess [description]
 * @param  {[type]} onError   [description]
 * @return {[type]}           [description]
 */
QTestAccessor.prototype.retrieveEnvironments = function (projectId, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  args.push(this._url);

  var url = Utils.format(QTestAccessor.API_ENVIRONMENT, args);

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
      .execute(
          function (response) {
            onSuccess(response);
          },
          function (error) {
            onError(error);
          }
      );
};

/**
 * Retrieve CI Setting
 * @param  {[type]} projectId    [description]
 * @param  {[type]} bambooServer [description]
 * @param  {[type]} planKey      [description]
 * @param  {[type]} onSuccess    [description]
 * @param  {[type]} onError      [description]
 * @return {[type]}              [description]
 */
QTestAccessor.prototype.retrieveCISetting = function (projectId, bambooServer, planKey, onSuccess, onError) {
  var args = [];
  args.push(projectId);
  args.push(this._url);
  args.push(bambooServer);
  args.push(planKey);

  var url = Utils.format(QTestAccessor.API_CI_SETTING, args);

  var request = new HttpRequest(url);
  request.setHeaders(this._headers)
      .execute(
          function (response) {
            onSuccess(response);
          },
          function (error) {
            onError(error);
          }
      );
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
QTESTPLUGIN.Utils = Utils;
QTESTPLUGIN.QTestAccessor = QTestAccessor;
