/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.utils.http;

import com.qasymphony.qtest.bambooplugin.utils.http.UserAgentHeaderInterceptor;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClientFactory {
    public HttpClient build() {
        int timeout = 100000;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(100000).setConnectionRequestTimeout(100000).setSocketTimeout(100000).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config);
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
        SSLConnectionSocketFactory sslSocketFactory = this.getSslSocketFactory();
        NoConnectionReuseStrategy connectionReusesStrategy = new NoConnectionReuseStrategy();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)connectionReusesStrategy);
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new UserAgentHeaderInterceptor());
        return httpClientBuilder.build();
    }

    private SSLConnectionSocketFactory getSslSocketFactory() {
        SSLContext sslContext = this.getSslContext();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        return sslSocketFactory;
    }

    private SSLContext getSslContext() {
        try {
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            TrustAllStrategy trustStrategy = new TrustAllStrategy();
            sslContextBuilder.loadTrustMaterial(keyStore, (org.apache.http.ssl.TrustStrategy)trustStrategy);
            SSLContext sslContext = sslContextBuilder.build();
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

