/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.utils;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import java.io.File;
import java.util.List;
import java.util.UUID;

public final class PluginUtils {
    private static final String QTEST = "qtest";

    public static String getPlanKey(String fullPlanKeyIncludingJobKey) {
        String planKey = fullPlanKeyIncludingJobKey.substring(0, fullPlanKeyIncludingJobKey.lastIndexOf("-"));
        return planKey;
    }

    public static String getPluginKey(String fullPluginKeyIncludingTaskKey) {
        String pluginKey = fullPluginKeyIncludingTaskKey.substring(0, fullPluginKeyIncludingTaskKey.indexOf(":"));
        return pluginKey;
    }

    public static String getTestSuiteLink(String qTestUrl, Long projectId, long testSuiteId) {
        String format = "%s/p/%s/portal/project#tab=testexecution&object=2&id=%s";
        return String.format("%s/p/%s/portal/project#tab=testexecution&object=2&id=%s", qTestUrl, projectId, testSuiteId);
    }

    public static TaskDefinition getQTestTask(List<? extends ImmutableJob> jobs) {
        for (ImmutableJob immutableJob : jobs) {
            List taskDefinitions = immutableJob.getBuildDefinition().getTaskDefinitions();
            for (TaskDefinition taskDefinition : taskDefinitions) {
                if (!"com.qasymphony.qtest-plugin-for-bamboo:qtest.task".equals(taskDefinition.getPluginKey())) continue;
                return taskDefinition;
            }
        }
        return null;
    }

    public static File getQTestReportDirectory(File buildWorkingDir, String planKey) {
        File qTestDirForPlan;
        String path;
        File xmlDataDir = PluginUtils.getXmlDataDirectory(buildWorkingDir);
        if (null == xmlDataDir && null != buildWorkingDir) {
            path = buildWorkingDir.getAbsolutePath() + "/qtest";
            File tmp = new File(path);
            xmlDataDir = tmp.exists() ? buildWorkingDir : buildWorkingDir.getParentFile();
        }
        if (!(qTestDirForPlan = new File(path = xmlDataDir.getAbsolutePath() + "/qtest/" + planKey)).exists()) {
            qTestDirForPlan.mkdirs();
        }
        return qTestDirForPlan;
    }

    private static File getXmlDataDirectory(File buildWorkingDir) {
        if (null != buildWorkingDir && buildWorkingDir.isDirectory()) {
            if (buildWorkingDir.getName().equalsIgnoreCase("xml-data")) {
                return buildWorkingDir;
            }
            return PluginUtils.getXmlDataDirectory(buildWorkingDir.getParentFile());
        }
        return null;
    }

    public static String retrievePluginId(BandanaManager bandanaManager) {
        String id = (String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.qasymphony.qtest-plugin-for-bamboo:plugin.id");
        if (null == id) {
            id = UUID.randomUUID().toString();
            bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.qasymphony.qtest-plugin-for-bamboo:plugin.id", (Object)id);
        }
        return id;
    }

    public static boolean hasIndexInKey(String key) {
        return Character.isDigit(key.charAt(key.length() - 1));
    }

    public static String removeIndexFromKey(String key) {
        return key.replaceAll("\\d*$", "");
    }
}

