/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

public class JsonUtils {
    private static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String toJson(T object, boolean prettyPrint) {
        try {
            if (prettyPrint) {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw JsonUtils.wrapException(e);
        }
    }

    public static <T> String toJson(T object) {
        return JsonUtils.toJson(object, false);
    }

    public static <T> T toObject(String json, Class<T> type) {
        try {
            T object = mapper.readValue(json, type);
            return object;
        }
        catch (IOException e) {
            throw JsonUtils.wrapException(e);
        }
    }

    public static <T> List<T> toList(String json, Class<T> type) {
        try {
            TypeFactory typeFactory = mapper.getTypeFactory();
            CollectionType collectionType = typeFactory.constructCollectionType(List.class, type);
            List list = (List)mapper.readValue(json, (JavaType)collectionType);
            return list;
        }
        catch (IOException e) {
            throw JsonUtils.wrapException(e);
        }
    }

    public static <T> T getProperty(String json, String property, Class<T> type) {
        try {
            JsonNode node = mapper.readValue(json, JsonNode.class);
            JsonNode propertyNode = node.get(property);
            return mapper.readValue(propertyNode.traverse(), type);
        }
        catch (Exception e) {
            throw JsonUtils.wrapException(e);
        }
    }

    private static IllegalStateException wrapException(Throwable e) {
        return new IllegalStateException(e);
    }

    static {
        mapper.setDateFormat(new SimpleDateFormat(UTC_DATE_FORMAT));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

