/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.testsubmission;

import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.testsubmission.BambooTestResults;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestResult;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestResultTransformer;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResult;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitter;
import com.qasymphony.qtest.bambooplugin.utils.Operation;
import com.qasymphony.qtest.bambooplugin.utils.OperationHelper;
import com.qasymphony.qtest.bambooplugin.utils.PluginLogger;
import com.qasymphony.qtest.bambooplugin.utils.PluginUtils;
import com.qasymphony.qtest.bambooplugin.utils.http.OperationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class TestSubmissionService {
    private TestResultTransformer testResultTransformer = new TestResultTransformer();

    public TestSubmitResult submit(final TaskContext taskContext, final Configuration configuration) throws FileNotFoundException, IOException {
        BambooTestResults bambooTestResults = this.buildTestResults(taskContext);
        final TestSubmitResult result = new TestSubmitResult();
        result.setBuildNumber(bambooTestResults.getBuildNumber());
        if (bambooTestResults.getTestResults().isEmpty()) {
            PluginLogger.addLogEntry(taskContext, "No test logs found! Skip submit to qTest!");
            result.setNumberOfTestResult(0);
            result.setSubmitStatus("Skipped");
        } else {
            PluginLogger.addLogEntry(taskContext, "Submit test logs to qTest");
            try {
                result.setNumberOfTestResult(bambooTestResults.getTestResults().size());
                final TestSubmitter submitter = new TestSubmitter(taskContext, bambooTestResults);
                OperationHelper.executeWithRetry(3, 30, new Operation(){

                    @Override
                    public void execute() throws Exception {
                        submitter.submit(result, configuration);
                    }

                    @Override
                    public void handleException(Exception e) {
                        PluginLogger.addErrorLogEntry(taskContext, "Submit failed", e);
                        PluginLogger.addLogEntry(taskContext, " Retry to submit in 30 seconds...");
                    }
                });
            }
            catch (OperationException e) {
                result.setSubmitStatus("Failed");
                PluginLogger.addErrorLogEntry(taskContext, "Error when submit test log", e);
                result.setError(e.getMessage());
            }
        }
        return result;
    }

    private String getBuildNumber(TaskContext taskContext) {
        String fullPlanKeyIncludeJob = taskContext.getBuildContext().getPlanKey();
        String planKey = PluginUtils.getPlanKey(fullPlanKeyIncludeJob);
        String buildNumber = planKey + "-" + taskContext.getBuildContext().getBuildNumber();
        return buildNumber;
    }

    private BambooTestResults buildTestResults(TaskContext taskContext) throws IOException {
        CurrentBuildResult currentBuildResult = taskContext.getBuildContext().getBuildResult();
        Collection failedTests = currentBuildResult.getFailedTestResults();
        Collection skippedTests = currentBuildResult.getSkippedTestResults();
        Collection successfulTests = currentBuildResult.getSuccessfulTestResults();
        ArrayList<TestResults> testResults = new ArrayList<TestResults>();
        testResults.addAll(successfulTests);
        testResults.addAll(skippedTests);
        testResults.addAll(failedTests);
        Map<String, TestResult> resultMap = this.testResultTransformer.buildResults(testResults);
        BambooTestResults bambooTestResults = new BambooTestResults();
        String buildNumber = this.getBuildNumber(taskContext);
        bambooTestResults.setBuildNumber(buildNumber);
        bambooTestResults.setBuildPath("/browse/" + buildNumber);
        bambooTestResults.setTestResults(resultMap.values());
        return bambooTestResults;
    }
}

