/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.testsubmission;

import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.qasymphony.qtest.bambooplugin.testsubmission.Attachment;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestLog;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class TestResultTransformer {
    private static final String FILE_EXT_ZIP = ".zip";
    private static final String CONTENT_TYPE_APPLICATION_ZIP = "application/zip";
    private static final String CONTENT_TYPE_PLAN_TEXT = "text/plain";
    private static final String FILE_EXT_TXT = ".txt";
    private static final int MAX_PLAIN_FILES = 5;

    public Map<String, TestResult> buildResults(List<TestResults> results) throws IOException {
        HashMap<String, TestResult> resultMap = new HashMap<String, TestResult>();
        for (TestResults result : results) {
            List<TestLog> testlogs;
            TestResult testResult = null;
            String className = result.getClassName();
            String status = result.getState().toString();
            if (resultMap.containsKey(className)) {
                testResult = (TestResult)resultMap.get(className);
            } else {
                testResult = new TestResult();
                resultMap.put(className, testResult);
                testResult.setStatus(status);
                testResult.setName(className);
                testResult.setAutomationContent(className);
                Date current = new Date();
                testResult.setExecutedEndDate(current);
                testResult.setExecutedStartDate(current);
            }
            if (result.getState().equals((Object)TestState.FAILED)) {
                testResult.setStatus(status);
                List<Attachment> attachments = testResult.getAttachments();
                if (null == attachments) {
                    attachments = new ArrayList<Attachment>();
                    testResult.setAttachments(attachments);
                }
                attachments.add(this.getAttachment(result));
            }
            if ((testlogs = testResult.getTestlogs()) == null) {
                testlogs = new ArrayList<TestLog>();
                testResult.setTestlogs(testlogs);
            }
            TestLog testlog = new TestLog();
            testlog.setDescription(result.getActualMethodName());
            testlog.setExpectedResult(result.getActualMethodName());
            testlog.setOrder(0);
            testlog.setStatus(status);
            testlogs.add(testlog);
        }
        this.refineAttachments(resultMap);
        return resultMap;
    }

    private void refineAttachments(Map<String, TestResult> resultMap) throws FileNotFoundException, IOException {
        for (TestResult test : resultMap.values()) {
            if (null == test.getAttachments()) continue;
            int totalAttachements = test.getAttachments().size();
            if (totalAttachements > 5) {
                this.zipAttachments(test);
                continue;
            }
            this.keepAttachmentsAsPlainText(test);
        }
    }

    private void keepAttachmentsAsPlainText(TestResult test) {
        for (Attachment attachment : test.getAttachments()) {
            attachment.setContentType(CONTENT_TYPE_PLAN_TEXT);
            attachment.setData(this.encode(attachment.getData().getBytes()));
        }
    }

    private void zipAttachments(TestResult test) throws FileNotFoundException, IOException {
        File zip = this.createZipFile(test);
        Attachment zipAtt = new Attachment();
        zipAtt.setContentType(CONTENT_TYPE_APPLICATION_ZIP);
        zipAtt.setName(test.getName() + FILE_EXT_ZIP);
        try (FileInputStream is = new FileInputStream(zip);){
            zipAtt.setData(this.encode(IOUtils.toByteArray((InputStream)is)));
            ((InputStream)is).close();
        }
        zip.delete();
        List<Attachment> attachments = test.getAttachments();
        attachments.clear();
        attachments.add(zipAtt);
    }

    private File createZipFile(TestResult test) throws IOException {
        File zip = File.createTempFile(test.getName(), FILE_EXT_ZIP);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));){
            for (Attachment attachment : test.getAttachments()) {
                zos.putNextEntry(new ZipEntry(attachment.getName()));
                zos.write(attachment.getData().getBytes());
                zos.closeEntry();
            }
            zos.close();
        }
        return zip;
    }

    private String encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    private Attachment getAttachment(TestResults testResult) {
        Attachment att = new Attachment();
        att.setName(testResult.getActualMethodName() + FILE_EXT_TXT);
        StringBuilder errorBuilder = new StringBuilder();
        for (TestCaseResultError error : testResult.getErrors()) {
            errorBuilder.append(error.getContent()).append("\n");
        }
        att.setData(errorBuilder.toString());
        return att;
    }
}

