/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.qtesttask;

import com.qasymphony.qtest.bambooplugin.core.QTestConnector;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.utils.http.HttpClientUtils;

public class ConfigurationService {
    private Configuration create(Configuration configuration) {
        configuration.setId(-1L);
        String path = String.format("/api/v3/projects/%s/ci", configuration.getProjectId());
        QTestConnector connector = new QTestConnector(configuration.getqTestUrl(), configuration.getApiKey());
        return connector.post(path, configuration, Configuration.class);
    }

    public Configuration get(String qTestUrl, String apiKey, String projectId, String serverName, String projectName, String ciid) {
        String encodedCiid = this.encodeCiid(ciid);
        String url = String.format("/api/v3/projects/%s/ci?server=%s&project=%s&ciid=%s&type=bamboo", projectId, serverName, projectName, encodedCiid);
        QTestConnector connector = new QTestConnector(qTestUrl, apiKey);
        return connector.get(url, Configuration.class);
    }

    private String encodeCiid(String ciid) {
        String encodedCiid = "";
        if (null != ciid) {
            encodedCiid = HttpClientUtils.encode(ciid);
        }
        return encodedCiid;
    }

    private Configuration update(Configuration configuration) {
        try {
            String url = String.format("/api/v3/projects/%s/ci/%s", configuration.getProjectId(), configuration.getId());
            QTestConnector connector = new QTestConnector(configuration.getqTestUrl(), configuration.getApiKey());
            return connector.put(url, configuration, Configuration.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Configuration saveOrUpdate(Configuration configuration) {
        if (null == configuration.getId()) {
            return this.create(configuration);
        }
        return this.update(configuration);
    }
}

