/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.planaction;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.ww2.actions.chains.ListChainResults;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.qasymphony.qtest.bambooplugin.planaction.PlanLog;
import com.qasymphony.qtest.bambooplugin.storage.TestResultStoreService;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResult;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TestSubmissionPlanAction
extends ListChainResults {
    private static final long serialVersionUID = -354286876478490203L;
    private TestResultStoreService testResultStoreService = new TestResultStoreService();
    @ComponentImport
    private BuildDirectoryManager buildDirectoryManager;

    public List<PlanLog> getPlanLogs() throws IOException {
        ArrayList<PlanLog> logs = new ArrayList<PlanLog>();
        List planResults = this.getPager().getPage().getList();
        if (!planResults.isEmpty()) {
            ChainResultsSummary firstBuild = (ChainResultsSummary)planResults.get(0);
            ChainResultsSummary lastBuild = (ChainResultsSummary)planResults.get(planResults.size() - 1);
            Map<String, TestSubmitResult> results = this.getTestSubmitResults(firstBuild.getBuildNumber(), lastBuild.getBuildNumber());
            for (ChainResultsSummary plan : planResults) {
                PlanLog log = this.createPlanLog(plan, results);
                logs.add(log);
            }
        }
        return logs;
    }

    private PlanLog createPlanLog(ChainResultsSummary resultSummary, Map<String, TestSubmitResult> testSubmitResults) {
        PlanLog log = new PlanLog();
        String buildKey = resultSummary.getPlanResultKey().getKey();
        log.setBuildNumber(resultSummary.getBuildNumber());
        log.setBuildResultKey(buildKey);
        log.setTestNumber(resultSummary.getTestResultsSummary().getTotalTestCaseCount());
        if (testSubmitResults.containsKey(buildKey)) {
            TestSubmitResult result = testSubmitResults.get(buildKey);
            log.setStatus(result.getSubmitStatus());
            log.setSuiteName(result.getTestSuiteName());
            String testSuiteLink = "";
            if (null != result.getTestSuiteLink()) {
                testSuiteLink = result.getTestSuiteLink();
            }
            log.setSuiteLink(testSuiteLink);
            if (null != result.getNumberOfTestResult()) {
                log.setTestNumber(result.getNumberOfTestResult().intValue());
            }
            if (null != result.getNumberOfTestLog()) {
                log.setTestLogNumber(result.getNumberOfTestLog().intValue());
            }
        } else {
            log.setStatus("Canceled");
        }
        return log;
    }

    private Map<String, TestSubmitResult> getTestSubmitResults(int startBuildNumber, int endBuildNumber) throws IOException {
        String planKey = this.getPlanKey();
        File workingDir = this.buildDirectoryManager.getBaseBuildWorkingDirectory();
        Map<String, TestSubmitResult> results = this.testResultStoreService.fetch(workingDir, planKey, startBuildNumber, endBuildNumber);
        return results;
    }

    @Inject
    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }
}

