/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.core;

import com.qasymphony.qtest.bambooplugin.core.AccessDeniedException;
import com.qasymphony.qtest.bambooplugin.core.QTestConnector;
import com.qasymphony.qtest.bambooplugin.core.TokenStatus;
import java.util.HashMap;
import java.util.Map;

public class QTestAccessTokenHolder {
    private static Map<String, Map<String, QTestAccessTokenHolder>> instances = new HashMap<String, Map<String, QTestAccessTokenHolder>>();
    private String accessToken;
    private String apiKey;
    private String qTestUrl;

    private QTestAccessTokenHolder(String qTestUrl, String apiKey) {
        this.qTestUrl = qTestUrl;
        this.apiKey = apiKey;
    }

    public static QTestAccessTokenHolder getInstance(String qTestUrl, String apiKey) {
        QTestAccessTokenHolder instance = QTestAccessTokenHolder.checkInstance(qTestUrl, apiKey);
        if (null == instance) {
            instance = new QTestAccessTokenHolder(qTestUrl, apiKey);
            QTestAccessTokenHolder.putInstance(instance);
        }
        return instance;
    }

    private static QTestAccessTokenHolder checkInstance(String qTestUrl, String apiKey) {
        Map<String, QTestAccessTokenHolder> insts = instances.get(qTestUrl);
        if (null != insts) {
            return insts.get(apiKey);
        }
        return null;
    }

    private static void putInstance(QTestAccessTokenHolder instance) {
        Map<String, QTestAccessTokenHolder> insts = instances.get(instance.qTestUrl);
        if (null == insts) {
            insts = new HashMap<String, QTestAccessTokenHolder>();
            instances.put(instance.qTestUrl, insts);
        }
        insts.put(instance.apiKey, instance);
    }

    String getAccessToken() {
        if (this.expiredToken()) {
            this.accessToken = new QTestConnector(this.qTestUrl, this.apiKey).refreshAccessToken();
        }
        return this.accessToken;
    }

    private boolean expiredToken() {
        if (null == this.accessToken) {
            return true;
        }
        try {
            TokenStatus status = new QTestConnector(this.qTestUrl).getTokenStatus(this.accessToken);
            return null == status || status.isExpiration();
        }
        catch (AccessDeniedException ade) {
            return true;
        }
    }
}

