<#-- [@ww.textfield labelKey="qTest URL" name="qtesturl" required='true'/]
[@ww.textfield labelKey="API Key" name="apikey" required='true'/]
 -->

${webResourceManager.requireResource("com.qasymphony.qtest-plugin-for-bamboo:qtest-plugin-for-bamboo-resources")}
<#--  ${$webResourceManager.requireResourcesForContext("qtest-plugin-for-bamboo")}  -->
<script type="text/javascript" src="${req.contextPath}/download/resources/com.qasymphony.qtest-plugin-for-bamboo:qtest-plugin-for-bamboo-resources/qtest-plugin-for-bamboo-cors.js"></script>
<script type="text/javascript" src="${req.contextPath}/download/resources/com.qasymphony.qtest-plugin-for-bamboo:qtest-plugin-for-bamboo-resources/js/task-configure.js"></script>

<div id="message-bar"></div>

<div style="display: none;">
    <span id="bamboo_url">${bamboo_url}</span>
    <span id="context_path">${req.contextPath}</span>
    <span id="plan_key">${plan_key}</span>
    <input type="text" name="qtest_configuration_id" id="qtest_configuration_id" class="text long-field" value="${qtest_configuration_id}"/>
</div>

<div class="field-group">
  <label>qTest URL<span class="aui-icon icon-required">(required)</span></label>
  <input type="text" name="qtest_url"  id="qtest_url" class="text long-field" required value="${qtest_url}"/>
</div>
<div class="field-group">
  <label>API Key<span class="aui-icon icon-required">(required)</span></label>
  <input type="password" name="qtest_apikey" id="qtest_apikey" class="text long-field" required value="${qtest_apikey}"/>
</div>
<div class="field-group">
  <button class="aui-button" onclick="retrieveProjects(event)" >Retrieve projects</button>
</div>
<div class="field-group">
  <label>Project<span class="aui-icon icon-required">(required)</span></label>
  <select value="" name="qtest_project" id="qtest_projects" onchange="onProjectChange(event)" class="select long-field" required></select>
  <span class="projects-spinner"></span>
</div>
<div class="field-group">
  <label>Release<span class="aui-icon icon-required">(required)</span></label>
  <select value="" name="qtest_release" id="qtest_releases" onchange="onReleaseChange(event)" class="select long-field" required></select>
  <span class="releases-spinner"></span>
</div>
<div class="field-group">
  <label>Environment</label>
  <select value="" name="qtest_environment" id="qtest_environments" onchange="onEnvironmentChange(event)" class="select long-field"></select>
  <span class="environments-spinner"></span>
</div>

<fieldset class="collapsible-section collapsed" style="margin-top: 10px;">
  <div class="summary">
    <span class="icon icon-expand"></span>
    <h3 class="collapsible-header">Advanced options</h3>
  </div>
  <div class="collapsible-details">
    <div class="field-group">
      <div class="checkbox">
        <input class="checkbox" type="checkbox" name="use_file_pattern" value="true" onchange="onUseFilePatternChange(event)"
          <#if use_file_pattern == "true">
            checked
          </#if>
         />
        <label>Specify custom results directories</label>
        <div class="description">Where does the build place generated test results?</div>
      </div>
    </div>
    <div class="field-group" id="use_file_pattern_body"
      <#if use_file_pattern == "true">
        style="display: block;"
      <#else>
        style="display: none;"
      </#if>
    >
      <input class="text long-field" type="text" name="test_file_pattern" id="test_file_pattern" value="${test_file_pattern}"></input>
      <div class="description">
        <span>This is a comma separated list of test result directories. You can also use </span>
        <a target="blank" href="https://confluence.atlassian.com/bamboo/pattern-matching-reference-301663849.html">Ant style patterns</a>
        <span> such as **/test-reports/*.xml</span>
      </div>
    </div>
    <div class="checkbox">
      <input class="checkbox" type="checkbox" value="true" id="produce_build_result" name="produce_build_result"
        <#if produce_build_result = "true">
          checked
        </#if>
       />
      <label>The build will produce test results.</label>
      <div class="description">
        If checked, the build will fail if at least on test failed.
      </div>
    </div>
  </div>
</fieldset>

<#if qtest_url?? && qtest_apikey??>
  <script type="text/javascript">
      initConfiguration(
        "${qtest_url}", 
        "${qtest_apikey}", 
        ${qtest_project}, 
        ${qtest_release}, 
        <#if qtest_environment != ''>
          ${qtest_environment}
        <#else>
          null
        </#if>
        )  
  </script>


</#if>