console.log('enter task-configure.js');

var QTESTPLUGIN = window.QTESTPLUGIN;
var Utils =  QTESTPLUGIN.Utils;
var QTestAccessor = QTESTPLUGIN.QTestAccessor;


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function initConfiguration(qtesturl, apikey, project, release, environment){
  if(qtesturl && apikey){
    var qtestAccessor = new QTestAccessor(qtesturl, apikey);

    qtestAccessor._headers = {
      token: apikey
    };

    qtestAccessor.queryChain(
        new Array(
            function(qtestAccessor){
              retrieveProjects(null, project, qtestAccessor);
            },
            function(qtestAccessor){
              retrieveReleases(null, project, release, qtestAccessor);
            },
            function(qtestAccessor){
              retrieveEnvironments(null, project, environment, qtestAccessor);
            }
          )
      );

  }
}


function retrieveProjects(e, selectedProject, qtestAccessor){
  if(e){
    e.preventDefault();
    e.stopPropagation();
  }

  // keep the previous selected project if it's selected
  var prevSelectedProjectId = jQuery('#qtest_projects').val();
  if(prevSelectedProjectId){
    selectedProject = prevSelectedProjectId;
  }

  // remove all projects
  jQuery("#qtest_projects").empty();
  if(!selectedProject){
    // also remove all releases and environments of old project
    cleanReleases();
    cleanEnvironments();
  }

  var qtesturl = jQuery("#qtest_url").val();
  var apikey = jQuery("#qtest_apikey").val();

  if(!qtestAccessor){
    qtestAccessor = new QTestAccessor(qtesturl, apikey);
  }

  qtestAccessor._headers = {
    token: apikey
  };

  qtestAccessor.query(function(acessor){
    // spin waiting
    Utils.spin('.projects-spinner');

    acessor.retrieveProjects(
      function(response){
        var projects = response;
        var keepCurrentProject = false;

        // init projects
        jQuery('<option value="">Select Project</option>').appendTo('#qtest_projects');

        projects.forEach(function(project){
          var option = '<option value="' + project.id + '"';
          if(selectedProject == project.id){
            option += ' selected ';
            keepCurrentProject = true;
          }
          option += '>' + Utils.escapeHtml(project.name) + '</option>';

          jQuery(option).appendTo('#qtest_projects');
        });
        Utils.stopSpin('.projects-spinner');

        // continue to load releases, environment if project selected previously
        if(prevSelectedProjectId){
          retrieveReleases(null, null, null, acessor);
          retrieveEnvironments(null, null, null, acessor);
        }
      },
      function(error){
        console.error(error);
        Utils.error('Could not retrieve projects. Please check your qTest URL and API Key', error);
        Utils.stopSpin('.projects-spinner');
      }
    );
  });
}

function retrieveReleases(e, project, selectedRelease, qtestAccessor){
  // remove all releases of old project
  cleanReleases();

  if(!project){
    project = jQuery("#qtest_projects").val();
  }

  if(!project){
    return;
  }


  Utils.spin('.releases-spinner');

  qtestAccessor.retrieveReleases(
    project,
    function(response){
      var releases = response;
      // remove all releases
      jQuery('<option value="">Select Release</option>').appendTo('#qtest_releases');

      releases.forEach(function(release){
        var option = '<option value="' + release.id + '"';
        if(selectedRelease == release.id){
          option += ' selected ';
        }
        option += '>' + Utils.escapeHtml(release.name) + '</option>';
        jQuery(option).appendTo('#qtest_releases');
      });

      Utils.stopSpin('.releases-spinner');
    },
    function(error){
      console.error(error);
      Utils.stopSpin('.releases-spinner');
      Utils.error('Could not retrieve releases', error);
    }
  );
}


function retrieveEnvironments(e, project, selectedEnvironment, qtestAccessor){
  
  // remove all environments of old release
  cleanEnvironments();

  if(!project){
    project = jQuery("#qtest_projects").val();
  }

  if(!project){
    return;
  }

  Utils.spin('.environments-spinner');
  
  qtestAccessor.retrieveEnvironments(
    project,
    function(response){
      var testSuiteFields = response;
      var environments = [];

      for (var i = testSuiteFields.length - 1; i >= 0; i--) {
        var field = testSuiteFields[i];
        if(field.original_name == QTestAccessor.TEST_SUITE_ENVIRONMENT_FIELD){

          field.allowed_values.forEach(function(env){
            if(env.is_active){
              environments.push(env);
            }
          });
        }
      };

      if(environments.length > 0){
        jQuery('<option value="">Select Environment</option>').appendTo('#qtest_environments');

        environments.forEach(function(env){
          var option = '<option value="' + env.value + '"';
          if(selectedEnvironment == env.value){
            option += ' selected ';
          }
          option += '>' + Utils.escapeHtml(env.label) + '</option>';
          jQuery(option).appendTo('#qtest_environments');
        });
      }


      Utils.stopSpin('.environments-spinner');
    },
    function(error){
      console.error(error);
      Utils.error('Could not retrieve environments', error);
      Utils.stopSpin('.environments-spinner');
    }
  );
}


/**
 * Retrieve CI Setting from qTest if it have been saved.
 * @param  {[type]} e        event
 * @param  {[type]} qTestUrl [description]
 * @param  {[type]} apikey   [description]
 * @return {[type]}          [description]
 */
function retrieveCISetting(qtestAccessor, success, error){
  var projectId = jQuery("#qtest_projects").val();
  var bambooServer = jQuery("#bamboo_url").text();
  var planKey = jQuery("#plan_key").text();

  qtestAccessor.retrieveCISetting(
    projectId, 
    bambooServer, 
    planKey,
    function(response){
      success(response);
    },
    function(errorObj){
      error(errorObj);
    }
  );
}


function cleanReleases(){
  jQuery("#qtest_releases").empty();
}

function cleanEnvironments(){
  jQuery("#qtest_environments").empty();
}

function onProjectChange(e){

  var projectId = e.target.value;
  if(!projectId){
    cleanReleases();
    cleanEnvironments();
    return;
  }


  var qtesturl = jQuery("#qtest_url").val();
  var apikey = jQuery("#qtest_apikey").val();

  // keep reference of QtestQuery
  var qtestAccessor = new QTestAccessor(qtesturl, apikey);

  qtestAccessor._headers = {
    token: apikey
  };

  qtestAccessor.query(function(accessor){
    // try to get saved setting. 
    retrieveCISetting(
      accessor,
      function(setting){
        /**
         * If having saved configuration for this qTest project.
         * Utilize it to configure current task.
         */
        Utils.hint('Saved Configuration Found', 'We have found a saved configuration for this project.');

        jQuery("#qtest_configuration_id").val(setting.id);

        var projectId = setting.project_id;
        
        retrieveReleases(null, projectId, setting.release_id, accessor);

        retrieveEnvironments(null, projectId, setting.environment_id, accessor);
      },
      function(error){
        /**
         * If not found CI setting for this qTest project.
         * Fresh retrieve release, environments.
         */
        // load releases
        retrieveReleases(null, null, null, accessor);

        // load environments
        retrieveEnvironments(null, null, null, accessor);
      }
    );
  });
}

function onReleaseChange(e){
}


function onEnvironmentChange(e){
}

function onUseFilePatternChange(e){
var display = "none";
  var required = false;
  if(e.target.checked){
    display = "block";
    required = true;
  }
  jQuery("#use_file_pattern_body").css("display", display);

  if(required){
    jQuery("#test_file_pattern").prop("required", true);
  } else {
    jQuery("#test_file_pattern").removeProp("required");
  }
}
