/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.utils.http;

import com.qasymphony.qtest.bambooplugin.utils.ResponseEntity;
import com.qasymphony.qtest.bambooplugin.utils.http.ClientRequestException;
import com.qasymphony.qtest.bambooplugin.utils.http.HttpClientFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class HttpClientUtils {
    private static HttpClient CLIENT;

    private HttpClientUtils() {
    }

    private static HttpClient getClient() throws ClientRequestException {
        HttpClientUtils.initClient();
        return CLIENT;
    }

    private static synchronized void initClient() throws ClientRequestException {
        if (null == CLIENT) {
            try {
                CLIENT = new HttpClientFactory().build();
            }
            catch (Exception e) {
                throw new ClientRequestException(e.getMessage());
            }
        }
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static ResponseEntity get(String url, Map<String, String> headers) throws ClientRequestException {
        HttpGet request = new HttpGet(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity post(String url, Map<String, String> headers, String data) throws ClientRequestException {
        return HttpClientUtils.post(url, headers, data, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity post(String url, Map<String, String> headers, String data, ContentType contentType) throws ClientRequestException {
        HttpPost request = new HttpPost(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        if (!StringUtils.isEmpty((String)data)) {
            request.setEntity((HttpEntity)new StringEntity(data, contentType));
        }
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity put(String url, Map<String, String> headers, String data) throws ClientRequestException {
        return HttpClientUtils.put(url, headers, data, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity put(String url, Map<String, String> headers, String data, ContentType contentType) throws ClientRequestException {
        HttpPut request = new HttpPut(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        if (!StringUtils.isEmpty((String)data)) {
            request.setEntity((HttpEntity)new StringEntity(data, contentType));
        }
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity delete(String url, Map<String, String> headers) throws ClientRequestException {
        return HttpClientUtils.delete(url, headers, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity delete(String url, Map<String, String> headers, ContentType contentType) throws ClientRequestException {
        HttpDelete request = new HttpDelete(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    private static ResponseEntity doExecute(HttpResponse response) throws ClientRequestException {
        if (null == response) {
            throw new ClientRequestException("response is null.");
        }
        HttpEntity entity = response.getEntity();
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new InputStreamReader(entity.getContent()));
        }
        catch (IOException e) {
            throw new ClientRequestException(e.getMessage(), e);
        }
        StringBuilder result = new StringBuilder();
        String line = "";
        try {
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            throw new ClientRequestException(e.getMessage());
        }
        return new ResponseEntity(result.toString(), response.getStatusLine().getStatusCode());
    }

    public static ResponseEntity execute(HttpUriRequest request) throws ClientRequestException {
        ResponseEntity responseEntity;
        HttpClient client;
        try {
            client = HttpClientUtils.getClient();
        }
        catch (Exception e) {
            throw new ClientRequestException("Cannot get HttpClient." + e.getMessage(), e);
        }
        HttpResponse response = null;
        try {
            response = client.execute(request);
            responseEntity = HttpClientUtils.doExecute(response);
        }
        catch (IOException e) {
            throw new ClientRequestException(e.getMessage(), e);
        }
        finally {
            if (null != response) {
                org.apache.http.client.utils.HttpClientUtils.closeQuietly((HttpResponse)response);
            }
        }
        return responseEntity;
    }

    private static void addHeader(HttpRequestBase httpRequestBase, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequestBase.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class TrustAllStrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

