/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.testsubmission;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.qasymphony.qtest.bambooplugin.core.QTestConnector;
import com.qasymphony.qtest.bambooplugin.qtesttask.Configuration;
import com.qasymphony.qtest.bambooplugin.testsubmission.BambooTestResults;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmissionTracking;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResponse;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResult;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitStatus;
import com.qasymphony.qtest.bambooplugin.utils.JsonUtils;
import com.qasymphony.qtest.bambooplugin.utils.PluginLogger;
import com.qasymphony.qtest.bambooplugin.utils.PluginUtils;
import com.qasymphony.qtest.bambooplugin.utils.http.ClientRequestException;
import java.util.Date;

public class TestSubmitter {
    private final TaskContext taskContext;
    private final String qTestUrl;
    private final String apiKey;
    private final BambooTestResults bambooTestResults;

    public TestSubmitter(TaskContext taskContext, BambooTestResults bambooTestResults) {
        this.taskContext = taskContext;
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.qTestUrl = (String)configurationMap.get((Object)"qtest_url");
        this.apiKey = (String)configurationMap.get((Object)"qtest_apikey");
        this.bambooTestResults = bambooTestResults;
    }

    public void submit(TestSubmitResult result, Configuration configuration) throws ClientRequestException, InterruptedException {
        this.entranceLog(configuration);
        try {
            String url = String.format("/api/v3/projects/%s/test-runs/0/auto-test-logs/ci/%s", configuration.getProjectId(), configuration.getId());
            QTestConnector connector = new QTestConnector(this.qTestUrl, this.apiKey);
            TestSubmissionTracking testSubmissionTracking = connector.post(url, this.bambooTestResults, TestSubmissionTracking.class);
            this.waitAndSee(result, testSubmissionTracking, configuration);
            this.successfulLog(result);
        }
        catch (Exception e) {
            result.setSubmitStatus("Failed");
            result.setError(e.getMessage());
        }
        this.exitLog();
    }

    private void exitLog() {
        PluginLogger.addLogEntry(this.taskContext, "End submit test result to qTest at " + new Date().toString());
    }

    private void successfulLog(TestSubmitResult result) {
        PluginLogger.addLogEntry(this.taskContext, "Result after submit: " + result.toString());
        PluginLogger.addLogEntry(this.taskContext, "Test suite link: " + result.getTestSuiteLink());
    }

    private void entranceLog(Configuration configuration) {
        PluginLogger.addLogEntry(this.taskContext, "Submit Junit test result to qTest at " + this.qTestUrl);
        PluginLogger.addLogEntry(this.taskContext, "With project id : " + configuration.getProjectId());
        PluginLogger.addLogEntry(this.taskContext, "With release id : " + configuration.getReleaseId());
        PluginLogger.addLogEntry(this.taskContext, "With environment id: " + configuration.getEnvironmentId());
        PluginLogger.addLogEntry(this.taskContext, "Begin submit test result to qTest at " + new Date());
        PluginLogger.addLogEntry(this.taskContext, "With body " + this.bambooTestResults.toString());
    }

    private void waitAndSee(TestSubmitResult result, TestSubmissionTracking testSubmissionTracking, Configuration configuration) throws ClientRequestException, InterruptedException {
        String log = String.format("Please wait for jobId %d, processing...", testSubmissionTracking.getId());
        PluginLogger.addLogEntry(this.taskContext, log);
        long startTime = System.currentTimeMillis();
        long HOUR_IN_MILLISECOND = 3600000L;
        do {
            Thread.sleep(3000L);
            testSubmissionTracking = this.checkProcessing(testSubmissionTracking);
            if (System.currentTimeMillis() - startTime <= 3600000L) continue;
            PluginLogger.addLogEntry(this.taskContext, "Waiting result from submitting timed out");
            break;
        } while (this.processingNotComplete(testSubmissionTracking));
        if (!this.processingNotComplete(testSubmissionTracking)) {
            PluginLogger.addLogEntry(this.taskContext, "Finish processing with state " + (Object)((Object)testSubmissionTracking.getState()));
            if (TestSubmitStatus.SUCCESS.equals((Object)testSubmissionTracking.getState())) {
                TestSubmitResponse response = JsonUtils.toObject(testSubmissionTracking.getContent(), TestSubmitResponse.class);
                result.setSubmitStatus("Complete");
                result.setNumberOfTestLog(response.getTotalTestLogs());
                result.setTestSuiteId(response.getTestSuiteId());
                result.setTestSuiteName(response.getTestSuiteName());
                String testSuiteLink = PluginUtils.getTestSuiteLink(this.qTestUrl, configuration.getProjectId(), response.getTestSuiteId());
                result.setTestSuiteLink(testSuiteLink);
            } else {
                result.setSubmitStatus("Failed");
                result.setError(testSubmissionTracking.getContent());
            }
        }
    }

    private TestSubmissionTracking checkProcessing(TestSubmissionTracking testSubmissionTracking) throws ClientRequestException {
        String url = String.format("/api/v3/projects/queue-processing/%s", testSubmissionTracking.getId());
        QTestConnector connector = new QTestConnector(this.qTestUrl, this.apiKey);
        return connector.get(url, TestSubmissionTracking.class);
    }

    private boolean processingNotComplete(TestSubmissionTracking testSubmissionTracking) {
        TestSubmitStatus status = testSubmissionTracking.getState();
        return TestSubmitStatus.IN_PROCESSING.equals((Object)status) || TestSubmitStatus.IN_WAITING.equals((Object)status);
    }
}

