/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.storage.file;

import com.qasymphony.qtest.bambooplugin.storage.file.BufferedAccessFile;
import com.qasymphony.qtest.bambooplugin.storage.file.FileReaderException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileReader
implements Closeable,
AutoCloseable {
    private static final ForkJoinPool DEFAULT_POOL = new ForkJoinPool();
    private static final long MIN_FORK_THRESHOLD = 1000000L;
    private static final String READ_MODE = "r";
    private final BufferedAccessFile raf;
    private final Charset charset;
    private final SortedSet<Long> index;
    private final Lock lock;
    private boolean isClosed = false;

    public FileReader(File file) throws IOException {
        this(file, Charset.defaultCharset(), 1, DEFAULT_POOL);
    }

    public FileReader(File file, Charset charset) throws IOException {
        this(file, charset, 1, DEFAULT_POOL);
    }

    public FileReader(File file, Charset charset, int splitCount) throws IOException {
        this(file, charset, splitCount, DEFAULT_POOL);
    }

    public FileReader(File file, Charset charset, int splitCount, ForkJoinPool pool) throws IOException {
        this.raf = new BufferedAccessFile(file, READ_MODE);
        this.charset = charset;
        long threshold = Math.max(1000000L, file.length() / (long)splitCount);
        this.index = Collections.unmodifiableSortedSet(pool.invoke(new IndexingTask(file, 0L, file.length(), threshold)));
        this.lock = new ReentrantLock();
    }

    public FileReader(File file, int splitCount) throws IOException {
        this(file, Charset.defaultCharset(), splitCount, DEFAULT_POOL);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, String> find(int from, int to, String regex) throws IOException {
        this.assertIsOpen();
        if (regex == null) {
            throw new NullPointerException("Regex cannot be null");
        }
        if (from < 1) {
            throw new IllegalArgumentException("'from' must be greater than or equal to 1");
        }
        if (to < from) {
            throw new IllegalArgumentException("'to' must be greater than or equal to 'from'");
        }
        TreeMap<Integer, String> lines = new TreeMap<Integer, String>();
        ArrayList<Long> positions = new ArrayList<Long>(this.index);
        try {
            String line;
            this.lock.lock();
            this.raf.seek((Long)positions.get(from - 1));
            for (int i = from; i <= to && (line = this.raf.getNextLine(this.charset)) != null; ++i) {
                if (!line.matches(regex)) continue;
                lines.put(i, line);
            }
            TreeMap<Integer, String> treeMap = lines;
            return treeMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.index.size();
    }

    public SortedMap<Integer, String> head(int n) throws IOException {
        this.assertIsOpen();
        if (n < 1) {
            throw new IllegalArgumentException("'n' must be greater than or equal to 1");
        }
        return this.readLines(1, n);
    }

    public SortedMap<Integer, String> readAll() throws IOException {
        this.assertIsOpen();
        return this.readLines(1, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Integer, String> readLines(int from, int to) throws IOException {
        this.assertIsOpen();
        if (from < 1) {
            throw new IllegalArgumentException("'from' must be greater than or equal to 1");
        }
        if (to < from) {
            throw new IllegalArgumentException("'to' must be greater than or equal to 'from'");
        }
        if (from > this.index.size()) {
            throw new IllegalArgumentException("'from' must be less than the file's number of lines");
        }
        TreeMap<Integer, String> lines = new TreeMap<Integer, String>();
        ArrayList<Long> positions = new ArrayList<Long>(this.index);
        try {
            String line;
            this.lock.lock();
            this.raf.seek((Long)positions.get(from - 1));
            for (int i = from; i <= to && (line = this.raf.getNextLine(this.charset)) != null; ++i) {
                lines.put(i, line);
            }
            TreeMap<Integer, String> treeMap = lines;
            return treeMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SortedMap<Integer, String> tail(int n) throws IOException {
        this.assertIsOpen();
        if (n < 1) {
            throw new IllegalArgumentException("'n' must be greater than or equal to 1");
        }
        int from = this.index.size() - n;
        int to = from + n;
        return this.readLines(from, to);
    }

    private void assertIsOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Reader is closed!");
        }
    }

    private static final class IndexingTask
    extends RecursiveTask<SortedSet<Long>> {
        private static final long serialVersionUID = 3509549890190032574L;
        private final File file;
        private final long start;
        private final long end;
        private final long length;
        private final long threshold;

        public IndexingTask(File file, long start, long end, long threshold) {
            this.file = file;
            this.start = start;
            this.end = end;
            this.length = end - start;
            this.threshold = threshold;
        }

        @Override
        protected SortedSet<Long> compute() {
            TreeSet<Long> index;
            block9: {
                index = new TreeSet<Long>();
                try {
                    long end1;
                    if (this.length < this.threshold) {
                        try (RandomAccessFile raf = null;){
                            raf = new BufferedAccessFile(this.file, FileReader.READ_MODE);
                            ((BufferedAccessFile)raf).seek(this.start);
                            if (((BufferedAccessFile)raf).getFilePointer() == 0L) {
                                index.add(((BufferedAccessFile)raf).getFilePointer());
                            }
                            while (((BufferedAccessFile)raf).getFilePointer() < this.end) {
                                ((BufferedAccessFile)raf).getNextLine();
                                index.add(((BufferedAccessFile)raf).getFilePointer());
                            }
                            break block9;
                        }
                    }
                    long start1 = this.start;
                    long start2 = end1 = this.start + this.length / 2L;
                    long end2 = this.end;
                    IndexingTask task1 = new IndexingTask(this.file, start1, end1, this.threshold);
                    task1.fork();
                    IndexingTask task2 = new IndexingTask(this.file, start2, end2, this.threshold);
                    index.addAll((Collection<Long>)task2.compute());
                    index.addAll((Collection)task1.join());
                }
                catch (IOException ex) {
                    throw new FileReaderException("Error while index file:" + ex.getMessage(), ex);
                }
            }
            return index;
        }
    }
}

