/*
 * Decompiled with CFR 0.152.
 */
package com.qasymphony.qtest.bambooplugin.storage;

import com.qasymphony.qtest.bambooplugin.storage.file.FileReader;
import com.qasymphony.qtest.bambooplugin.testsubmission.TestSubmitResult;
import com.qasymphony.qtest.bambooplugin.utils.JsonUtils;
import com.qasymphony.qtest.bambooplugin.utils.PluginUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class TestResultStoreService {
    private static final int MAX_PAGE_SIZE = 100;
    private static final String FILE_NAME = "result";
    private static final String FILE_FORMAT = "%s-page%d-%d-%d.txt";

    public void store(TestSubmitResult result, File workingDir, String planKey, int buildNumber) throws IOException {
        String data = JsonUtils.toJson(result);
        File dest = this.getReportFile(workingDir, planKey, buildNumber);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(dest, true));
            writer.write(data);
            writer.newLine();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot store result", e);
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public Map<String, TestSubmitResult> fetch(File workingDir, String planKey, int startBuildNumber, int endBuildNumber) throws IOException {
        List<File> files = this.getReportFiles(workingDir, planKey, startBuildNumber, endBuildNumber);
        HashMap<String, TestSubmitResult> map = new HashMap<String, TestSubmitResult>();
        for (File file : files) {
            map.putAll(this.readResultsFromFile(file));
        }
        return map;
    }

    private File getReportFile(File workingDir, String planKey, int buildNumber) throws IOException {
        int page = this.getPageNumber(buildNumber);
        File qTestReportDir = PluginUtils.getQTestReportDirectory(workingDir, planKey);
        return this.getPageFile(qTestReportDir, page);
    }

    private int getPageNumber(int buildNumber) {
        int page = --buildNumber / 100;
        return page;
    }

    private File getPageFile(File workingDir, int pageNumber) throws IOException {
        int fromIdx = pageNumber * 100;
        int endIdx = fromIdx + 100;
        String fileName = String.format(FILE_FORMAT, FILE_NAME, pageNumber, fromIdx + 1, endIdx);
        File file = new File(workingDir, fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private List<File> getReportFiles(File workingDir, String planKey, int startBuildNumber, int endBuildNumber) throws IOException {
        int startPage = this.getPageNumber(startBuildNumber);
        int endPage = this.getPageNumber(endBuildNumber);
        File qTestReportDir = PluginUtils.getQTestReportDirectory(workingDir, planKey);
        return this.getReportFiles(qTestReportDir, startPage, endPage);
    }

    private List<File> getReportFiles(File qTestReportDir, int startPage, int endPage) throws IOException {
        if (startPage > endPage) {
            int tmp = startPage;
            startPage = endPage;
            endPage = tmp;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (int i = startPage; i <= endPage; ++i) {
            File pageFile = this.getPageFile(qTestReportDir, i);
            files.add(pageFile);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TestSubmitResult> readResultsFromFile(File file) throws IOException {
        FileReader fileReader = null;
        try {
            HashMap<String, TestSubmitResult> map = new HashMap<String, TestSubmitResult>();
            fileReader = new FileReader(file);
            SortedMap<Integer, String> lines = fileReader.readAll();
            for (String line : lines.values()) {
                TestSubmitResult testSubmitResult = JsonUtils.toObject(line, TestSubmitResult.class);
                if (null == testSubmitResult) continue;
                map.put(testSubmitResult.getBuildNumber(), testSubmitResult);
            }
            HashMap<String, TestSubmitResult> hashMap = map;
            return hashMap;
        }
        finally {
            if (null != fileReader) {
                fileReader.close();
            }
        }
    }
}

